/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.explorer.node;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.action.ActionRegistry;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodePropertySupport;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseNode
extends AbstractNode {
    protected static final String DATABASEURL = "DatabaseURL";
    protected static final String DATABASEURLDESC = "DatabaseURLDescription";
    protected static final String DRIVER = "DriverURL";
    protected static final String DRIVERDESC = "DriverURLDescription";
    protected static final String SCHEMA = "Schema";
    protected static final String SCHEMADESC = "SchemaDescription";
    protected static final String PROP_DEFSCHEMA = "DefaultSchema";
    protected static final String PROP_DEFSCHEMADESC = "DefaultSchema";
    protected static final String PROP_DEFCATALOG = "DefaultCatalog";
    protected static final String PROP_DEFCATALOGDESC = "DefaultCatalog";
    protected static final String USER = "User";
    protected static final String USERDESC = "UserDescription";
    protected static final String REMEMBERPW = "RememberPassword";
    protected static final String REMEMBERPWDESC = "RememberPasswordDescription";
    protected static final String CATALOG = "Catalog";
    protected static final String CATALOGDESC = "CatalogDescription";
    protected static final String DISPLAYNAME = "DisplayName";
    protected static final String DISPLAYNAMEDESC = "DisplayNameDescription";
    protected static final String UNIQUE = "UniqueNoMnemonic";
    protected static final String UNIQUEDESC = "UniqueDescription";
    protected static final String NULL = "Null";
    protected static final String NULLDESC = "NullDescription";
    protected static final String TYPE = "Type";
    protected static final String TYPEDESC = "TypeDescription";
    protected static final String DATATYPE = "Datatype";
    protected static final String DATATYPEDESC = "DatatypeDescription";
    protected static final String COLUMNSIZE = "ColumnSize";
    protected static final String COLUMNSIZEDESC = "ColumnSizeDescription";
    protected static final String DIGITS = "DecimalDigits";
    protected static final String DIGITSDESC = "DecimalDigitsDescription";
    protected static final String POSITION = "Position";
    protected static final String POSITIONDESC = "PositionDescription";
    protected static final String FKPOSITION = "PositionInFK";
    protected static final String FKPOSITIONDESC = "PositionInFKDescription";
    protected static final String FKREFERRINGSCHEMA = "ReferringFKSchema";
    protected static final String FKREFERRINGSCHEMADESC = "ReferringFKSchema";
    protected static final String FKREFERRINGTABLE = "ReferringFKTable";
    protected static final String FKREFERRINGTABLEDESC = "ReferringFKTable";
    protected static final String FKREFERRINGCOLUMN = "ReferringFKColumn";
    protected static final String FKREFERRINGCOLUMNDESC = "ReferringFKColumn";
    protected static final String FKREFERREDSCHEMA = "ReferredFKSchema";
    protected static final String FKREFERREDSCHEMADESC = "ReferredFKSchema";
    protected static final String FKREFERREDTABLE = "ReferredFKTable";
    protected static final String FKREFERREDTABLEDESC = "ReferredFKTable";
    protected static final String FKREFERREDCOLUMN = "ReferredFKColumn";
    protected static final String FKREFERREDCOLUMNDESC = "ReferredFKColumn";
    private final NodeDataLookup dataLookup;
    private final ActionRegistry actionRegistry;
    private final NodeRegistry nodeRegistry;
    private final ChildNodeFactory childNodeFactory;
    private final NodeProvider nodeProvider;
    private final List<Node.Property> props = new CopyOnWriteArrayList<Node.Property>();
    private final HashMap<String, Object> propMap = new HashMap();
    public boolean isRemoved = false;

    public BaseNode(NodeDataLookup nodeDataLookup, String string, NodeProvider nodeProvider) {
        this(Children.LEAF, null, nodeDataLookup, string, nodeProvider);
    }

    public BaseNode(ChildNodeFactory childNodeFactory, NodeDataLookup nodeDataLookup, String string, NodeProvider nodeProvider) {
        this(Children.create((ChildFactory)childNodeFactory, (boolean)true), childNodeFactory, nodeDataLookup, string, nodeProvider);
    }

    private BaseNode(Children children, ChildNodeFactory childNodeFactory, NodeDataLookup nodeDataLookup, String string, NodeProvider nodeProvider) {
        super(children, (Lookup)nodeDataLookup);
        this.dataLookup = nodeDataLookup;
        this.childNodeFactory = childNodeFactory;
        this.actionRegistry = new ActionRegistry(string);
        this.nodeRegistry = NodeRegistry.create(string, this.dataLookup);
        this.nodeProvider = nodeProvider;
    }

    protected abstract void initialize();

    public NodeRegistry getNodeRegistry() {
        return this.nodeRegistry;
    }

    public synchronized void refresh() {
        this.nodeRegistry.refresh();
        this.update();
    }

    protected void setup() {
        this.dataLookup.add(this.nodeRegistry);
        this.dataLookup.add((Object)this);
        this.nodeRegistry.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BaseNode.this.update();
            }
        });
        this.initialize();
        this.updateProperties();
    }

    protected void remove() {
        this.remove(false);
    }

    protected void remove(boolean bl) {
        this.isRemoved = true;
        this.nodeProvider.removeNode((Node)this);
        if (bl) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Node node = BaseNode.this.getParentNode();
                    if (node instanceof BaseNode) {
                        ((BaseNode)node).refresh();
                    }
                }
            });
        }
    }

    public Collection<? extends Node> getChildNodesSync() {
        if (this.childNodeFactory != null) {
            this.childNodeFactory.refreshSync();
        }
        return this.nodeRegistry.getNodes();
    }

    public Collection<? extends Node> getChildNodes() {
        return this.nodeRegistry.getNodes();
    }

    public void update() {
        this.updateProperties();
        if (this.childNodeFactory != null) {
            this.childNodeFactory.refresh();
        }
    }

    protected void updateProperties() {
        this.setName(this.getName());
        this.setDisplayName(this.getDisplayName());
        String string = this.getIconBase();
        if (string != null) {
            this.setIconBaseWithExtension(string);
        }
    }

    protected void clearProperties() {
        for (Node.Property property : this.props) {
            this.getSheet().get("properties").remove(property.getName());
        }
        this.props.clear();
        this.propMap.clear();
    }

    protected void addProperty(Node.Property property) {
        this.props.add(property);
        this.getSheet().get("properties").put(property);
    }

    protected void addProperty(String string, String string2, Class clazz, boolean bl, Object object) {
        String string3 = NbBundle.getMessage(BaseNode.class, (String)string);
        String string4 = string2 == null ? string3 : NbBundle.getMessage(BaseNode.class, (String)string2);
        NodePropertySupport nodePropertySupport = new NodePropertySupport(this, string, clazz, string3, string4, bl);
        this.props.add((Node.Property)nodePropertySupport);
        this.propMap.put(nodePropertySupport.getName(), object);
        this.getSheet().get("properties").put((Node.Property)nodePropertySupport);
    }

    public void setPropertyValue(Node.Property property, Object object) {
        this.propMap.put(property.getName(), object);
    }

    public Object getPropertyValue(String string) {
        return this.propMap.get(string);
    }

    public synchronized Collection<Node.Property> getProperties() {
        return Collections.unmodifiableCollection(this.props);
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        this.setSheet(sheet);
        return sheet;
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return super.getActions(true);
        }
        Collection<Action> collection = this.actionRegistry.getActions();
        return collection.toArray(new Action[collection.size()]);
    }

    public abstract String getIconBase();

    public abstract String getName();

    public void destroy() {
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }
}

