/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.web.core.syntax.completion.ELImplicitObjects;
import org.netbeans.modules.web.core.syntax.completion.api.ElCompletionItem;
import org.netbeans.modules.web.core.syntax.completion.api.JspCompletionItem;
import org.netbeans.modules.web.core.syntax.spi.ELImplicitObject;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELExpression {
    private static final Logger logger = Logger.getLogger(ELExpression.class.getName());
    public static final int NOT_EL = 0;
    public static final int EL_START = 1;
    public static final int EL_BEAN = 2;
    public static final int EL_IMPLICIT = 3;
    public static final int EL_FUNCTION = 4;
    public static final int EL_UNKNOWN = 5;
    protected String expression;
    protected String resolvedExpression;
    private String replace;
    private boolean isDefferedExecution = false;
    private Document doc;
    private int myParseType = -1;
    private boolean isAttribute;
    private String myAttributeValue;
    private String myXhtmlToken;
    private int contextOffset = -1;
    private int myStartOffset = -1;

    public ELExpression(Document document) {
        this.doc = document;
        this.replace = "";
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getContextOffset() {
        return this.contextOffset;
    }

    public Document getDocument() {
        return this.doc;
    }

    public final int parse(final int n) {
        final int[] nArray = new int[1];
        ((BaseDocument)this.doc).render(new Runnable(){

            public void run() {
                nArray[0] = ELExpression.this.doParse(n);
            }
        });
        this.myParseType = nArray[0];
        return this.myParseType;
    }

    public final int getParseType() {
        return this.myParseType;
    }

    public List<CompletionItem> getPropertyCompletionItems(String string, int n) {
        CompletionInfo completionInfo = this.getPropertyCompletionInfo(string, n);
        this.runTask(completionInfo);
        return completionInfo.getCompletionItems();
    }

    public boolean gotoPropertyDeclaration(String string) {
        GoToSourceTask goToSourceTask = new GoToSourceTask(string);
        this.runTask(goToSourceTask);
        return goToSourceTask.wasSuccessful();
    }

    public String getObjectClass() {
        String string = this.extractBeanName();
        ELImplicitObject eLImplicitObject = ELImplicitObjects.getELImplicitObject(string, this);
        if (eLImplicitObject != null) {
            return eLImplicitObject.getClazz();
        }
        return null;
    }

    public String getBeanName() {
        return this.extractBeanName();
    }

    public FileObject getFileObject() {
        return DataLoadersBridge.getDefault().getFileObject(this.doc);
    }

    protected CompletionInfo getPropertyCompletionInfo(String string, int n) {
        return new PropertyCompletionItemsTask(string, n);
    }

    protected void runTask(CancellableTask<CompilationController> cancellableTask) {
        if (this.getFileObject() == null) {
            return;
        }
        ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)this.getFileObject());
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (Collection)Collections.EMPTY_LIST);
        try {
            javaSource.runUserActionTask(cancellableTask, true);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
    }

    protected String extractBeanName() {
        return this.extractBeanName(this.getExpression());
    }

    protected String extractBeanName(String string) {
        if (string != null && !string.equals("")) {
            int n = string.indexOf(46);
            int n2 = string.indexOf(91);
            if (n > -1 || n2 > -1) {
                String string2 = string.substring(0, this.getPositiveMin(n, n2));
                return string2;
            }
        }
        return null;
    }

    protected int getPositiveMin(int n, int n2) {
        if (n < 0) {
            return n2 >= 0 ? n2 : 0;
        }
        if (n2 < 0) {
            return n;
        }
        return Math.min(n, n2);
    }

    public boolean isDefferedExecution() {
        return this.isDefferedExecution;
    }

    public String getPropertyBeingTypedName() {
        String string = this.getExpression();
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(91);
        int n3 = string.lastIndexOf(93);
        if (n3 < n2) {
            return string.substring(n2 + 1);
        }
        if (n2 > -1 && n < n3) {
            return string.substring(n2 + 1);
        }
        if (n > -1) {
            return string.substring(n + 1);
        }
        return null;
    }

    public String removeQuotes(String string) {
        if (string.length() > 0) {
            char c;
            char c2 = string.charAt(0);
            if ((c2 == '\"' || c2 == '\'') && string.length() > 1 && string.charAt(string.length() - 1) == c2) {
                return string.substring(1, string.length() - 1);
            }
            if (c2 == '\\' && string.length() >= 4 && ((c = string.charAt(1)) == '\"' || c == '\'') && string.charAt(string.length() - 1) == c && string.charAt(string.length() - 2) == '\\') {
                string = string.substring(2, string.length() - 2);
            }
        }
        return string;
    }

    public String getInsert(String string, char c) {
        int n = this.getExpression().lastIndexOf(91);
        int n2 = this.getExpression().lastIndexOf(93);
        if (n2 < n) {
            String string2 = null;
            if (c == '\"' || c == '\'') {
                string2 = "" + c;
            } else if (this.isAttribute && this.myAttributeValue != null && this.myAttributeValue.length() > 0) {
                string2 = this.getQuote(this.myAttributeValue.charAt(0), this.myAttributeValue);
            } else if (this.myXhtmlToken != null) {
                int n3 = this.myXhtmlToken.lastIndexOf(34);
                int n4 = this.myXhtmlToken.lastIndexOf(39);
                if (n4 > n3) {
                    string2 = this.getQuote('\'', this.myXhtmlToken);
                } else if (n3 >= 0) {
                    string2 = this.getQuote('\"', this.myXhtmlToken);
                }
            }
            if (string2 == null) {
                string2 = "\"";
            }
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        return string;
    }

    private String getQuote(char c, String string) {
        if (c == '\"') {
            if (string.indexOf("'") != -1) {
                return "\\\"";
            }
            return "'";
        }
        if (c == '\'') {
            if (string.indexOf(34) != -1) {
                return "\\'";
            }
            return "\"";
        }
        return null;
    }

    static String getPropertyName(String string, int n) {
        String string2 = string.substring(n);
        String string3 = string2.substring(1);
        if (string3.length() > 0 && string3.equals(string3.toUpperCase())) {
            return string2;
        }
        return Character.toLowerCase(string2.charAt(0)) + string3;
    }

    private void setContextOffset(int n) {
        this.contextOffset = n;
    }

    protected Part[] getParts() {
        return this.getParts(this.getExpression());
    }

    protected Part[] getParts(String string) {
        LinkedList<Part> linkedList = new LinkedList<Part>();
        String string2 = string;
        if (string.indexOf(91) == -1) {
            String[] stringArray = string2.split("\\.");
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                linkedList.add(new Part(n, stringArray[i]));
                n = n + stringArray[i].length() + 1;
            }
            return linkedList.toArray(new Part[linkedList.size()]);
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        while (string2.length() > 0 && n < string2.length()) {
            String string3;
            char c = string2.charAt(n);
            if (c == '.') {
                if (bl2) {
                    this.addPart(linkedList, string2.substring(n + 1), n + n2 + 1);
                    break;
                }
                bl = true;
                string3 = string2.substring(0, n);
                this.addPart(linkedList, string3, n2);
                n2 = n2 + string3.length() + 1;
                string2 = string2.substring(n + 1);
                n = 0;
                continue;
            }
            if (c == '[') {
                if (bl2) {
                    this.addPart(linkedList, string2.substring(n + 1), n + n2 + 1);
                    break;
                }
                if (bl) {
                    bl = false;
                }
                bl2 = true;
                string3 = string2.substring(0, n);
                this.addPart(linkedList, string3, n2);
                n2 = n2 + string3.length() + 1;
                int n3 = string2.indexOf(93);
                if (n3 == -1) {
                    this.addPart(linkedList, string2.substring(n + 1), n2);
                    break;
                }
                string3 = string2.substring(n + 1, n3);
                String string4 = this.removeQuotes(string3);
                int n4 = string3.indexOf(string4);
                this.addPart(linkedList, string4, n2 + n4);
                string2 = string2.substring(n3 + 1);
                n2 = n2 + string3.length() + 1;
                bl2 = false;
                n = 0;
                continue;
            }
            ++n;
        }
        if (bl) {
            this.addPart(linkedList, string2, this.getExpression().length() - string2.length());
        }
        return linkedList.toArray(new Part[linkedList.size()]);
    }

    private void addPart(List<Part> list, String string, int n) {
        if (string != null && string.length() != 0) {
            list.add(new Part(n, string));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int doParse(int n) {
        TokenSequence tokenSequence;
        this.setContextOffset(n);
        BaseDocument baseDocument = (BaseDocument)this.doc;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        TokenSequence tokenSequence2 = null;
        for (tokenSequence = tokenHierarchy.tokenSequence(); tokenSequence != null; tokenSequence = tokenSequence.embedded()) {
            if (tokenSequence.language() == ELTokenId.language()) {
                this.isDefferedExecution = ((Object)tokenSequence2.token().text()).toString().startsWith("#{");
                if (!tokenSequence2.movePrevious()) break;
                if (JspTokenId.ATTR_VALUE == tokenSequence2.token().id()) {
                    this.isAttribute = true;
                    this.myAttributeValue = ((Object)tokenSequence2.token().text()).toString();
                    break;
                }
                if (!tokenSequence2.token().id().toString().equals("HTML") || !tokenSequence2.language().mimeType().equals("text/xhtml")) break;
                this.myXhtmlToken = ((Object)tokenSequence2.token().text()).toString();
                break;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) return 0;
            tokenSequence2 = tokenSequence;
        }
        if (tokenSequence == null) {
            return 0;
        }
        int n2 = tokenSequence.move(n);
        if (n2 == 0 ? !tokenSequence.movePrevious() : !tokenSequence.moveNext()) {
            return 1;
        }
        Token token = tokenSequence.token();
        boolean bl = false;
        while (bl || (!ELTokenId.ELTokenCategories.OPERATORS.hasCategory(tokenSequence.token().id()) || tokenSequence.token().id() == ELTokenId.DOT || tokenSequence.token().id() == ELTokenId.LBRACKET || tokenSequence.token().id() == ELTokenId.RBRACKET) && tokenSequence.token().id() != ELTokenId.WHITESPACE && (!ELTokenId.ELTokenCategories.KEYWORDS.hasCategory(tokenSequence.token().id()) || ELTokenId.ELTokenCategories.NUMERIC_LITERALS.hasCategory(tokenSequence.token().id()))) {
            if (tokenSequence.token().id() == ELTokenId.RBRACKET) {
                bl = true;
            } else if (tokenSequence.token().id() == ELTokenId.LBRACKET) {
                bl = false;
            }
            if (this.expression == null) {
                this.expression = ((Object)tokenSequence.token().text()).toString();
                if (tokenSequence.token().id() == ELTokenId.DOT || tokenSequence.token().id() == ELTokenId.LBRACKET) {
                    this.replace = "";
                } else if (tokenSequence.token().text().length() >= n - tokenSequence.token().offset(tokenHierarchy)) {
                    if (tokenSequence.token().offset(tokenHierarchy) > n) return 0;
                    this.replace = this.expression = this.expression.substring(0, n - tokenSequence.token().offset(tokenHierarchy));
                }
            } else {
                this.expression = ((Object)tokenSequence.token().text()).toString() + this.expression;
                if (tokenSequence.token().id() == ELTokenId.TAG_LIB_PREFIX) {
                    this.replace = this.expression;
                }
            }
            token = tokenSequence.token();
            this.myStartOffset = tokenSequence.offset();
            if (tokenSequence.movePrevious()) continue;
        }
        if (ELTokenId.ELTokenCategories.OPERATORS.hasCategory(token.id()) || token.id() == ELTokenId.WHITESPACE || token.id() == ELTokenId.LPAREN) {
            return 1;
        }
        if (token.id() != ELTokenId.IDENTIFIER && token.id() != ELTokenId.TAG_LIB_PREFIX) {
            this.expression = null;
            return 0;
        } else {
            if (this.expression == null) return 0;
            return this.findContext(this.expression);
        }
    }

    protected int findContext(String string) {
        int n = string.indexOf(46);
        int n2 = string.indexOf(91);
        int n3 = 5;
        if (n2 == -1 && n > -1) {
            String string2 = string.substring(0, n);
            if (n3 == 5 && ELImplicitObjects.getELImplicitObjects(string2, this).size() > 0) {
                n3 = 3;
            }
        } else if (n2 == -1 && n == -1) {
            n3 = 1;
        }
        return n3;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getResolvedExpression() {
        return this.resolvedExpression != null ? this.resolvedExpression : this.expression;
    }

    public boolean isResolvedExpression() {
        return !this.getExpression().equals(this.getResolvedExpression());
    }

    public String getReplace() {
        return this.replace;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertyCompletionItemsTask
    extends BaseELTaskClass
    implements CompletionInfo {
        private List<CompletionItem> completionItems;
        private int anchorOffset;
        private String myQName;

        PropertyCompletionItemsTask(String string, int n) {
            super(string);
            this.completionItems = new ArrayList<CompletionItem>();
            this.anchorOffset = n;
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TypeElement typeElement = this.getTypePreceedingCaret((CompilationInfo)compilationController);
            if (typeElement != null) {
                this.myQName = typeElement.getQualifiedName().toString();
                String string = ELExpression.this.getPropertyBeingTypedName();
                char c = '\u0000';
                if (string.length() > 0) {
                    c = string.charAt(0);
                }
                if (c == '\"' || c == '\'') {
                    string = string.substring(1);
                }
                for (ExecutableElement executableElement : ElementFilter.methodsIn(compilationController.getElements().getAllMembers(typeElement))) {
                    String string2 = this.getExpressionSuffix(executableElement, compilationController);
                    if (string2 == null || !string2.startsWith(string)) continue;
                    boolean bl = string2.equals(executableElement.getSimpleName().toString());
                    String string3 = bl ? "" : ((Object)executableElement.getReturnType()).toString();
                    JspCompletionItem jspCompletionItem = ElCompletionItem.createELProperty(string2, ELExpression.this.getInsert(string2, c), this.anchorOffset, string3);
                    this.completionItems.add(jspCompletionItem);
                }
            }
        }

        @Override
        public List<CompletionItem> getCompletionItems() {
            return this.completionItems;
        }

        @Override
        public String getTypeOnCaretQualifiedName() {
            return this.myQName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface CompletionInfo
    extends CancellableTask<CompilationController> {
        public List<CompletionItem> getCompletionItems();

        public String getTypeOnCaretQualifiedName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GoToSourceTask
    extends BaseELTaskClass
    implements CancellableTask<CompilationController> {
        private boolean success;

        GoToSourceTask(String string) {
            super(string);
            this.success = false;
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TypeElement typeElement = this.getTypePreceedingCaret((CompilationInfo)compilationController);
            if (typeElement != null) {
                String string = this.removeQuotes(ELExpression.this.getPropertyBeingTypedName());
                for (ExecutableElement executableElement : ElementFilter.methodsIn(compilationController.getElements().getAllMembers(typeElement))) {
                    String string2 = this.getExpressionSuffix(executableElement, compilationController);
                    if (string2 == null || !string2.equals(string)) continue;
                    this.success = UiUtils.open((ClasspathInfo)compilationController.getClasspathInfo(), (Element)executableElement);
                    break;
                }
            }
        }

        public boolean wasSuccessful() {
            return this.success;
        }
    }

    public static interface FailHandler {
        public void typeNotFound(int var1, String var2);
    }

    protected abstract class BaseELTaskClass {
        protected String beanType;

        public BaseELTaskClass(String string) {
            this.beanType = string;
        }

        public void cancel() {
        }

        protected String removeQuotes(String string) {
            return ELExpression.this.removeQuotes(string);
        }

        protected TypeElement getTypePreceedingCaret(CompilationInfo compilationInfo) {
            return this.getTypePreceedingCaret(compilationInfo, ELExpression.this.getExpression(), null);
        }

        protected TypeElement getTypePreceedingCaret(CompilationInfo compilationInfo, String string) {
            return this.getTypePreceedingCaret(compilationInfo, string, null);
        }

        protected TypeElement getTypePreceedingCaret(CompilationInfo compilationInfo, String string, FailHandler failHandler) {
            return this.getTypePreceedingCaret(compilationInfo, string, failHandler, false);
        }

        protected TypeElement getTypePreceedingCaret(CompilationInfo compilationInfo, String string, FailHandler failHandler, boolean bl) {
            TypeMirror typeMirror = this.getTypeMirrorPreceedingCaret(compilationInfo, string, failHandler, bl);
            if (typeMirror == null) {
                return null;
            }
            return (TypeElement)compilationInfo.getTypes().asElement(typeMirror);
        }

        protected TypeMirror getTypeMirrorPreceedingCaret(CompilationInfo compilationInfo, String string, FailHandler failHandler, boolean bl) {
            Object object;
            int n;
            if (this.beanType == null) {
                if (failHandler != null) {
                    failHandler.typeNotFound(0, ELExpression.this.extractBeanName());
                }
                return null;
            }
            TypeElement typeElement = compilationInfo.getElements().getTypeElement(this.beanType);
            Object object2 = null;
            if (typeElement != null) {
                object2 = typeElement.asType();
            }
            Object object3 = object2;
            Object object4 = null;
            Part[] partArray = ELExpression.this.getParts(string);
            int n2 = partArray.length - 1;
            if (bl || ELExpression.this.getPropertyBeingTypedName().length() == 0) {
                ++n2;
            }
            block0: for (n = 1; n < n2; ++n) {
                AnnotatedConstruct annotatedConstruct;
                if (object2 == null && object4 == null) {
                    logger.fine("EL CC: Could not resolve type for property " + partArray[n] + " in " + string);
                    if (failHandler != null) {
                        failHandler.typeNotFound(partArray[n - 1].getIndex(), partArray[n - 1].getPart());
                    }
                    return null;
                }
                if (object2 != null) {
                    AnnotatedConstruct annotatedConstruct2;
                    object = this.getAccessorName(partArray[n].getPart());
                    if (ELExpression.this.isResolvedExpression() && (annotatedConstruct = this.extractTypeParameter(compilationInfo, (TypeMirror)object2, Iterable.class)) != null) {
                        object3 = object2 = annotatedConstruct;
                    }
                    List<Object> list = (annotatedConstruct = compilationInfo.getTypes().asElement((TypeMirror)object2)) instanceof TypeElement ? ElementFilter.methodsIn(compilationInfo.getElements().getAllMembers((TypeElement)annotatedConstruct)) : Collections.emptyList();
                    object2 = null;
                    for (Object object5 : list) {
                        if (!((String)object).equals(object5.getSimpleName().toString())) continue;
                        annotatedConstruct2 = object5.getReturnType();
                        object4 = annotatedConstruct2;
                        if (annotatedConstruct2.getKind() == TypeKind.ARRAY) continue block0;
                        object3 = object2 = annotatedConstruct2;
                        break;
                    }
                    if (object2 == null && n2 - n == 1) {
                        Object object5;
                        String string2 = partArray[n].getPart();
                        object5 = list.iterator();
                        while (object5.hasNext()) {
                            annotatedConstruct2 = (ExecutableElement)object5.next();
                            if (!string2.equals(annotatedConstruct2.getSimpleName().toString())) continue;
                            TypeMirror typeMirror = annotatedConstruct2.getReturnType();
                            object4 = typeMirror;
                            if (typeMirror.getKind() == TypeKind.ARRAY) continue block0;
                            object3 = object2 = typeMirror;
                            break;
                        }
                    }
                }
                if (object2 != null || object4 == null) continue;
                if (object4.getKind() == TypeKind.ARRAY) {
                    object = ((ArrayType)object4).getComponentType();
                    if (object.getKind() == TypeKind.ARRAY) {
                        object4 = object;
                        continue;
                    }
                    object3 = object2 = object;
                } else if (compilationInfo.getTypes().isAssignable(compilationInfo.getTypes().erasure((TypeMirror)object4), compilationInfo.getElements().getTypeElement(List.class.getCanonicalName()).asType())) {
                    if (object4 instanceof DeclaredType && (object = ((DeclaredType)object4).getTypeArguments()).size() != 0 && (annotatedConstruct = object.get(0)).getKind() == TypeKind.DECLARED) {
                        object3 = object2 = annotatedConstruct;
                    }
                    if (object2 == null) {
                        object3 = object2 = compilationInfo.getElements().getTypeElement(Object.class.getCanonicalName()).asType();
                    }
                } else if (compilationInfo.getTypes().isAssignable(compilationInfo.getTypes().erasure((TypeMirror)object4), compilationInfo.getElements().getTypeElement(Map.class.getCanonicalName()).asType())) {
                    if (object4 instanceof DeclaredType && (object = ((DeclaredType)object4).getTypeArguments()).size() == 2 && (annotatedConstruct = object.get(1)).getKind() == TypeKind.DECLARED) {
                        object3 = object2 = annotatedConstruct;
                    }
                    if (object2 == null) {
                        object3 = object2 = compilationInfo.getElements().getTypeElement(Object.class.getCanonicalName()).asType();
                    }
                }
                object4 = null;
            }
            if (object2 == null && object4 == null && failHandler != null) {
                failHandler.typeNotFound(partArray[n - 1].getIndex(), partArray[n - 1].getPart());
            }
            if (ELExpression.this.isResolvedExpression()) {
                object = this.extractTypeParameter(compilationInfo, (TypeMirror)object3, Iterable.class);
                object3 = object != null ? object : object3;
            }
            return object3;
        }

        private TypeMirror extractTypeParameter(CompilationInfo compilationInfo, TypeMirror typeMirror, Class clazz) {
            TypeMirror typeMirror2;
            List<? extends TypeMirror> list;
            if (compilationInfo.getTypes().isAssignable(compilationInfo.getTypes().erasure(typeMirror), compilationInfo.getElements().getTypeElement(clazz.getCanonicalName()).asType()) && typeMirror instanceof DeclaredType && (list = ((DeclaredType)typeMirror).getTypeArguments()).size() != 0 && (typeMirror2 = list.get(0)).getKind() == TypeKind.DECLARED) {
                return typeMirror2;
            }
            return null;
        }

        protected String getAccessorName(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            if (string.length() == 1) {
                stringBuilder.append(Character.toUpperCase(string.charAt(0)));
            } else if (string.length() > 1) {
                stringBuilder.append(Character.toUpperCase(string.charAt(0)));
                stringBuilder.append(string.substring(1));
            }
            return stringBuilder.insert(0, "get").toString();
        }

        protected String getExpressionSuffix(ExecutableElement executableElement, CompilationController compilationController) {
            if (executableElement.getModifiers().contains((Object)Modifier.PUBLIC) && this.checkMethodParameters(executableElement, compilationController)) {
                String string = executableElement.getSimpleName().toString();
                if (string.startsWith("get") && string.length() > 3) {
                    return ELExpression.getPropertyName(string, 3);
                }
                if (string.startsWith("is") && string.length() > 2) {
                    return ELExpression.getPropertyName(string, 2);
                }
                if (ELExpression.this.isDefferedExecution() && this.checkMethod(executableElement, compilationController)) {
                    return string;
                }
            }
            return null;
        }

        protected boolean checkMethodParameters(ExecutableElement executableElement, CompilationController compilationController) {
            return executableElement.getParameters().size() == 0;
        }

        protected boolean checkMethod(ExecutableElement executableElement, CompilationController compilationController) {
            return String.class.getCanonicalName().equals(((Object)executableElement.getReturnType()).toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class InspectPropertiesTask
    extends BaseELTaskClass
    implements CancellableTask<CompilationController> {
        private int myOffset;
        private String myProperty;
        private boolean isLast;

        public InspectPropertiesTask() {
            super(ELExpression.this.getObjectClass());
            this.myOffset = -1;
        }

        public InspectPropertiesTask(String string) {
            super(string);
            this.myOffset = -1;
        }

        public void execute() {
            ELExpression.this.runTask(this);
        }

        public TypeElement getTypePreceedingCaret(CompilationController compilationController) throws Exception {
            return this.getTypePreceedingCaret(compilationController, false, false);
        }

        public TypeElement getTypePreceedingCaret(CompilationController compilationController, boolean bl, boolean bl2) throws Exception {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            return this.getTypePreceedingCaret((CompilationInfo)compilationController, bl2 ? ELExpression.this.getResolvedExpression() : ELExpression.this.getExpression(), new FailHandler(){

                public void typeNotFound(int n, String string) {
                    InspectPropertiesTask.this.myOffset = n;
                    InspectPropertiesTask.this.myProperty = string;
                }
            }, bl);
        }

        public TypeMirror getTypePreceedingCaret(CompilationController compilationController, String string) throws Exception {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            return this.getTypeMirrorPreceedingCaret((CompilationInfo)compilationController, string, null, true);
        }

        public String getProperty() {
            return this.myProperty;
        }

        public int getOffset() {
            return this.myOffset;
        }

        public boolean lastProperty() {
            return this.isLast;
        }

        protected void setOffset(int n) {
            this.myOffset = n;
        }

        protected void setProperty(String string) {
            this.myProperty = string;
        }

        protected void setLast() {
            this.isLast = true;
        }
    }

    public static class Part {
        private int myIndex;
        private String myPart;

        Part(int n, String string) {
            this.myIndex = n;
            this.myPart = string;
        }

        public String getPart() {
            return this.myPart;
        }

        public int getIndex() {
            return this.myIndex;
        }
    }
}

