/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.JspELExpression;
import org.netbeans.modules.web.core.syntax.completion.api.ELExpression;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspHyperlinkProvider
implements HyperlinkProvider {
    private static final Logger logger = Logger.getLogger(JspHyperlinkProvider.class.getName());

    public boolean isHyperlinkPoint(Document document, int n) {
        if (!(document instanceof BaseDocument)) {
            return false;
        }
        try {
            Object object;
            SyntaxElement syntaxElement;
            BaseDocument baseDocument = (BaseDocument)document;
            JTextComponent jTextComponent = Utilities.getFocusedComponent();
            if (jTextComponent == null || jTextComponent.getDocument() != baseDocument) {
                return false;
            }
            JspSyntaxSupport jspSyntaxSupport = JspSyntaxSupport.get((Document)baseDocument);
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return false;
            }
            Token token = tokenSequence.token();
            if (token.id() == JspTokenId.ATTR_VALUE && (syntaxElement = jspSyntaxSupport.getElementChain(n)) != null) {
                if (syntaxElement.getCompletionContext() == 3) {
                    object = (SyntaxElement.Directive)syntaxElement;
                    if ("include".equals(((SyntaxElement.TagLikeElement)object).getName())) {
                        return this.containsAttribute(tokenSequence, "file");
                    }
                    if ("page".equals(((SyntaxElement.TagLikeElement)object).getName())) {
                        return this.containsAttribute(tokenSequence, "errorPage");
                    }
                }
                if (syntaxElement.getCompletionContext() == 1) {
                    while (tokenSequence.movePrevious() && tokenSequence.token().id() != JspTokenId.TAG) {
                        if (tokenSequence.token().id() != JspTokenId.ATTRIBUTE) continue;
                        object = ((Object)tokenSequence.token().text()).toString();
                        String string = ((SyntaxElement.Tag)syntaxElement).getName();
                        if ("jsp:include".equals(string) && "page".equals(object)) {
                            return true;
                        }
                        if ("jsp:forward".equals(string) && "page".equals(object)) {
                            return true;
                        }
                        if (!"jsp:useBean".equals(string) || !"type".equals(object) && !"class".equals(object)) continue;
                        return true;
                    }
                }
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) {
                return false;
            }
            syntaxElement = tokenSequence.embedded(ELTokenId.language());
            if (syntaxElement != null) {
                object = new JspELExpression(jspSyntaxSupport);
                syntaxElement.move(n);
                if (!syntaxElement.moveNext()) {
                    return false;
                }
                if (syntaxElement.token().id() == ELTokenId.DOT) {
                    return false;
                }
                int n2 = syntaxElement.offset() + syntaxElement.token().length();
                int n3 = ((ELExpression)object).parse(n2);
                if (n3 == 1) {
                    n3 = ((ELExpression)object).parse(n2 + 1);
                }
                return n3 == 2;
            }
            return this.canBeTagFile(tokenSequence, jspSyntaxSupport);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return false;
        }
    }

    private boolean containsAttribute(TokenSequence<?> tokenSequence, String string) {
        while (tokenSequence.movePrevious() && tokenSequence.token().id() != JspTokenId.TAG) {
            if (tokenSequence.token().id() != JspTokenId.ATTRIBUTE) continue;
            return ((Object)tokenSequence.token().text()).toString().equals(string);
        }
        return false;
    }

    public int[] getHyperlinkSpan(Document document, int n) {
        if (!(document instanceof BaseDocument)) {
            return null;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        JTextComponent jTextComponent = Utilities.getFocusedComponent();
        if (jTextComponent == null || jTextComponent.getDocument() != baseDocument) {
            return null;
        }
        JspSyntaxSupport jspSyntaxSupport = JspSyntaxSupport.get((Document)baseDocument);
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return null;
        }
        Token token = tokenSequence.token();
        if (this.canBeTagFile(tokenSequence, jspSyntaxSupport)) {
            int n2 = token.offset(tokenHierarchy);
            int n3 = token.offset(tokenHierarchy) + token.length();
            String string = ((Object)token.text()).toString().trim();
            if (string.startsWith("<")) {
                // empty if block
            }
            return new int[]{++n2, n3};
        }
        TokenSequence tokenSequence2 = tokenSequence.embedded(ELTokenId.language());
        if (tokenSequence2 != null) {
            JspELExpression jspELExpression = new JspELExpression(jspSyntaxSupport);
            tokenSequence2.move(n);
            if (!tokenSequence2.moveNext()) {
                return null;
            }
            int n4 = tokenSequence2.offset() + tokenSequence2.token().length();
            int n5 = jspELExpression.parse(n4);
            if (n5 == 2 || n5 == 1) {
                return new int[]{tokenSequence2.offset(), n4};
            }
        }
        if (token.length() > 2) {
            return new int[]{token.offset(tokenHierarchy) + 1, token.offset(tokenHierarchy) + token.length() - 1};
        }
        return null;
    }

    public void performClickAction(final Document document, final int n) {
        document.render(new Runnable(){

            public void run() {
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    BaseDocument baseDocument = (BaseDocument)document;
                    JTextComponent jTextComponent = Utilities.getFocusedComponent();
                    if (jTextComponent == null || jTextComponent.getDocument() != baseDocument) {
                        return;
                    }
                    JspSyntaxSupport jspSyntaxSupport = JspSyntaxSupport.get((Document)baseDocument);
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                    TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                    tokenSequence.move(n);
                    if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                        return;
                    }
                    Token token = tokenSequence.token();
                    TokenSequence tokenSequence2 = tokenSequence.embedded(ELTokenId.language());
                    if (tokenSequence2 != null) {
                        JspELExpression jspELExpression = new JspELExpression(jspSyntaxSupport);
                        tokenSequence2.move(n);
                        if (!tokenSequence2.moveNext()) {
                            return;
                        }
                        int n3 = tokenSequence2.offset() + tokenSequence2.token().length();
                        int n2 = jspELExpression.parse(n3);
                        if (n2 == 1) {
                            JspHyperlinkProvider.this.navigateToUserBeanDef((Document)baseDocument, jspSyntaxSupport, jTextComponent, ((Object)tokenSequence2.token().text()).toString());
                            return;
                        }
                        if (n2 == 2 && !jspELExpression.gotoPropertyDeclaration(jspELExpression.getObjectClass())) {
                            JspHyperlinkProvider.this.gotoSourceFailed();
                        }
                        return;
                    }
                    while (tokenSequence.token().id() != JspTokenId.TAG && !"jsp:useBean".equals(((Object)tokenSequence.token().text()).toString()) && tokenSequence.movePrevious()) {
                    }
                    if (tokenSequence.index() != -1 && tokenSequence.token().id() == JspTokenId.TAG) {
                        object3 = ((Object)token.text()).toString().substring(1, token.length() - 1).trim();
                        object2 = ClasspathInfo.create((FileObject)jspSyntaxSupport.getFileObject());
                        object = JavaSource.create((ClasspathInfo)object2, (Collection)Collections.EMPTY_LIST);
                        AtomicBoolean atomicBoolean = new AtomicBoolean();
                        Compute<TypeElement> compute = new Compute<TypeElement>(atomicBoolean, (JavaSource)object, JavaSource.Phase.ELEMENTS_RESOLVED, new Worker<TypeElement>((String)object3){
                            final /* synthetic */ String val$className;
                            {
                                this.val$className = string;
                            }

                            @Override
                            public TypeElement process(CompilationInfo compilationInfo) {
                                return compilationInfo.getElements().getTypeElement(this.val$className);
                            }
                        });
                        ProgressUtils.runOffEventDispatchThread(compute, (String)NbBundle.getMessage(JspHyperlinkProvider.class, (String)"MSG_goto-source"), (AtomicBoolean)atomicBoolean, (boolean)false);
                        if (atomicBoolean.get()) {
                            return;
                        }
                        TypeElement typeElement = compute.result();
                        if (typeElement != null && !UiUtils.open((ClasspathInfo)object2, (Element)typeElement)) {
                            JspHyperlinkProvider.this.gotoSourceFailed();
                        }
                    }
                    tokenSequence.move(n);
                    if (!tokenSequence.moveNext()) {
                        return;
                    }
                    object3 = JspHyperlinkProvider.this.getTagFile(tokenSequence, jspSyntaxSupport);
                    if (object3 != null) {
                        JspHyperlinkProvider.this.openInEditor(object3);
                    } else {
                        object2 = ((Object)token.text()).toString();
                        object2 = ((String)object2).substring(((String)object2).indexOf(34) + 1);
                        object3 = JspUtils.getFileObject((Document)baseDocument, (String)(object2 = ((String)object2).substring(0, ((String)object2).indexOf(34))));
                        if (object3 != null) {
                            JspHyperlinkProvider.this.openInEditor(object3);
                        } else {
                            object = NbBundle.getMessage(JspHyperlinkProvider.class, (String)"LBL_file_not_found", (Object)object2);
                            StatusDisplayer.getDefault().setStatusText((String)object);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        });
    }

    private String getTagName(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    private void openInEditor(FileObject fileObject) {
        if (fileObject != null) {
            Node.Cookie cookie;
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                return;
            }
            if (dataObject != null && (cookie = dataObject.getCookie(EditCookie.class)) != null) {
                ((EditCookie)cookie).edit();
            }
        }
    }

    private boolean canBeTagFile(TokenSequence<?> tokenSequence, JspSyntaxSupport jspSyntaxSupport) {
        Token token = tokenSequence.token();
        if (token.id() == JspTokenId.TAG) {
            String string = ((Object)token.text()).toString().trim();
            if (string.startsWith("<")) {
                string = string.substring(1).trim();
            }
            if (!string.startsWith("jsp:") && string.indexOf(58) != -1) {
                return true;
            }
        }
        return false;
    }

    private FileObject getTagFile(TokenSequence<?> tokenSequence, JspSyntaxSupport jspSyntaxSupport) {
        Token token = tokenSequence.token();
        if (token.id() == JspTokenId.TAG) {
            TagFileInfo tagFileInfo;
            TagLibraryInfo tagLibraryInfo;
            List list;
            String string = ((Object)token.text()).toString().trim();
            if (string.startsWith("<")) {
                string = string.substring(1).trim();
            }
            if (!string.startsWith("jsp:") && string.indexOf(58) != -1 && (list = jspSyntaxSupport.getTags(string)).size() == 1 && (tagLibraryInfo = ((TagInfo)list.get(0)).getTagLibrary()) != null && (tagFileInfo = tagLibraryInfo.getTagFile(this.getTagName(string))) != null) {
                return JspUtils.getFileObject((Document)jspSyntaxSupport.getDocument(), tagFileInfo.getPath());
            }
        }
        return null;
    }

    private void navigateToUserBeanDef(Document document, JspSyntaxSupport jspSyntaxSupport, JTextComponent jTextComponent, String string) throws BadLocationException {
        String string2 = document.getText(0, document.getLength());
        int n = string2.indexOf(string);
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        while (n > 0) {
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return;
            }
            Token token = tokenSequence.token();
            if (token.id() == JspTokenId.ATTR_VALUE) {
                while (!(token.id() == JspTokenId.ATTRIBUTE && (((Object)token.text()).toString().equals("class") || ((Object)token.text()).toString().equals("type")) || token.id() == JspTokenId.SYMBOL && ((Object)token.text()).toString().equals("/>") || !tokenSequence.moveNext())) {
                    token = tokenSequence.token();
                }
                if (tokenSequence.index() != -1 && token.id() == JspTokenId.SYMBOL) {
                    while (!(token.id() == JspTokenId.ATTRIBUTE && (((Object)token.text()).toString().equals("class") || ((Object)token.text()).toString().equals("type")) || token.id() != JspTokenId.SYMBOL && ((Object)token.text()).toString().equals("<") || !tokenSequence.movePrevious())) {
                        token = tokenSequence.token();
                    }
                }
                if (tokenSequence.index() != -1 && token.id() == JspTokenId.ATTRIBUTE) {
                    while (token.id() != JspTokenId.ATTR_VALUE && tokenSequence.moveNext()) {
                        token = tokenSequence.token();
                    }
                }
                if (tokenSequence.index() != -1 && token.id() == JspTokenId.ATTR_VALUE) {
                    jTextComponent.setCaretPosition(token.offset(tokenHierarchy) + 1);
                    break;
                }
            }
            n = string2.indexOf(string, n + string.length());
        }
    }

    private void gotoSourceFailed() {
        String string = NbBundle.getBundle(JspHyperlinkProvider.class).getString("MSG_source_not_found");
        StatusDisplayer.getDefault().setStatusText(string);
        Toolkit.getDefaultToolkit().beep();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Worker<T> {
        public T process(CompilationInfo var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Compute<T>
    implements Runnable,
    Task<CompilationController> {
        private final AtomicBoolean cancel;
        private final JavaSource source;
        private final JavaSource.Phase phase;
        private final Worker<T> worker;
        private T result;

        public Compute(AtomicBoolean atomicBoolean, JavaSource javaSource, JavaSource.Phase phase, Worker<T> worker) {
            this.cancel = atomicBoolean;
            this.source = javaSource;
            this.phase = phase;
            this.worker = worker;
        }

        @Override
        public void run() {
            try {
                this.source.runUserActionTask((Task)this, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                this.result = null;
            }
        }

        public void run(CompilationController compilationController) throws Exception {
            if (this.cancel.get()) {
                return;
            }
            compilationController.toPhase(this.phase);
            if (this.cancel.get()) {
                return;
            }
            T t = this.worker.process((CompilationInfo)compilationController);
            if (this.cancel.get()) {
                return;
            }
            this.result = t;
        }

        public T result() {
            return this.result;
        }
    }
}

