/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.awt.Color;
import java.util.EventListener;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

public class EmbeddedSectionsHighlighting
extends AbstractHighlightsContainer
implements TokenHierarchyListener {
    private static final Logger LOG = Logger.getLogger(EmbeddedSectionsHighlighting.class.getName());
    private final Document document;
    private final AttributeSet javascripletBackground;
    private final AttributeSet expressionLanguageBackground;
    private TokenHierarchy<? extends Document> hierarchy = null;
    private long version = 0L;

    EmbeddedSectionsHighlighting(Document document) {
        this.document = document;
        AttributeSet attributeSet = null;
        AttributeSet attributeSet2 = null;
        String string = (String)document.getProperty("mimeType");
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((String)string).lookup(FontColorSettings.class);
        if (fontColorSettings != null) {
            Color color;
            Color color2 = EmbeddedSectionsHighlighting.getColoring(fontColorSettings, JspTokenId.SCRIPTLET.primaryCategory());
            if (color2 != null) {
                attributeSet = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color2, ATTR_EXTENDS_EOL, Boolean.TRUE});
            }
            if ((color = EmbeddedSectionsHighlighting.getColoring(fontColorSettings, JspTokenId.EL.primaryCategory())) != null) {
                attributeSet2 = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color, ATTR_EXTENDS_EOL, Boolean.TRUE});
            }
        }
        this.javascripletBackground = attributeSet;
        this.expressionLanguageBackground = attributeSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int n, int n2) {
        EmbeddedSectionsHighlighting embeddedSectionsHighlighting = this;
        synchronized (embeddedSectionsHighlighting) {
            if (this.javascripletBackground != null || this.expressionLanguageBackground != null) {
                if (this.hierarchy == null) {
                    this.hierarchy = TokenHierarchy.get((Document)this.document);
                    if (this.hierarchy != null) {
                        this.hierarchy.addTokenHierarchyListener((TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)((Object)this), this.hierarchy));
                    }
                }
                if (this.hierarchy != null) {
                    return new Highlights(this.version, this.hierarchy, n, n2);
                }
            }
            return HighlightsSequence.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
        EmbeddedSectionsHighlighting embeddedSectionsHighlighting = this;
        synchronized (embeddedSectionsHighlighting) {
            ++this.version;
        }
        this.fireHighlightsChange(tokenHierarchyEvent.affectedStartOffset(), tokenHierarchyEvent.affectedEndOffset());
    }

    private static Color getColoring(FontColorSettings fontColorSettings, String string) {
        AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string);
        if (attributeSet != null) {
            return (Color)attributeSet.getAttribute(StyleConstants.Background);
        }
        return null;
    }

    private static boolean isWhitespace(Document document, int n, int n2) throws BadLocationException {
        int n3 = document.getLength();
        assert (n >= 0);
        assert (n <= n3);
        assert (n2 >= 0);
        assert (n2 <= n3);
        assert (n2 >= n);
        CharSequence charSequence = DocumentUtilities.getText((Document)document, (int)n, (int)(n2 - n));
        for (int i = 0; i < charSequence.length(); ++i) {
            if (Character.isWhitespace(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final class Factory
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            return new HighlightsLayer[]{HighlightsLayer.create((String)"jsp-embedded-java-scriplets-highlighting-layer", (ZOrder)ZOrder.BOTTOM_RACK.forPosition(100), (boolean)true, (HighlightsContainer)new EmbeddedSectionsHighlighting(context.getDocument()))};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Highlights
    implements HighlightsSequence {
        private final long version;
        private final TokenHierarchy<?> scanner;
        private final int startOffset;
        private final int endOffset;
        private TokenSequence<?> sequence = null;
        private int sectionStart = -1;
        private int sectionEnd = -1;
        private boolean finished = false;
        private AttributeSet attributeSet;

        private Highlights(long l, TokenHierarchy<?> tokenHierarchy, int n, int n2) {
            this.version = l;
            this.scanner = tokenHierarchy;
            this.startOffset = n;
            this.endOffset = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            EmbeddedSectionsHighlighting embeddedSectionsHighlighting = EmbeddedSectionsHighlighting.this;
            synchronized (embeddedSectionsHighlighting) {
                if (this.checkVersion()) {
                    if (this.sequence == null) {
                        if (!this.scanner.isActive()) {
                            return false;
                        }
                        this.sequence = this.scanner.tokenSequence();
                        this.sequence.move(this.startOffset);
                    }
                    while (this.sequence.moveNext() && this.sequence.offset() < this.endOffset) {
                        if (EmbeddedSectionsHighlighting.this.javascripletBackground != null && this.sequence.token().id() == JspTokenId.SCRIPTLET) {
                            this.sectionStart = this.sequence.offset();
                            this.sectionEnd = this.sequence.offset() + this.sequence.token().length();
                            try {
                                int n = EmbeddedSectionsHighlighting.this.document.getLength();
                                int n2 = Utilities.getLineOffset((BaseDocument)((BaseDocument)EmbeddedSectionsHighlighting.this.document), (int)Math.min(this.sectionStart, n));
                                int n3 = Utilities.getLineOffset((BaseDocument)((BaseDocument)EmbeddedSectionsHighlighting.this.document), (int)Math.min(this.sectionEnd, n));
                                if (n2 != n3) {
                                    int n4;
                                    int n5;
                                    int n6 = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)EmbeddedSectionsHighlighting.this.document), (int)n2);
                                    if (n6 < this.sectionStart - 2 && EmbeddedSectionsHighlighting.isWhitespace(EmbeddedSectionsHighlighting.this.document, n6, this.sectionStart - 2)) {
                                        this.sectionStart = n6;
                                    }
                                    if (this.sectionEnd + 2 >= (n5 = n3 + 1 < (n4 = Utilities.getRowCount((BaseDocument)((BaseDocument)EmbeddedSectionsHighlighting.this.document))) ? Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)EmbeddedSectionsHighlighting.this.document), (int)(n3 + 1)) : EmbeddedSectionsHighlighting.this.document.getLength()) || EmbeddedSectionsHighlighting.isWhitespace(EmbeddedSectionsHighlighting.this.document, this.sectionEnd + 2, n5)) {
                                        this.sectionEnd = n5;
                                    }
                                }
                                this.attributeSet = EmbeddedSectionsHighlighting.this.javascripletBackground;
                                return true;
                            }
                            catch (BadLocationException badLocationException) {
                                LOG.log(Level.WARNING, null, badLocationException);
                                continue;
                            }
                        }
                        if (EmbeddedSectionsHighlighting.this.expressionLanguageBackground == null || this.sequence.token().id() != JspTokenId.EL) continue;
                        this.sectionStart = this.sequence.offset();
                        this.sectionEnd = this.sequence.offset() + this.sequence.token().length();
                        this.attributeSet = EmbeddedSectionsHighlighting.this.expressionLanguageBackground;
                        return true;
                    }
                }
                this.sectionStart = -1;
                this.sectionEnd = -1;
                this.finished = true;
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStartOffset() {
            EmbeddedSectionsHighlighting embeddedSectionsHighlighting = EmbeddedSectionsHighlighting.this;
            synchronized (embeddedSectionsHighlighting) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.sequence != null) : "Sequence not initialized, call moveNext() first.";
                return Math.max(this.sectionStart, this.startOffset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEndOffset() {
            EmbeddedSectionsHighlighting embeddedSectionsHighlighting = EmbeddedSectionsHighlighting.this;
            synchronized (embeddedSectionsHighlighting) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.sequence != null) : "Sequence not initialized, call moveNext() first.";
                return Math.min(this.sectionEnd, this.endOffset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getAttributes() {
            EmbeddedSectionsHighlighting embeddedSectionsHighlighting = EmbeddedSectionsHighlighting.this;
            synchronized (embeddedSectionsHighlighting) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.sequence != null) : "Sequence not initialized, call moveNext() first.";
                return this.attributeSet;
            }
        }

        private boolean checkVersion() {
            return this.version == EmbeddedSectionsHighlighting.this.version;
        }
    }
}

