/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.model.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.asm.model.lang.instruction.InstructionArgs;
import org.netbeans.modules.cnd.asm.model.lang.operand.Operand;
import org.netbeans.modules.cnd.asm.model.xml.Util;
import org.netbeans.modules.cnd.asm.model.xml.XMLBaseInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultXMLBaseInstruction
extends XMLBaseInstruction {
    public static final Collection<Integer> DEFAULT_READ = Arrays.asList(2);
    public static final Collection<Integer> DEFAULT_WRITE = Arrays.asList(1);
    private Collection<Integer> readArgsIdx = DEFAULT_READ;
    private Collection<Integer> writeArgsIdx = DEFAULT_WRITE;
    private static final String ARG_PREFIX = "%arg";

    public DefaultXMLBaseInstruction(String string, String string2, String string3, Collection<InstructionArgs> collection) {
        super(string, string3, string2, collection);
    }

    public boolean isSupportive(Operand[] operandArray) {
        return false;
    }

    public void setWrite(String string) {
        this.writeArgsIdx = DefaultXMLBaseInstruction.parseArgs(Util.descriptionTokenizer(string));
        if (this.readArgsIdx == DEFAULT_READ) {
            this.readArgsIdx = Collections.emptyList();
        }
    }

    public void setRead(String string) {
        this.readArgsIdx = DefaultXMLBaseInstruction.parseArgs(Util.descriptionTokenizer(string));
        if (this.writeArgsIdx == DEFAULT_WRITE) {
            this.writeArgsIdx = Collections.emptyList();
        }
    }

    private static Collection<Integer> parseArgs(List<String> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string : list) {
            if (!string.startsWith(ARG_PREFIX)) continue;
            String string2 = string.substring(ARG_PREFIX.length(), string.length() - 1);
            try {
                arrayList.add(Integer.valueOf(string2));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return arrayList;
    }

    @Override
    public Collection<Integer> getReadArgIdxs() {
        return this.readArgsIdx;
    }

    @Override
    public Collection<Integer> getWriteArgIdxs() {
        return this.writeArgsIdx;
    }
}

