/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.asm.model.lang.AsmOffsetable;
import org.netbeans.modules.cnd.asm.model.util.DefaultOffsetable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalSet<E extends AsmOffsetable>
implements Iterable<E> {
    private List<E> intervals;

    public IntervalSet() {
        this.intervals = new ArrayList();
    }

    public IntervalSet(int n) {
        this.intervals = new ArrayList(n);
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public int getLowerBound() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty");
        }
        return ((AsmOffsetable)this.intervals.get(0)).getStartOffset();
    }

    public int getUpperBound() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty");
        }
        return ((AsmOffsetable)this.intervals.get(this.intervals.size() - 1)).getEndOffset();
    }

    public IntervalSet<E> getFromBounds(int n, int n2) {
        IntervalSet<AsmOffsetable> intervalSet = new IntervalSet<AsmOffsetable>();
        DefaultOffsetable defaultOffsetable = new DefaultOffsetable(n, n2);
        for (AsmOffsetable asmOffsetable : this) {
            int n3 = IntersectionComparator.getInstance().compare(defaultOffsetable, asmOffsetable);
            if (n3 == 0) {
                intervalSet.add(asmOffsetable);
                continue;
            }
            if (n3 >= 0) continue;
            break;
        }
        return intervalSet;
    }

    public void add(E e) {
        int n = Collections.binarySearch(this.intervals, e, IntersectionComparator.getInstance());
        if (n >= 0) {
            throw new IllegalArgumentException("Intersection");
        }
        this.intervals.add(-n - 1, e);
    }

    public E getElementAtPosition(int n) {
        int n2 = Collections.binarySearch(this.intervals, new DummyOffsetable(n), IntersectionComparator.getInstance());
        return (E)(n2 < 0 ? null : (AsmOffsetable)this.intervals.get(n2));
    }

    public void clear() {
        this.intervals.clear();
    }

    public List<E> getList() {
        return Collections.unmodifiableList(this.intervals);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getList().iterator();
    }

    private static class DummyOffsetable
    implements AsmOffsetable {
        private int pos;

        public DummyOffsetable(int n) {
            this.pos = n;
        }

        public int getStartOffset() {
            return this.pos;
        }

        public int getEndOffset() {
            return this.pos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntersectionComparator
    implements Comparator<AsmOffsetable> {
        private static final Comparator<AsmOffsetable> instance = new IntersectionComparator();

        public static Comparator<AsmOffsetable> getInstance() {
            return instance;
        }

        @Override
        public int compare(AsmOffsetable asmOffsetable, AsmOffsetable asmOffsetable2) {
            if (asmOffsetable.getEndOffset() < asmOffsetable2.getStartOffset()) {
                return -1;
            }
            if (asmOffsetable2.getEndOffset() < asmOffsetable.getStartOffset()) {
                return 1;
            }
            return 0;
        }

        private IntersectionComparator() {
        }
    }
}

