/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.cnd.asm.model.AsmModelProvider;
import org.netbeans.modules.cnd.asm.model.AsmSyntaxProvider;
import org.netbeans.modules.cnd.asm.model.AsmTypesProvider;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class ModelChooser
extends AbstractAction
implements Presenter.Menu {
    private static AsmModelProvider curModel;
    private static AsmSyntaxProvider curSyntax;
    private static JMenu menu;

    public static AsmModelProvider getModelProvider() {
        return curModel;
    }

    public static AsmSyntaxProvider getSyntaxProvider() {
        return curSyntax;
    }

    public ModelChooser() {
        super(NbBundle.getMessage(ModelChooser.class, (String)"CTL_ModelChooser"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (false);
    }

    public JMenuItem getMenuPresenter() {
        String string = NbBundle.getMessage(ModelChooser.class, (String)"CTL_ModelChooser");
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)string);
        return menu;
    }

    static {
        menu = new UpdatingMenu();
    }

    private static final class UpdatingMenu
    extends JMenu
    implements DynamicMenuContent {
        private JComponent[] models = this.calcPresenters();

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return this.models;
        }

        public JComponent[] getMenuPresenters() {
            return this.models;
        }

        public JComponent[] calcPresenters() {
            this.removeAll();
            ButtonGroup buttonGroup = new ButtonGroup();
            boolean bl = true;
            Collection collection = Lookup.getDefault().lookup(new Lookup.Template(AsmTypesProvider.class)).allInstances();
            for (AsmTypesProvider asmTypesProvider : collection) {
                for (AsmTypesProvider.AsmTypesEntry asmTypesEntry : asmTypesProvider.getAsmTypes()) {
                    Iterator<AsmSyntaxProvider> iterator = asmTypesEntry.getSyntaxProviders().iterator();
                    while (iterator.hasNext()) {
                        AsmSyntaxProvider asmSyntaxProvider;
                        final AsmSyntaxProvider asmSyntaxProvider2 = asmSyntaxProvider = iterator.next();
                        final AsmModelProvider asmModelProvider = asmTypesEntry.getModelProvider();
                        String string = asmModelProvider.toString();
                        String string2 = asmSyntaxProvider2.toString();
                        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string + " - " + string2);
                        jRadioButtonMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                curModel = asmModelProvider;
                                curSyntax = asmSyntaxProvider2;
                            }
                        });
                        buttonGroup.add(jRadioButtonMenuItem);
                        this.add(jRadioButtonMenuItem);
                        if (!bl) continue;
                        buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
                        curModel = asmModelProvider;
                        curSyntax = asmSyntaxProvider2;
                        bl = false;
                    }
                }
            }
            this.setEnabled(true);
            return new JComponent[]{this};
        }
    }
}

