/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.editor;

import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.cnd.asm.model.AbstractAsmModel;
import org.netbeans.modules.cnd.asm.model.AsmModel;
import org.netbeans.modules.cnd.asm.model.AsmModelAccessor;
import org.netbeans.modules.cnd.asm.model.AsmState;
import org.netbeans.modules.cnd.asm.model.AsmSyntax;
import org.netbeans.modules.cnd.asm.model.lang.AsmElement;
import org.netbeans.modules.cnd.asm.model.lang.BranchElement;
import org.netbeans.modules.cnd.asm.model.lang.LabelElement;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmParser;
import org.netbeans.modules.cnd.asm.model.util.AsmModelUtilities;
import org.netbeans.modules.cnd.asm.model.util.EmptyAsmState;
import org.netbeans.modules.cnd.asm.model.util.Pair;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class AsmModelAccessorImpl
implements AsmModelAccessor {
    private static final Logger LOGGER = Logger.getLogger(AsmModelAccessorImpl.class.getName());
    private static final RequestProcessor reqProc = new RequestProcessor("asm parser", 1);
    private static final int INPUT_REACTION_DELAY = 500;
    private AsmState lastState;
    private final Object stateLock;
    private final AbstractAsmModel model;
    private final AsmSyntax synt;
    private final Document doc;
    private final String docName;
    private final AsmDocumentListener docListener;
    private final RequestProcessor.Task reparseTask;
    private final List<AsmModelAccessor.ParseListener> listeners;

    public AsmModelAccessorImpl(AsmModel asmModel, AsmSyntax asmSyntax, Document document) {
        this.model = (AbstractAsmModel)asmModel;
        this.synt = asmSyntax;
        this.doc = document;
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        this.docName = fileObject != null ? fileObject.getName() : "";
        this.reparseTask = reqProc.create((Runnable)new ReparseTask(), true);
        this.listeners = new LinkedList<AsmModelAccessor.ParseListener>();
        this.notifyChange(true);
        this.docListener = new AsmDocumentListener(document);
        this.stateLock = new Object();
        this.lastState = new EmptyAsmState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsmState getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.lastState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParseListener(AsmModelAccessor.ParseListener parseListener) {
        List<AsmModelAccessor.ParseListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(parseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParseListener(AsmModelAccessor.ParseListener parseListener) {
        List<AsmModelAccessor.ParseListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(parseListener);
        }
    }

    private void notifyChange(boolean bl) {
        int n = bl ? 0 : 500;
        this.reparseTask.schedule(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireParsed() {
        List<AsmModelAccessor.ParseListener> list = this.listeners;
        synchronized (list) {
            for (AsmModelAccessor.ParseListener parseListener : this.listeners) {
                parseListener.notifyParsed();
            }
        }
    }

    private class AsmDocumentListener
    implements DocumentListener {
        public AsmDocumentListener(Document document) {
            document.addDocumentListener(WeakListeners.document((DocumentListener)this, (Object)document));
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AsmModelAccessorImpl.this.notifyChange(false);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AsmModelAccessorImpl.this.notifyChange(false);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class X86AsmState
    implements AsmState {
        private final AsmElement elements;
        private final Lookup lookup;

        public X86AsmState(AsmElement asmElement, Lookup lookup) {
            this.elements = asmElement;
            this.lookup = lookup;
        }

        @Override
        public Lookup getServices() {
            return this.lookup;
        }

        @Override
        public AsmElement getElements() {
            return this.elements;
        }

        public boolean isActual() {
            return AsmModelAccessorImpl.this.lastState == this;
        }

        @Override
        public Pair<AsmElement, AsmElement> resolveLink(int n) {
            AsmElement asmElement = AsmModelUtilities.findAtRecursive(this.elements, n);
            if (asmElement instanceof BranchElement) {
                String string = ((BranchElement)asmElement).getName();
                LabelLinkResolver labelLinkResolver = new LabelLinkResolver(string);
                AsmModelUtilities.walkCompound(this.elements, labelLinkResolver);
                AsmElement asmElement2 = labelLinkResolver.getResult();
                if (asmElement2 != null) {
                    return Pair.getPair(asmElement, asmElement2);
                }
            }
            return null;
        }

        private class LabelLinkResolver
        implements AsmModelUtilities.AsmVisitor {
            private AsmElement result;
            private String name;

            public LabelLinkResolver(String string) {
                this.name = string;
            }

            public boolean visit(AsmElement asmElement) {
                LabelElement labelElement;
                if (asmElement instanceof LabelElement && (labelElement = (LabelElement)asmElement).getName().equals(this.name)) {
                    this.result = labelElement;
                    return false;
                }
                return true;
            }

            public AsmElement getResult() {
                return this.result;
            }
        }
    }

    private class ReparseTask
    implements Runnable {
        private ReparseTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = System.currentTimeMillis();
            AsmParser asmParser = AsmModelAccessorImpl.this.synt.createParser();
            AsmElement asmElement = asmParser.parse(new StringReader(AsmObjectUtilities.getText(AsmModelAccessorImpl.this.doc)));
            long l2 = System.currentTimeMillis();
            LOGGER.log(Level.FINE, String.format("%s parse time: %d ms", AsmModelAccessorImpl.this.docName, l2 - l));
            if (!Thread.currentThread().isInterrupted()) {
                Object object = AsmModelAccessorImpl.this.stateLock;
                synchronized (object) {
                    AsmModelAccessorImpl.this.lastState = new X86AsmState(asmElement, asmParser.getServices());
                }
                AsmModelAccessorImpl.this.fireParsed();
            }
        }
    }
}

