/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core.wizard;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ImporterWizardPanel;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectImporterWizard;
import org.netbeans.modules.projectimport.eclipse.core.wizard.SelectionPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SelectionWizardPanel
extends ImporterWizardPanel
implements PropertyChangeListener,
WizardDescriptor.ValidatingPanel<WizardDescriptor> {
    private SelectionPanel panel = new SelectionPanel();

    SelectionWizardPanel() {
        this.panel.addPropertyChangeListener(this);
        this.initPanel(this.panel, 0);
    }

    public Component getComponent() {
        return this.panel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("errorMessage".equals(string)) {
            this.setErrorMessage((String)propertyChangeEvent.getNewValue());
        } else if ("workspaceChoosen".equals(string)) {
            String[] stringArray = (Boolean)propertyChangeEvent.getNewValue() != false ? new String[]{WORKSPACE_LOCATION_STEP, PROJECTS_SELECTION_STEP} : new String[]{PROJECT_SELECTION_STEP};
            this.panel.putClientProperty("WizardPanel_contentData", stringArray);
            this.setValid(this.isValid(), true);
        }
    }

    boolean isWorkspaceChosen() {
        return this.panel.isWorkspaceChosen();
    }

    String getProjectDir() {
        return this.panel.getProjectDir();
    }

    public String getProjectDestinationDir() {
        return this.panel.getProjectDestinationDir();
    }

    public File getWorkspaceDir() {
        return this.panel.getWorkspaceDir();
    }

    public void validate() throws WizardValidationException {
        if (!this.panel.isWorkspaceChosen()) {
            String string = this.getProjectDestinationDir();
            String string2 = null;
            if (!(string == null || new File(string).isAbsolute() && EclipseUtils.isWritable(string))) {
                string2 = ProjectImporterWizard.getMessage("MSG_CannotCreateProjectInFolder", string);
            } else if (!EclipseUtils.isRegularProject(this.getProjectDir())) {
                string2 = ProjectImporterWizard.getMessage("MSG_CannotImportNonJavaProject");
            }
            if (string2 != null) {
                this.setErrorMessage(string2);
                throw new WizardValidationException((JComponent)this.panel, string2, null);
            }
        }
    }
}

