/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.ImportProblemsPanel;
import org.netbeans.modules.projectimport.eclipse.core.ImportProjectAction;
import org.netbeans.modules.projectimport.eclipse.core.RequiredProjectsPanel;
import org.netbeans.modules.projectimport.eclipse.core.UpdateProjectAction;
import org.netbeans.modules.projectimport.eclipse.core.UpgradableProject;
import org.netbeans.modules.projectimport.eclipse.core.WorkspaceFactory;
import org.netbeans.modules.projectimport.eclipse.core.wizard.ProjectSelectionPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateAllProjects {
    private static final Logger LOG = Logger.getLogger(UpdateAllProjects.class.getName());

    private List<UpgradableProject> getListOfUpdatableProjects() {
        ArrayList<UpgradableProject> arrayList = new ArrayList<UpgradableProject>();
        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
            UpgradableProject upgradableProject = (UpgradableProject)project.getLookup().lookup(UpgradableProject.class);
            if (upgradableProject == null || !upgradableProject.isCreatedFromEclipse()) continue;
            arrayList.add(upgradableProject);
        }
        return arrayList;
    }

    private boolean ensureProjectsReachable(List<UpgradableProject> list, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (UpgradableProject upgradableProject : list) {
            if (upgradableProject.isEclipseProjectReachable()) continue;
            if (bl) {
                LOG.info("eclipse link is broken for project: " + upgradableProject.getProject().getProjectDirectory());
                return false;
            }
            if (upgradableProject.updateBrokenEclipseReference(hashMap)) continue;
            return false;
        }
        return true;
    }

    private Boolean resolveNewRequiredProjects(List<UpgradableProject> list, boolean bl, List<String> list2, List<Project> list3) throws IOException {
        HashMap<File, ProjectsAndDestination> hashMap = new HashMap<File, ProjectsAndDestination>();
        HashSet<File> hashSet = new HashSet<File>();
        for (UpgradableProject object : list) {
            if (object.getWorkspace() == null) continue;
            hashSet.add(object.getWorkspace().getDirectory());
        }
        for (File file : hashSet) {
            ProjectsAndDestination projectsAndDestination = new ProjectsAndDestination();
            for (UpgradableProject upgradableProject : list) {
                if (upgradableProject.getWorkspace() == null || !upgradableProject.getWorkspace().getDirectory().equals(file)) continue;
                EclipseProject eclipseProject = upgradableProject.getEclipseProject();
                File file2 = FileUtil.toFile((FileObject)upgradableProject.getProject().getProjectDirectory());
                File file3 = null;
                if (!file2.equals(eclipseProject.getDirectory())) {
                    file3 = file2.getParentFile();
                }
                projectsAndDestination.dest = file3;
                Set<EclipseProject> set = ProjectSelectionPanel.getFlattenedRequiredProjects(Collections.singleton(eclipseProject));
                for (EclipseProject eclipseProject2 : set) {
                    File file4;
                    File file5 = file4 = file3 == null ? eclipseProject2.getDirectory() : new File(file3, eclipseProject2.getDirectory().getName());
                    if (projectsAndDestination.eps.contains(eclipseProject2) || this.findNetBeansProject(file4, eclipseProject2)) continue;
                    projectsAndDestination.eps.add(eclipseProject2);
                }
            }
            if (projectsAndDestination.eps.size() <= 0) continue;
            hashMap.put(file, projectsAndDestination);
        }
        if (hashMap.values().size() == 0) {
            return Boolean.FALSE;
        }
        if (hashMap.values().size() > 0 && bl) {
            return null;
        }
        if (!RequiredProjectsPanel.showConfirmation(hashMap.values())) {
            return null;
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            ImportProjectAction.performImport(ProjectSelectionPanel.getFlattenedProjects(((ProjectsAndDestination)entry.getValue()).eps), ((ProjectsAndDestination)entry.getValue()).dest == null ? null : ((ProjectsAndDestination)entry.getValue()).dest.getPath(), null, ((ProjectsAndDestination)entry.getValue()).eps.size(), false, false, true, list2, list3);
        }
        return Boolean.TRUE;
    }

    private boolean findNetBeansProject(File file, EclipseProject eclipseProject) throws IOException {
        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
            if (!eclipseProject.getName().equals(((ProjectInformation)project.getLookup().lookup(ProjectInformation.class)).getDisplayName())) continue;
            return true;
        }
        if (!file.exists()) {
            return false;
        }
        return ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file)) != null;
    }

    private boolean updateExistingProjects(List<UpgradableProject> list, List<String> list2, boolean bl) throws IOException {
        boolean bl2 = false;
        boolean bl3 = !bl;
        for (UpgradableProject upgradableProject : list) {
            if (upgradableProject.isUpToDate(bl3)) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            bl2 = true;
            upgradableProject.update(arrayList);
            if (arrayList.size() <= 0) continue;
            list2.add(NbBundle.getMessage(UpdateAllProjects.class, (String)"MSG_ProjectUpdateIssues", (Object)upgradableProject.getEclipseProject().getName()));
            for (String string : arrayList) {
                list2.add(" " + string);
            }
        }
        return bl2;
    }

    public void update(boolean bl) {
        LOG.fine("Eclipse resynchronize started (" + bl + ")");
        WorkspaceFactory.getInstance().resetCache();
        ArrayList<String> arrayList = new ArrayList<String>();
        List<UpgradableProject> list = this.getListOfUpdatableProjects();
        if (list.size() == 0 && !bl) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(UpdateProjectAction.class, (String)"UpdateProjectAction.nothing-to-synch")));
            return;
        }
        if (!this.ensureProjectsReachable(list, bl)) {
            return;
        }
        try {
            Boolean bl2 = this.resolveNewRequiredProjects(list, bl, arrayList, null);
            if (bl2 == null) {
                return;
            }
            boolean bl3 = this.updateExistingProjects(list, arrayList, bl);
            if (!bl3 && bl2.equals(Boolean.FALSE) && !bl) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(UpdateProjectAction.class, (String)"UpdateProjectAction.already-in-synch")));
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "synchronization with Eclipse failed", iOException);
            arrayList.add(NbBundle.getMessage(UpdateAllProjects.class, (String)"MSG_UpdateFailed", (Object)iOException.getMessage()));
        }
        if (arrayList.size() > 0) {
            arrayList.add(0, NbBundle.getMessage(UpdateProjectAction.class, (String)"UpdateProjectAction.problems-occurred-2"));
        }
        ImportProblemsPanel.showReport(NbBundle.getMessage(UpdateProjectAction.class, (String)"UpdateProjectAction.update-issues"), arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProjectsAndDestination {
        private Set<EclipseProject> eps = new HashSet<EclipseProject>();
        private File dest;

        public File getDestination() {
            return this.dest;
        }

        public Set<EclipseProject> getEclipseProjects() {
            return this.eps;
        }
    }
}

