/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.util.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class SplitChannel
implements ReadableByteChannel,
WritableByteChannel {
    private ReadableByteChannel inChannel;
    private WritableByteChannel outChannel;
    private boolean isOpen;
    private boolean writable;
    private boolean readable;

    public SplitChannel(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel) {
        this.inChannel = readableByteChannel;
        this.outChannel = writableByteChannel;
        this.isOpen = true;
        if (readableByteChannel != null) {
            this.readable = true;
        }
        if (writableByteChannel != null) {
            this.writable = true;
        }
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.isOpen && this.readable) {
            return this.inChannel.read(byteBuffer);
        }
        throw new EOFException();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void close() throws IOException {
        this.inChannel.close();
        this.outChannel.close();
        this.isOpen = false;
    }

    public void closeRead() throws IOException {
        this.inChannel.close();
        this.readable = false;
    }

    public void closeWrite() throws IOException {
        this.outChannel.close();
        this.writable = false;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        if (this.isOpen && this.writable) {
            return this.outChannel.write(byteBuffer);
        }
        throw new EOFException();
    }
}

