/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Pattern;
import org.jruby.nb.util.JRubyFile;

public class JavaNameMangler {
    public static final Pattern PATH_SPLIT = Pattern.compile("[/\\\\]");

    public static String mangledFilenameForStartupClasspath(String string) {
        if (string.equals("-e")) {
            return "ruby/__dash_e__";
        }
        return JavaNameMangler.mangleFilenameForClasspath(string, null, "", false);
    }

    public static String mangleFilenameForClasspath(String string) {
        return JavaNameMangler.mangleFilenameForClasspath(string, null, "ruby");
    }

    public static String mangleFilenameForClasspath(String string, String string2, String string3) {
        return JavaNameMangler.mangleFilenameForClasspath(string, string2, string3, true);
    }

    public static String mangleFilenameForClasspath(String string, String string2, String string3, boolean bl) {
        try {
            Object object;
            String string4 = "";
            if (string.indexOf("!") != -1) {
                object = string.substring(6, string.indexOf("!"));
                string4 = bl ? new JRubyFile((String)object + string.substring(string.indexOf("!") + 1)).getCanonicalPath().toString() : new JRubyFile((String)object + string.substring(string.indexOf("!") + 1)).toString();
            } else {
                try {
                    string4 = bl ? new JRubyFile(string).getCanonicalPath().toString() : new JRubyFile(string).toString();
                }
                catch (IOException iOException) {
                    string4 = string;
                }
            }
            if (string2 != null && string2.length() > 0) {
                try {
                    object = bl ? new JRubyFile(string2).getCanonicalPath().toString() : new JRubyFile(string2).toString();
                }
                catch (IOException iOException) {
                    object = string2;
                }
                if (!string4.startsWith((String)object)) {
                    throw new FileNotFoundException("File path " + string4 + " does not start with parent path " + (String)object);
                }
                int n = ((String)object).length();
                string4 = string4.substring(n);
            }
            object = PATH_SPLIT.split(string4);
            StringBuilder stringBuilder = new StringBuilder(string3);
            for (String string5 : object) {
                if (string5.length() <= 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("/");
                }
                if (!Character.isJavaIdentifierStart(string5.charAt(0))) {
                    stringBuilder.append("$");
                }
                stringBuilder.append(JavaNameMangler.mangleStringForCleanJavaIdentifier(string5));
            }
            int n = stringBuilder.indexOf("_dot_rb");
            if (n != -1 && n == stringBuilder.length() - 7) {
                stringBuilder.delete(n, n + 7);
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    public static String mangleStringForCleanJavaIdentifier(String string) {
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        block15: for (int i = 0; i < cArray.length; ++i) {
            if (i == 0 && Character.isJavaIdentifierStart(cArray[i]) || Character.isJavaIdentifierPart(cArray[i])) {
                stringBuilder.append(cArray[i]);
                bl = false;
                continue;
            }
            if (!bl) {
                stringBuilder.append("_");
            }
            bl = true;
            switch (cArray[i]) {
                case '?': {
                    stringBuilder.append("p_");
                    continue block15;
                }
                case '!': {
                    stringBuilder.append("b_");
                    continue block15;
                }
                case '<': {
                    stringBuilder.append("lt_");
                    continue block15;
                }
                case '>': {
                    stringBuilder.append("gt_");
                    continue block15;
                }
                case '=': {
                    stringBuilder.append("equal_");
                    continue block15;
                }
                case '[': {
                    if (i + 1 < cArray.length && cArray[i + 1] == ']') {
                        stringBuilder.append("aref_");
                        ++i;
                        continue block15;
                    }
                    stringBuilder.append("lbracket_");
                    continue block15;
                }
                case ']': {
                    stringBuilder.append("rbracket_");
                    continue block15;
                }
                case '+': {
                    stringBuilder.append("plus_");
                    continue block15;
                }
                case '-': {
                    stringBuilder.append("minus_");
                    continue block15;
                }
                case '*': {
                    stringBuilder.append("times_");
                    continue block15;
                }
                case '/': {
                    stringBuilder.append("div_");
                    continue block15;
                }
                case '&': {
                    stringBuilder.append("and_");
                    continue block15;
                }
                case '.': {
                    stringBuilder.append("dot_");
                    continue block15;
                }
                default: {
                    stringBuilder.append(Integer.toHexString(cArray[i])).append("_");
                }
            }
        }
        return stringBuilder.toString();
    }
}

