/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyModule;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CacheMap;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public abstract class CallSite {
    public final String methodName;
    protected final CallType callType;

    public CallSite(String string, CallType callType) {
        this.methodName = string;
        this.callType = callType;
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, IRubyObject var5);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject[] var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, Block var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, Block var4);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, Block var5);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, IRubyObject var5, Block var6);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject[] var3, Block var4);

    public abstract IRubyObject callIter(ThreadContext var1, IRubyObject var2, Block var3);

    public abstract IRubyObject callIter(ThreadContext var1, IRubyObject var2, IRubyObject var3, Block var4);

    public abstract IRubyObject callIter(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, Block var5);

    public abstract IRubyObject callIter(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, IRubyObject var5, Block var6);

    public abstract IRubyObject callIter(ThreadContext var1, IRubyObject var2, IRubyObject[] var3, Block var4);

    public static class GeCallSite
    extends InlineCachingCallSite {
        public GeCallSite() {
            super(">=", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            if (iRubyObject instanceof RubyFixnum) {
                return ((RubyFixnum)iRubyObject).op_ge(threadContext, iRubyObject2);
            }
            return super.call(threadContext, iRubyObject, iRubyObject2);
        }
    }

    public static class GtCallSite
    extends InlineCachingCallSite {
        public GtCallSite() {
            super(">", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            if (iRubyObject instanceof RubyFixnum) {
                return ((RubyFixnum)iRubyObject).op_gt(threadContext, iRubyObject2);
            }
            return super.call(threadContext, iRubyObject, iRubyObject2);
        }
    }

    public static class LeCallSite
    extends InlineCachingCallSite {
        public LeCallSite() {
            super("<=", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            if (iRubyObject instanceof RubyFixnum) {
                return ((RubyFixnum)iRubyObject).op_le(threadContext, iRubyObject2);
            }
            return super.call(threadContext, iRubyObject, iRubyObject2);
        }
    }

    public static class LtCallSite
    extends InlineCachingCallSite {
        public LtCallSite() {
            super("<", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            if (iRubyObject instanceof RubyFixnum) {
                return ((RubyFixnum)iRubyObject).op_lt(threadContext, iRubyObject2);
            }
            return super.call(threadContext, iRubyObject, iRubyObject2);
        }
    }

    public static class DivCallSite
    extends InlineCachingCallSite {
        public DivCallSite() {
            super("/", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            if (iRubyObject instanceof RubyFixnum) {
                return ((RubyFixnum)iRubyObject).op_div(threadContext, iRubyObject2);
            }
            return super.call(threadContext, iRubyObject, iRubyObject2);
        }
    }

    public static class MulCallSite
    extends InlineCachingCallSite {
        public MulCallSite() {
            super("*", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            if (iRubyObject instanceof RubyFixnum) {
                return ((RubyFixnum)iRubyObject).op_mul(threadContext, iRubyObject2);
            }
            return super.call(threadContext, iRubyObject, iRubyObject2);
        }
    }

    public static class MinusCallSite
    extends InlineCachingCallSite {
        public MinusCallSite() {
            super("-", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            if (iRubyObject instanceof RubyFixnum) {
                return ((RubyFixnum)iRubyObject).op_minus(threadContext, iRubyObject2);
            }
            return super.call(threadContext, iRubyObject, iRubyObject2);
        }
    }

    public static class PlusCallSite
    extends InlineCachingCallSite {
        public PlusCallSite() {
            super("+", CallType.NORMAL);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            if (iRubyObject instanceof RubyFixnum) {
                return ((RubyFixnum)iRubyObject).op_plus(threadContext, iRubyObject2);
            }
            return super.call(threadContext, iRubyObject, iRubyObject2);
        }
    }

    public static class InlineCachingCallSite
    extends CallSite
    implements CacheMap.CacheSite {
        private static final CacheEntry NULL_CACHE = new CacheEntry(null, null);
        private volatile CacheEntry cache = NULL_CACHE;
        private int misses = 0;
        private static final int MAX_MISSES = 50;
        public static volatile int totalCallSites;
        public static volatile int failedCallSites;

        public InlineCachingCallSite(String string, CallType callType) {
            super(string, callType);
            ++totalCallSites;
        }

        protected IRubyObject cacheAndCall(RubyClass rubyClass, Block block, IRubyObject[] iRubyObjectArray, ThreadContext threadContext, IRubyObject iRubyObject) {
            DynamicMethod dynamicMethod = rubyClass.searchMethod(this.methodName);
            if (this.methodMissing(dynamicMethod, threadContext)) {
                return this.callMethodMissing(threadContext, iRubyObject, dynamicMethod, iRubyObjectArray, block);
            }
            this.updateCacheEntry(dynamicMethod, rubyClass);
            return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObjectArray, block);
        }

        protected IRubyObject cacheAndCall(RubyClass rubyClass, IRubyObject[] iRubyObjectArray, ThreadContext threadContext, IRubyObject iRubyObject) {
            DynamicMethod dynamicMethod = rubyClass.searchMethod(this.methodName);
            if (this.methodMissing(dynamicMethod, threadContext)) {
                return this.callMethodMising(threadContext, iRubyObject, dynamicMethod, iRubyObjectArray);
            }
            this.updateCacheEntry(dynamicMethod, rubyClass);
            return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObjectArray);
        }

        protected IRubyObject cacheAndCall(RubyClass rubyClass, ThreadContext threadContext, IRubyObject iRubyObject) {
            DynamicMethod dynamicMethod = rubyClass.searchMethod(this.methodName);
            if (this.methodMissing(dynamicMethod, threadContext)) {
                return this.callMethodMissing(threadContext, iRubyObject, dynamicMethod);
            }
            this.updateCacheEntry(dynamicMethod, rubyClass);
            return dynamicMethod.call(threadContext, iRubyObject, rubyClass, this.methodName);
        }

        protected IRubyObject cacheAndCall(RubyClass rubyClass, Block block, ThreadContext threadContext, IRubyObject iRubyObject) {
            DynamicMethod dynamicMethod = rubyClass.searchMethod(this.methodName);
            if (this.methodMissing(dynamicMethod, threadContext)) {
                return this.callMethodMissing(threadContext, iRubyObject, dynamicMethod, block);
            }
            this.updateCacheEntry(dynamicMethod, rubyClass);
            return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, block);
        }

        protected IRubyObject cacheAndCall(RubyClass rubyClass, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            DynamicMethod dynamicMethod = rubyClass.searchMethod(this.methodName);
            if (this.methodMissing(dynamicMethod, threadContext)) {
                return this.callMethodMissing(threadContext, iRubyObject, dynamicMethod, iRubyObject2);
            }
            this.updateCacheEntry(dynamicMethod, rubyClass);
            return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObject2);
        }

        protected IRubyObject cacheAndCall(RubyClass rubyClass, Block block, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            DynamicMethod dynamicMethod = rubyClass.searchMethod(this.methodName);
            if (this.methodMissing(dynamicMethod, threadContext)) {
                return this.callMethodMissing(threadContext, iRubyObject, dynamicMethod, iRubyObject2, block);
            }
            this.updateCacheEntry(dynamicMethod, rubyClass);
            return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObject2, block);
        }

        protected IRubyObject cacheAndCall(RubyClass rubyClass, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            DynamicMethod dynamicMethod = rubyClass.searchMethod(this.methodName);
            if (this.methodMissing(dynamicMethod, threadContext)) {
                return this.callMethodMissing(threadContext, iRubyObject, dynamicMethod, iRubyObject2, iRubyObject3);
            }
            this.updateCacheEntry(dynamicMethod, rubyClass);
            return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObject2, iRubyObject3);
        }

        protected IRubyObject cacheAndCall(RubyClass rubyClass, Block block, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            DynamicMethod dynamicMethod = rubyClass.searchMethod(this.methodName);
            if (this.methodMissing(dynamicMethod, threadContext)) {
                return this.callMethodMissing(threadContext, iRubyObject, dynamicMethod, iRubyObject2, iRubyObject3, block);
            }
            this.updateCacheEntry(dynamicMethod, rubyClass);
            return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObject2, iRubyObject3, block);
        }

        protected IRubyObject cacheAndCall(RubyClass rubyClass, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
            DynamicMethod dynamicMethod = rubyClass.searchMethod(this.methodName);
            if (this.methodMissing(dynamicMethod, threadContext)) {
                return this.callMethodMissing(threadContext, iRubyObject, dynamicMethod, iRubyObject2, iRubyObject3, iRubyObject4);
            }
            this.updateCacheEntry(dynamicMethod, rubyClass);
            return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObject2, iRubyObject3, iRubyObject4);
        }

        protected IRubyObject cacheAndCall(RubyClass rubyClass, Block block, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
            DynamicMethod dynamicMethod = rubyClass.searchMethod(this.methodName);
            if (this.methodMissing(dynamicMethod, threadContext)) {
                return this.callMethodMissing(threadContext, iRubyObject, dynamicMethod, iRubyObject2, iRubyObject3, iRubyObject4, block);
            }
            this.updateCacheEntry(dynamicMethod, rubyClass);
            return dynamicMethod.call(threadContext, iRubyObject, rubyClass, this.methodName, iRubyObject2, iRubyObject3, iRubyObject4, block);
        }

        private IRubyObject callMethodMising(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, IRubyObject[] iRubyObjectArray) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, this.methodName, iRubyObjectArray, threadContext.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, this.methodName, threadContext.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, Block block) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, this.methodName, threadContext.getFrameSelf(), this.callType, block);
        }

        private IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, IRubyObject iRubyObject2) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, this.methodName, iRubyObject2, threadContext.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, IRubyObject[] iRubyObjectArray, Block block) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, this.methodName, iRubyObjectArray, threadContext.getFrameSelf(), this.callType, block);
        }

        private IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, IRubyObject iRubyObject2, Block block) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, this.methodName, iRubyObject2, threadContext.getFrameSelf(), this.callType, block);
        }

        private IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, this.methodName, iRubyObject2, iRubyObject3, threadContext.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, this.methodName, iRubyObject2, iRubyObject3, threadContext.getFrameSelf(), this.callType, block);
        }

        private IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, this.methodName, iRubyObject2, iRubyObject3, iRubyObject4, threadContext.getFrameSelf(), this.callType, Block.NULL_BLOCK);
        }

        private IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, this.methodName, iRubyObject2, iRubyObject3, iRubyObject4, threadContext.getFrameSelf(), this.callType, block);
        }

        private boolean methodMissing(DynamicMethod dynamicMethod, ThreadContext threadContext) {
            return dynamicMethod.isUndefined() || !this.methodName.equals("method_missing") && !dynamicMethod.isCallableFrom(threadContext.getFrameSelf(), this.callType);
        }

        private RubyClass pollAndGetClass(ThreadContext threadContext, IRubyObject iRubyObject) {
            threadContext.callThreadPoll();
            RubyClass rubyClass = iRubyObject.getMetaClass();
            return rubyClass;
        }

        private void updateCacheEntry(DynamicMethod dynamicMethod, RubyClass rubyClass) {
            if (this.misses < 50) {
                ++this.misses;
                if (this.misses >= 50) {
                    ++failedCallSites;
                }
                this.cache = new CacheEntry(dynamicMethod, rubyClass);
                rubyClass.getRuntime().getCacheMap().add(dynamicMethod, this);
            }
        }

        public void removeCachedMethod() {
            this.cache = NULL_CACHE;
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            CacheEntry cacheEntry = this.cache;
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            if (cacheEntry.isOk(rubyClass)) {
                return cacheEntry.cachedMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObjectArray);
            }
            return this.cacheAndCall(rubyClass, iRubyObjectArray, threadContext, iRubyObject);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            try {
                CacheEntry cacheEntry = this.cache;
                if (cacheEntry.isOk(rubyClass)) {
                    return cacheEntry.cachedMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObjectArray, block);
                }
                return this.cacheAndCall(rubyClass, block, iRubyObjectArray, threadContext, iRubyObject);
            }
            catch (JumpException.BreakJump breakJump) {
                return this.handleBreakJump(threadContext, breakJump);
            }
            catch (JumpException.RetryJump retryJump) {
                throw this.retryJumpError(threadContext);
            }
            catch (StackOverflowError stackOverflowError) {
                throw this.systemStackError(threadContext);
            }
        }

        public IRubyObject callIter(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            try {
                CacheEntry cacheEntry = this.cache;
                if (cacheEntry.isOk(rubyClass)) {
                    IRubyObject iRubyObject2 = cacheEntry.cachedMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObjectArray, block);
                    return iRubyObject2;
                }
                IRubyObject iRubyObject3 = this.cacheAndCall(rubyClass, block, iRubyObjectArray, threadContext, iRubyObject);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump breakJump) {
                IRubyObject iRubyObject4 = this.handleBreakJump(threadContext, breakJump);
                return iRubyObject4;
            }
            catch (JumpException.RetryJump retryJump) {
                throw this.retryJumpError(threadContext);
            }
            catch (StackOverflowError stackOverflowError) {
                throw this.systemStackError(threadContext);
            }
            finally {
                block.escape();
            }
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject) {
            CacheEntry cacheEntry = this.cache;
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            if (cacheEntry.isOk(rubyClass)) {
                return cacheEntry.cachedMethod.call(threadContext, iRubyObject, rubyClass, this.methodName);
            }
            return this.cacheAndCall(rubyClass, threadContext, iRubyObject);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            try {
                CacheEntry cacheEntry = this.cache;
                if (cacheEntry.isOk(rubyClass)) {
                    return cacheEntry.cachedMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, block);
                }
                return this.cacheAndCall(rubyClass, block, threadContext, iRubyObject);
            }
            catch (JumpException.BreakJump breakJump) {
                return this.handleBreakJump(threadContext, breakJump);
            }
            catch (JumpException.RetryJump retryJump) {
                throw this.retryJumpError(threadContext);
            }
            catch (StackOverflowError stackOverflowError) {
                throw this.systemStackError(threadContext);
            }
        }

        public IRubyObject callIter(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            try {
                CacheEntry cacheEntry = this.cache;
                if (cacheEntry.isOk(rubyClass)) {
                    IRubyObject iRubyObject2 = cacheEntry.cachedMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, block);
                    return iRubyObject2;
                }
                IRubyObject iRubyObject3 = this.cacheAndCall(rubyClass, block, threadContext, iRubyObject);
                return iRubyObject3;
            }
            catch (JumpException.BreakJump breakJump) {
                IRubyObject iRubyObject4 = this.handleBreakJump(threadContext, breakJump);
                return iRubyObject4;
            }
            catch (JumpException.RetryJump retryJump) {
                throw this.retryJumpError(threadContext);
            }
            catch (StackOverflowError stackOverflowError) {
                throw this.systemStackError(threadContext);
            }
            finally {
                block.escape();
            }
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            CacheEntry cacheEntry = this.cache;
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            if (cacheEntry.isOk(rubyClass)) {
                return cacheEntry.cachedMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObject2);
            }
            return this.cacheAndCall(rubyClass, threadContext, iRubyObject, iRubyObject2);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            try {
                CacheEntry cacheEntry = this.cache;
                if (cacheEntry.isOk(rubyClass)) {
                    return cacheEntry.cachedMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObject2, block);
                }
                return this.cacheAndCall(rubyClass, block, threadContext, iRubyObject, iRubyObject2);
            }
            catch (JumpException.BreakJump breakJump) {
                return this.handleBreakJump(threadContext, breakJump);
            }
            catch (JumpException.RetryJump retryJump) {
                throw this.retryJumpError(threadContext);
            }
            catch (StackOverflowError stackOverflowError) {
                throw this.systemStackError(threadContext);
            }
        }

        public IRubyObject callIter(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            try {
                CacheEntry cacheEntry = this.cache;
                if (cacheEntry.isOk(rubyClass)) {
                    IRubyObject iRubyObject3 = cacheEntry.cachedMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObject2, block);
                    return iRubyObject3;
                }
                IRubyObject iRubyObject4 = this.cacheAndCall(rubyClass, block, threadContext, iRubyObject, iRubyObject2);
                return iRubyObject4;
            }
            catch (JumpException.BreakJump breakJump) {
                IRubyObject iRubyObject5 = this.handleBreakJump(threadContext, breakJump);
                return iRubyObject5;
            }
            catch (JumpException.RetryJump retryJump) {
                throw this.retryJumpError(threadContext);
            }
            catch (StackOverflowError stackOverflowError) {
                throw this.systemStackError(threadContext);
            }
            finally {
                block.escape();
            }
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            CacheEntry cacheEntry = this.cache;
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            if (cacheEntry.isOk(rubyClass)) {
                return cacheEntry.cachedMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObject2, iRubyObject3);
            }
            return this.cacheAndCall(rubyClass, threadContext, iRubyObject, iRubyObject2, iRubyObject3);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            try {
                CacheEntry cacheEntry = this.cache;
                if (cacheEntry.isOk(rubyClass)) {
                    return cacheEntry.cachedMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObject2, iRubyObject3, block);
                }
                return this.cacheAndCall(rubyClass, block, threadContext, iRubyObject, iRubyObject2, iRubyObject3);
            }
            catch (JumpException.BreakJump breakJump) {
                return this.handleBreakJump(threadContext, breakJump);
            }
            catch (JumpException.RetryJump retryJump) {
                throw this.retryJumpError(threadContext);
            }
            catch (StackOverflowError stackOverflowError) {
                throw this.systemStackError(threadContext);
            }
        }

        public IRubyObject callIter(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            try {
                CacheEntry cacheEntry = this.cache;
                if (cacheEntry.isOk(rubyClass)) {
                    IRubyObject iRubyObject4 = cacheEntry.cachedMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObject2, iRubyObject3, block);
                    return iRubyObject4;
                }
                IRubyObject iRubyObject5 = this.cacheAndCall(rubyClass, block, threadContext, iRubyObject, iRubyObject2, iRubyObject3);
                return iRubyObject5;
            }
            catch (JumpException.BreakJump breakJump) {
                IRubyObject iRubyObject6 = this.handleBreakJump(threadContext, breakJump);
                return iRubyObject6;
            }
            catch (JumpException.RetryJump retryJump) {
                throw this.retryJumpError(threadContext);
            }
            catch (StackOverflowError stackOverflowError) {
                throw this.systemStackError(threadContext);
            }
            finally {
                block.escape();
            }
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
            CacheEntry cacheEntry = this.cache;
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            if (cacheEntry.isOk(rubyClass)) {
                return cacheEntry.cachedMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, this.methodName, iRubyObject2, iRubyObject3, iRubyObject4);
            }
            return this.cacheAndCall(rubyClass, threadContext, iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4);
        }

        public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            try {
                CacheEntry cacheEntry = this.cache;
                if (cacheEntry.isOk(rubyClass)) {
                    return cacheEntry.cachedMethod.call(threadContext, iRubyObject, rubyClass, this.methodName, iRubyObject2, iRubyObject3, iRubyObject4, block);
                }
                return this.cacheAndCall(rubyClass, block, threadContext, iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4);
            }
            catch (JumpException.BreakJump breakJump) {
                return this.handleBreakJump(threadContext, breakJump);
            }
            catch (JumpException.RetryJump retryJump) {
                throw this.retryJumpError(threadContext);
            }
            catch (StackOverflowError stackOverflowError) {
                throw this.systemStackError(threadContext);
            }
        }

        public IRubyObject callIter(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
            RubyClass rubyClass = this.pollAndGetClass(threadContext, iRubyObject);
            try {
                CacheEntry cacheEntry = this.cache;
                if (cacheEntry.isOk(rubyClass)) {
                    IRubyObject iRubyObject5 = cacheEntry.cachedMethod.call(threadContext, iRubyObject, rubyClass, this.methodName, iRubyObject2, iRubyObject3, iRubyObject4, block);
                    return iRubyObject5;
                }
                IRubyObject iRubyObject6 = this.cacheAndCall(rubyClass, block, threadContext, iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4);
                return iRubyObject6;
            }
            catch (JumpException.BreakJump breakJump) {
                IRubyObject iRubyObject7 = this.handleBreakJump(threadContext, breakJump);
                return iRubyObject7;
            }
            catch (JumpException.RetryJump retryJump) {
                throw this.retryJumpError(threadContext);
            }
            catch (StackOverflowError stackOverflowError) {
                throw this.systemStackError(threadContext);
            }
            finally {
                block.escape();
            }
        }

        private IRubyObject handleBreakJump(ThreadContext threadContext, JumpException.BreakJump breakJump) throws JumpException.BreakJump {
            if (threadContext.getFrameJumpTarget() == breakJump.getTarget()) {
                return (IRubyObject)breakJump.getValue();
            }
            throw breakJump;
        }

        private RaiseException retryJumpError(ThreadContext threadContext) {
            return threadContext.getRuntime().newLocalJumpError("retry", threadContext.getRuntime().getNil(), "retry outside of rescue not supported");
        }

        private RaiseException systemStackError(ThreadContext threadContext) {
            return threadContext.getRuntime().newSystemStackError("stack level too deep");
        }

        private static class CacheEntry {
            public final DynamicMethod cachedMethod;
            public final RubyClass cachedType;

            public CacheEntry(DynamicMethod dynamicMethod, RubyClass rubyClass) {
                this.cachedMethod = dynamicMethod;
                this.cachedType = rubyClass;
            }

            public boolean isOk(RubyClass rubyClass) {
                return this.cachedType == rubyClass;
            }
        }
    }
}

