/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.parser;

import org.jruby.nb.ast.AssignableNode;
import org.jruby.nb.ast.LocalAsgnNode;
import org.jruby.nb.ast.LocalVarNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.VCallNode;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.parser.BlockStaticScope;
import org.jruby.nb.parser.StaticScope;

public class LocalStaticScope
extends StaticScope {
    private static final long serialVersionUID = 2204064248888411628L;
    private static final String[] NO_NAMES = new String[0];

    public LocalStaticScope(StaticScope staticScope) {
        this(staticScope, NO_NAMES);
    }

    public LocalStaticScope(StaticScope staticScope, String[] stringArray) {
        super(staticScope, stringArray);
        this.setArgumentScope(true);
    }

    public StaticScope getLocalScope() {
        return this;
    }

    public int isDefined(String string, int n) {
        return n << 16 | this.exists(string);
    }

    public String[] getAllNamesInScope() {
        return this.getVariables();
    }

    public AssignableNode assign(ISourcePosition iSourcePosition, String string, Node node, StaticScope staticScope, int n) {
        int n2 = this.exists(string);
        if (n2 >= 0) {
            if (n > 0) {
                this.capture(n2);
            }
            return new LocalAsgnNode(iSourcePosition, string, n << 16 | n2, node);
        }
        if (staticScope == this) {
            n2 = this.addVariable(string);
            return new LocalAsgnNode(iSourcePosition, string, n2, node);
        }
        return ((BlockStaticScope)staticScope).addAssign(iSourcePosition, string, node);
    }

    public Node declare(ISourcePosition iSourcePosition, String string, int n) {
        int n2 = this.exists(string);
        if (n2 >= 0) {
            if (n > 0) {
                this.capture(n2);
            }
            return new LocalVarNode(iSourcePosition, n << 16 | n2, string);
        }
        return new VCallNode(iSourcePosition, string);
    }

    public String toString() {
        return "LocalScope: " + super.toString();
    }
}

