/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport.util;

import org.jruby.nb.MetaClass;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyException;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyHash;
import org.jruby.nb.RubyInstanceConfig;
import org.jruby.nb.RubyKernel;
import org.jruby.nb.RubyLocalJumpError;
import org.jruby.nb.RubyMatchData;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyProc;
import org.jruby.nb.RubyRegexp;
import org.jruby.nb.RubyString;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.ast.util.ArgsUtil;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.internal.runtime.methods.WrapperMethod;
import org.jruby.nb.javasupport.JavaClass;
import org.jruby.nb.parser.BlockStaticScope;
import org.jruby.nb.parser.LocalStaticScope;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.BlockBody;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.CallbackFactory;
import org.jruby.nb.runtime.CompiledBlock;
import org.jruby.nb.runtime.CompiledBlockCallback;
import org.jruby.nb.runtime.CompiledBlockLight;
import org.jruby.nb.runtime.CompiledSharedScopeBlock;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.MethodFactory;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.TypeConverter;

public class RuntimeHelpers {
    public static final int MAX_SPECIFIC_ARITY_OBJECT_ARRAY = 5;
    public static final int MAX_SPECIFIC_ARITY_HASH = 3;

    public static CompiledBlockCallback createBlockCallback(Ruby ruby, Object object, String string) {
        Class<?> clazz = object.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        CallbackFactory callbackFactory = CallbackFactory.createFactory(ruby, clazz, classLoader);
        return callbackFactory.getBlockCallback(string, object);
    }

    public static BlockBody createCompiledBlockBody(ThreadContext threadContext, Object object, String string, int n, String[] stringArray, boolean bl, int n2, boolean bl2) {
        BlockStaticScope blockStaticScope = new BlockStaticScope(threadContext.getCurrentScope().getStaticScope(), stringArray);
        blockStaticScope.determineModule();
        if (bl2) {
            return CompiledBlockLight.newCompiledBlockLight(Arity.createArity(n), blockStaticScope, RuntimeHelpers.createBlockCallback(threadContext.getRuntime(), object, string), bl, n2);
        }
        return CompiledBlock.newCompiledBlock(Arity.createArity(n), blockStaticScope, RuntimeHelpers.createBlockCallback(threadContext.getRuntime(), object, string), bl, n2);
    }

    public static Block createBlock(ThreadContext threadContext, IRubyObject iRubyObject, BlockBody blockBody) {
        return CompiledBlock.newCompiledClosure(threadContext, iRubyObject, blockBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject runBeginBlock(ThreadContext threadContext, IRubyObject iRubyObject, String[] stringArray, CompiledBlockCallback compiledBlockCallback) {
        BlockStaticScope blockStaticScope = new BlockStaticScope(threadContext.getCurrentScope().getStaticScope(), stringArray);
        blockStaticScope.determineModule();
        threadContext.preScopedBody(DynamicScope.newDynamicScope(blockStaticScope, threadContext.getCurrentScope()));
        Block block = CompiledBlock.newCompiledClosure(threadContext, iRubyObject, Arity.createArity(0), blockStaticScope, compiledBlockCallback, false, 0);
        try {
            block.yield(threadContext, null);
            Object var7_6 = null;
            threadContext.postScopedBody();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            threadContext.postScopedBody();
            throw throwable;
        }
        return threadContext.getRuntime().getNil();
    }

    public static Block createSharedScopeBlock(ThreadContext threadContext, IRubyObject iRubyObject, int n, CompiledBlockCallback compiledBlockCallback, boolean bl, int n2) {
        return CompiledSharedScopeBlock.newCompiledSharedScopeClosure(threadContext, iRubyObject, Arity.createArity(n), threadContext.getCurrentScope(), compiledBlockCallback, bl, n2);
    }

    public static IRubyObject def(ThreadContext threadContext, IRubyObject iRubyObject, Object object, String string, String string2, String[] stringArray, int n, int n2, int n3, int n4, CallConfiguration callConfiguration) {
        Class<?> clazz = object.getClass();
        Ruby ruby = threadContext.getRuntime();
        RubyModule rubyModule = threadContext.getRubyClass();
        Visibility visibility = threadContext.getCurrentVisibility();
        RuntimeHelpers.performNormalMethodChecks(rubyModule, ruby, string);
        StaticScope staticScope = RuntimeHelpers.creatScopeForClass(threadContext, stringArray, n2, n3, n4);
        MethodFactory methodFactory = MethodFactory.createFactory(clazz.getClassLoader());
        DynamicMethod dynamicMethod = RuntimeHelpers.constructNormalMethod(string, visibility, methodFactory, rubyModule, string2, n, staticScope, object, callConfiguration);
        RuntimeHelpers.addInstanceMethod(rubyModule, string, dynamicMethod, visibility, threadContext, ruby);
        return ruby.getNil();
    }

    public static IRubyObject defs(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Object object, String string, String string2, String[] stringArray, int n, int n2, int n3, int n4, CallConfiguration callConfiguration) {
        Class<?> clazz = object.getClass();
        Ruby ruby = threadContext.getRuntime();
        RubyClass rubyClass = RuntimeHelpers.performSingletonMethodChecks(ruby, iRubyObject2, string);
        StaticScope staticScope = RuntimeHelpers.creatScopeForClass(threadContext, stringArray, n2, n3, n4);
        MethodFactory methodFactory = MethodFactory.createFactory(clazz.getClassLoader());
        DynamicMethod dynamicMethod = RuntimeHelpers.constructSingletonMethod(methodFactory, rubyClass, string2, n, staticScope, object, callConfiguration);
        rubyClass.addMethod(string, dynamicMethod);
        RuntimeHelpers.callSingletonMethodHook(iRubyObject2, threadContext, ruby.fastNewSymbol(string));
        return ruby.getNil();
    }

    public static RubyClass getSingletonClass(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum || iRubyObject instanceof RubySymbol) {
            throw ruby.newTypeError("no virtual class for " + iRubyObject.getMetaClass().getBaseName());
        }
        if (ruby.getSafeLevel() >= 4 && !iRubyObject.isTaint()) {
            throw ruby.newSecurityError("Insecure: can't extend object.");
        }
        return iRubyObject.getSingletonClass();
    }

    @Deprecated
    public static IRubyObject doAttrAssign(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, ThreadContext threadContext, String string, IRubyObject iRubyObject2, CallType callType, Block block) {
        if (iRubyObject == iRubyObject2) {
            callType = CallType.VARIABLE;
        }
        return RuntimeHelpers.compilerCallMethod(threadContext, iRubyObject, string, iRubyObjectArray, iRubyObject2, callType, block);
    }

    @Deprecated
    public static IRubyObject doAttrAssignIndexed(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, ThreadContext threadContext, byte by, String string, IRubyObject iRubyObject2, CallType callType, Block block) {
        if (iRubyObject == iRubyObject2) {
            callType = CallType.VARIABLE;
        }
        return RuntimeHelpers.compilerCallMethodWithIndex(threadContext, iRubyObject, by, string, iRubyObjectArray, iRubyObject2, callType, block);
    }

    @Deprecated
    public static IRubyObject doInvokeDynamic(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, ThreadContext threadContext, String string, IRubyObject iRubyObject2, CallType callType, Block block) {
        return RuntimeHelpers.compilerCallMethod(threadContext, iRubyObject, string, iRubyObjectArray, iRubyObject2, callType, block);
    }

    @Deprecated
    public static IRubyObject doInvokeDynamicIndexed(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, ThreadContext threadContext, byte by, String string, IRubyObject iRubyObject2, CallType callType, Block block) {
        return RuntimeHelpers.compilerCallMethodWithIndex(threadContext, iRubyObject, by, string, iRubyObjectArray, iRubyObject2, callType, block);
    }

    @Deprecated
    public static IRubyObject compilerCallMethodWithIndex(ThreadContext threadContext, IRubyObject iRubyObject, int n, String string, IRubyObject[] iRubyObjectArray, IRubyObject iRubyObject2, CallType callType, Block block) {
        RubyClass rubyClass = iRubyObject.getMetaClass();
        if (rubyClass.index != 0) {
            return rubyClass.invoke(threadContext, iRubyObject, n, string, iRubyObjectArray, callType, block);
        }
        return RuntimeHelpers.compilerCallMethod(threadContext, iRubyObject, string, iRubyObjectArray, iRubyObject2, callType, block);
    }

    @Deprecated
    public static IRubyObject compilerCallMethod(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray, IRubyObject iRubyObject2, CallType callType, Block block) {
        assert (iRubyObjectArray != null);
        DynamicMethod dynamicMethod = null;
        RubyClass rubyClass = iRubyObject.getMetaClass();
        dynamicMethod = rubyClass.searchMethod(string);
        if (dynamicMethod.isUndefined() || !string.equals("method_missing") && !dynamicMethod.isCallableFrom(iRubyObject2, callType)) {
            return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObjectArray, iRubyObject2, callType, block);
        }
        return dynamicMethod.call(threadContext, iRubyObject, (RubyModule)rubyClass, string, iRubyObjectArray, block);
    }

    @Deprecated
    public static IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, String string, int n, IRubyObject[] iRubyObjectArray, IRubyObject iRubyObject2, CallType callType, Block block) {
        return RuntimeHelpers.callMethodMissing(threadContext, iRubyObject, dynamicMethod, string, iRubyObjectArray, iRubyObject2, callType, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, String string, IRubyObject[] iRubyObjectArray, IRubyObject iRubyObject2, CallType callType, Block block) {
        threadContext.setLastCallStatusAndVisibility(callType, dynamicMethod.getVisibility());
        return RuntimeHelpers.callMethodMissingInternal(threadContext, iRubyObject, string, iRubyObjectArray, iRubyObject2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, CallType callType, Block block) {
        threadContext.setLastCallStatusAndVisibility(callType, dynamicMethod.getVisibility());
        return RuntimeHelpers.callMethodMissingInternal(threadContext, iRubyObject, string, iRubyObject2, iRubyObject3, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, CallType callType, Block block) {
        threadContext.setLastCallStatusAndVisibility(callType, dynamicMethod.getVisibility());
        return RuntimeHelpers.callMethodMissingInternal(threadContext, iRubyObject, string, iRubyObject2, iRubyObject3, iRubyObject4, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, IRubyObject iRubyObject5, CallType callType, Block block) {
        threadContext.setLastCallStatusAndVisibility(callType, dynamicMethod.getVisibility());
        return RuntimeHelpers.callMethodMissingInternal(threadContext, iRubyObject, string, iRubyObject2, iRubyObject3, iRubyObject4, iRubyObject5, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, String string, IRubyObject iRubyObject2, CallType callType, Block block) {
        threadContext.setLastCallStatusAndVisibility(callType, dynamicMethod.getVisibility());
        return RuntimeHelpers.callMethodMissingInternal(threadContext, iRubyObject, string, iRubyObject2, block);
    }

    private static IRubyObject callMethodMissingInternal(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray, IRubyObject iRubyObject2, Block block) {
        if (string.equals("method_missing")) {
            return RubyKernel.method_missing(threadContext, iRubyObject2, iRubyObjectArray, block);
        }
        IRubyObject[] iRubyObjectArray2 = RuntimeHelpers.prepareMethodMissingArgs(iRubyObjectArray, threadContext, string);
        return RuntimeHelpers.invoke(threadContext, iRubyObject, "method_missing", iRubyObjectArray2, block);
    }

    private static IRubyObject callMethodMissingInternal(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, Block block) {
        if (string.equals("method_missing")) {
            return RubyKernel.method_missing(threadContext, iRubyObject2, IRubyObject.NULL_ARRAY, block);
        }
        return RuntimeHelpers.invoke(threadContext, iRubyObject, "method_missing", (IRubyObject)threadContext.getRuntime().newSymbol(string), block);
    }

    private static IRubyObject callMethodMissingInternal(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        if (string.equals("method_missing")) {
            return RubyKernel.method_missing(threadContext, iRubyObject3, RuntimeHelpers.constructObjectArray(iRubyObject2), block);
        }
        return RuntimeHelpers.invoke(threadContext, iRubyObject, "method_missing", (IRubyObject)threadContext.getRuntime().newSymbol(string), iRubyObject2, block);
    }

    private static IRubyObject callMethodMissingInternal(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
        if (string.equals("method_missing")) {
            return RubyKernel.method_missing(threadContext, iRubyObject4, RuntimeHelpers.constructObjectArray(iRubyObject2, iRubyObject3), block);
        }
        return RuntimeHelpers.invoke(threadContext, iRubyObject, "method_missing", threadContext.getRuntime().newSymbol(string), iRubyObject2, iRubyObject3, block);
    }

    private static IRubyObject callMethodMissingInternal(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, IRubyObject iRubyObject5, Block block) {
        if (string.equals("method_missing")) {
            return RubyKernel.method_missing(threadContext, iRubyObject5, RuntimeHelpers.constructObjectArray(iRubyObject2, iRubyObject3, iRubyObject4), block);
        }
        return RuntimeHelpers.invoke(threadContext, iRubyObject, "method_missing", RuntimeHelpers.constructObjectArray(threadContext.getRuntime().newSymbol(string), iRubyObject2, iRubyObject3, iRubyObject4), block);
    }

    private static IRubyObject[] prepareMethodMissingArgs(IRubyObject[] iRubyObjectArray, ThreadContext threadContext, String string) {
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[iRubyObjectArray.length + 1];
        System.arraycopy(iRubyObjectArray, 0, iRubyObjectArray2, 1, iRubyObjectArray.length);
        iRubyObjectArray2[0] = threadContext.getRuntime().newSymbol(string);
        return iRubyObjectArray2;
    }

    @Deprecated
    public static IRubyObject callMethodMissing(ThreadContext threadContext, IRubyObject iRubyObject, DynamicMethod dynamicMethod, String string, IRubyObject[] iRubyObjectArray, IRubyObject iRubyObject2) {
        threadContext.setLastCallStatusAndVisibility(CallType.FUNCTIONAL, Visibility.PUBLIC);
        return RuntimeHelpers.callMethodMissingInternal(threadContext, iRubyObject, string, iRubyObjectArray, iRubyObject2, Block.NULL_BLOCK);
    }

    @Deprecated
    public static IRubyObject invokeMethodMissing(IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray) {
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        threadContext.setLastCallStatus(CallType.FUNCTIONAL);
        threadContext.setLastVisibility(Visibility.PUBLIC);
        if (string.equals(MethodIndex.METHOD_MISSING)) {
            return RubyKernel.method_missing(threadContext, threadContext.getFrameSelf(), iRubyObjectArray, Block.NULL_BLOCK);
        }
        IRubyObject[] iRubyObjectArray2 = RuntimeHelpers.prepareMethodMissingArgs(iRubyObjectArray, threadContext, string);
        return RuntimeHelpers.invoke(threadContext, iRubyObject, "method_missing", iRubyObjectArray2, Block.NULL_BLOCK);
    }

    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, Block block) {
        return iRubyObject.getMetaClass().finvoke(threadContext, iRubyObject, string, block);
    }

    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, Block block) {
        return iRubyObject.getMetaClass().finvoke(threadContext, iRubyObject, string, iRubyObject2, block);
    }

    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        return iRubyObject.getMetaClass().finvoke(threadContext, iRubyObject, string, iRubyObject2, iRubyObject3, block);
    }

    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, Block block) {
        return iRubyObject.getMetaClass().finvoke(threadContext, iRubyObject, string, iRubyObject2, iRubyObject3, iRubyObject4, block);
    }

    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray, Block block) {
        return iRubyObject.getMetaClass().finvoke(threadContext, iRubyObject, string, iRubyObjectArray, block);
    }

    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string) {
        return iRubyObject.getMetaClass().finvoke(threadContext, iRubyObject, string);
    }

    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2) {
        return iRubyObject.getMetaClass().finvoke(threadContext, iRubyObject, string, iRubyObject2);
    }

    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return iRubyObject.getMetaClass().finvoke(threadContext, iRubyObject, string, iRubyObject2, iRubyObject3);
    }

    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        return iRubyObject.getMetaClass().finvoke(threadContext, iRubyObject, string, iRubyObject2, iRubyObject3, iRubyObject4);
    }

    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray) {
        return iRubyObject.getMetaClass().finvoke(threadContext, iRubyObject, string, iRubyObjectArray);
    }

    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, CallType callType) {
        return RuntimeHelpers.invoke(threadContext, iRubyObject, string, IRubyObject.NULL_ARRAY, callType, Block.NULL_BLOCK);
    }

    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray, CallType callType, Block block) {
        return iRubyObject.getMetaClass().invoke(threadContext, iRubyObject, string, iRubyObjectArray, callType, block);
    }

    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, CallType callType, Block block) {
        return iRubyObject.getMetaClass().invoke(threadContext, iRubyObject, string, iRubyObject2, callType, block);
    }

    public static IRubyObject invokeAs(ThreadContext threadContext, RubyClass rubyClass, IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray, CallType callType, Block block) {
        return rubyClass.invoke(threadContext, iRubyObject, string, iRubyObjectArray, callType, block);
    }

    @Deprecated
    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, int n, String string, IRubyObject[] iRubyObjectArray) {
        return RuntimeHelpers.invoke(threadContext, iRubyObject, n, string, iRubyObjectArray, CallType.FUNCTIONAL, Block.NULL_BLOCK);
    }

    @Deprecated
    public static IRubyObject invoke(ThreadContext threadContext, IRubyObject iRubyObject, int n, String string, IRubyObject[] iRubyObjectArray, CallType callType, Block block) {
        return iRubyObject.getMetaClass().invoke(threadContext, iRubyObject, n, string, iRubyObjectArray, callType, block);
    }

    public static RubyArray ensureRubyArray(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyArray)) {
            iRubyObject = RubyArray.newArray(iRubyObject.getRuntime(), iRubyObject);
        }
        return (RubyArray)iRubyObject;
    }

    public static RubyArray ensureMultipleAssignableRubyArray(IRubyObject iRubyObject, Ruby ruby, boolean bl) {
        if (!(iRubyObject instanceof RubyArray)) {
            iRubyObject = ArgsUtil.convertToRubyArray(ruby, iRubyObject, bl);
        }
        return (RubyArray)iRubyObject;
    }

    public static IRubyObject fetchClassVariable(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject, String string) {
        RubyModule rubyModule = ASTInterpreter.getClassVariableBase(threadContext, ruby);
        if (rubyModule == null) {
            rubyModule = iRubyObject.getMetaClass();
        }
        return rubyModule.getClassVar(string);
    }

    public static IRubyObject fastFetchClassVariable(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject, String string) {
        RubyModule rubyModule = ASTInterpreter.getClassVariableBase(threadContext, ruby);
        if (rubyModule == null) {
            rubyModule = iRubyObject.getMetaClass();
        }
        return rubyModule.fastGetClassVar(string);
    }

    public static IRubyObject nullToNil(IRubyObject iRubyObject, Ruby ruby) {
        return iRubyObject != null ? iRubyObject : ruby.getNil();
    }

    public static RubyClass prepareSuperClass(Ruby ruby, IRubyObject iRubyObject) {
        RubyClass.checkInheritable(iRubyObject);
        return (RubyClass)iRubyObject;
    }

    public static RubyModule prepareClassNamespace(ThreadContext threadContext, IRubyObject iRubyObject) {
        if ((iRubyObject == null || iRubyObject.isNil()) && (iRubyObject = threadContext.getCurrentScope().getStaticScope().getModule()) == null) {
            throw threadContext.getRuntime().newTypeError("no outer class/module");
        }
        if (iRubyObject instanceof RubyModule) {
            return (RubyModule)iRubyObject;
        }
        throw threadContext.getRuntime().newTypeError(iRubyObject + " is not a class/module");
    }

    public static IRubyObject setClassVariable(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2) {
        RubyModule rubyModule = ASTInterpreter.getClassVariableBase(threadContext, ruby);
        if (rubyModule == null) {
            rubyModule = iRubyObject.getMetaClass();
        }
        rubyModule.setClassVar(string, iRubyObject2);
        return iRubyObject2;
    }

    public static IRubyObject fastSetClassVariable(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2) {
        RubyModule rubyModule = ASTInterpreter.getClassVariableBase(threadContext, ruby);
        if (rubyModule == null) {
            rubyModule = iRubyObject.getMetaClass();
        }
        rubyModule.fastSetClassVar(string, iRubyObject2);
        return iRubyObject2;
    }

    public static IRubyObject declareClassVariable(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2) {
        RubyModule rubyModule = ASTInterpreter.getClassVariableBase(threadContext, ruby);
        if (rubyModule == null) {
            throw ruby.newTypeError("no class/module to define class variable");
        }
        rubyModule.setClassVar(string, iRubyObject2);
        return iRubyObject2;
    }

    public static IRubyObject fastDeclareClassVariable(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject, String string, IRubyObject iRubyObject2) {
        RubyModule rubyModule = ASTInterpreter.getClassVariableBase(threadContext, ruby);
        if (rubyModule == null) {
            throw ruby.newTypeError("no class/module to define class variable");
        }
        rubyModule.fastSetClassVar(string, iRubyObject2);
        return iRubyObject2;
    }

    public static void handleArgumentSizes(ThreadContext threadContext, Ruby ruby, int n, int n2, int n3, int n4) {
        if (n3 == 0) {
            if (n4 < 0 ? n != n2 : n < n2) {
                throw ruby.newArgumentError("wrong # of arguments(" + n + " for " + n2 + ")");
            }
        } else if (n4 < 0) {
            if (n < n2) {
                throw ruby.newArgumentError("wrong # of arguments(" + n + " for " + n2 + ")");
            }
            if (n > n2 + n3) {
                throw ruby.newArgumentError("wrong # of arguments(" + n + " for " + (n2 + n3) + ")");
            }
        } else if (n < n2) {
            throw ruby.newArgumentError("wrong # of arguments(" + n + " for " + n2 + ")");
        }
    }

    public static String getLocalJumpTypeOrRethrow(RaiseException raiseException) {
        RubyException rubyException = raiseException.getException();
        Ruby ruby = rubyException.getRuntime();
        if (ruby.getLocalJumpError().isInstance(rubyException)) {
            RubyLocalJumpError rubyLocalJumpError = (RubyLocalJumpError)raiseException.getException();
            IRubyObject iRubyObject = rubyLocalJumpError.reason();
            return iRubyObject.asJavaString();
        }
        throw raiseException;
    }

    public static IRubyObject unwrapLocalJumpErrorValue(RaiseException raiseException) {
        return ((RubyLocalJumpError)raiseException.getException()).exit_value();
    }

    public static IRubyObject processBlockArgument(Ruby ruby, Block block) {
        if (!block.isGiven()) {
            return ruby.getNil();
        }
        return RuntimeHelpers.processGivenBlock(block, ruby);
    }

    private static IRubyObject processGivenBlock(Block block, Ruby ruby) {
        RubyProc rubyProc = block.getProcObject();
        if (rubyProc == null) {
            rubyProc = ruby.newBlockPassProc(Block.Type.PROC, block);
            rubyProc.getBlock().type = Block.Type.PROC;
        }
        return rubyProc;
    }

    public static Block getBlockFromBlockPassBody(Ruby ruby, IRubyObject iRubyObject, Block block) {
        if (iRubyObject.isNil()) {
            return Block.NULL_BLOCK;
        }
        if (!(iRubyObject instanceof RubyProc)) {
            iRubyObject = RuntimeHelpers.coerceProc(iRubyObject, ruby);
        }
        return RuntimeHelpers.getBlockFromProc(block, iRubyObject);
    }

    private static IRubyObject coerceProc(IRubyObject iRubyObject, Ruby ruby) throws RaiseException {
        if (!((iRubyObject = TypeConverter.convertToType(iRubyObject, ruby.getProc(), 0, "to_proc", false)) instanceof RubyProc)) {
            throw ruby.newTypeError("wrong argument type " + iRubyObject.getMetaClass().getName() + " (expected Proc)");
        }
        return iRubyObject;
    }

    private static Block getBlockFromProc(Block block, IRubyObject iRubyObject) {
        RubyProc rubyProc;
        if (block != null && block.isGiven() && (rubyProc = block.getProcObject()) != null && rubyProc == iRubyObject) {
            return block;
        }
        return ((RubyProc)iRubyObject).getBlock();
    }

    public static Block getBlockFromBlockPassBody(IRubyObject iRubyObject, Block block) {
        return RuntimeHelpers.getBlockFromBlockPassBody(iRubyObject.getRuntime(), iRubyObject, block);
    }

    public static IRubyObject backref(ThreadContext threadContext) {
        IRubyObject iRubyObject = threadContext.getCurrentFrame().getBackRef();
        if (iRubyObject instanceof RubyMatchData) {
            ((RubyMatchData)iRubyObject).use();
        }
        return iRubyObject;
    }

    public static IRubyObject backrefLastMatch(ThreadContext threadContext) {
        IRubyObject iRubyObject = threadContext.getCurrentFrame().getBackRef();
        return RubyRegexp.last_match(iRubyObject);
    }

    public static IRubyObject backrefMatchPre(ThreadContext threadContext) {
        IRubyObject iRubyObject = threadContext.getCurrentFrame().getBackRef();
        return RubyRegexp.match_pre(iRubyObject);
    }

    public static IRubyObject backrefMatchPost(ThreadContext threadContext) {
        IRubyObject iRubyObject = threadContext.getCurrentFrame().getBackRef();
        return RubyRegexp.match_post(iRubyObject);
    }

    public static IRubyObject backrefMatchLast(ThreadContext threadContext) {
        IRubyObject iRubyObject = threadContext.getCurrentFrame().getBackRef();
        return RubyRegexp.match_last(iRubyObject);
    }

    public static IRubyObject callZSuper(Ruby ruby, ThreadContext threadContext, Block block, IRubyObject iRubyObject) {
        RuntimeHelpers.checkSuperDisabledOrOutOfMethod(threadContext);
        if (!block.isGiven()) {
            block = threadContext.getCurrentFrame().getBlock();
        }
        return iRubyObject.callSuper(threadContext, threadContext.getCurrentScope().getArgValues(), block);
    }

    public static IRubyObject[] appendToObjectArray(IRubyObject[] iRubyObjectArray, IRubyObject iRubyObject) {
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[iRubyObjectArray.length + 1];
        System.arraycopy(iRubyObjectArray, 0, iRubyObjectArray2, 0, iRubyObjectArray.length);
        iRubyObjectArray2[iRubyObjectArray.length] = iRubyObject;
        return iRubyObjectArray2;
    }

    public static JumpException.ReturnJump returnJump(IRubyObject iRubyObject, ThreadContext threadContext) {
        return threadContext.returnJump(iRubyObject);
    }

    public static IRubyObject breakJumpInWhile(JumpException.BreakJump breakJump, Block block, ThreadContext threadContext) {
        if (breakJump.getTarget() == threadContext.getFrameJumpTarget()) {
            return (IRubyObject)breakJump.getValue();
        }
        throw breakJump;
    }

    public static IRubyObject breakJump(ThreadContext threadContext, IRubyObject iRubyObject) {
        throw new JumpException.BreakJump(threadContext.getFrameJumpTarget(), iRubyObject);
    }

    public static IRubyObject breakLocalJumpError(Ruby ruby, IRubyObject iRubyObject) {
        throw ruby.newLocalJumpError("break", iRubyObject, "unexpected break");
    }

    public static IRubyObject[] concatObjectArrays(IRubyObject[] iRubyObjectArray, IRubyObject[] iRubyObjectArray2) {
        IRubyObject[] iRubyObjectArray3 = new IRubyObject[iRubyObjectArray.length + iRubyObjectArray2.length];
        System.arraycopy(iRubyObjectArray, 0, iRubyObjectArray3, 0, iRubyObjectArray.length);
        System.arraycopy(iRubyObjectArray2, 0, iRubyObjectArray3, iRubyObjectArray.length, iRubyObjectArray2.length);
        return iRubyObjectArray3;
    }

    public static IRubyObject isExceptionHandled(RubyException rubyException, IRubyObject[] iRubyObjectArray, Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject) {
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            if (!ruby.getModule().isInstance(iRubyObjectArray[i])) {
                throw ruby.newTypeError("class or module required for rescue clause");
            }
            IRubyObject iRubyObject2 = iRubyObjectArray[i].callMethod(threadContext, "===", rubyException);
            if (!iRubyObject2.isTrue()) continue;
            return iRubyObject2;
        }
        return ruby.getFalse();
    }

    public static IRubyObject isJavaExceptionHandled(Exception exception, IRubyObject[] iRubyObjectArray, Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject) {
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            Class clazz;
            RubyClass rubyClass;
            JavaClass javaClass;
            if (!(iRubyObjectArray[i] instanceof RubyClass) || (javaClass = (JavaClass)(rubyClass = (RubyClass)iRubyObjectArray[i]).fastGetInstanceVariable("@java_class")) == null || !(clazz = javaClass.javaClass()).isInstance(exception)) continue;
            return ruby.getTrue();
        }
        return ruby.getFalse();
    }

    public static void checkSuperDisabledOrOutOfMethod(ThreadContext threadContext) {
        if (threadContext.getFrameKlazz() == null) {
            String string = threadContext.getFrameName();
            if (string != null) {
                throw threadContext.getRuntime().newNameError("superclass method '" + string + "' disabled", string);
            }
            throw threadContext.getRuntime().newNoMethodError("super called outside of method", null, threadContext.getRuntime().getNil());
        }
    }

    public static Block ensureSuperBlock(Block block, Block block2) {
        if (!block.isGiven()) {
            return block2;
        }
        return block;
    }

    public static RubyModule findImplementerIfNecessary(RubyModule rubyModule, RubyModule rubyModule2) {
        if (rubyModule2 != null && rubyModule2.needsImplementer()) {
            return rubyModule.findImplementer(rubyModule2);
        }
        return rubyModule2;
    }

    public static RubyArray createSubarray(RubyArray rubyArray, int n) {
        return (RubyArray)rubyArray.subseqLight(n, rubyArray.size() - n);
    }

    public static RubyArray createSubarray(IRubyObject[] iRubyObjectArray, Ruby ruby, int n) {
        return RubyArray.newArrayNoCopy(ruby, iRubyObjectArray, n);
    }

    public static RubyBoolean isWhenTriggered(IRubyObject iRubyObject, IRubyObject iRubyObject2, ThreadContext threadContext) {
        RubyArray rubyArray = RuntimeHelpers.splatValue(iRubyObject2);
        int n = rubyArray.getLength();
        for (int i = 0; i < n; ++i) {
            IRubyObject iRubyObject3 = rubyArray.eltInternal(i);
            if ((iRubyObject == null || !iRubyObject3.callMethod(threadContext, MethodIndex.OP_EQQ, "===", iRubyObject).isTrue()) && (iRubyObject != null || !iRubyObject3.isTrue())) continue;
            return threadContext.getRuntime().getTrue();
        }
        return threadContext.getRuntime().getFalse();
    }

    public static IRubyObject setConstantInModule(IRubyObject iRubyObject, IRubyObject iRubyObject2, String string, ThreadContext threadContext) {
        return threadContext.setConstantInModule(string, iRubyObject, iRubyObject2);
    }

    public static IRubyObject retryJump() {
        throw JumpException.RETRY_JUMP;
    }

    public static IRubyObject redoJump() {
        throw JumpException.REDO_JUMP;
    }

    public static IRubyObject redoLocalJumpError(Ruby ruby) {
        throw ruby.newLocalJumpError("redo", ruby.getNil(), "unexpected redo");
    }

    public static IRubyObject nextJump(IRubyObject iRubyObject) {
        throw new JumpException.NextJump(iRubyObject);
    }

    public static IRubyObject nextLocalJumpError(Ruby ruby, IRubyObject iRubyObject) {
        throw ruby.newLocalJumpError("next", iRubyObject, "unexpected next");
    }

    public static IRubyObject[] constructObjectArray(IRubyObject iRubyObject) {
        return new IRubyObject[]{iRubyObject};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return new IRubyObject[]{iRubyObject, iRubyObject2};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return new IRubyObject[]{iRubyObject, iRubyObject2, iRubyObject3};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        return new IRubyObject[]{iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, IRubyObject iRubyObject5) {
        return new IRubyObject[]{iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4, iRubyObject5};
    }

    public static String[] constructStringArray(String string) {
        return new String[]{string};
    }

    public static String[] constructStringArray(String string, String string2) {
        return new String[]{string, string2};
    }

    public static String[] constructStringArray(String string, String string2, String string3) {
        return new String[]{string, string2, string3};
    }

    public static String[] constructStringArray(String string, String string2, String string3, String string4) {
        return new String[]{string, string2, string3, string4};
    }

    public static String[] constructStringArray(String string, String string2, String string3, String string4, String string5) {
        return new String[]{string, string2, string3, string4, string5};
    }

    public static String[] constructStringArray(String string, String string2, String string3, String string4, String string5, String string6) {
        return new String[]{string, string2, string3, string4, string5, string6};
    }

    public static String[] constructStringArray(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return new String[]{string, string2, string3, string4, string5, string6, string7};
    }

    public static String[] constructStringArray(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        return new String[]{string, string2, string3, string4, string5, string6, string7, string8};
    }

    public static String[] constructStringArray(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        return new String[]{string, string2, string3, string4, string5, string6, string7, string8, string9};
    }

    public static String[] constructStringArray(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        return new String[]{string, string2, string3, string4, string5, string6, string7, string8, string9, string10};
    }

    public static RubyHash constructHash(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyHash rubyHash = RubyHash.newHash(ruby);
        rubyHash.fastASet(iRubyObject, iRubyObject2);
        return rubyHash;
    }

    public static RubyHash constructHash(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        RubyHash rubyHash = RubyHash.newHash(ruby);
        rubyHash.fastASet(iRubyObject, iRubyObject2);
        rubyHash.fastASet(iRubyObject3, iRubyObject4);
        return rubyHash;
    }

    public static RubyHash constructHash(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, IRubyObject iRubyObject5, IRubyObject iRubyObject6) {
        RubyHash rubyHash = RubyHash.newHash(ruby);
        rubyHash.fastASet(iRubyObject, iRubyObject2);
        rubyHash.fastASet(iRubyObject3, iRubyObject4);
        rubyHash.fastASet(iRubyObject5, iRubyObject6);
        return rubyHash;
    }

    public static IRubyObject defineAlias(ThreadContext threadContext, String string, String string2) {
        Ruby ruby = threadContext.getRuntime();
        RubyModule rubyModule = threadContext.getRubyClass();
        if (rubyModule == null) {
            throw ruby.newTypeError("no class to make alias");
        }
        rubyModule.defineAlias(string, string2);
        rubyModule.callMethod(threadContext, "method_added", ruby.newSymbol(string));
        return ruby.getNil();
    }

    public static IRubyObject getInstanceVariable(Ruby ruby, IRubyObject iRubyObject, String string) {
        IRubyObject iRubyObject2 = iRubyObject.getInstanceVariables().getInstanceVariable(string);
        if (iRubyObject2 != null) {
            return iRubyObject2;
        }
        ruby.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + string + " not initialized", new Object[0]);
        return ruby.getNil();
    }

    public static IRubyObject fastGetInstanceVariable(Ruby ruby, IRubyObject iRubyObject, String string) {
        IRubyObject iRubyObject2 = iRubyObject.getInstanceVariables().fastGetInstanceVariable(string);
        if (iRubyObject2 != null) {
            return iRubyObject2;
        }
        ruby.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + string + " not initialized", new Object[0]);
        return ruby.getNil();
    }

    public static IRubyObject negate(IRubyObject iRubyObject, Ruby ruby) {
        if (iRubyObject.isTrue()) {
            return ruby.getFalse();
        }
        return ruby.getTrue();
    }

    public static IRubyObject stringOrNil(String string, Ruby ruby, IRubyObject iRubyObject) {
        if (string == null) {
            return iRubyObject;
        }
        return RubyString.newString(ruby, string);
    }

    public static void preLoad(ThreadContext threadContext, String[] stringArray) {
        LocalStaticScope localStaticScope = new LocalStaticScope(null, stringArray);
        localStaticScope.setModule(threadContext.getRuntime().getObject());
        DynamicScope dynamicScope = DynamicScope.newDynamicScope(localStaticScope);
        threadContext.preScopedBody(dynamicScope);
    }

    public static void postLoad(ThreadContext threadContext) {
        threadContext.postScopedBody();
    }

    public static void registerEndBlock(Block block, Ruby ruby) {
        ruby.pushExitBlock(ruby.newProc(Block.Type.LAMBDA, block));
    }

    public static IRubyObject match3(RubyRegexp rubyRegexp, IRubyObject iRubyObject, ThreadContext threadContext) {
        if (iRubyObject instanceof RubyString) {
            return rubyRegexp.op_match(threadContext, iRubyObject);
        }
        return iRubyObject.callMethod(threadContext, "=~", rubyRegexp);
    }

    public static IRubyObject getErrorInfo(Ruby ruby) {
        return ruby.getGlobalVariables().get("$!");
    }

    public static void setErrorInfo(Ruby ruby, IRubyObject iRubyObject) {
        ruby.getGlobalVariables().set("$!", iRubyObject);
    }

    public static IRubyObject setLastLine(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject) {
        return threadContext.getCurrentFrame().setLastLine(iRubyObject);
    }

    public static IRubyObject getLastLine(Ruby ruby, ThreadContext threadContext) {
        return threadContext.getCurrentFrame().getLastLine();
    }

    public static IRubyObject setBackref(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject) {
        if (!iRubyObject.isNil() && !(iRubyObject instanceof RubyMatchData)) {
            throw ruby.newTypeError(iRubyObject, ruby.getMatchData());
        }
        return threadContext.getCurrentFrame().setBackRef(iRubyObject);
    }

    public static IRubyObject getBackref(Ruby ruby, ThreadContext threadContext) {
        IRubyObject iRubyObject = threadContext.getCurrentFrame().getBackRef();
        if (iRubyObject instanceof RubyMatchData) {
            ((RubyMatchData)iRubyObject).use();
        }
        return iRubyObject;
    }

    public static IRubyObject preOpAsgnWithOrAnd(IRubyObject iRubyObject, ThreadContext threadContext, CallSite callSite) {
        return callSite.call(threadContext, iRubyObject);
    }

    public static IRubyObject postOpAsgnWithOrAnd(IRubyObject iRubyObject, IRubyObject iRubyObject2, ThreadContext threadContext, CallSite callSite) {
        callSite.call(threadContext, iRubyObject, iRubyObject2);
        return iRubyObject2;
    }

    public static IRubyObject opAsgnWithMethod(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, CallSite callSite, CallSite callSite2, CallSite callSite3) {
        IRubyObject iRubyObject3 = callSite.call(threadContext, iRubyObject);
        IRubyObject iRubyObject4 = callSite2.call(threadContext, iRubyObject3, iRubyObject2);
        callSite3.call(threadContext, iRubyObject, iRubyObject4);
        return iRubyObject4;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, CallSite callSite, CallSite callSite2, CallSite callSite3) {
        IRubyObject iRubyObject3 = callSite.call(threadContext, iRubyObject);
        IRubyObject iRubyObject4 = callSite2.call(threadContext, iRubyObject3, iRubyObject2);
        callSite3.call(threadContext, iRubyObject, iRubyObject4);
        return iRubyObject4;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, CallSite callSite, CallSite callSite2, CallSite callSite3) {
        IRubyObject iRubyObject4 = callSite.call(threadContext, iRubyObject, iRubyObject2);
        IRubyObject iRubyObject5 = callSite2.call(threadContext, iRubyObject4, iRubyObject3);
        callSite3.call(threadContext, iRubyObject, iRubyObject2, iRubyObject5);
        return iRubyObject5;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, CallSite callSite, CallSite callSite2, CallSite callSite3) {
        IRubyObject iRubyObject5 = callSite.call(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
        IRubyObject iRubyObject6 = callSite2.call(threadContext, iRubyObject5, iRubyObject4);
        callSite3.call(threadContext, iRubyObject, iRubyObject2, iRubyObject3, iRubyObject6);
        return iRubyObject6;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, IRubyObject iRubyObject5, CallSite callSite, CallSite callSite2, CallSite callSite3) {
        IRubyObject iRubyObject6 = callSite.call(threadContext, iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4);
        IRubyObject iRubyObject7 = callSite2.call(threadContext, iRubyObject6, iRubyObject5);
        callSite3.call(threadContext, iRubyObject, new IRubyObject[]{iRubyObject2, iRubyObject3, iRubyObject4, iRubyObject7});
        return iRubyObject7;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, IRubyObject iRubyObject2, CallSite callSite, CallSite callSite2, CallSite callSite3) {
        IRubyObject iRubyObject3 = callSite.call(threadContext, iRubyObject);
        IRubyObject iRubyObject4 = callSite2.call(threadContext, iRubyObject3, iRubyObject2);
        callSite3.call(threadContext, iRubyObject, RuntimeHelpers.appendToObjectArray(iRubyObjectArray, iRubyObject4));
        return iRubyObject4;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoOneArg(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, CallSite callSite) {
        callSite.call(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
        return iRubyObject3;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoTwoArgs(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, IRubyObject iRubyObject2, CallSite callSite) {
        callSite.call(threadContext, iRubyObject, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObject2);
        return iRubyObject2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoThreeArgs(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, IRubyObject iRubyObject2, CallSite callSite) {
        callSite.call(threadContext, iRubyObject, new IRubyObject[]{iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2], iRubyObject2});
        return iRubyObject2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoNArgs(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, IRubyObject iRubyObject2, CallSite callSite) {
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[iRubyObjectArray.length + 1];
        System.arraycopy(iRubyObjectArray, 0, iRubyObjectArray2, 0, iRubyObjectArray.length);
        iRubyObjectArray2[iRubyObjectArray.length] = iRubyObject2;
        callSite.call(threadContext, iRubyObject, iRubyObjectArray2);
        return iRubyObject2;
    }

    public static RubyArray arrayValue(IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = iRubyObject.checkArrayType();
        if (iRubyObject2.isNil()) {
            Ruby ruby = iRubyObject.getRuntime();
            if (iRubyObject.getMetaClass().searchMethod("to_a").getImplementationClass() != ruby.getKernel()) {
                if (!((iRubyObject = iRubyObject.callMethod(ruby.getCurrentContext(), MethodIndex.TO_A, "to_a")) instanceof RubyArray)) {
                    throw ruby.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)iRubyObject;
            }
            return ruby.newArray(iRubyObject);
        }
        return (RubyArray)iRubyObject2;
    }

    public static IRubyObject aryToAry(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyArray) {
            return iRubyObject;
        }
        if (iRubyObject.respondsTo("to_ary")) {
            return TypeConverter.convertToType(iRubyObject, iRubyObject.getRuntime().getArray(), MethodIndex.TO_A, "to_ary", false);
        }
        return iRubyObject.getRuntime().newArray(iRubyObject);
    }

    public static IRubyObject aValueSplat(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyArray) || ((RubyArray)iRubyObject).length().getLongValue() == 0L) {
            return iRubyObject.getRuntime().getNil();
        }
        RubyArray rubyArray = (RubyArray)iRubyObject;
        return rubyArray.getLength() == 1 ? rubyArray.first() : rubyArray;
    }

    public static RubyArray splatValue(IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return iRubyObject.getRuntime().newArray(iRubyObject);
        }
        return RuntimeHelpers.arrayValue(iRubyObject);
    }

    public static void addInstanceMethod(RubyModule rubyModule, String string, DynamicMethod dynamicMethod, Visibility visibility, ThreadContext threadContext, Ruby ruby) {
        rubyModule.addMethod(string, dynamicMethod);
        RubySymbol rubySymbol = ruby.fastNewSymbol(string);
        if (visibility == Visibility.MODULE_FUNCTION) {
            RuntimeHelpers.addModuleMethod(rubyModule, string, dynamicMethod, threadContext, rubySymbol);
        }
        RuntimeHelpers.callNormalMethodHook(rubyModule, threadContext, rubySymbol);
    }

    private static void addModuleMethod(RubyModule rubyModule, String string, DynamicMethod dynamicMethod, ThreadContext threadContext, RubySymbol rubySymbol) {
        rubyModule.getSingletonClass().addMethod(string, new WrapperMethod((RubyModule)rubyModule.getSingletonClass(), dynamicMethod, Visibility.PUBLIC));
        rubyModule.callMethod(threadContext, "singleton_method_added", rubySymbol);
    }

    private static void callNormalMethodHook(RubyModule rubyModule, ThreadContext threadContext, RubySymbol rubySymbol) {
        if (rubyModule.isSingleton()) {
            RuntimeHelpers.callSingletonMethodHook(((MetaClass)rubyModule).getAttached(), threadContext, rubySymbol);
        } else {
            rubyModule.callMethod(threadContext, "method_added", rubySymbol);
        }
    }

    private static void callSingletonMethodHook(IRubyObject iRubyObject, ThreadContext threadContext, RubySymbol rubySymbol) {
        iRubyObject.callMethod(threadContext, "singleton_method_added", rubySymbol);
    }

    private static DynamicMethod constructNormalMethod(String string, Visibility visibility, MethodFactory methodFactory, RubyModule rubyModule, String string2, int n, StaticScope staticScope, Object object, CallConfiguration callConfiguration) {
        if (string.equals("initialize") || string.equals("initialize_copy") || visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        DynamicMethod dynamicMethod = RubyInstanceConfig.LAZYHANDLES_COMPILE ? methodFactory.getCompiledMethodLazily(rubyModule, string2, Arity.createArity(n), visibility, staticScope, object, callConfiguration) : methodFactory.getCompiledMethod(rubyModule, string2, Arity.createArity(n), visibility, staticScope, object, callConfiguration);
        return dynamicMethod;
    }

    private static DynamicMethod constructSingletonMethod(MethodFactory methodFactory, RubyClass rubyClass, String string, int n, StaticScope staticScope, Object object, CallConfiguration callConfiguration) {
        return methodFactory.getCompiledMethodLazily(rubyClass, string, Arity.createArity(n), Visibility.PUBLIC, staticScope, object, callConfiguration);
    }

    private static StaticScope creatScopeForClass(ThreadContext threadContext, String[] stringArray, int n, int n2, int n3) {
        LocalStaticScope localStaticScope = new LocalStaticScope(threadContext.getCurrentScope().getStaticScope(), stringArray);
        localStaticScope.determineModule();
        localStaticScope.setArities(n, n2, n3);
        return localStaticScope;
    }

    private static void performNormalMethodChecks(RubyModule rubyModule, Ruby ruby, String string) throws RaiseException {
        if (rubyModule == ruby.getDummy()) {
            throw ruby.newTypeError("no class/module to add method");
        }
        if (rubyModule == ruby.getObject() && string.equals("initialize")) {
            ruby.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining Object#initialize may cause infinite loop", "Object#initialize");
        }
        if (string.equals("__id__") || string.equals("__send__")) {
            ruby.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining `" + string + "' may cause serious problem", string);
        }
    }

    private static RubyClass performSingletonMethodChecks(Ruby ruby, IRubyObject iRubyObject, String string) throws RaiseException {
        if (ruby.getSafeLevel() >= 4 && !iRubyObject.isTaint()) {
            throw ruby.newSecurityError("Insecure; can't define singleton method.");
        }
        if (iRubyObject instanceof RubyFixnum || iRubyObject instanceof RubySymbol) {
            throw ruby.newTypeError("can't define singleton method \"" + string + "\" for " + iRubyObject.getMetaClass().getBaseName());
        }
        if (iRubyObject.isFrozen()) {
            throw ruby.newFrozenError("object");
        }
        RubyClass rubyClass = iRubyObject.getSingletonClass();
        if (ruby.getSafeLevel() >= 4 && rubyClass.getMethods().get(string) != null) {
            throw ruby.newSecurityError("redefining method prohibited.");
        }
        return rubyClass;
    }

    public static IRubyObject arrayEntryOrNil(RubyArray rubyArray, IRubyObject iRubyObject, int n) {
        if (n < rubyArray.getLength()) {
            return rubyArray.entry(n);
        }
        return iRubyObject;
    }

    public static RubyArray subarrayOrEmpty(RubyArray rubyArray, Ruby ruby, int n) {
        if (n < rubyArray.getLength()) {
            return RuntimeHelpers.createSubarray(rubyArray, n);
        }
        return RubyArray.newEmptyArray(ruby);
    }
}

