/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi.jna;

import com.sun.jna.Pointer;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.ext.ffi.AbstractBuffer;
import org.jruby.nb.ext.ffi.AbstractMemoryPointer;
import org.jruby.nb.ext.ffi.FFIProvider;
import org.jruby.nb.ext.ffi.MemoryIO;
import org.jruby.nb.ext.ffi.Util;
import org.jruby.nb.ext.ffi.jna.JNAMemory;
import org.jruby.nb.ext.ffi.jna.JNAMemoryIO;
import org.jruby.nb.ext.ffi.jna.JNAMemoryPointer;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"JRuby::FFI::Buffer"}, parent="JRuby::FFI::AbstractMemoryPointer")
public class JNABuffer
extends AbstractBuffer
implements JNAMemory {
    public static final String BUFFER_RUBY_CLASS = "Buffer";
    private static final boolean CLEAR_DEFAULT = true;

    public static RubyClass createBufferClass(Ruby ruby) {
        RubyModule rubyModule = FFIProvider.getModule(ruby);
        RubyClass rubyClass = rubyModule.defineClassUnder(BUFFER_RUBY_CLASS, rubyModule.getClass("AbstractBuffer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(JNABuffer.class);
        rubyClass.defineAnnotatedConstants(JNABuffer.class);
        return rubyClass;
    }

    public JNABuffer(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass, JNAMemoryIO.wrap(Pointer.NULL), 0L, 0L);
    }

    private JNABuffer(Ruby ruby, JNABuffer jNABuffer, long l) {
        this(ruby, jNABuffer.io, jNABuffer.offset + l, jNABuffer.size == Long.MAX_VALUE ? Long.MAX_VALUE : jNABuffer.size - l);
    }

    private JNABuffer(Ruby ruby, MemoryIO memoryIO, long l, long l2) {
        super(ruby, FFIProvider.getModule(ruby).fastGetClass(BUFFER_RUBY_CLASS), memoryIO, l, l2);
    }

    private static JNABuffer allocate(ThreadContext threadContext, IRubyObject iRubyObject, boolean bl) {
        JNAMemoryIO jNAMemoryIO;
        int n = Util.int32Value(iRubyObject);
        JNAMemoryIO jNAMemoryIO2 = jNAMemoryIO = n > 0 ? JNAMemoryIO.allocateDirect(n) : JNAMemoryIO.NULL;
        if (bl && n > 0) {
            jNAMemoryIO.setMemory(0L, n, (byte)0);
        }
        return new JNABuffer(threadContext.getRuntime(), jNAMemoryIO, 0L, n);
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout", "__alloc_heap_inout", "__alloc_direct_inout"}, meta=true)
    public static JNABuffer allocateDirect(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return JNABuffer.allocate(threadContext, iRubyObject2, true);
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout", "__alloc_heap_inout", "__alloc_direct_inout"}, meta=true)
    public static JNABuffer allocateDirect(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return JNABuffer.allocate(threadContext, iRubyObject2, iRubyObject3.isTrue());
    }

    @JRubyMethod(name={"alloc_in", "__alloc_in", "__alloc_heap_in", "__alloc_direct_in"}, meta=true)
    public static JNABuffer allocateInput(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject2 instanceof RubyString) {
            RubyString rubyString = (RubyString)iRubyObject2;
            int n = Util.int32Value(rubyString.length());
            ByteList byteList = rubyString.getByteList();
            JNAMemoryIO jNAMemoryIO = JNAMemoryIO.allocateDirect(n);
            jNAMemoryIO.put(0L, byteList.unsafeBytes(), byteList.begin(), byteList.length());
            jNAMemoryIO.putByte(byteList.length(), (byte)0);
            return new JNABuffer(threadContext.getRuntime(), jNAMemoryIO, 0L, n);
        }
        return JNABuffer.allocate(threadContext, iRubyObject2, true);
    }

    @JRubyMethod(name={"alloc_in", "__alloc_in", "__alloc_heap_in", "__alloc_direct_in"}, meta=true)
    public static JNABuffer allocateInput(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return JNABuffer.allocate(threadContext, iRubyObject2, iRubyObject3.isTrue());
    }

    @JRubyMethod(name={"alloc_out", "__alloc_out", "__alloc_heap_out", "__alloc_direct_out"}, meta=true)
    public static JNABuffer allocateOutput(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return JNABuffer.allocate(threadContext, iRubyObject2, true);
    }

    @JRubyMethod(name={"alloc_out", "__alloc_out", "__alloc_heap_out", "__alloc_direct_out"}, meta=true)
    public static JNABuffer allocateOutput(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return JNABuffer.allocate(threadContext, iRubyObject2, iRubyObject3.isTrue());
    }

    public Object getNativeMemory() {
        return ((JNAMemoryIO)this.getMemoryIO()).slice(this.offset).getMemory();
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext threadContext, IRubyObject iRubyObject) {
        return new JNABuffer(threadContext.getRuntime(), this, RubyNumeric.fix2long(iRubyObject));
    }

    @JRubyMethod(name={"put_pointer"}, required=2)
    public IRubyObject put_pointer(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Pointer pointer;
        if (iRubyObject2 instanceof JNAMemoryPointer) {
            pointer = ((JNAMemoryPointer)iRubyObject2).getAddress();
        } else if (iRubyObject2.isNil()) {
            pointer = Pointer.NULL;
        } else {
            throw threadContext.getRuntime().newArgumentError("Cannot convert argument to pointer");
        }
        ((JNAMemoryIO)this.getMemoryIO()).putPointer(this.getOffset(iRubyObject), pointer);
        return this;
    }

    protected AbstractMemoryPointer getMemoryPointer(Ruby ruby, long l) {
        return new JNAMemoryPointer(ruby, this.getMemoryIO().getMemoryIO(this.offset + l), 0L, Long.MAX_VALUE);
    }
}

