/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext;

import java.io.IOException;
import org.jruby.nb.Ruby;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.runtime.load.Library;

public class LateLoadingLibrary
implements Library {
    private final String libraryName;
    private final String className;
    private ClassLoader classLoader;

    public LateLoadingLibrary(String string, String string2, ClassLoader classLoader) {
        this.libraryName = string;
        this.className = string2;
        this.classLoader = classLoader;
    }

    public synchronized void load(Ruby ruby, boolean bl) throws IOException {
        try {
            if (this.classLoader == null && Ruby.isSecurityRestricted()) {
                this.classLoader = ruby.getInstanceConfig().getLoader();
            }
            Library library = (Library)this.classLoader.loadClass(this.className).newInstance();
            library.load(ruby, bl);
        }
        catch (RaiseException raiseException) {
            throw raiseException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw ruby.newLoadError("library `" + this.libraryName + "' could not be loaded: " + throwable);
        }
    }
}

