/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ast.BlockAcceptingNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperNode
extends Node
implements BlockAcceptingNode {
    private final Node argsNode;
    private Node iterNode;

    public SuperNode(ISourcePosition iSourcePosition, Node node) {
        this(iSourcePosition, node, null);
    }

    public SuperNode(ISourcePosition iSourcePosition, Node node, Node node2) {
        super(iSourcePosition, NodeType.SUPERNODE);
        this.argsNode = node;
        this.iterNode = node2;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitSuperNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public List<Node> childNodes() {
        return this.iterNode != null ? SuperNode.createList(this.argsNode, this.iterNode) : SuperNode.createList(this.argsNode);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node node) {
        this.iterNode = node;
        return this;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        RuntimeHelpers.checkSuperDisabledOrOutOfMethod(threadContext);
        IRubyObject[] iRubyObjectArray = ASTInterpreter.setupArgs(ruby, threadContext, this.argsNode, iRubyObject, block);
        Block block2 = ASTInterpreter.getBlock(ruby, threadContext, iRubyObject, block, this.iterNode);
        if (this.iterNode == null && !block2.isGiven()) {
            block2 = block;
        }
        return iRubyObject.callSuper(threadContext, iRubyObjectArray, block2);
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        String string = threadContext.getFrameName();
        RubyModule rubyModule = threadContext.getFrameKlazz();
        if (string != null && rubyModule != null && rubyModule.getSuperClass().isMethodBound(string, false)) {
            return ASTInterpreter.getArgumentDefinition(ruby, threadContext, this.argsNode, "super", iRubyObject, block);
        }
        return null;
    }
}

