/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVarNode
extends Node
implements INameNode {
    private String name;
    private final int location;

    public LocalVarNode(ISourcePosition iSourcePosition, int n, String string) {
        super(iSourcePosition, NodeType.LOCALVARNODE);
        this.location = n;
        this.name = string;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitLocalVarNode(this);
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = threadContext.getCurrentScope().getValue(this.getIndex(), this.getDepth());
        return iRubyObject2 == null ? ruby.getNil() : iRubyObject2;
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return "local-variable";
    }
}

