/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyException;
import org.jruby.nb.RubyHash;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.anno.JRubyModule;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"Iconv"})
public class RubyIconv
extends RubyObject {
    private static final String IGNORE = "//ignore";
    private CharsetDecoder fromEncoding;
    private CharsetEncoder toEncoding;
    private static final ObjectAllocator ICONV_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyIconv(ruby, rubyClass);
        }
    };

    public RubyIconv(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static void createIconv(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Iconv", ruby.getObject(), ICONV_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(RubyIconv.class);
        RubyModule rubyModule = rubyClass.defineModuleUnder("Failure");
        RubyClass rubyClass2 = ruby.getArgumentError();
        String[] stringArray = new String[]{"IllegalSequence", "InvalidCharacter", "InvalidEncoding", "OutOfRange", "BrokenLibrary"};
        for (int i = 0; i < stringArray.length; ++i) {
            RubyClass rubyClass3 = rubyClass.defineClassUnder(stringArray[i], rubyClass2, RubyFailure.ICONV_FAILURE_ALLOCATOR);
            rubyClass3.defineAnnotatedMethods(RubyFailure.class);
            rubyClass3.includeModule(rubyModule);
        }
    }

    private static String getCharset(String string) {
        int n = string.indexOf("//");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private static boolean isIgnore(String string) {
        return string.toLowerCase().indexOf(IGNORE) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, required=2, frame=true, meta=true)
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        Ruby ruby = threadContext.getRuntime();
        RubyIconv rubyIconv = RubyIconv.newIconv(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
        if (!block.isGiven()) {
            return rubyIconv;
        }
        IRubyObject iRubyObject4 = ruby.getNil();
        try {
            iRubyObject4 = block.yield(threadContext, rubyIconv);
        }
        finally {
            rubyIconv.close();
        }
        return iRubyObject4;
    }

    private static RubyIconv newIconv(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        RubyClass rubyClass = (RubyClass)iRubyObject;
        return (RubyIconv)rubyClass.newInstance(threadContext, new IRubyObject[]{iRubyObject2, iRubyObject3}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"initialize"}, required=2, frame=true)
    public IRubyObject initialize(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        Ruby ruby = this.getRuntime();
        if (!iRubyObject.respondsTo("to_str")) {
            throw ruby.newTypeError("can't convert " + iRubyObject.getMetaClass() + " into String");
        }
        if (!iRubyObject2.respondsTo("to_str")) {
            throw ruby.newTypeError("can't convert " + iRubyObject2.getMetaClass() + " into String");
        }
        String string = iRubyObject.convertToString().toString();
        String string2 = iRubyObject2.convertToString().toString();
        try {
            this.fromEncoding = Charset.forName(RubyIconv.getCharset(string2)).newDecoder();
            this.toEncoding = Charset.forName(RubyIconv.getCharset(string)).newEncoder();
            if (!RubyIconv.isIgnore(string2)) {
                this.fromEncoding.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            if (!RubyIconv.isIgnore(string)) {
                this.toEncoding.onUnmappableCharacter(CodingErrorAction.REPORT);
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw ruby.newInvalidEncoding("invalid encoding");
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw ruby.newInvalidEncoding("invalid encoding");
        }
        catch (Exception exception) {
            throw ruby.newSystemCallError(exception.toString());
        }
        return this;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        this.toEncoding = null;
        this.fromEncoding = null;
        return RubyString.newEmptyString(this.getRuntime());
    }

    @JRubyMethod
    public IRubyObject iconv(IRubyObject iRubyObject) {
        return this.iconv(iRubyObject, 0, -1);
    }

    @JRubyMethod
    public IRubyObject iconv(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = 0;
        if (!iRubyObject2.isNil()) {
            n = RubyNumeric.fix2int(iRubyObject2);
        }
        return this.iconv(iRubyObject, n, -1);
    }

    @JRubyMethod
    public IRubyObject iconv(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        int n = 0;
        int n2 = -1;
        if (!iRubyObject2.isNil()) {
            n = RubyNumeric.fix2int(iRubyObject2);
        }
        if (!iRubyObject3.isNil()) {
            n2 = RubyNumeric.fix2int(iRubyObject3);
        }
        return this.iconv(iRubyObject, n, n2);
    }

    private IRubyObject iconv(IRubyObject iRubyObject, int n, int n2) {
        if (iRubyObject.isNil()) {
            this.fromEncoding.reset();
            this.toEncoding.reset();
            return RubyString.newEmptyString(this.getRuntime());
        }
        return this._iconv(iRubyObject.convertToString(), n, n2);
    }

    public IRubyObject iconv(IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 1: {
                return this.iconv(iRubyObjectArray[0]);
            }
            case 2: {
                return this.iconv(iRubyObjectArray[0], iRubyObjectArray[1]);
            }
            case 3: {
                return this.iconv(iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), iRubyObjectArray.length, 1, 2);
        return null;
    }

    private IRubyObject _iconv(RubyString rubyString, int n, int n2) {
        Object object;
        if (this.fromEncoding == null) {
            throw this.getRuntime().newArgumentError("closed iconv");
        }
        ByteList byteList = rubyString.getByteList();
        if (n < 0) {
            n += byteList.length();
        }
        if (n2 < 0) {
            n2 += 1 + byteList.length();
        } else if (n2 > byteList.length()) {
            n2 = byteList.length();
        }
        if (n < 0 || n2 < n) {
            return RubyString.newEmptyString(this.getRuntime());
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin() + n, n2 - n);
        try {
            object = this.fromEncoding.decode(byteBuffer);
            byteBuffer = this.toEncoding.encode((CharBuffer)object);
        }
        catch (MalformedInputException malformedInputException) {
        }
        catch (UnmappableCharacterException unmappableCharacterException) {
        }
        catch (CharacterCodingException characterCodingException) {
            throw this.getRuntime().newInvalidEncoding("invalid sequence");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        object = byteBuffer.array();
        return this.getRuntime().newString(new ByteList((byte[])object, 0, byteBuffer.limit()));
    }

    @JRubyMethod(name={"iconv"}, required=2, rest=true, meta=true)
    public static IRubyObject iconv(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyIconv.convertWithArgs(threadContext, iRubyObject, iRubyObjectArray, "iconv");
    }

    @JRubyMethod(name={"conv"}, required=3, rest=true, meta=true)
    public static IRubyObject conv(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyIconv.convertWithArgs(threadContext, iRubyObject, iRubyObjectArray, "conv").join(threadContext, RubyString.newEmptyString(iRubyObject.getRuntime()));
    }

    @JRubyMethod(name={"charset_map"}, meta=true)
    public static IRubyObject charset_map_get(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().getCharsetMap();
    }

    private static String mapCharset(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyString rubyString;
        IRubyObject iRubyObject2;
        RubyHash rubyHash = iRubyObject.getRuntime().getCharsetMap();
        if (rubyHash.size() > 0 && (iRubyObject2 = rubyHash.fastARef(rubyString = iRubyObject.callMethod(threadContext, "downcase").convertToString())) != null) {
            iRubyObject = iRubyObject2;
        }
        return iRubyObject.convertToString().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyArray convertWithArgs(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, String string) {
        assert (iRubyObjectArray.length >= 2);
        RubyArray rubyArray = threadContext.getRuntime().newArray(iRubyObjectArray.length - 2);
        RubyIconv rubyIconv = RubyIconv.newIconv(threadContext, iRubyObject, iRubyObjectArray[0], iRubyObjectArray[1]);
        try {
            for (int i = 2; i < iRubyObjectArray.length; ++i) {
                rubyArray.append(rubyIconv.iconv(iRubyObjectArray[i]));
            }
        }
        finally {
            rubyIconv.close();
        }
        return rubyArray;
    }

    public static class RubyFailure
    extends RubyException {
        private IRubyObject success;
        private IRubyObject failed;
        protected static final ObjectAllocator ICONV_FAILURE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new RubyFailure(ruby, rubyClass);
            }
        };

        public static RubyFailure newInstance(Ruby ruby, RubyClass rubyClass, String string) {
            return new RubyFailure(ruby, rubyClass, string);
        }

        protected RubyFailure(Ruby ruby, RubyClass rubyClass) {
            this(ruby, rubyClass, null);
        }

        public RubyFailure(Ruby ruby, RubyClass rubyClass, String string) {
            super(ruby, rubyClass, string);
        }

        @JRubyMethod(name={"initialize"}, required=1, optional=2, frame=true)
        public IRubyObject initialize(IRubyObject[] iRubyObjectArray, Block block) {
            super.initialize(iRubyObjectArray, block);
            this.success = iRubyObjectArray.length >= 2 ? iRubyObjectArray[1] : this.getRuntime().getNil();
            this.failed = iRubyObjectArray.length == 3 ? iRubyObjectArray[2] : this.getRuntime().getNil();
            return this;
        }

        @JRubyMethod(name={"success"})
        public IRubyObject success() {
            return this.success;
        }

        @JRubyMethod(name={"failed"})
        public IRubyObject failed() {
            return this.failed;
        }

        @JRubyMethod(name={"inspect"})
        public IRubyObject inspect() {
            RubyClass rubyClass = this.getMetaClass();
            StringBuilder stringBuilder = new StringBuilder("#<");
            stringBuilder.append(rubyClass.getName()).append(": ").append(this.success.inspect().toString());
            stringBuilder.append(", ").append(this.failed.inspect().toString()).append(">");
            return this.getRuntime().newString(stringBuilder.toString());
        }
    }

    @JRubyClass(name={"Iconv::BrokenLibrary"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class BrokenLibrary {
    }

    @JRubyClass(name={"Iconv::OutOfRange"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class OutOfRange {
    }

    @JRubyClass(name={"Iconv::InvalidEncoding"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class InvalidEncoding {
    }

    @JRubyClass(name={"Iconv::InvalidCharacter"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class InvalidCharacter {
    }

    @JRubyClass(name={"Iconv::IllegalSequence"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class IllegalSequence {
    }

    @JRubyModule(name={"Iconv::Failure"})
    public static class Failure {
    }
}

