/*
 * Decompiled with CFR 0.152.
 */
package org.yecht.ruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;
import org.yecht.Data;
import org.yecht.ImplicitScanner;
import org.yecht.MapPart;
import org.yecht.Node;
import org.yecht.ruby.YAMLExtra;

public class Resolver {
    public static IRubyObject const_find(IRubyObject self, IRubyObject const_name) {
        RubyClass tclass = self.getRuntime().getObject();
        RubyArray tparts = ((RubyString)const_name).split(self.getRuntime().getCurrentContext(), (IRubyObject)self.getRuntime().newString("::"));
        for (int i = 0; i < tparts.getLength(); ++i) {
            String tpart = tparts.entry(i).toString();
            try {
                tclass = (RubyModule)tclass.getConstant(tpart);
                continue;
            }
            catch (Exception e) {
                return self.getRuntime().getNil();
            }
        }
        return tclass;
    }

    @JRubyMethod
    public static IRubyObject initialize(IRubyObject self) {
        ((RubyObject)self).fastSetInstanceVariable("@tags", (IRubyObject)RubyHash.newHash((Ruby)self.getRuntime()));
        return self;
    }

    @JRubyMethod
    public static IRubyObject add_type(IRubyObject self, IRubyObject taguri, IRubyObject cls) {
        IRubyObject tags = self.callMethod(self.getRuntime().getCurrentContext(), "tags");
        ((RubyHash)tags).fastASet(taguri, cls);
        return self.getRuntime().getNil();
    }

    @JRubyMethod
    public static IRubyObject use_types_at(IRubyObject self, IRubyObject hsh) {
        ((RubyObject)self).fastSetInstanceVariable("@tags", hsh);
        return self.getRuntime().getNil();
    }

    @JRubyMethod
    public static IRubyObject detect_implicit(IRubyObject self, IRubyObject val) {
        return RubyString.newEmptyString((Ruby)self.getRuntime());
    }

    @JRubyMethod
    public static IRubyObject transfer(IRubyObject self, IRubyObject type, IRubyObject val) {
        final Ruby runtime = self.getRuntime();
        ThreadContext ctx = runtime.getCurrentContext();
        if (type.isNil() || type.convertToString().getByteList().realSize == 0) {
            type = self.callMethod(ctx, "detect_implicit", val);
        }
        if (!type.isNil() && type.convertToString().getByteList().realSize != 0) {
            IRubyObject target_class;
            RubyString colon = runtime.newString(":");
            IRubyObject tags = self.callMethod(ctx, "tags");
            IRubyObject subclass = target_class = ((RubyHash)tags).op_aref(ctx, type);
            Object obj = runtime.getNil();
            if (target_class.isNil()) {
                RubyArray subclass_parts = runtime.newArray();
                RubyArray parts = ((RubyString)type).split(ctx, (IRubyObject)colon);
                while (parts.getLength() > 1) {
                    subclass_parts.unshift(parts.pop(ctx));
                    IRubyObject partial = parts.join(ctx, (IRubyObject)colon);
                    target_class = ((RubyHash)tags).op_aref(ctx, partial);
                    if (target_class.isNil()) {
                        ((RubyString)partial).append((IRubyObject)colon);
                        target_class = ((RubyHash)tags).op_aref(ctx, partial);
                    }
                    if (target_class.isNil()) continue;
                    subclass = target_class;
                    if (subclass_parts.getLength() <= 0 || !target_class.respondsTo("yaml_tag_subclasses?") || !target_class.callMethod(ctx, "yaml_tag_subclasses?").isTrue()) break;
                    subclass = subclass_parts.join(ctx, (IRubyObject)colon);
                    IRubyObject subclass_v = Resolver.const_find(self, subclass = target_class.callMethod(ctx, "yaml_tag_read_class", subclass));
                    if (subclass_v != runtime.getNil()) {
                        subclass = subclass_v;
                        break;
                    }
                    if (target_class == runtime.getObject() && subclass_v == runtime.getNil()) {
                        target_class = runtime.getModule("YAML").getConstant("Object");
                        type = subclass;
                        subclass = target_class;
                        break;
                    }
                    throw runtime.newTypeError("invalid subclass");
                }
            }
            if (target_class.respondsTo("call")) {
                obj = target_class.callMethod(ctx, "call", new IRubyObject[]{type, val});
            } else if (target_class.respondsTo("yaml_new")) {
                obj = target_class.callMethod(ctx, "yaml_new", new IRubyObject[]{subclass, type, val});
            } else if (!target_class.isNil()) {
                obj = subclass == runtime.getBignum() ? RubyNumeric.str2inum((Ruby)runtime, (RubyString)val.convertToString(), (int)10) : ((RubyClass)subclass).allocate();
                if (obj.respondsTo("yaml_initialize")) {
                    obj.callMethod(ctx, "yaml_initialize", new IRubyObject[]{type, val});
                } else if (!obj.isNil() && val instanceof RubyHash) {
                    final IRubyObject _obj = obj;
                    RubyEnumerable.callEach((Ruby)runtime, (ThreadContext)ctx, (IRubyObject)val, (BlockCallback)new BlockCallback(){

                        public IRubyObject call(ThreadContext _ctx, IRubyObject[] largs, Block blk) {
                            IRubyObject ivname = ((RubyArray)largs[0]).entry(0);
                            String ivn = "@" + ivname.convertToString().toString();
                            _obj.getInstanceVariables().setInstanceVariable(ivn, ((RubyArray)largs[0]).entry(1));
                            return runtime.getNil();
                        }
                    });
                }
            } else {
                RubyArray parts = ((RubyString)type).split(ctx, (IRubyObject)colon);
                IRubyObject scheme = parts.shift(ctx);
                if (scheme.convertToString().toString().equals("x-private")) {
                    IRubyObject name = parts.join(ctx, (IRubyObject)colon);
                    obj = ((RubyModule)runtime.getModule("YAML").getConstant("Yecht")).getConstant("PrivateType").callMethod(ctx, "new", new IRubyObject[]{name, val});
                } else {
                    IRubyObject domain = parts.shift(ctx);
                    IRubyObject name = parts.join(ctx, (IRubyObject)colon);
                    obj = ((RubyModule)runtime.getModule("YAML").getConstant("Yecht")).getConstant("DomainType").callMethod(ctx, "new", new IRubyObject[]{domain, name, val});
                }
            }
            val = obj;
        }
        return val;
    }

    @JRubyMethod
    public static IRubyObject node_import(IRubyObject self, IRubyObject node) {
        final Ruby runtime = self.getRuntime();
        ThreadContext ctx = runtime.getCurrentContext();
        Node n = (Node)node.dataGetStructChecked();
        YAMLExtra x = ((org.yecht.ruby.Node)node).x;
        RubyHash obj = null;
        switch (n.kind) {
            case Str: {
                Data.Str dd = (Data.Str)n.data;
                obj = RubyString.newStringShared((Ruby)runtime, (byte[])dd.ptr.buffer, (int)dd.ptr.start, (int)dd.len);
                break;
            }
            case Seq: {
                Data.Seq ds = (Data.Seq)n.data;
                obj = RubyArray.newArray((Ruby)runtime, (int)ds.idx);
                for (int i = 0; i < ds.idx; ++i) {
                    IRubyObject obj2 = (IRubyObject)n.seqRead(i);
                    ((RubyArray)obj).store((long)i, obj2);
                }
                break;
            }
            case Map: {
                Data.Map dm = (Data.Map)n.data;
                obj = RubyHash.newHash((Ruby)runtime);
                RubyClass cMergeKey = x.MergeKey;
                RubyClass cDefaultKey = x.DefaultKey;
                RubyClass cHash = runtime.getHash();
                RubyClass cArray = runtime.getArray();
                for (int i = 0; i < dm.idx; ++i) {
                    IRubyObject k = (IRubyObject)n.mapRead(MapPart.Key, i);
                    IRubyObject v = (IRubyObject)n.mapRead(MapPart.Value, i);
                    if (null == v) {
                        v = runtime.getNil();
                    }
                    boolean skip_aset = false;
                    if (cMergeKey.isInstance(k)) {
                        IRubyObject end;
                        if (cHash.isInstance(v)) {
                            IRubyObject dup = v.callMethod(ctx, "dup");
                            dup.callMethod(ctx, "update", (IRubyObject)obj);
                            obj = dup;
                            skip_aset = true;
                        } else if (cArray.isInstance(v) && cHash.isInstance(end = ((RubyArray)v).pop(ctx))) {
                            final IRubyObject dup = end.callMethod(ctx, "dup");
                            v = ((RubyArray)v).reverse();
                            ((RubyArray)v).append((IRubyObject)obj);
                            RubyEnumerable.callEach((Ruby)runtime, (ThreadContext)ctx, (IRubyObject)v, (BlockCallback)new BlockCallback(){

                                public IRubyObject call(ThreadContext _ctx, IRubyObject[] largs, Block blk) {
                                    IRubyObject entry = largs[0];
                                    IRubyObject tmp = null;
                                    tmp = TypeConverter.convertToTypeWithCheck((IRubyObject)entry, (RubyClass)runtime.getHash(), (String)"to_hash");
                                    if (!tmp.isNil()) {
                                        dup.callMethod(_ctx, "update", tmp);
                                    }
                                    return runtime.getNil();
                                }
                            });
                            obj = dup;
                            skip_aset = true;
                        }
                    } else if (cDefaultKey.isInstance(k)) {
                        obj.callMethod(ctx, "default=", v);
                        skip_aset = true;
                    }
                    if (skip_aset) continue;
                    obj.fastASet(k, v);
                }
                break;
            }
        }
        if (n.type_id != null) {
            obj = self.callMethod(ctx, "transfer", new IRubyObject[]{runtime.newString(n.type_id), obj});
        }
        return obj;
    }

    @JRubyMethod
    public static IRubyObject tagurize(IRubyObject self, IRubyObject val) {
        IRubyObject tmp = val.checkStringType();
        if (!tmp.isNil()) {
            String taguri = ImplicitScanner.typeIdToUri(tmp.toString());
            val = self.getRuntime().newString(taguri);
        }
        return val;
    }
}

