/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.w3c.dom.Element;

public class Utilities {
    private static final XPath xpath = XPathFactory.newInstance().newXPath();

    private Utilities() {
    }

    public static boolean isSupportedVersion(HudsonVersion hudsonVersion) {
        if (null == hudsonVersion) {
            return false;
        }
        return hudsonVersion.compareTo(HudsonVersion.SUPPORTED_VERSION) >= 0;
    }

    public static String uriEncode(String string) {
        if (string.contains("/")) {
            throw new IllegalArgumentException("cannot contain a slash: " + string);
        }
        try {
            return new URI(null, string, null).toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (IllegalArgumentException)new IllegalArgumentException(uRISyntaxException.toString()).initCause(uRISyntaxException);
        }
    }

    public static String uriDecode(String string) {
        String string2 = URI.create(string).getPath();
        if (string2.contains("/")) {
            throw new IllegalArgumentException(string2);
        }
        return string2;
    }

    public static synchronized String xpath(String string, Element element) {
        try {
            return xpath.evaluate(string, element);
        }
        catch (XPathExpressionException xPathExpressionException) {
            Logger.getLogger(Utilities.class.getName()).log(Level.FINE, "cannot evaluate '" + string + "'", xPathExpressionException);
            return null;
        }
    }
}

