/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.util.Enumerations;
import org.openide.util.NbCollections;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.Attr,
AbstractFileSystem.Change,
AbstractFileSystem.List,
AbstractFileSystem.Info {
    private static final Logger LOG = Logger.getLogger(RemoteFileSystem.class.getName());
    private static final int TIMEOUT = 10000;
    private final URL baseURL;
    private final String displayName;
    private final HudsonJob job;
    private final Set<String> nonDirs = new HashSet<String>();
    private final Map<String, Long> lastModified = new HashMap<String, Long>();
    private final Map<String, Integer> size = new HashMap<String, Integer>();
    private final Map<String, byte[]> headers = new HashMap<String, byte[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteFileSystem(URL uRL, String string, HudsonJob hudsonJob) {
        this.baseURL = uRL;
        this.displayName = string;
        this.job = hudsonJob;
        this.attr = this;
        this.change = this;
        this.list = this;
        this.info = this;
        Class<Mapper> clazz = Mapper.class;
        synchronized (Mapper.class) {
            if (Mapper.workspaces == null) {
                Mapper.workspaces = new WeakSet();
            }
            Mapper.workspaces.add(this);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    RemoteFileSystem(HudsonJob hudsonJob) throws MalformedURLException {
        this(new URL(hudsonJob.getUrl() + "ws/"), hudsonJob.getDisplayName(), hudsonJob);
    }

    RemoteFileSystem(HudsonJobBuild hudsonJobBuild) throws MalformedURLException {
        this(new URL(hudsonJobBuild.getUrl() + "artifact/"), hudsonJobBuild.getDisplayName(), hudsonJobBuild.getJob());
    }

    RemoteFileSystem(HudsonMavenModuleBuild hudsonMavenModuleBuild) throws MalformedURLException {
        this(new URL(hudsonMavenModuleBuild.getUrl() + "artifact/"), hudsonMavenModuleBuild.getBuildDisplayName(), hudsonMavenModuleBuild.getBuild().getJob());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshAll() {
        LOG.log(Level.FINE, "refreshing files in {0}", this.baseURL);
        Set<String> set = this.nonDirs;
        synchronized (set) {
            this.nonDirs.clear();
            this.lastModified.clear();
            this.size.clear();
            this.headers.clear();
        }
        for (FileObject fileObject : NbCollections.iterable((Enumeration)this.existingFileObjects(this.getRoot()))) {
            if (Thread.interrupted()) {
                return;
            }
            LOG.log(Level.FINER, "  refreshing {0}", fileObject.getPath());
            fileObject.refresh();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] children(String string) {
        String string2 = string.length() > 0 ? string + "/" : "";
        try {
            URL uRL = new URL(this.baseURL, string2 + "*plain*");
            URLConnection uRLConnection = new ConnectionBuilder().job(this.job).url(uRL).timeout(10000).connection();
            String string3 = uRLConnection.getContentType();
            if (string3 == null || !string3.startsWith("text/plain")) {
                LOG.log(Level.FINE, "non-plain dir listing: {0}", uRL);
                return new String[0];
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            InputStream inputStream = uRLConnection.getInputStream();
            try {
                String string4;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while ((string4 = bufferedReader.readLine()) != null) {
                    Object object;
                    if (string4.endsWith("/")) {
                        object = string4.substring(0, string4.length() - 1);
                        arrayList.add(object);
                        continue;
                    }
                    arrayList.add(string4);
                    object = this.nonDirs;
                    synchronized (object) {
                        this.nonDirs.add(string2 + string4);
                    }
                }
            }
            finally {
                inputStream.close();
            }
            LOG.log(Level.FINE, "children: {0} -> {1}", new Object[]{uRL, arrayList});
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, "cannot list children of {0} in {1}: {2}", new Object[]{string, this.baseURL, iOException});
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean folder(String string) {
        Set<String> set = this.nonDirs;
        synchronized (set) {
            return !this.nonDirs.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLConnection connection(String string, boolean bl) throws IOException {
        LOG.log(Level.FINE, "metadata in {0}: {1}", new Object[]{this.baseURL, string});
        URLConnection uRLConnection = new ConnectionBuilder().job(this.job).url(new URL(this.baseURL, string)).timeout(10000).connection();
        if (bl) {
            assert (Thread.holdsLock(this.nonDirs));
            this.lastModified.put(string, uRLConnection.getLastModified());
            int n = uRLConnection.getContentLength();
            if (n == -1) {
                LOG.warning("unknown content length for " + string + " in " + this.baseURL);
                this.size.put(string, 0);
            } else {
                this.size.put(string, n);
            }
            if (n >= 0) {
                byte[] byArray = new byte[Math.min(n, 8192)];
                InputStream inputStream = uRLConnection.getInputStream();
                try {
                    int n2;
                    int n3;
                    for (n2 = 0; n2 < byArray.length && (n3 = inputStream.read(byArray, n2, byArray.length - n2)) != -1; n2 += n3) {
                    }
                    if (n2 == byArray.length) {
                        this.headers.put(string, byArray);
                    } else {
                        LOG.warning("incomplete read for " + string + " in " + this.baseURL + ": read up to " + n2 + " where reported length is " + n);
                    }
                }
                finally {
                    inputStream.close();
                }
            }
        }
        return uRLConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date lastModified(String string) {
        Set<String> set = this.nonDirs;
        synchronized (set) {
            if (this.folder(string)) {
                return new Date(0L);
            }
            if (!this.lastModified.containsKey(string)) {
                try {
                    this.connection(string, true);
                }
                catch (IOException iOException) {
                    LOG.log(Level.FINE, "cannot get metadata for " + string + " in " + this.baseURL, iOException);
                    return new Date(0L);
                }
            }
            return new Date(this.lastModified.get(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size(String string) {
        Set<String> set = this.nonDirs;
        synchronized (set) {
            if (this.folder(string)) {
                return 0L;
            }
            if (!this.size.containsKey(string)) {
                try {
                    this.connection(string, true);
                }
                catch (IOException iOException) {
                    LOG.log(Level.FINE, "cannot get metadata for " + string + " in " + this.baseURL, iOException);
                    return 0L;
                }
            }
            return this.size.get(string).intValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream inputStream(final String string) throws FileNotFoundException {
        Set<String> set = this.nonDirs;
        synchronized (set) {
            final byte[] byArray = this.headers.get(string);
            if (byArray != null) {
                LOG.log(Level.FINE, "cached inputStream: {0}", string);
                if ((long)byArray.length == this.size(string)) {
                    return new ByteArrayInputStream(byArray);
                }
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class HeaderCachedInputStream
                extends InputStream {
                    int p;
                    InputStream delegate;

                    HeaderCachedInputStream() {
                    }

                    @Override
                    public int read() throws IOException {
                        if (this.delegate != null) {
                            return this.delegate.read();
                        }
                        if (this.p < byArray.length) {
                            return byArray[this.p++] & 0xFF;
                        }
                        if (this.delegate == null) {
                            LOG.log(Level.FINE, "uncached tail of inputStream: {0}", string);
                            this.delegate = RemoteFileSystem.this.inputStreamNoCache(string);
                            while (this.p-- > 0) {
                                if (this.delegate.read() != -1) continue;
                                throw new IOException("Premature EOF in " + string);
                            }
                        }
                        return this.delegate.read();
                    }

                    @Override
                    public void close() throws IOException {
                        if (this.delegate != null) {
                            this.delegate.close();
                        }
                    }

                    @Override
                    public int available() throws IOException {
                        if (this.delegate != null) {
                            return this.delegate.available();
                        }
                        return byArray.length - this.p;
                    }
                }
                return new HeaderCachedInputStream();
            }
            return this.inputStreamNoCache(string);
        }
    }

    private InputStream inputStreamNoCache(String string) throws FileNotFoundException {
        LOG.log(Level.FINE, "inputStream: {0}", string);
        try {
            return new BufferedInputStream(this.connection(string, false).getInputStream());
        }
        catch (IOException iOException) {
            throw (FileNotFoundException)new FileNotFoundException(iOException.getMessage()).initCause(iOException);
        }
    }

    public Object readAttribute(String string, String string2) {
        if (string2.equals("isRemoteAndSlow")) {
            return true;
        }
        return null;
    }

    public void writeAttribute(String string, String string2, Object object) throws IOException {
        throw new IOException();
    }

    public Enumeration<String> attributes(String string) {
        return Enumerations.empty();
    }

    public void renameAttributes(String string, String string2) {
    }

    public void deleteAttributes(String string) {
    }

    public void createFolder(String string) throws IOException {
        throw new IOException();
    }

    public void createData(String string) throws IOException {
        throw new IOException();
    }

    public void rename(String string, String string2) throws IOException {
        throw new IOException();
    }

    public void delete(String string) throws IOException {
        throw new IOException();
    }

    public boolean readOnly(String string) {
        return true;
    }

    public String mimeType(String string) {
        return null;
    }

    public OutputStream outputStream(String string) throws IOException {
        throw new IOException();
    }

    public void lock(String string) throws IOException {
    }

    public void unlock(String string) {
    }

    public void markUnimportant(String string) {
    }

    public static class Mapper
    extends URLMapper {
        static Set<RemoteFileSystem> workspaces = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URL getURL(FileObject fileObject, int n) {
            Class<Mapper> clazz = Mapper.class;
            synchronized (Mapper.class) {
                if (workspaces == null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return null;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return Mapper.doGetURL(fileObject);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject[] getFileObjects(URL uRL) {
            Class<Mapper> clazz = Mapper.class;
            synchronized (Mapper.class) {
                if (workspaces == null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Mapper.doGetFileObjects(uRL);
            }
        }

        private static URL doGetURL(FileObject fileObject) {
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                if (fileSystem instanceof RemoteFileSystem) {
                    return new URL(((RemoteFileSystem)fileSystem).baseURL, fileObject.getPath());
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "trying to get URL for " + fileObject, iOException);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static FileObject[] doGetFileObjects(URL uRL) {
            RemoteFileSystem remoteFileSystem = null;
            String string = uRL.toString();
            FileObject fileObject = Mapper.class;
            synchronized (Mapper.class) {
                for (RemoteFileSystem remoteFileSystem2 : workspaces) {
                    if (!string.startsWith(remoteFileSystem2.baseURL.toString())) continue;
                    remoteFileSystem = remoteFileSystem2;
                    break;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (remoteFileSystem != null && (fileObject = remoteFileSystem.findResource(string.substring(remoteFileSystem.baseURL.toString().length()))) != null) {
                    return new FileObject[]{fileObject};
                }
                return null;
            }
        }
    }
}

