/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.disassembly;

import java.io.IOException;
import java.util.Collection;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.debugger.common.disassembly.RegisterValue;
import org.netbeans.modules.cnd.debugger.gdb.GdbContext;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class DisToolTipAnnotation
extends Annotation
implements Runnable {
    private Line.Part lp;
    private EditorCookie ec;

    public String getShortDescription() {
        Disassembly disassembly = Disassembly.getCurrent();
        if (disassembly == null) {
            return null;
        }
        Line.Part part = (Line.Part)this.getAttachedAnnotatable();
        if (part == null) {
            return null;
        }
        Line line = part.getLine();
        DataObject dataObject = DataEditorSupport.findDataObject((Line)line);
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        this.lp = part;
        this.ec = editorCookie;
        RequestProcessor.getDefault().post((Runnable)this);
        return null;
    }

    public void run() {
        StyledDocument styledDocument;
        if (this.lp == null || this.ec == null) {
            return;
        }
        try {
            styledDocument = this.ec.openDocument();
        }
        catch (IOException iOException) {
            return;
        }
        JEditorPane jEditorPane = EditorContextDispatcher.getDefault().getCurrentEditor();
        if (jEditorPane == null) {
            return;
        }
        String string = DisToolTipAnnotation.getRegister(styledDocument, jEditorPane, NbDocument.findLineOffset((StyledDocument)styledDocument, (int)this.lp.getLine().getLineNumber()) + this.lp.getColumn());
        if (string == null) {
            return;
        }
        String string2 = null;
        Collection collection = (Collection)GdbContext.getInstance().getProperty("Registers");
        if (collection != null) {
            for (RegisterValue registerValue : collection) {
                if (!string.equals(registerValue.getName())) continue;
                string2 = registerValue.getValue();
            }
        }
        this.firePropertyChange("shortDescription", null, string2);
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getRegister(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            return string;
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        try {
            int n4;
            int n5;
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
            if (element == null) {
                return null;
            }
            int n6 = element.getStartOffset();
            int n7 = element.getEndOffset() - n6;
            string = styledDocument.getText(n6, n7);
            for (n5 = n3; n5 > 0 && (Character.isJavaIdentifierPart(string.charAt(n5 - 1)) || string.charAt(n5 - 1) == '.'); --n5) {
            }
            if (n5 == 0 || string.charAt(n5 - 1) != '%') {
                return null;
            }
            for (n4 = n3; n4 < n7 && Character.isJavaIdentifierPart(string.charAt(n4)); ++n4) {
            }
            if (n5 == n4) {
                return null;
            }
            return string.substring(n5, n4);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

