/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.openide.util.NbPreferences;

public class CsmFileFilter {
    private BooleanFilter showForwardClassDeclarations = new BooleanFilter("ShowForwardClassDeclarations", true);
    private BooleanFilter showForwardFunctionDeclarations = new BooleanFilter("ShowForwardFunctionDeclarations", false);
    private BooleanFilter showInclude = new BooleanFilter("ShowInclude", true);
    private BooleanFilter showMacro = new BooleanFilter("ShowMacro", true);
    private BooleanFilter showTypedef = new BooleanFilter("ShowTypedef", true);
    private BooleanFilter showVariable = new BooleanFilter("ShowVariable", true);
    private BooleanFilter showField = new BooleanFilter("ShowField", true);
    private BooleanFilter showUsing = new BooleanFilter("ShowUsing", true);
    private SortMode sortByName = SortMode.Name;
    private BooleanFilter groupByKind = new BooleanFilter("groupByKind", false);
    private BooleanFilter expandAll = new BooleanFilter("expandAll", false);

    public CsmFileFilter() {
        Preferences preferences = NbPreferences.forModule(CsmFileFilter.class);
        this.sortByName = SortMode.valueOf(preferences.get("SortByName", this.sortByName.name()));
    }

    public boolean isApplicable(CsmOffsetable csmOffsetable) {
        if (!this.isShowForwardFunctionDeclarations() && CsmKindUtilities.isFunctionDeclaration((CsmObject)csmOffsetable)) {
            CsmFunctionDefinition csmFunctionDefinition = ((CsmFunction)csmOffsetable).getDefinition();
            if (csmFunctionDefinition != null && !csmFunctionDefinition.equals(csmOffsetable) && !CsmKindUtilities.isMethod((CsmObject)csmFunctionDefinition)) {
                return !csmOffsetable.getContainingFile().equals(csmFunctionDefinition.getContainingFile());
            }
        } else {
            if (!this.isShowForwardClassDeclarations() && CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmOffsetable)) {
                return false;
            }
            if (!this.isShowTypedef() && CsmKindUtilities.isTypedef((CsmObject)csmOffsetable)) {
                return false;
            }
            if (!(this.isShowVariable() && this.isShowField() || !CsmKindUtilities.isVariable((CsmObject)csmOffsetable))) {
                if (CsmKindUtilities.isClassMember((CsmObject)csmOffsetable)) {
                    return this.isShowField();
                }
                return this.isShowVariable();
            }
            if (!this.isShowUsing() && (CsmKindUtilities.isUsing((CsmObject)csmOffsetable) || CsmKindUtilities.isNamespaceAlias((CsmObject)csmOffsetable))) {
                return false;
            }
        }
        return true;
    }

    public boolean isApplicableInclude() {
        return this.isShowInclude();
    }

    public boolean isApplicableMacro() {
        return this.isShowMacro();
    }

    public boolean isShowInclude() {
        return this.showInclude.isSelected();
    }

    public void setShowInclude(boolean bl) {
        this.showInclude.setSelected(bl);
    }

    public boolean isShowMacro() {
        return this.showMacro.isSelected();
    }

    public void setShowMacro(boolean bl) {
        this.showMacro.setSelected(bl);
    }

    public boolean isShowForwardFunctionDeclarations() {
        return this.showForwardFunctionDeclarations.isSelected();
    }

    public void setShowForwardFunctionDeclarations(boolean bl) {
        this.showForwardFunctionDeclarations.setSelected(bl);
    }

    public boolean isShowForwardClassDeclarations() {
        return this.showForwardClassDeclarations.isSelected();
    }

    public void setShowForwardClassDeclarations(boolean bl) {
        this.showForwardClassDeclarations.setSelected(bl);
    }

    public boolean isShowTypedef() {
        return this.showTypedef.isSelected();
    }

    public void setShowTypedef(boolean bl) {
        this.showTypedef.setSelected(bl);
    }

    public boolean isShowVariable() {
        return this.showVariable.isSelected();
    }

    public void setShowVariable(boolean bl) {
        this.showVariable.setSelected(bl);
    }

    public boolean isShowField() {
        return this.showField.isSelected();
    }

    public void setShowField(boolean bl) {
        this.showField.setSelected(bl);
    }

    public boolean isShowUsing() {
        return this.showUsing.isSelected();
    }

    public void setShowUsing(boolean bl) {
        this.showUsing.setSelected(bl);
    }

    public SortMode getSortMode() {
        return this.sortByName;
    }

    public void setSortMode(SortMode sortMode) {
        this.sortByName = sortMode;
        Preferences preferences = NbPreferences.forModule(CsmFileFilter.class);
        preferences.put("SortByName", sortMode.name());
    }

    public boolean isGroupByKind() {
        return this.groupByKind.isSelected();
    }

    public void setGroupByKind(boolean bl) {
        this.groupByKind.setSelected(bl);
    }

    public boolean isExpandAll() {
        return this.expandAll.isSelected();
    }

    public void setExpandAll(boolean bl) {
        this.expandAll.setSelected(bl);
    }

    private static final class BooleanFilter {
        private boolean value;
        private final String name;

        private BooleanFilter(String string, boolean bl) {
            this.name = string;
            this.value = this.getPreferences().getBoolean(string, bl);
        }

        public boolean isSelected() {
            return this.value;
        }

        public void setSelected(boolean bl) {
            this.value = bl;
            this.getPreferences().putBoolean(this.name, bl);
        }

        private Preferences getPreferences() {
            return NbPreferences.forModule(CsmFileFilter.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortMode {
        Name,
        Offset;

    }
}

