/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterInfo;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.BinaryClusterEntry;
import org.netbeans.modules.apisupport.project.universe.BinaryEntry;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;
import org.netbeans.modules.apisupport.project.universe.ExternalEntry;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.apisupport.project.universe.NetBeansOrgCachedEntry;
import org.netbeans.modules.apisupport.project.universe.NetBeansOrgEntry;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbCollections;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleList {
    private static final Logger LOG = Logger.getLogger(ModuleList.class.getName());
    static long timeSpentInXmlParsing;
    static int xmlFilesParsed;
    static int directoriesChecked;
    static int jarsOpened;
    private static final String[] FOREST;
    private static final Map<File, ModuleList> sourceLists;
    private static final Map<File, ModuleList> binaryLists;
    private static final Map<File, File[]> clusterLists;
    private static final Map<File, Map<String, String>> clusterPropertiesFiles;
    private static final Map<File, Map<String, String>> clusterLocations;
    private static final Map<File, Set<ModuleEntry>> knownEntries;
    private static final Map<File, File> netbeansOrgDestDirs;
    private static final String MSG_FAILURE = "Failed to load cached module list in ";
    private static final String MSG_IGNORED = "Ignoring nbbuild cache in ";
    public static final Set<String> EXCLUDED_DIR_NAMES;
    private static final Map<File, String[]> DIR_SCAN_CACHE;
    private static final String[] MODULE_DIRS;
    private static final String PROJECT_XML;
    private static boolean PERMIT_CACHES;
    private Map<String, ModuleEntry> entries;
    private final File home;
    private boolean lazyNetBeansOrgList;

    public static ModuleList getModuleList(File file) throws IOException {
        return ModuleList.getModuleList(file, null);
    }

    private static File getClusterPropertiesFile(File file) {
        return new File(file, "nbbuild" + File.separatorChar + "cluster.properties");
    }

    private static ModuleList runProtected(final Object object, final Mutex.ExceptionAction<ModuleList> exceptionAction) throws IOException {
        try {
            LOG.log(Level.FINE, "runProtected: sync 0");
            return (ModuleList)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<ModuleList>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public ModuleList run() throws Exception {
                    LOG.log(Level.FINE, "runProtected: sync 1");
                    Object object2 = object;
                    synchronized (object2) {
                        return (ModuleList)exceptionAction.run();
                    }
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static ModuleList getModuleList(final File file, final File file2) throws IOException {
        return ModuleList.runProtected(binaryLists, new Mutex.ExceptionAction<ModuleList>(){

            public ModuleList run() throws IOException {
                boolean bl;
                timeSpentInXmlParsing = 0L;
                xmlFilesParsed = 0;
                directoriesChecked = 0;
                jarsOpened = 0;
                Element element = ModuleList.parseData(file);
                if (element == null) {
                    throw new IOException("Not an NBM project in " + file);
                }
                boolean bl2 = Util.findElement(element, "suite-component", "http://www.netbeans.org/ns/nb-module-project/3") != null;
                boolean bl3 = bl = Util.findElement(element, "standalone", "http://www.netbeans.org/ns/nb-module-project/3") != null;
                assert (!bl2 || !bl) : file;
                if (bl2) {
                    PropertyEvaluator propertyEvaluator = ModuleList.parseProperties(file, null, NbModuleProvider.NbModuleType.SUITE_COMPONENT, "irrelevant");
                    String string = propertyEvaluator.getProperty("suite.dir");
                    if (string == null) {
                        throw new IOException("No suite.dir defined from " + file);
                    }
                    File file3 = PropertyUtils.resolveFile((File)file, (String)string);
                    return ModuleList.findOrCreateModuleListFromSuite(file3, file2);
                }
                if (bl) {
                    return ModuleList.findOrCreateModuleListFromStandaloneModule(file, file2);
                }
                File file4 = ModuleList.findNetBeansOrg(file);
                if (file4 == null) {
                    throw new IOException("Could not find netbeans.org source root from " + file + "; note that 3rd-level modules (a/b/c) are permitted at the maximum");
                }
                return ModuleList.findOrCreateModuleListFromNetBeansOrgSources(file4);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existKnownEntries() {
        Map<File, Set<ModuleEntry>> map = knownEntries;
        synchronized (map) {
            return !knownEntries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ModuleEntry> getKnownEntries(File file) {
        Map<File, Set<ModuleEntry>> map = knownEntries;
        synchronized (map) {
            Set<ModuleEntry> set = knownEntries.get(file);
            if (set != null) {
                return Collections.unmodifiableSet(set);
            }
            return Collections.emptySet();
        }
    }

    public static URL[] getSourceRootsForExternalModule(File file) {
        Set<ModuleEntry> set = ModuleList.getKnownEntries(file);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (ModuleEntry moduleEntry : set) {
            if (!(moduleEntry instanceof BinaryClusterEntry)) continue;
            BinaryClusterEntry binaryClusterEntry = (BinaryClusterEntry)moduleEntry;
            arrayList.addAll(Arrays.asList(binaryClusterEntry.getSourceRoots()));
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public static URL[] getJavadocRootsForExternalModule(File file) {
        Set<ModuleEntry> set = ModuleList.getKnownEntries(file);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (ModuleEntry moduleEntry : set) {
            if (!(moduleEntry instanceof BinaryClusterEntry)) continue;
            BinaryClusterEntry binaryClusterEntry = (BinaryClusterEntry)moduleEntry;
            arrayList.addAll(Arrays.asList(binaryClusterEntry.getJavadocRoots()));
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerEntry(ModuleEntry moduleEntry, Set<File> set) {
        Map<File, Set<ModuleEntry>> map = knownEntries;
        synchronized (map) {
            for (File file : set) {
                Set<ModuleEntry> set2 = knownEntries.get(file);
                if (set2 == null) {
                    set2 = new HashSet<ModuleEntry>();
                    knownEntries.put(file, set2);
                }
                set2.add(moduleEntry);
            }
        }
    }

    static ModuleList findOrCreateModuleListFromNetBeansOrgSources(final File file) throws IOException {
        return ModuleList.runProtected(sourceLists, new Mutex.ExceptionAction<ModuleList>(){

            public ModuleList run() throws IOException {
                ModuleList moduleList = (ModuleList)sourceLists.get(file);
                if (moduleList == null) {
                    File file2 = ModuleList.findNetBeansOrgDestDir(file);
                    if (file2.equals(new File(new File(file, "nbbuild"), "netbeans"))) {
                        moduleList = ModuleList.createModuleListFromNetBeansOrgSources(file, file2);
                    } else {
                        HashMap hashMap = new HashMap();
                        ModuleList.doScanNetBeansOrgSources(hashMap, file, 1, file, file2, null);
                        ModuleList moduleList2 = new ModuleList(hashMap, file, false);
                        ModuleList moduleList3 = ModuleList.findOrCreateModuleListFromBinaries(file2);
                        moduleList = ModuleList.merge(new ModuleList[]{moduleList2, moduleList3}, file);
                    }
                    sourceLists.put(file, moduleList);
                }
                return moduleList;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File findNetBeansOrgDestDir(File file) {
        Map<File, File> map = netbeansOrgDestDirs;
        synchronized (map) {
            File file2 = netbeansOrgDestDirs.get(file);
            if (file2 == null) {
                File file3 = new File(file, "nbbuild");
                file2 = ModuleList.checkForNetBeansOrgDestDir(new File(file3, "user.build.properties"));
                if (file2 == null && (file2 = ModuleList.checkForNetBeansOrgDestDir(new File(file3, "site.build.properties"))) == null && (file2 = ModuleList.checkForNetBeansOrgDestDir(new File(System.getProperty("user.home"), ".nbbuild.properties"))) == null) {
                    file2 = new File(file3, "netbeans");
                }
                netbeansOrgDestDirs.put(file, file2);
            }
            return file2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File checkForNetBeansOrgDestDir(File file) {
        if (!file.isFile()) return null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                Properties properties = new Properties();
                properties.load(fileInputStream);
                String string = properties.getProperty("netbeans.dest.dir");
                if (string == null) return null;
                File file2 = new File(string);
                return file2;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Could not read " + file, iOException);
        }
        return null;
    }

    private static ModuleList createModuleListFromNetBeansOrgSources(File file, File file2) throws IOException {
        LOG.log(Level.INFO, "ModuleList.createModuleListFromSources: " + file);
        ModuleList moduleList = ModuleList.loadNetBeansOrgCachedModuleList(file, file2);
        if (moduleList != null) {
            return moduleList;
        }
        HashMap<String, ModuleEntry> hashMap = new HashMap<String, ModuleEntry>();
        ModuleList.scanNetBeansOrgStableSources(hashMap, file, file2);
        return new ModuleList(hashMap, file, true);
    }

    private static void logCacheIgnored(String string, File file, File file2) {
        LOG.log(Level.INFO, string + file + "; falling back to scan due to file: " + file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ModuleList loadNetBeansOrgCachedModuleList(File file, File file2) {
        try {
            if (!PERMIT_CACHES) {
                ModuleList.logCacheIgnored("Due to previous call of refresh(), not using nbbuild cache in ", file, null);
                return null;
            }
            File file3 = new File(file, "nbbuild" + File.separatorChar + "nbproject" + File.separatorChar + "private" + File.separatorChar + "scan-cache-full.ser");
            if (!file3.isFile()) {
                ModuleList.logCacheIgnored(MSG_FAILURE, file, file3);
                return null;
            }
            File file4 = new File(file, "nbbuild" + File.separatorChar + "nbantext.jar");
            if (!file4.isFile()) {
                ModuleList.logCacheIgnored(MSG_FAILURE, file, file4);
                return null;
            }
            final URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file4.toURI().toURL()}, ClassLoader.getSystemClassLoader());
            FileInputStream fileInputStream = new FileInputStream(file3);
            try {
                Serializable serializable;
                Map.Entry entry2;
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                        return Class.forName(objectStreamClass.getName(), true, uRLClassLoader);
                    }
                };
                for (Map.Entry entry2 : NbCollections.checkedMapByFilter((Map)((Map)objectInputStream.readObject()), File.class, Long[].class, (boolean)true).entrySet()) {
                    serializable = (File)entry2.getKey();
                    if (((File)serializable).lastModified() == ((Long[])entry2.getValue())[0].longValue() && ((File)serializable).length() == ((Long[])entry2.getValue())[1].longValue()) continue;
                    ModuleList.logCacheIgnored(MSG_IGNORED, file, (File)serializable);
                    ModuleList moduleList = null;
                    return moduleList;
                }
                Map map = (Map)objectInputStream.readObject();
                entry2 = uRLClassLoader.loadClass("org.netbeans.nbbuild.ModuleListParser$Entry");
                serializable = new HashMap();
                for (Field field : ((Class)((Object)entry2)).getDeclaredFields()) {
                    field.setAccessible(true);
                    serializable.put(field.getName(), field);
                }
                HashMap hashMap = new HashMap();
                for (Object v : map.values()) {
                    String string = (String)((Field)serializable.get("cnb")).get(v);
                    File file5 = (File)((Field)serializable.get("jar")).get(v);
                    File[] fileArray = (File[])((Field)serializable.get("classPathExtensions")).get(v);
                    File file6 = (File)((Field)serializable.get("sourceLocation")).get(v);
                    String string2 = (String)((Field)serializable.get("netbeansOrgPath")).get(v);
                    String[] stringArray = (String[])((Field)serializable.get("buildPrerequisites")).get(v);
                    String string3 = (String)((Field)serializable.get("clusterName")).get(v);
                    String[] stringArray2 = (String[])((Field)serializable.get("runtimeDependencies")).get(v);
                    Map map2 = NbCollections.checkedMapByFilter((Map)((Map)((Field)serializable.get("testDependencies")).get(v)), String.class, String[].class, (boolean)false);
                    NetBeansOrgCachedEntry netBeansOrgCachedEntry = new NetBeansOrgCachedEntry(file, file2, string, file5, fileArray, file6, string2, stringArray, string3, stringArray2, (String[])map2.get("unit"));
                    hashMap.put(string, netBeansOrgCachedEntry);
                    ModuleList.registerEntry(netBeansOrgCachedEntry, Collections.singleton(file5));
                }
                LOG.log(Level.FINE, "Successfully loaded " + file3 + " with " + hashMap.size() + " entries");
                ModuleList moduleList = new ModuleList(hashMap, file, false);
                return moduleList;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (Exception exception) {
            ModuleList.logCacheIgnored(MSG_FAILURE, file, null);
            LOG.log(Level.FINE, "Caught exception: ", exception);
            return null;
        }
    }

    private static void scanNetBeansOrgStableSources(Map<String, ModuleEntry> map, File file, File file2) throws IOException {
        Object object;
        LOG.log(Level.FINER, "scanning NetBeans.org stable sources started");
        Map<String, String> map2 = ModuleList.getClusterProperties(file);
        String string = map2.get("clusters.list");
        if (string == null && (object = map2.get("cluster.config")) != null) {
            string = map2.get("clusters.config." + (String)object + ".list");
        }
        if (string == null) {
            throw new IOException("Neither ${clusters.list} nor ${cluster.config} + ${clusters.config.<cfg>.list} found in " + ModuleList.getClusterPropertiesFile(file));
        }
        object = new StringTokenizer(string, ", ");
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string2 = ((StringTokenizer)object).nextToken();
            String string3 = map2.get(string2);
            if (string3 == null) {
                throw new IOException("No ${" + string2 + "} found in " + file);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ", ");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                ModuleList.scanPossibleProject(new File(file, string4.replace('/', File.separatorChar)), map, NbModuleProvider.NbModuleType.NETBEANS_ORG, file, file2, string4);
            }
        }
        LOG.log(Level.FINER, "scanning NetBeans.org stable sources finished");
    }

    private static void doScanNetBeansOrgSources(Map<String, ModuleEntry> map, File file, int n, File file2, File file3, String string) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file4 : fileArray) {
            String string2;
            if (!file4.isDirectory() || EXCLUDED_DIR_NAMES.contains(string2 = file4.getName())) continue;
            String string3 = string != null ? string + "/" + string2 : string2;
            try {
                ModuleList.scanPossibleProject(file4, map, NbModuleProvider.NbModuleType.NETBEANS_ORG, file2, file3, string3);
            }
            catch (IOException iOException) {
                Util.err.annotate((Throwable)iOException, 0, "Malformed project metadata in " + file4 + ", skipping...", null, null, null);
                Util.err.notify(1, (Throwable)iOException);
            }
            if (n <= 1) continue;
            ModuleList.doScanNetBeansOrgSources(map, file4, n - 1, file2, file3, string3);
        }
    }

    static void scanPossibleProject(File file, Map<String, ModuleEntry> map, NbModuleProvider.NbModuleType nbModuleType, File file2, File file3, String string) throws IOException {
        Object object;
        ManifestManager.PackageExport[] packageExportArray;
        Object object2;
        Object object3;
        ++directoriesChecked;
        Element element = ModuleList.parseData(file);
        if (element == null) {
            return;
        }
        assert (file2 != null ^ nbModuleType != NbModuleProvider.NbModuleType.NETBEANS_ORG);
        assert (string != null ^ nbModuleType != NbModuleProvider.NbModuleType.NETBEANS_ORG);
        String string2 = Util.findText(Util.findElement(element, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/3"));
        PropertyEvaluator propertyEvaluator = ModuleList.parseProperties(file, file2, nbModuleType, string2);
        String string3 = propertyEvaluator.getProperty("module.jar");
        StringBuffer stringBuffer = new StringBuffer();
        for (Element object42 : Util.findSubElements(element)) {
            if (!object42.getLocalName().equals("class-path-extension")) continue;
            object3 = Util.findElement(object42, "binary-origin", "http://www.netbeans.org/ns/nb-module-project/3");
            if (object3 != null) {
                object2 = Util.findText((Element)object3);
            } else {
                packageExportArray = Util.findElement(object42, "runtime-relative-path", "http://www.netbeans.org/ns/nb-module-project/3");
                assert (packageExportArray != null) : "Malformed <class-path-extension> in " + file;
                object = Util.findText((Element)packageExportArray);
                object2 = "${cluster}/${module.jar.dir}/" + (String)object;
            }
            packageExportArray = propertyEvaluator.evaluate((String)object2);
            if (packageExportArray == null) continue;
            object = PropertyUtils.resolveFile((File)file, (String)packageExportArray);
            stringBuffer.append(File.pathSeparatorChar);
            stringBuffer.append(((File)object).getAbsolutePath());
        }
        File file4 = new File(file, "manifest.mf");
        ManifestManager manifestManager = file4.isFile() ? ManifestManager.getInstance(file4, false) : ManifestManager.NULL_INSTANCE;
        object3 = PropertyUtils.resolveFile((File)file, (String)propertyEvaluator.getProperty("cluster"));
        packageExportArray = ProjectXMLManager.findPublicPackages(element);
        object = ProjectXMLManager.findFriends(element);
        String string4 = propertyEvaluator.getProperty("src.dir");
        if (string4 == null) {
            string4 = "src";
        }
        object2 = nbModuleType == NbModuleProvider.NbModuleType.NETBEANS_ORG ? new NetBeansOrgEntry(file2, string2, string, (File)object3, string3, stringBuffer.toString(), manifestManager.getReleaseVersion(), manifestManager.getProvidedTokens(), packageExportArray, (String[])object, manifestManager.isDeprecated(), string4) : new ExternalEntry(file, string2, (File)object3, PropertyUtils.resolveFile((File)object3, (String)string3), stringBuffer.toString(), file3, manifestManager.getReleaseVersion(), manifestManager.getProvidedTokens(), packageExportArray, (String[])object, manifestManager.isDeprecated(), string4);
        if (map.containsKey(string2)) {
            LOG.log(Level.WARNING, "Warning: two modules found with the same code name base (" + string2 + "): " + map.get(string2) + " and " + object2);
        } else {
            map.put(string2, (ModuleEntry)object2);
        }
        ModuleList.registerEntry((ModuleEntry)object2, ModuleList.findSourceNBMFiles((ModuleEntry)object2, propertyEvaluator));
        LOG.log(Level.FINER, "scanPossibleProject: " + file + " scanned successfully");
    }

    private static Set<File> findSourceNBMFiles(ModuleEntry moduleEntry, PropertyEvaluator propertyEvaluator) throws IOException {
        HashSet<File> hashSet = new HashSet<File>();
        hashSet.add(moduleEntry.getJarLocation());
        File file = moduleEntry.getClusterDirectory();
        String string = moduleEntry.getCodeNameBase().replace('.', '-');
        String[] stringArray = new String[]{"update_tracking/*.xml", "config/Modules/*.xml", "config/ModuleAutoDeps/*.xml", "ant/nblib/*.jar", "modules/docs/*.jar"};
        for (String string2 : stringArray) {
            int n = string2.indexOf(42);
            ModuleList.findSourceNBMFilesMaybeAdd(hashSet, file, string2.substring(0, n) + string + string2.substring(n + 1));
        }
        String string3 = propertyEvaluator.getProperty("extra.module.files");
        if (string3 != null) {
            for (String string4 : string3.split(" *, *")) {
                if (string4.endsWith("/")) {
                    string4 = string4 + "**";
                }
                if (string4.indexOf(42) == -1) {
                    ModuleList.findSourceNBMFilesMaybeAdd(hashSet, file, string4);
                    continue;
                }
                String string5 = "\\Q" + string4.replaceAll("\\*\\*", "__DBLASTERISK__").replaceAll("\\*", "\\\\E[^/]*\\\\Q").replaceAll("__DBLASTERISK__", "\\\\E.*\\\\Q") + "\\E";
                Pattern object = Pattern.compile(string5);
                for (String string2 : ModuleList.scanDirForFiles(file)) {
                    if (!object.matcher(string2).matches()) continue;
                    ModuleList.findSourceNBMFilesMaybeAdd(hashSet, file, string2);
                }
            }
        }
        File file2 = moduleEntry.getSourceLocation();
        assert (file2 != null && file2.isDirectory()) : moduleEntry;
        File file3 = new File(file2, "release");
        if (file3.isDirectory()) {
            for (String string4 : ModuleList.scanDirForFiles(file3)) {
                ModuleList.findSourceNBMFilesMaybeAdd(hashSet, file, string4);
            }
        }
        return hashSet;
    }

    private static void findSourceNBMFilesMaybeAdd(Set<File> set, File file, String string) {
        File file2 = new File(file, string.replace('/', File.separatorChar));
        set.add(file2);
    }

    private static String[] scanDirForFiles(File file) {
        String[] stringArray = DIR_SCAN_CACHE.get(file);
        if (stringArray == null) {
            ArrayList<String> arrayList = new ArrayList<String>(250);
            ModuleList.doScanDirForFiles(file, arrayList, "");
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        return stringArray;
    }

    private static void doScanDirForFiles(File file, List<String> list, String string) {
        ++directoriesChecked;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isFile()) {
                    list.add(string + file2.getName());
                    continue;
                }
                if (!file2.isDirectory()) continue;
                ModuleList.doScanDirForFiles(file2, list, string + file2.getName() + '/');
            }
        }
    }

    public static ModuleList findOrCreateModuleListFromSuite(File file, File file2) throws IOException {
        PropertyEvaluator propertyEvaluator = ModuleList.parseSuiteProperties(file);
        File file3 = ModuleList.resolveNbDestDir(file, file2, propertyEvaluator);
        Set<ClusterInfo> set = ClusterUtils.evaluateClusterPath(file, propertyEvaluator, file3);
        LOG.log(Level.FINE, "Scanning suite in " + file + ", cluster.path is: " + set);
        if (!set.isEmpty()) {
            ArrayList<ModuleList> arrayList = new ArrayList<ModuleList>();
            arrayList.add(ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(file, file3, propertyEvaluator));
            arrayList.addAll(ModuleList.findOrCreateModuleListsFromClusterPath(set, file3));
            return ModuleList.merge(arrayList.toArray(new ModuleList[arrayList.size()]), file);
        }
        return ModuleList.merge(new ModuleList[]{ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(file, file3, propertyEvaluator), ModuleList.findOrCreateModuleListFromBinaries(file3)}, file);
    }

    private static List<ModuleList> findOrCreateModuleListsFromClusterPath(Set<ClusterInfo> set, File file) throws IOException {
        ArrayList<ModuleList> arrayList = new ArrayList<ModuleList>();
        for (ClusterInfo clusterInfo : set) {
            File file2;
            Project project = clusterInfo.getProject();
            if (project != null) {
                file2 = FileUtil.toFile((FileObject)project.getProjectDirectory());
                if (SuiteUtils.isSuite(file2)) {
                    arrayList.add(ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(file2, file));
                    continue;
                }
                arrayList.add(ModuleList.findOrCreateModuleListFromStandaloneModule(file2, file));
                continue;
            }
            file2 = clusterInfo.getClusterDir();
            ModuleList moduleList = ModuleList.findOrCreateModuleListFromCluster(file2, clusterInfo.isPlatformCluster() ? file2.getParentFile() : null, clusterInfo);
            arrayList.add(moduleList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleList findOrCreateModuleListFromSuiteWithoutBinaries(File file, File file2, PropertyEvaluator propertyEvaluator) throws IOException {
        Map<File, ModuleList> map = sourceLists;
        synchronized (map) {
            ModuleList moduleList = sourceLists.get(file);
            if (moduleList == null) {
                HashMap<String, ModuleEntry> hashMap = new HashMap<String, ModuleEntry>();
                for (File file3 : ModuleList.findModulesInSuite(file, propertyEvaluator)) {
                    try {
                        ModuleList.scanPossibleProject(file3, hashMap, NbModuleProvider.NbModuleType.SUITE_COMPONENT, null, file2, null);
                    }
                    catch (IOException iOException) {
                        Util.err.annotate((Throwable)iOException, 0, "Malformed project metadata in " + file3 + ", skipping...", null, null, null);
                        Util.err.notify(1, (Throwable)iOException);
                    }
                }
                moduleList = new ModuleList(hashMap, file, false);
                sourceLists.put(file, moduleList);
            }
            return moduleList;
        }
    }

    private static File resolveNbDestDir(File file, File file2, PropertyEvaluator propertyEvaluator) throws IOException {
        File file3;
        Object object;
        if (file2 == null) {
            object = propertyEvaluator.getProperty("netbeans.dest.dir");
            if (object == null) {
                throw new IOException("No netbeans.dest.dir defined in " + file);
            }
            file3 = PropertyUtils.resolveFile((File)file, (String)object);
        } else {
            file3 = file2;
        }
        if (!file3.exists()) {
            LOG.log(Level.INFO, "Project in " + file + " is missing its platform '" + propertyEvaluator.getProperty("nbplatform.active") + "', switching to default platform");
            object = NbPlatform.getDefaultPlatform();
            if (object != null) {
                file3 = ((NbPlatform)object).getDestDir();
            }
        }
        return file3;
    }

    private static ModuleList findOrCreateModuleListFromSuiteWithoutBinaries(File file, File file2) throws IOException {
        PropertyEvaluator propertyEvaluator = ModuleList.parseSuiteProperties(file);
        File file3 = ModuleList.resolveNbDestDir(file, file2, propertyEvaluator);
        return ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(file, file3, propertyEvaluator);
    }

    static ModuleList findOrCreateModuleListFromSuiteWithoutBinaries(File file) throws IOException {
        return ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyEvaluator parseSuiteProperties(File file) throws IOException {
        Map map;
        Properties properties;
        Properties properties2 = properties = System.getProperties();
        synchronized (properties2) {
            map = NbCollections.checkedMapByCopy((Map)properties, String.class, String.class, (boolean)false);
        }
        map.put("basedir", file.getAbsolutePath());
        properties2 = PropertyUtils.fixedPropertyProvider((Map)map);
        ArrayList<PropertyProvider> arrayList = new ArrayList<PropertyProvider>();
        arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
        arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "platform.properties")));
        PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)properties2, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
        String string = propertyEvaluator.getProperty("user.properties.file");
        if (string != null) {
            arrayList.add(ModuleList.loadPropertiesFile(PropertyUtils.resolveFile((File)file, (String)string)));
        } else {
            arrayList.add(PropertyUtils.globalPropertyProvider());
        }
        arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "private" + File.separatorChar + "private.properties")));
        arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "project.properties")));
        propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)properties2, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
        String string2 = propertyEvaluator.getProperty("nbplatform.active");
        if (string2 != null) {
            arrayList.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap("netbeans.dest.dir", "${nbplatform." + string2 + ".netbeans.dest.dir}")));
        }
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)properties2, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
    }

    static File[] findModulesInSuite(File file) throws IOException {
        return ModuleList.findModulesInSuite(file, ModuleList.parseSuiteProperties(file));
    }

    private static File[] findModulesInSuite(File file, PropertyEvaluator propertyEvaluator) throws IOException {
        String string = propertyEvaluator.getProperty("modules");
        if (string == null) {
            string = "";
        }
        String[] stringArray = PropertyUtils.tokenizePath((String)string);
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fileArray[i] = PropertyUtils.resolveFile((File)file, (String)stringArray[i]);
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleList findOrCreateModuleListFromStandaloneModule(File file, File file2) throws IOException {
        PropertyEvaluator propertyEvaluator = ModuleList.parseProperties(file, null, NbModuleProvider.NbModuleType.STANDALONE, "irrelevant");
        File file3 = ModuleList.resolveNbDestDir(file, file2, propertyEvaluator);
        Map<File, ModuleList> map = sourceLists;
        synchronized (map) {
            ModuleList moduleList = ModuleList.findOrCreateModuleListFromBinaries(file3);
            ModuleList moduleList2 = sourceLists.get(file);
            if (moduleList2 == null) {
                HashMap<String, ModuleEntry> hashMap = new HashMap<String, ModuleEntry>();
                ModuleList.scanPossibleProject(file, hashMap, NbModuleProvider.NbModuleType.STANDALONE, null, file3, null);
                if (hashMap.isEmpty()) {
                    throw new IOException("No module in " + file);
                }
                moduleList2 = new ModuleList(hashMap, file, false);
                sourceLists.put(file, moduleList2);
            }
            return ModuleList.merge(new ModuleList[]{moduleList2, moduleList}, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModuleList findOrCreateModuleListFromBinaries(File file) throws IOException {
        ModuleList[] moduleListArray = clusterLists;
        synchronized (clusterLists) {
            File[] fileArray = clusterLists.get(file);
            if (fileArray == null) {
                fileArray = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory();
                    }
                });
                if (fileArray == null) {
                    throw new IOException("Cannot examine dir " + file);
                }
                clusterLists.put(file, fileArray);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            moduleListArray = new ModuleList[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                moduleListArray[i] = ModuleList.findOrCreateModuleListFromCluster(fileArray[i], file, null);
            }
            return ModuleList.merge(moduleListArray, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleList findOrCreateModuleListFromCluster(File file, File file2, ClusterInfo clusterInfo) throws IOException {
        Map<File, ModuleList> map = binaryLists;
        synchronized (map) {
            ModuleList moduleList = binaryLists.get(file);
            if (moduleList == null) {
                moduleList = ModuleList.scanCluster(file, file2, true, clusterInfo);
                binaryLists.put(file, moduleList);
            }
            return moduleList;
        }
    }

    public static ModuleList scanCluster(File file, File file2, boolean bl, ClusterInfo clusterInfo) throws IOException {
        HashMap<String, ModuleEntry> hashMap = new HashMap<String, ModuleEntry>();
        for (String string : MODULE_DIRS) {
            File file3 = new File(file, string.replace('/', File.separatorChar));
            if (!file3.isDirectory()) continue;
            File[] fileArray = file3.listFiles();
            if (fileArray == null) {
                throw new IOException("Cannot examine dir " + file3);
            }
            for (File file4 : fileArray) {
                Object object;
                File[] fileArray2;
                if (!file4.getName().endsWith(".jar")) continue;
                ++jarsOpened;
                ManifestManager manifestManager = ManifestManager.getInstanceFromJAR(file4);
                String string2 = manifestManager.getCodeNameBase();
                if (string2 == null) continue;
                String string3 = manifestManager.getClassPath();
                if (string3 == null) {
                    fileArray2 = new File[]{};
                } else {
                    object = string3.trim().split(" +");
                    fileArray2 = new File[((String[])object).length];
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        fileArray2[i] = new File(file3, object[i].replace('/', File.separatorChar));
                    }
                }
                Object object2 = object = clusterInfo == null || clusterInfo.isPlatformCluster() ? new BinaryEntry(string2, file4, fileArray2, file2, file, manifestManager.getReleaseVersion(), manifestManager.getSpecificationVersion(), manifestManager.getProvidedTokens(), manifestManager.getPublicPackages(), manifestManager.getFriends(), manifestManager.isDeprecated(), manifestManager.getModuleDependencies()) : new BinaryClusterEntry(string2, file4, fileArray2, file, manifestManager.getReleaseVersion(), manifestManager.getSpecificationVersion(), manifestManager.getProvidedTokens(), manifestManager.getPublicPackages(), manifestManager.getFriends(), manifestManager.isDeprecated(), manifestManager.getModuleDependencies(), clusterInfo.getSourceRoots(), clusterInfo.getJavadocRoots());
                if (hashMap.containsKey(string2)) {
                    LOG.log(Level.WARNING, "Warning: two modules found with the same code name base (" + string2 + "): " + hashMap.get(string2) + " and " + object);
                } else {
                    hashMap.put(string2, (ModuleEntry)object);
                }
                if (!bl) continue;
                ModuleList.registerEntry((ModuleEntry)object, ModuleList.findBinaryNBMFiles(file, string2, file4));
            }
        }
        LOG.log(Level.FINER, "scanCluster: " + file + " succeeded.");
        return new ModuleList(hashMap, file2, false);
    }

    private static Set<File> findBinaryNBMFiles(File file, String string, File file2) throws IOException {
        HashSet<File> hashSet = new HashSet<File>();
        hashSet.add(file2);
        File file3 = new File(new File(file, "update_tracking"), string.replace('.', '-') + ".xml");
        if (file3.isFile()) {
            Document document;
            hashSet.add(file3);
            try {
                ++xmlFilesParsed;
                timeSpentInXmlParsing -= System.currentTimeMillis();
                document = XMLUtil.parse((InputSource)new InputSource(file3.toURI().toString()), (boolean)false, (boolean)false, null, null);
                timeSpentInXmlParsing += System.currentTimeMillis();
            }
            catch (SAXException sAXException) {
                throw (IOException)new IOException(sAXException.toString()).initCause(sAXException);
            }
            for (Element element : Util.findSubElements(document.getDocumentElement())) {
                if (!element.getTagName().equals("module_version") || !element.getAttribute("last").equals("true")) continue;
                for (Element element2 : Util.findSubElements(element)) {
                    String string2;
                    File file4;
                    if (!element2.getTagName().equals("file") || !(file4 = new File(file, (string2 = element2.getAttribute("name")).replace('/', File.separatorChar))).isFile()) continue;
                    hashSet.add(file4);
                }
            }
        }
        return hashSet;
    }

    static Element parseData(File file) throws IOException {
        Document document;
        File file2 = new File(file, PROJECT_XML);
        if (!file2.exists() || !file2.isFile()) {
            return null;
        }
        try {
            ++xmlFilesParsed;
            timeSpentInXmlParsing -= System.currentTimeMillis();
            document = XMLUtil.parse((InputSource)new InputSource(file2.toURI().toString()), (boolean)false, (boolean)true, null, null);
            timeSpentInXmlParsing += System.currentTimeMillis();
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException(file2 + ": " + sAXException.toString()).initCause(sAXException);
        }
        Element element = document.getDocumentElement();
        Element element2 = Util.findElement(element, "type", "http://www.netbeans.org/ns/project/1");
        if (!Util.findText(element2).equals("org.netbeans.modules.apisupport.project")) {
            return null;
        }
        Element element3 = Util.findElement(element, "configuration", "http://www.netbeans.org/ns/project/1");
        Element element4 = Util.findElement(element3, "data", "http://www.netbeans.org/ns/nb-module-project/3");
        if (element4 != null) {
            return element4;
        }
        element4 = Util.findElement(element3, "data", "http://www.netbeans.org/ns/nb-module-project/2");
        if (element4 != null) {
            return Util.translateXML(element4, "http://www.netbeans.org/ns/nb-module-project/3");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PropertyEvaluator parseProperties(File file, File file2, NbModuleProvider.NbModuleType nbModuleType, String string) throws IOException {
        Object object;
        String string2;
        Object object2;
        Map map;
        Properties properties;
        Properties properties2 = properties = System.getProperties();
        synchronized (properties2) {
            map = NbCollections.checkedMapByCopy((Map)properties, String.class, String.class, (boolean)false);
        }
        map.put("basedir", file.getAbsolutePath());
        properties2 = PropertyUtils.fixedPropertyProvider((Map)map);
        ArrayList<PropertyProvider> arrayList = new ArrayList<PropertyProvider>();
        if (nbModuleType == NbModuleProvider.NbModuleType.SUITE_COMPONENT) {
            arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "private" + File.separatorChar + "suite-private.properties")));
            arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "suite.properties")));
            object2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)properties2, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
            string2 = object2.getProperty("suite.dir");
            if (string2 != null) {
                object = PropertyUtils.resolveFile((File)file, (String)string2);
                arrayList.add(ModuleList.loadPropertiesFile(new File((File)object, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
                arrayList.add(ModuleList.loadPropertiesFile(new File((File)object, "nbproject" + File.separatorChar + "platform.properties")));
            }
        } else if (nbModuleType == NbModuleProvider.NbModuleType.STANDALONE) {
            arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
            arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "platform.properties")));
        }
        if (nbModuleType != NbModuleProvider.NbModuleType.NETBEANS_ORG) {
            object2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)properties2, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
            string2 = object2.getProperty("user.properties.file");
            if (string2 != null) {
                arrayList.add(ModuleList.loadPropertiesFile(PropertyUtils.resolveFile((File)file, (String)string2)));
            } else {
                arrayList.add(PropertyUtils.globalPropertyProvider());
            }
            object2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)properties2, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
            object = object2.getProperty("nbplatform.active");
            if (object != null) {
                arrayList.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap("netbeans.dest.dir", "${nbplatform." + (String)object + ".netbeans.dest.dir}")));
            }
        }
        arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "private" + File.separatorChar + "private.properties")));
        arrayList.add(ModuleList.loadPropertiesFile(new File(file, "nbproject" + File.separatorChar + "project.properties")));
        object2 = new HashMap();
        if (nbModuleType == NbModuleProvider.NbModuleType.NETBEANS_ORG) {
            object2.put("nb_all", file2.getAbsolutePath());
            object2.put("netbeans.dest.dir", ModuleList.findNetBeansOrgDestDir(file2).getAbsolutePath());
        }
        object2.put("code.name.base.dashes", string.replace('.', '-'));
        object2.put("module.jar.dir", "modules");
        object2.put("module.jar.basename", "${code.name.base.dashes}.jar");
        object2.put("module.jar", "${module.jar.dir}/${module.jar.basename}");
        arrayList.add(PropertyUtils.fixedPropertyProvider((Map)object2));
        object2.put("cluster", ModuleList.findClusterLocation(file, file2, nbModuleType));
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)properties2, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyProvider loadPropertiesFile(File file) throws IOException {
        if (!file.isFile()) {
            return PropertyUtils.fixedPropertyProvider(Collections.emptyMap());
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            properties.load(fileInputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return PropertyUtils.fixedPropertyProvider((Map)NbCollections.checkedMapByFilter((Map)properties, String.class, String.class, (boolean)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        Map<File, Object> map = sourceLists;
        synchronized (map) {
            sourceLists.clear();
        }
        map = binaryLists;
        synchronized (map) {
            binaryLists.clear();
        }
        map = clusterLists;
        synchronized (map) {
            clusterLists.clear();
        }
        map = knownEntries;
        synchronized (map) {
            knownEntries.clear();
        }
        PERMIT_CACHES = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshModuleListForRoot(File file) {
        Map<File, ModuleList> map = sourceLists;
        synchronized (map) {
            sourceLists.remove(file);
        }
    }

    public static void refreshClusterModuleList(File file) {
    }

    public static boolean isNetBeansOrg(File file) {
        return new File(file, "nbbuild").isDirectory();
    }

    public static File findNetBeansOrg(File file) {
        File file2 = file;
        File file3 = file2.getParentFile();
        if (file3 != null) {
            for (String string : FOREST) {
                File file4;
                if (string == null) {
                    file4 = file3;
                } else {
                    if (!file3.getName().equals(string)) continue;
                    file4 = file3.getParentFile();
                }
                if (!new File(file4, "nbbuild").isDirectory()) continue;
                return file4;
            }
        }
        for (int i = 0; i < 3; ++i) {
            if ((file2 = file2.getParentFile()) == null) {
                return null;
            }
            if (!new File(file2, "nbbuild").isDirectory() || !new File(file2, "core").isDirectory()) continue;
            return file2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getClusterProperties(File file) throws IOException {
        Map map = null;
        Map<File, Map<String, String>> map2 = clusterPropertiesFiles;
        synchronized (map2) {
            map = clusterPropertiesFiles.get(file);
            if (map == null) {
                PropertyProvider propertyProvider = ModuleList.loadPropertiesFile(ModuleList.getClusterPropertiesFile(file));
                PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)PropertyUtils.fixedPropertyProvider(Collections.emptyMap()), (PropertyProvider[])new PropertyProvider[]{propertyProvider});
                map = propertyEvaluator.getProperties();
                if (map == null) {
                    map = Collections.emptyMap();
                }
                clusterPropertiesFiles.put(file, map);
            }
        }
        return map;
    }

    public static String findClusterLocation(File file, File file2, NbModuleProvider.NbModuleType nbModuleType) throws IOException {
        String string;
        switch (nbModuleType) {
            case SUITE_COMPONENT: {
                string = "${suite.dir}/build/cluster";
                break;
            }
            case STANDALONE: {
                string = PropertyUtils.resolveFile((File)file, (String)"build/cluster").getAbsolutePath();
                break;
            }
            default: {
                String string2 = PropertyUtils.relativizeFile((File)file2, (File)file);
                Map<String, String> map = clusterLocations.get(file2);
                if (map == null) {
                    map = new HashMap<String, String>();
                    Map<String, String> map2 = ModuleList.getClusterProperties(file2);
                    for (Map.Entry<String, String> entry : map2.entrySet()) {
                        String string3 = entry.getKey();
                        String string4 = map2.get(string3 + ".dir");
                        if (string4 == null) continue;
                        String string5 = entry.getValue();
                        StringTokenizer stringTokenizer = new StringTokenizer(string5, ", ");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string6 = stringTokenizer.nextToken();
                            map.put(string6, string4);
                        }
                    }
                    clusterLocations.put(file2, map);
                }
                if ((string = map.get(string2)) == null) {
                    string = "extra";
                }
                string = "${netbeans.dest.dir}/" + string;
            }
        }
        return string;
    }

    private ModuleList(Map<String, ModuleEntry> map, File file, boolean bl) {
        this.entries = map;
        this.home = file;
        this.lazyNetBeansOrgList = bl;
    }

    public String toString() {
        return "ModuleList[" + this.home + "]" + (this.lazyNetBeansOrgList ? "[lazy]" : "") + this.entries.values();
    }

    private static ModuleList merge(ModuleList[] moduleListArray, File file) {
        HashMap<String, ModuleEntry> hashMap = new HashMap<String, ModuleEntry>();
        for (ModuleList moduleList : moduleListArray) {
            moduleList.maybeRescanNetBeansOrgSources();
            for (Map.Entry<String, ModuleEntry> entry : moduleList.entries.entrySet()) {
                String string = entry.getKey();
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, entry.getValue());
            }
        }
        return new ModuleList(hashMap, file, false);
    }

    private void maybeRescanNetBeansOrgSources() {
        if (this.lazyNetBeansOrgList) {
            this.lazyNetBeansOrgList = false;
            File file = ModuleList.findNetBeansOrgDestDir(this.home);
            HashMap<String, ModuleEntry> hashMap = new HashMap<String, ModuleEntry>(this.entries);
            if (new File(this.home, "openide.util").isDirectory()) {
                for (String string : FOREST) {
                    ModuleList.doScanNetBeansOrgSources(hashMap, string == null ? this.home : new File(this.home, string), 1, this.home, file, string);
                }
            } else {
                ModuleList.doScanNetBeansOrgSources(hashMap, this.home, 3, this.home, file, null);
            }
            this.entries = hashMap;
        }
    }

    public ModuleEntry getEntry(String string) {
        if (string == null) {
            return null;
        }
        ModuleEntry moduleEntry = this.entries.get(string);
        if (moduleEntry != null) {
            return moduleEntry;
        }
        if (ModuleList.isNetBeansOrg(this.home)) {
            File file = ModuleList.findNetBeansOrgDestDir(this.home);
            for (String string2 : FOREST) {
                String string3 = ModuleList.abbreviate(string);
                File file2 = new File(string2 == null ? this.home : new File(this.home, string2), string3);
                HashMap<String, ModuleEntry> hashMap = new HashMap<String, ModuleEntry>();
                try {
                    ModuleList.scanPossibleProject(file2, hashMap, NbModuleProvider.NbModuleType.NETBEANS_ORG, this.home, file, string2 == null ? string3 : string2 + "/" + string3);
                }
                catch (IOException iOException) {
                    LOG.log(Level.INFO, null, iOException);
                    continue;
                }
                if (hashMap.isEmpty()) continue;
                hashMap.putAll(this.entries);
                this.entries = hashMap;
                moduleEntry = (ModuleEntry)hashMap.get(string);
                if (moduleEntry == null) continue;
                LOG.log(Level.FINE, "Found entry for {0} by direct guess in {1}", new Object[]{string, file2});
                return moduleEntry;
            }
        }
        this.maybeRescanNetBeansOrgSources();
        return this.entries.get(string);
    }

    public static String abbreviate(String string) {
        return string.replaceFirst("^org\\.netbeans\\.modules\\.", "").replaceFirst("^org\\.netbeans\\.(libs|lib|api|spi|core)\\.", "$1.").replaceFirst("^org\\.netbeans\\.", "o.n.").replaceFirst("^org\\.openide\\.", "openide.").replaceFirst("^org\\.", "o.").replaceFirst("^com\\.sun\\.", "c.s.").replaceFirst("^com\\.", "c.");
    }

    public Set<ModuleEntry> getAllEntries() {
        this.maybeRescanNetBeansOrgSources();
        return new HashSet<ModuleEntry>(this.entries.values());
    }

    public Set<ModuleEntry> getAllEntriesSoft() {
        return new HashSet<ModuleEntry>(this.entries.values());
    }

    public static LocalizedBundleInfo loadBundleInfo(File file) {
        LocalizedBundleInfo localizedBundleInfo = Util.findLocalizedBundleInfo(file);
        return localizedBundleInfo == null ? LocalizedBundleInfo.EMPTY : localizedBundleInfo;
    }

    static {
        FOREST = new String[]{null, "contrib"};
        sourceLists = new HashMap<File, ModuleList>();
        binaryLists = new HashMap<File, ModuleList>();
        clusterLists = new HashMap<File, File[]>();
        clusterPropertiesFiles = new HashMap<File, Map<String, String>>();
        clusterLocations = new HashMap<File, Map<String, String>>();
        knownEntries = new HashMap<File, Set<ModuleEntry>>();
        netbeansOrgDestDirs = new HashMap<File, File>();
        EXCLUDED_DIR_NAMES = new HashSet<String>();
        EXCLUDED_DIR_NAMES.add("CVS");
        EXCLUDED_DIR_NAMES.add("nbproject");
        EXCLUDED_DIR_NAMES.add("www");
        EXCLUDED_DIR_NAMES.add("test");
        EXCLUDED_DIR_NAMES.add("build");
        EXCLUDED_DIR_NAMES.add("src");
        EXCLUDED_DIR_NAMES.add("org");
        DIR_SCAN_CACHE = new HashMap<File, String[]>();
        MODULE_DIRS = new String[]{"modules", "modules/eager", "modules/autoload", "lib", "core"};
        PROJECT_XML = "nbproject" + File.separatorChar + "project.xml";
        PERMIT_CACHES = true;
    }
}

