/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.action;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.action.DataModel;
import org.netbeans.modules.apisupport.project.ui.wizard.action.ShortcutEnterPanel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GUIRegistrationPanel
extends BasicWizardIterator.Panel {
    private final RequestProcessor SFS_RP = new RequestProcessor(GUIRegistrationPanel.class.getName());
    private static final String ACTIONS_DIR = "Actions";
    private FileSystem sfs;
    private final ListCellRenderer POSITION_RENDERER = new PositionRenderer();
    private static final String POSITION_HERE = GUIRegistrationPanel.getMessage("CTL_PositionHere");
    private static final String POSITION_SEPARATOR = " - ";
    private DataModel data;
    private final JComponent[] gmiGroup;
    private final JComponent[] toolbarGroup;
    private final JComponent[] shortcutGroup;
    private final JComponent[] fileTypeGroup;
    private final JComponent[] editorGroup;
    private JComboBox category;
    private JLabel categoryTxt;
    private JComboBox edContentType;
    private JLabel edContentTypeTxt;
    private JComboBox edPosition;
    private JLabel edPositionTxt;
    private JCheckBox edSeparatorAfter;
    private JCheckBox edSeparatorBefore;
    private JPanel edSeparatorPanel;
    JCheckBox editorContext;
    JCheckBox fileTypeContext;
    private JLabel filler;
    private JComboBox ftContentType;
    private JLabel ftContentTypeTxt;
    private JComboBox ftPosition;
    private JLabel ftPositionTxt;
    private JCheckBox ftSeparatorAfter;
    private JCheckBox ftSeparatorBefore;
    private JPanel ftSeparatorPanel;
    private JCheckBox globalKeyboardShortcut;
    JCheckBox globalMenuItem;
    JCheckBox globalToolbarButton;
    private JScrollPane jScrollPane1;
    private JButton keyStrokeChange;
    private JButton keyStrokeRemove;
    private JLabel keyStrokeTxt;
    private JComboBox menu;
    private JComboBox menuPosition;
    private JLabel menuPositionTxt;
    private JCheckBox menuSeparatorAfter;
    private JCheckBox menuSeparatorBefore;
    private JPanel menuSeparatorPanel;
    private JLabel menuTxt;
    private JList shortcutsList;
    private JComboBox toolbar;
    private JComboBox toolbarPosition;
    private JLabel toolbarPositionTxt;
    private JLabel toolbarTxt;

    public GUIRegistrationPanel(WizardDescriptor wizardDescriptor, DataModel dataModel) {
        super(wizardDescriptor);
        this.data = dataModel;
        this.initComponents();
        this.putClientProperty("NewFileWizard_Title", GUIRegistrationPanel.getMessage("LBL_ActionWizardTitle"));
        this.menu.addPopupMenuListener(new PML(this.menu, this.menuPosition));
        this.toolbar.addPopupMenuListener(new PML(this.toolbar, this.toolbarPosition));
        this.ftContentType.addPopupMenuListener(new PML(this.ftContentType, this.ftPosition));
        this.edContentType.addPopupMenuListener(new PML(this.edContentType, this.edPosition));
        this.gmiGroup = new JComponent[]{this.menu, this.menuTxt, this.menuPosition, this.menuPositionTxt, this.menuSeparatorAfter, this.menuSeparatorBefore};
        this.toolbarGroup = new JComponent[]{this.toolbar, this.toolbarTxt, this.toolbarPosition, this.toolbarPositionTxt};
        this.shortcutGroup = new JComponent[]{this.shortcutsList, this.keyStrokeTxt, this.keyStrokeChange, this.keyStrokeRemove};
        this.fileTypeGroup = new JComponent[]{this.ftContentType, this.ftContentTypeTxt, this.ftPosition, this.ftPositionTxt, this.ftSeparatorAfter, this.ftSeparatorBefore};
        this.editorGroup = new JComponent[]{this.edContentType, this.edContentTypeTxt, this.edPosition, this.edPositionTxt, this.edSeparatorAfter, this.edSeparatorBefore};
        this.readSFS();
    }

    private void setEditable(final JComboBox jComboBox) {
        jComboBox.setEditable(true);
        if (jComboBox.getEditor().getEditorComponent() instanceof JTextField) {
            JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
            jTextField.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    if (!CustomizerComponentFactory.isWaitModel(jComboBox.getModel())) {
                        GUIRegistrationPanel.this.checkValidity();
                    }
                }
            });
        }
    }

    @Override
    protected String getPanelName() {
        return GUIRegistrationPanel.getMessage("LBL_GUIRegistration_Title");
    }

    private String getCategoryPath() {
        String string = UIUtil.getSFSPath(this.category, ACTIONS_DIR);
        return string == null ? "Actions/Tools" : string;
    }

    @Override
    protected void storeToDataModel() {
        if (!this.checkValidity()) {
            return;
        }
        this.data.setCategory(this.getCategoryPath());
        this.data.setGlobalMenuItemEnabled(this.globalMenuItem.isSelected());
        if (this.globalMenuItem.isSelected()) {
            this.data.setGMIParentMenu(GUIRegistrationPanel.getSelectedLayerPresenter(this.menu).getFullPath());
            this.data.setGMIPosition((DataModel.Position)this.menuPosition.getSelectedItem());
            this.data.setGMISeparatorAfter(this.menuSeparatorAfter.isSelected());
            this.data.setGMISeparatorBefore(this.menuSeparatorBefore.isSelected());
        }
        this.data.setToolbarEnabled(this.globalToolbarButton.isSelected());
        if (this.globalToolbarButton.isSelected()) {
            this.data.setToolbar(GUIRegistrationPanel.getSelectedLayerPresenter(this.toolbar).getFullPath());
            this.data.setToolbarPosition((DataModel.Position)this.toolbarPosition.getSelectedItem());
        }
        this.data.setKeyboardShortcutEnabled(this.globalKeyboardShortcut.isSelected());
        this.data.setFileTypeContextEnabled(this.fileTypeContext.isSelected());
        if (this.fileTypeContext.isSelected()) {
            this.data.setFTContextType(GUIRegistrationPanel.getSelectedLayerPresenter(this.ftContentType).getFullPath());
            this.data.setFTContextPosition((DataModel.Position)this.ftPosition.getSelectedItem());
            this.data.setFTContextSeparatorBefore(this.ftSeparatorBefore.isSelected());
            this.data.setFTContextSeparatorAfter(this.ftSeparatorAfter.isSelected());
        }
        this.data.setEditorContextEnabled(this.editorContext.isSelected());
        if (this.editorContext.isSelected()) {
            this.data.setEdContextType(GUIRegistrationPanel.getSelectedLayerPresenter(this.edContentType).getFullPath());
            this.data.setEdContextPosition((DataModel.Position)this.edPosition.getSelectedItem());
            this.data.setEdContextSeparatorBefore(this.edSeparatorBefore.isSelected());
            this.data.setEdContextSeparatorAfter(this.edSeparatorAfter.isSelected());
        }
    }

    @Override
    protected void readFromDataModel() {
        this.initializeGlobalAction();
        this.checkValidity();
    }

    private void initializeGlobalAction() {
        this.globalMenuItem.setSelected(true);
        this.globalMenuItem.setEnabled(true);
        this.setGroupEnabled(this.gmiGroup, this.globalMenuItem.isSelected());
        this.globalToolbarButton.setEnabled(true);
        this.setGroupEnabled(this.toolbarGroup, this.globalToolbarButton.isSelected());
        boolean bl = this.data.isAlwaysEnabled();
        this.globalKeyboardShortcut.setEnabled(bl);
        this.setShortcutGroupEnabled();
        if (bl) {
            this.fileTypeContext.setSelected(false);
            this.editorContext.setSelected(false);
        }
        this.fileTypeContext.setEnabled(!bl);
        this.setGroupEnabled(this.fileTypeGroup, this.fileTypeContext.isSelected());
        this.editorContext.setEnabled(!bl);
        this.setGroupEnabled(this.editorGroup, this.editorContext.isSelected());
    }

    boolean checkValidity() {
        boolean bl = false;
        if (this.globalKeyboardShortcut.isSelected() && ((DefaultListModel)this.shortcutsList.getModel()).isEmpty()) {
            this.setError(GUIRegistrationPanel.getMessage("MSG_YouMustSpecifyShortcut"));
        } else if (!(this.check(this.globalMenuItem, this.menu, this.menuPosition) && this.check(this.globalToolbarButton, this.toolbar, this.toolbarPosition) && this.check(this.fileTypeContext, this.ftContentType, this.ftPosition) && this.check(this.editorContext, this.edContentType, this.edPosition))) {
            this.markInvalid();
        } else if (!Util.isValidSFSPath(this.getCategoryPath())) {
            this.setError(GUIRegistrationPanel.getMessage("ERR_Category_Invalid"));
        } else {
            this.markValid();
            bl = true;
        }
        return bl;
    }

    private boolean check(JCheckBox jCheckBox, JComboBox jComboBox, JComboBox jComboBox2) {
        boolean bl = !jCheckBox.isSelected() || GUIRegistrationPanel.getSelectedItem(jComboBox) != null && GUIRegistrationPanel.getSelectedItem(jComboBox2) != null;
        return bl;
    }

    private void setGroupEnabled(JComponent[] jComponentArray, boolean bl) {
        for (int i = 0; i < jComponentArray.length; ++i) {
            if (jComponentArray[i] == null) continue;
            jComponentArray[i].setEnabled(bl && !this.isEmptyCombo(jComponentArray[i]));
        }
    }

    private void setShortcutGroupEnabled() {
        boolean bl = this.globalKeyboardShortcut.isSelected();
        this.setGroupEnabled(this.shortcutGroup, bl);
        bl = bl && this.shortcutsList.getSelectedValues().length > 0;
        this.keyStrokeRemove.setEnabled(bl);
    }

    private boolean isEmptyCombo(JComponent jComponent) {
        return jComponent instanceof JComboBox && CustomizerComponentFactory.hasOnlyValue(((JComboBox)jComponent).getModel(), CustomizerComponentFactory.EMPTY_VALUE);
    }

    private void readSFS() {
        this.markInvalid();
        this.loadComboAndPositions(ACTIONS_DIR, this.category, null, null, true);
        this.loadComboAndPositions("Menu", this.menu, this.menuPosition, null);
        this.loadComboAndPositions("Toolbars", this.toolbar, this.toolbarPosition, null);
        this.loadComboAndPositions("Loaders", this.ftContentType, this.ftPosition, ACTIONS_DIR);
        this.loadComboAndPositions("Editors", this.edContentType, this.edPosition, "Popup");
    }

    private void loadComboAndPositions(String string, JComboBox jComboBox, JComboBox jComboBox2, String string2) {
        this.loadComboAndPositions(string, jComboBox, jComboBox2, string2, false);
    }

    private void loadComboAndPositions(final String string, final JComboBox jComboBox, final JComboBox jComboBox2, final String string2, final boolean bl) {
        jComboBox.setModel(CustomizerComponentFactory.createComboWaitModel());
        this.SFS_RP.post(new Runnable(){

            public void run() {
                DataFolder dataFolder;
                Util.err.log("Loading " + string + " from SFS....");
                final FileObject fileObject = GUIRegistrationPanel.this.getSFS().getRoot().getFileObject(string);
                DataFolder dataFolder2 = dataFolder = fileObject != null ? DataFolder.findFolder((FileObject)fileObject) : null;
                if (dataFolder == null) {
                    Util.err.log("Could not find " + string);
                    GUIRegistrationPanel.this.setEmptyModel(jComboBox);
                    GUIRegistrationPanel.this.setEmptyModel(jComboBox2);
                    return;
                }
                final List list = string2 == null ? GUIRegistrationPanel.getFolders(dataFolder) : GUIRegistrationPanel.this.getFoldersByName(dataFolder, string2);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        LinkedHashSet<UIUtil.LayerItemPresenter> linkedHashSet = new LinkedHashSet<UIUtil.LayerItemPresenter>();
                        for (Object object : list) {
                            linkedHashSet.add(new UIUtil.LayerItemPresenter(object.getPrimaryFile(), fileObject, string2 != null));
                        }
                        if (linkedHashSet.size() == 0) {
                            GUIRegistrationPanel.this.setEmptyModel(jComboBox);
                            GUIRegistrationPanel.this.setEmptyModel(jComboBox2);
                        } else {
                            Object object;
                            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
                            object = linkedHashSet.iterator();
                            while (object.hasNext()) {
                                defaultComboBoxModel.addElement(object.next());
                            }
                            jComboBox.setModel(defaultComboBoxModel);
                            if (bl) {
                                GUIRegistrationPanel.this.setEditable(jComboBox);
                            }
                            if (jComboBox2 != null) {
                                GUIRegistrationPanel.this.loadPositionsCombo((UIUtil.LayerItemPresenter)jComboBox.getSelectedItem(), jComboBox2);
                            }
                        }
                    }
                });
            }
        });
    }

    private void loadPositionsCombo(final UIUtil.LayerItemPresenter layerItemPresenter, final JComboBox jComboBox) {
        assert (layerItemPresenter != null);
        assert (jComboBox != null);
        jComboBox.setModel(CustomizerComponentFactory.createComboWaitModel());
        this.SFS_RP.post(new Runnable(){

            public void run() {
                DataObject[] dataObjectArray = DataFolder.findFolder((FileObject)layerItemPresenter.getFileObject()).getChildren();
                final FileObject[] fileObjectArray = new FileObject[dataObjectArray.length];
                for (int i = 0; i < dataObjectArray.length; ++i) {
                    fileObjectArray[i] = dataObjectArray[i].getPrimaryFile();
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        GUIRegistrationPanel.this.createPositionModel(jComboBox, fileObjectArray, layerItemPresenter);
                    }
                });
            }
        });
    }

    private void createPositionModel(JComboBox jComboBox, FileObject[] fileObjectArray, UIUtil.LayerItemPresenter layerItemPresenter) {
        DefaultComboBoxModel<DataModel.Position> defaultComboBoxModel = new DefaultComboBoxModel<DataModel.Position>();
        UIUtil.LayerItemPresenter layerItemPresenter2 = null;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            UIUtil.LayerItemPresenter layerItemPresenter3 = new UIUtil.LayerItemPresenter(fileObjectArray[i], layerItemPresenter.getFileObject());
            defaultComboBoxModel.addElement(GUIRegistrationPanel.createPosition(layerItemPresenter2, layerItemPresenter3));
            layerItemPresenter2 = layerItemPresenter3;
        }
        defaultComboBoxModel.addElement(GUIRegistrationPanel.createPosition(layerItemPresenter2, null));
        jComboBox.setModel(defaultComboBoxModel);
        this.checkValidity();
    }

    private static Object getSelectedItem(JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        return object == CustomizerComponentFactory.WAIT_VALUE || object == CustomizerComponentFactory.EMPTY_VALUE ? null : object;
    }

    private static UIUtil.LayerItemPresenter getSelectedLayerPresenter(JComboBox jComboBox) {
        return (UIUtil.LayerItemPresenter)GUIRegistrationPanel.getSelectedItem(jComboBox);
    }

    private static DataModel.Position createPosition(UIUtil.LayerItemPresenter layerItemPresenter, UIUtil.LayerItemPresenter layerItemPresenter2) {
        return new DataModel.Position(layerItemPresenter == null ? null : layerItemPresenter.getFileObject().getNameExt(), layerItemPresenter2 == null ? null : layerItemPresenter2.getFileObject().getNameExt(), layerItemPresenter == null ? null : layerItemPresenter.getDisplayName(), layerItemPresenter2 == null ? null : layerItemPresenter2.getDisplayName());
    }

    private void setEmptyModel(JComboBox jComboBox) {
        if (jComboBox != null) {
            jComboBox.setModel(CustomizerComponentFactory.createComboEmptyModel());
            jComboBox.setEnabled(false);
            jComboBox.setEditable(false);
            this.checkValidity();
        }
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(GUIRegistrationPanel.class);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(GUIRegistrationPanel.class, (String)string);
    }

    private void initComponents() {
        this.categoryTxt = new JLabel();
        this.category = new JComboBox();
        this.globalMenuItem = new JCheckBox();
        this.menuTxt = new JLabel();
        this.menu = new JComboBox();
        this.menuPositionTxt = new JLabel();
        this.menuPosition = new JComboBox();
        this.menuSeparatorPanel = new JPanel();
        this.menuSeparatorBefore = new JCheckBox();
        this.menuSeparatorAfter = new JCheckBox();
        this.globalToolbarButton = new JCheckBox();
        this.toolbarTxt = new JLabel();
        this.toolbar = new JComboBox();
        this.toolbarPositionTxt = new JLabel();
        this.toolbarPosition = new JComboBox();
        this.globalKeyboardShortcut = new JCheckBox();
        this.keyStrokeTxt = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.shortcutsList = new JList(new DefaultListModel());
        this.keyStrokeChange = new JButton();
        this.keyStrokeRemove = new JButton();
        this.filler = new JLabel();
        this.fileTypeContext = new JCheckBox();
        this.ftContentTypeTxt = new JLabel();
        this.ftContentType = new JComboBox();
        this.ftPositionTxt = new JLabel();
        this.ftPosition = new JComboBox();
        this.ftSeparatorPanel = new JPanel();
        this.ftSeparatorBefore = new JCheckBox();
        this.ftSeparatorAfter = new JCheckBox();
        this.editorContext = new JCheckBox();
        this.edContentTypeTxt = new JLabel();
        this.edContentType = new JComboBox();
        this.edPositionTxt = new JLabel();
        this.edPosition = new JComboBox();
        this.edSeparatorPanel = new JPanel();
        this.edSeparatorBefore = new JCheckBox();
        this.edSeparatorAfter = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.categoryTxt.setLabelFor(this.category);
        Mnemonics.setLocalizedText((JLabel)this.categoryTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_Category"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.categoryTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.category, gridBagConstraints);
        this.category.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_Category"));
        Mnemonics.setLocalizedText((AbstractButton)this.globalMenuItem, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_GlobalMenuItem"));
        this.globalMenuItem.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.globalMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIRegistrationPanel.this.globalMenuItemActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.globalMenuItem, gridBagConstraints);
        this.globalMenuItem.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_globalMenuItem"));
        this.menuTxt.setLabelFor(this.menu);
        Mnemonics.setLocalizedText((JLabel)this.menuTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_Menu"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.menuTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.menu, gridBagConstraints);
        this.menu.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_menu"));
        this.menuPositionTxt.setLabelFor(this.menuPosition);
        Mnemonics.setLocalizedText((JLabel)this.menuPositionTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_Position"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.menuPositionTxt, gridBagConstraints);
        this.menuPosition.setRenderer(this.POSITION_RENDERER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.menuPosition, gridBagConstraints);
        this.menuPosition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_menuPosition"));
        this.menuSeparatorPanel.setLayout(new FlowLayout(1, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.menuSeparatorBefore, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_SeparatorBefore"));
        this.menuSeparatorPanel.add(this.menuSeparatorBefore);
        this.menuSeparatorBefore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_menuSeparatorBefore"));
        Mnemonics.setLocalizedText((AbstractButton)this.menuSeparatorAfter, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_SeparatorAfter"));
        this.menuSeparatorAfter.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.menuSeparatorPanel.add(this.menuSeparatorAfter);
        this.menuSeparatorAfter.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_menuSeparatorAfter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 0, 0);
        this.add((Component)this.menuSeparatorPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.globalToolbarButton, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_GlobalToolbarButton"));
        this.globalToolbarButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.globalToolbarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIRegistrationPanel.this.globalToolbarButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.globalToolbarButton, gridBagConstraints);
        this.globalToolbarButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_globalToolbarButton"));
        this.toolbarTxt.setLabelFor(this.toolbar);
        Mnemonics.setLocalizedText((JLabel)this.toolbarTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_Toolbar"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.toolbarTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.toolbar, gridBagConstraints);
        this.toolbar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_toolbar"));
        this.toolbarPositionTxt.setLabelFor(this.toolbarPosition);
        Mnemonics.setLocalizedText((JLabel)this.toolbarPositionTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_Position"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.toolbarPositionTxt, gridBagConstraints);
        this.toolbarPosition.setRenderer(this.POSITION_RENDERER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.toolbarPosition, gridBagConstraints);
        this.toolbarPosition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_toolbarPosition"));
        Mnemonics.setLocalizedText((AbstractButton)this.globalKeyboardShortcut, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_GlobalKeyboardShortcut"));
        this.globalKeyboardShortcut.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.globalKeyboardShortcut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIRegistrationPanel.this.globalKeyboardShortcutActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.globalKeyboardShortcut, gridBagConstraints);
        this.globalKeyboardShortcut.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_globalKeyboardShortcut"));
        this.keyStrokeTxt.setLabelFor(this.menuPosition);
        Mnemonics.setLocalizedText((JLabel)this.keyStrokeTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_KeyStroke"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.keyStrokeTxt, gridBagConstraints);
        this.keyStrokeTxt.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_keyStrokeDef"));
        this.shortcutsList.setVisibleRowCount(3);
        this.shortcutsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GUIRegistrationPanel.this.shortcutsListChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.shortcutsList);
        this.shortcutsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_keyStrokeList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.keyStrokeChange, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"CTL_Change"));
        this.keyStrokeChange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIRegistrationPanel.this.keyStrokeChangeActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.keyStrokeChange, gridBagConstraints);
        this.keyStrokeChange.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_keyStrokeChange"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/action/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.keyStrokeRemove, (String)resourceBundle.getString("CTL_Remove"));
        this.keyStrokeRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIRegistrationPanel.this.keyStrokeRemoveActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.keyStrokeRemove, gridBagConstraints);
        this.keyStrokeRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_keyStrokeRemove"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.fileTypeContext, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_FileTypeContextMenuItem"));
        this.fileTypeContext.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileTypeContext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIRegistrationPanel.this.fileTypeContextActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.fileTypeContext, gridBagConstraints);
        this.fileTypeContext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_FileTypeContext"));
        this.ftContentTypeTxt.setLabelFor(this.ftContentType);
        Mnemonics.setLocalizedText((JLabel)this.ftContentTypeTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_ContentType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.ftContentTypeTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.ftContentType, gridBagConstraints);
        this.ftContentType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_ftContentType"));
        this.ftPositionTxt.setLabelFor(this.ftPosition);
        Mnemonics.setLocalizedText((JLabel)this.ftPositionTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_Position"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.ftPositionTxt, gridBagConstraints);
        this.ftPosition.setRenderer(this.POSITION_RENDERER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.ftPosition, gridBagConstraints);
        this.ftPosition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_ftPosition"));
        this.ftSeparatorPanel.setLayout(new FlowLayout(1, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.ftSeparatorBefore, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_SeparatorBefore"));
        this.ftSeparatorPanel.add(this.ftSeparatorBefore);
        this.ftSeparatorBefore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_ftSeparatorBefore"));
        Mnemonics.setLocalizedText((AbstractButton)this.ftSeparatorAfter, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_SeparatorAfter"));
        this.ftSeparatorAfter.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.ftSeparatorPanel.add(this.ftSeparatorAfter);
        this.ftSeparatorAfter.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_ftSeparatorAfter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 0, 0);
        this.add((Component)this.ftSeparatorPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editorContext, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_EditorContextMenuItem"));
        this.editorContext.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.editorContext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIRegistrationPanel.this.editorContextActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 3, 0);
        this.add((Component)this.editorContext, gridBagConstraints);
        this.editorContext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_EditorContext"));
        this.edContentTypeTxt.setLabelFor(this.edContentType);
        Mnemonics.setLocalizedText((JLabel)this.edContentTypeTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_ContentType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.edContentTypeTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.edContentType, gridBagConstraints);
        this.edContentType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_edContentType"));
        this.edPositionTxt.setLabelFor(this.edPosition);
        Mnemonics.setLocalizedText((JLabel)this.edPositionTxt, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_Position"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 0);
        this.add((Component)this.edPositionTxt, gridBagConstraints);
        this.edPosition.setRenderer(this.POSITION_RENDERER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 0);
        this.add((Component)this.edPosition, gridBagConstraints);
        this.edPosition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_edPosition"));
        this.edSeparatorPanel.setLayout(new FlowLayout(1, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.edSeparatorBefore, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_SeparatorBefore"));
        this.edSeparatorPanel.add(this.edSeparatorBefore);
        this.edSeparatorBefore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_edSeparatorBefore"));
        Mnemonics.setLocalizedText((AbstractButton)this.edSeparatorAfter, (String)NbBundle.getMessage(GUIRegistrationPanel.class, (String)"LBL_SeparatorAfter"));
        this.edSeparatorAfter.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.edSeparatorPanel.add(this.edSeparatorAfter);
        this.edSeparatorAfter.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_CTL_edSeparatorAfter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 0, 0);
        this.add((Component)this.edSeparatorPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GUIRegistrationPanel.class, (String)"ACS_GuiRegistrationPanel"));
    }

    private void shortcutsListChanged(ListSelectionEvent listSelectionEvent) {
        this.setShortcutGroupEnabled();
    }

    private void keyStrokeRemoveActionPerformed(ActionEvent actionEvent) {
        DefaultListModel defaultListModel = (DefaultListModel)this.shortcutsList.getModel();
        Object[] objectArray = this.shortcutsList.getSelectedValues();
        if (objectArray.length > 0) {
            int n = this.shortcutsList.getSelectionModel().getMinSelectionIndex();
            for (int i = 0; i < objectArray.length; ++i) {
                defaultListModel.removeElement(objectArray[i]);
            }
            if (defaultListModel.getSize() > 0) {
                n = n > 0 ? n - 1 : 0;
                this.shortcutsList.setSelectedIndex(n);
            }
        }
        this.checkValidity();
    }

    private void editorContextActionPerformed(ActionEvent actionEvent) {
        this.setGroupEnabled(this.editorGroup, this.editorContext.isSelected());
        this.checkValidity();
    }

    private void fileTypeContextActionPerformed(ActionEvent actionEvent) {
        this.setGroupEnabled(this.fileTypeGroup, this.fileTypeContext.isSelected());
        this.checkValidity();
    }

    private void globalMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setGroupEnabled(this.gmiGroup, this.globalMenuItem.isSelected());
        this.checkValidity();
    }

    private void globalToolbarButtonActionPerformed(ActionEvent actionEvent) {
        this.setGroupEnabled(this.toolbarGroup, this.globalToolbarButton.isSelected());
        this.checkValidity();
    }

    private void globalKeyboardShortcutActionPerformed(ActionEvent actionEvent) {
        this.setShortcutGroupEnabled();
        this.checkValidity();
    }

    private void keyStrokeChangeActionPerformed(ActionEvent actionEvent) {
        KeyStroke[] keyStrokeArray = ShortcutEnterPanel.showDialog();
        if (keyStrokeArray != null && keyStrokeArray.length > 0) {
            String string = UIUtil.keyStrokesToString(keyStrokeArray);
            DefaultListModel defaultListModel = (DefaultListModel)this.shortcutsList.getModel();
            if (!defaultListModel.contains(string)) {
                defaultListModel.addElement(string);
                this.data.setKeyStroke(UIUtil.keyStrokesToLogicalString(keyStrokeArray));
                this.shortcutsList.setSelectedValue(string, true);
                this.checkValidity();
            }
        }
    }

    private FileSystem getSFS() {
        assert (!EventQueue.isDispatchThread()) : "Called from ETD!";
        if (this.sfs == null) {
            try {
                this.sfs = LayerUtils.getEffectiveSystemFilesystem(this.data.getProject());
            }
            catch (IOException iOException) {
                Util.err.notify((Throwable)iOException);
                this.sfs = FileUtil.createMemoryFileSystem();
            }
        }
        return this.sfs;
    }

    private List<DataFolder> getFoldersByName(DataFolder dataFolder, String string) {
        ArrayList<DataFolder> arrayList = new ArrayList<DataFolder>();
        for (DataFolder dataFolder2 : GUIRegistrationPanel.getFolders(dataFolder)) {
            if (!string.equals(dataFolder2.getName()) || dataFolder2.getPrimaryFile().getParent() == dataFolder.getPrimaryFile()) continue;
            arrayList.add(dataFolder2);
        }
        return arrayList;
    }

    private static List<DataFolder> getFolders(DataFolder dataFolder) {
        ArrayList<DataFolder> arrayList = new ArrayList<DataFolder>();
        GUIRegistrationPanel.getFolders(dataFolder, arrayList);
        return arrayList;
    }

    private static void getFolders(DataFolder dataFolder, List<DataFolder> list) {
        for (DataObject dataObject : dataFolder.getChildren()) {
            if (!(dataObject instanceof DataFolder)) continue;
            DataFolder dataFolder2 = (DataFolder)dataObject;
            list.add(dataFolder2);
            GUIRegistrationPanel.getFolders(dataFolder2, list);
        }
    }

    private class PML
    implements PopupMenuListener {
        private JComboBox menu;
        private JComboBox position;

        PML(JComboBox jComboBox, JComboBox jComboBox2) {
            this.menu = jComboBox;
            this.position = jComboBox2;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            UIUtil.LayerItemPresenter layerItemPresenter = GUIRegistrationPanel.getSelectedLayerPresenter(this.menu);
            if (layerItemPresenter != null) {
                GUIRegistrationPanel.this.loadPositionsCombo(layerItemPresenter, this.position);
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.popupMenuWillBecomeInvisible(null);
        }
    }

    private static class PositionRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public PositionRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            this.setName("ComboBox.listRenderer");
            if (object == null || object == CustomizerComponentFactory.WAIT_VALUE) {
                string = CustomizerComponentFactory.WAIT_VALUE;
            } else if (object == CustomizerComponentFactory.EMPTY_VALUE) {
                string = CustomizerComponentFactory.EMPTY_VALUE;
            } else {
                DataModel.Position position = (DataModel.Position)object;
                String string2 = position.getBeforeName() == null ? "" : position.getBeforeName() + GUIRegistrationPanel.POSITION_SEPARATOR;
                String string3 = position.getAfterName() == null ? "" : GUIRegistrationPanel.POSITION_SEPARATOR + position.getAfterName();
                string = string2 + POSITION_HERE + string3;
            }
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }
}

