/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizerSources;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.universe.JavadocRootsProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class NbPlatformCustomizerJavadoc
extends JPanel {
    private JavadocRootsProvider jrp;
    private PlatformComponentFactory.JavadocRootsModel model;
    private final NbPlatformCustomizerSources.ListListener listListener;
    private JButton addFolderButton;
    private JPanel buttonPanel;
    private JLabel javadocLabel;
    private JList javadocList;
    private JScrollPane javadocSP;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton removeButton;

    public NbPlatformCustomizerJavadoc() {
        this.initComponents();
        this.initAccessibility();
        this.listListener = new NbPlatformCustomizerSources.ListListener(){

            void listChanged() {
                NbPlatformCustomizerJavadoc.this.updateEnabled();
            }
        };
        this.updateEnabled();
    }

    public void addNotify() {
        super.addNotify();
        this.javadocList.addListSelectionListener(this.listListener);
        this.javadocList.getModel().addListDataListener(this.listListener);
    }

    public void removeNotify() {
        this.javadocList.removeListSelectionListener(this.listListener);
        this.javadocList.getModel().removeListDataListener(this.listListener);
        super.removeNotify();
    }

    private void updateEnabled() {
        this.removeButton.setEnabled(this.javadocList.getModel().getSize() > 0 && this.javadocList.getSelectedIndex() != -1);
        this.moveUpButton.setEnabled(this.javadocList.getSelectionModel().getMinSelectionIndex() > 0);
        this.moveDownButton.setEnabled(this.jrp != null && this.javadocList.getSelectionModel().getMaxSelectionIndex() < this.jrp.getJavadocRoots().length - 1);
    }

    public void setJavadocRootsProvider(JavadocRootsProvider javadocRootsProvider) {
        this.jrp = javadocRootsProvider;
        this.model = new PlatformComponentFactory.JavadocRootsModel(javadocRootsProvider);
        this.javadocList.setModel(this.model);
    }

    private void initComponents() {
        this.javadocLabel = new JLabel();
        this.javadocSP = new JScrollPane();
        this.javadocList = new JList();
        this.buttonPanel = new JPanel();
        this.addFolderButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.javadocLabel.setLabelFor(this.javadocList);
        Mnemonics.setLocalizedText((JLabel)this.javadocLabel, (String)NbBundle.getMessage(NbPlatformCustomizerJavadoc.class, (String)"LBL_PlatformJavadoc"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.javadocLabel, gridBagConstraints);
        this.javadocList.setCellRenderer(PlatformComponentFactory.getURLListRenderer());
        this.javadocSP.setViewportView(this.javadocList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.javadocSP, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.addFolderButton, (String)NbBundle.getMessage(NbPlatformCustomizerJavadoc.class, (String)"CTL_AddZipOrFolder"));
        this.addFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbPlatformCustomizerJavadoc.this.addZipFolder(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.addFolderButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(NbPlatformCustomizerJavadoc.class, (String)"CTL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbPlatformCustomizerJavadoc.this.removeFolder(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getMessage(NbPlatformCustomizerJavadoc.class, (String)"CTL_MoveUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbPlatformCustomizerJavadoc.this.moveUp(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.buttonPanel.add((Component)this.moveUpButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getMessage(NbPlatformCustomizerJavadoc.class, (String)"CTL_MoveDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbPlatformCustomizerJavadoc.this.moveDown(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void moveDown(ActionEvent actionEvent) {
        int[] nArray = this.javadocList.getSelectedIndices();
        this.model.moveJavadocRootsDown(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            int n2 = nArray[n] + 1;
            nArray[n] = n2;
            nArray[i] = n2;
        }
        this.javadocList.setSelectedIndices(nArray);
    }

    private void moveUp(ActionEvent actionEvent) {
        int[] nArray = this.javadocList.getSelectedIndices();
        this.model.moveJavadocRootsUp(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            int n2 = nArray[n] - 1;
            nArray[n] = n2;
            nArray[i] = n2;
        }
        this.javadocList.setSelectedIndices(nArray);
    }

    private void removeFolder(ActionEvent actionEvent) {
        Object[] objectArray = this.javadocList.getSelectedValues();
        int n = this.javadocList.getSelectedIndex() - 1;
        URL[] uRLArray = new URL[objectArray.length];
        System.arraycopy(objectArray, 0, uRLArray, 0, objectArray.length);
        this.model.removeJavadocRoots(uRLArray);
        this.javadocList.setSelectedIndex(n);
    }

    private void addZipFolder(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(ModuleUISettings.getDefault().getLastUsedNbPlatformLocation());
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase(Locale.US).endsWith(".jar") || file.getName().toLowerCase(Locale.US).endsWith(".zip");
            }

            public String getDescription() {
                return NbPlatformCustomizerJavadoc.this.getMessage("CTL_JavadocTab");
            }
        });
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            URL uRL = FileUtil.urlForArchiveOrDir((File)file);
            if (this.model.containsRoot(uRL)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.getMessage("MSG_ExistingJavadocRoot")));
            } else {
                ModuleUISettings.getDefault().setLastUsedNbPlatformLocation(file.getParentFile().getAbsolutePath());
                this.model.addJavadocRoot(uRL);
                this.javadocList.setSelectedValue(uRL, true);
            }
        }
    }

    private void initAccessibility() {
        this.addFolderButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_addFolderButton"));
        this.javadocList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_javadocList"));
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_moveDownButton"));
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_moveUpButton"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_removeButton"));
    }

    private String getMessage(String string) {
        return NbBundle.getMessage(NbPlatformCustomizerJavadoc.class, (String)string);
    }
}

