/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HarnessUpgrader {
    private HarnessUpgrader() {
    }

    public static void checkForUpgrade() {
        if (ModuleUISettings.getDefault().getHarnessesUpgraded()) {
            return;
        }
        ModuleUISettings.getDefault().setHarnessesUpgraded(true);
        final HashSet<NbPlatform> hashSet = new HashSet<NbPlatform>();
        for (NbPlatform nbPlatform : NbPlatform.getPlatforms()) {
            if (nbPlatform.isDefault() && !nbPlatform.isValid() || nbPlatform.getHarnessVersion() >= 2 || !nbPlatform.getHarnessLocation().equals(nbPlatform.getBundledHarnessLocation())) continue;
            hashSet.add(nbPlatform);
        }
        if (!hashSet.isEmpty()) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    HarnessUpgrader.promptForUpgrade(hashSet);
                }
            });
        }
    }

    private static void promptForUpgrade(Set<NbPlatform> set) {
        if (UIUtil.showAcceptCancelDialog(NbBundle.getMessage(HarnessUpgrader.class, (String)"HarnessUpgrader.title"), NbBundle.getMessage(HarnessUpgrader.class, (String)"HarnessUpgrader.text"), NbBundle.getMessage(HarnessUpgrader.class, (String)"HarnessUpgrader.upgrade"), NbBundle.getMessage(HarnessUpgrader.class, (String)"HarnessUpgrader.skip"), 3)) {
            try {
                HarnessUpgrader.doUpgrade(set);
            }
            catch (IOException iOException) {
                Util.err.notify((Throwable)iOException);
            }
        }
    }

    private static void doUpgrade(Set<NbPlatform> set) throws IOException {
        NbPlatform nbPlatform = NbPlatform.getDefaultPlatform();
        if (nbPlatform == null) {
            return;
        }
        File file = nbPlatform.getHarnessLocation();
        for (NbPlatform nbPlatform2 : set) {
            nbPlatform2.setHarnessLocation(file);
        }
    }
}

