/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterInfo;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerDisplay;
import org.netbeans.modules.apisupport.project.ui.customizer.EditClusterPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.JavaPlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.netbeans.swing.outline.Outline;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SuiteCustomizerLibraries
extends NbPropertyPanel.Suite
implements ExplorerManager.Provider,
ChangeListener {
    private final ExplorerManager manager;
    private ModuleEntry[] platformModules;
    Set<ModuleEntry> extraBinaryModules = new HashSet<ModuleEntry>();
    static boolean TEST = false;
    private LibrariesChildren libChildren;
    private boolean extClustersLoaded;
    private AbstractNode realRoot;
    private AbstractNode waitRoot;
    public static final String WAIT_ICON_PATH = "org/netbeans/modules/apisupport/project/suite/resources/wait.png";
    private RequestProcessor.Task refreshTask;
    private JButton addClusterButton;
    private JButton addProjectButton;
    private JPanel buttonsPanel;
    private JButton editButton;
    private JLabel filler;
    private JPanel hidingPanel;
    private JLabel jLabel1;
    private JButton javaPlatformButton;
    private JComboBox javaPlatformCombo;
    private JLabel javaPlatformLabel;
    private JButton managePlafsButton;
    private JLabel platform;
    private JComboBox platformValue;
    private JPanel platformsPanel;
    private JButton removeButton;
    private JButton resolveButton;
    private JPanel resolveButtonPanel;
    private OutlineView view;
    private JLabel viewLabel;
    private static final Comparator<Node> MODULES_COMPARATOR = new Comparator<Node>(){
        Collator COLL = Collator.getInstance();

        @Override
        public int compare(Node node, Node node2) {
            return this.COLL.compare(node.getDisplayName(), node2.getDisplayName());
        }
    };
    public static final Set<String> DISABLED_PLATFORM_MODULES = new HashSet<String>();
    private static final SystemAction[] NO_ACTIONS;
    private static final EnabledProp ENABLED_PROP_TEMPLATE;
    private static final OriginProp ORIGIN_PROP_TEMPLATE;
    private RequestProcessor.Task updateDependencyWarningsTask;
    private RequestProcessor RP = new RequestProcessor(SuiteCustomizerLibraries.class.getName(), 1);
    private static final Comparator<UniverseModule> UNIVERSE_MODULE_COMPARATOR;
    private Set<UniverseModule> universe;
    private final Object lock = new Object();
    private FixInfo resolveFixInfo;

    public SuiteCustomizerLibraries(SuiteProperties suiteProperties, ProjectCustomizer.Category category) {
        super(suiteProperties, SuiteCustomizerLibraries.class, category);
        this.initComponents();
        this.initAccessibility();
        this.manager = new ExplorerManager();
        this.waitRoot = new AbstractNode((Children)new Children.Array(){

            protected Collection<Node> initCollection() {
                return Collections.singleton(new WaitNode());
            }
        });
        this.waitRoot.setName(SuiteCustomizerLibraries.getMessage("LBL_ModuleListClusters"));
        this.waitRoot.setDisplayName(SuiteCustomizerLibraries.getMessage("LBL_ModuleListClustersModules"));
        this.manager.setRootContext((Node)this.waitRoot);
        this.refresh();
        this.view.setProperties(new Node.Property[]{ENABLED_PROP_TEMPLATE, ORIGIN_PROP_TEMPLATE});
        Outline outline = this.view.getOutline();
        outline.setRootVisible(false);
        outline.setSelectionMode(0);
        TableColumn tableColumn = outline.getColumnModel().getColumn(1);
        tableColumn.setMinWidth(25);
        tableColumn.setMaxWidth(200);
        tableColumn.setPreferredWidth(70);
        tableColumn = outline.getColumnModel().getColumn(2);
        tableColumn.setMinWidth(25);
        tableColumn.setMaxWidth(300);
        tableColumn.setPreferredWidth(130);
        suiteProperties.getBrandingModel().addChangeListener(this);
        suiteProperties.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("nbPlatform".equals(propertyChangeEvent.getPropertyName())) {
                    SuiteCustomizerLibraries.this.refresh();
                }
            }
        });
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                    Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                    SuiteCustomizerLibraries.this.updateButtons(nodeArray);
                }
            }
        });
        this.updateButtons(this.manager.getSelectedNodes());
        this.javaPlatformCombo.setRenderer(JavaPlatformComponentFactory.javaPlatformListCellRenderer());
    }

    private void addProjectCluster(ClusterInfo clusterInfo, boolean bl) throws MissingResourceException, IllegalArgumentException {
        ClusterNode clusterNode;
        Project project = clusterInfo.getProject();
        assert (project != null);
        SuiteProject suiteProject = this.getProperties().getProject();
        if (project == null) {
            return;
        }
        if (suiteProject.getProjectDirectory().equals(project.getProjectDirectory())) {
            if (bl) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"MSG_TryingToAddMyself", (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            }
            return;
        }
        if (this.libChildren.findCluster(clusterInfo.getClusterDir()) != null) {
            if (bl) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"MSG_AlreadyOnClusterPath", (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            }
            return;
        }
        this.initNodes();
        NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        if (nbModuleProvider != null) {
            assert (nbModuleProvider.getModuleType() == NbModuleProvider.STANDALONE);
            clusterNode = new ClusterNode(clusterInfo, Children.LEAF);
        } else {
            SuiteProvider suiteProvider = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
            assert (suiteProvider != null);
            clusterNode = this.createSuiteNode(clusterInfo);
        }
        this.libChildren.extraNodes.add(clusterNode);
        this.libChildren.setMergedKeys();
    }

    private boolean isExternalCluster(Enabled enabled) {
        return !enabled.isLeaf() && enabled.getProject() == null && !enabled.isPlatformNode();
    }

    private void updateButtons(Node[] nodeArray) {
        boolean bl = nodeArray.length > 0;
        boolean bl2 = nodeArray.length == 1;
        for (Node node : nodeArray) {
            if (!(node instanceof Enabled)) {
                bl2 = false;
                bl = false;
                break;
            }
            Enabled enabled = (Enabled)node;
            bl &= enabled instanceof ClusterNode && !enabled.isPlatformNode();
            bl2 &= this.isExternalCluster(enabled);
        }
        this.removeButton.setEnabled(bl);
        this.editButton.setEnabled(bl2);
    }

    @Override
    void refresh() {
        this.refreshJavaPlatforms();
        this.refreshPlatforms();
        if (this.refreshTask == null) {
            this.refreshTask = this.RP.create(new Runnable(){

                public void run() {
                    SuiteCustomizerLibraries.this.refreshModules();
                    SuiteCustomizerLibraries.this.updateDependencyWarnings(true);
                }
            });
        }
        if (TEST) {
            this.refreshTask.run();
        } else {
            this.refreshTask.schedule(0);
        }
        this.updateJavaPlatformEnabled();
    }

    private void addExtCluster(ClusterInfo clusterInfo) {
        Children.SortedArray sortedArray = new Children.SortedArray();
        try {
            ModuleList moduleList = ModuleList.scanCluster(clusterInfo.getClusterDir(), null, false, clusterInfo);
            sortedArray.setComparator(MODULES_COMPARATOR);
            for (ModuleEntry moduleEntry : moduleList.getAllEntries()) {
                sortedArray.add(new Node[]{new BinaryModuleNode(moduleEntry, clusterInfo.isEnabled())});
                this.extraBinaryModules.add(moduleEntry);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(16, (Throwable)iOException);
        }
        this.initNodes();
        this.libChildren.extraNodes.add(new ClusterNode(clusterInfo, (Children)sortedArray));
        this.libChildren.setMergedKeys();
    }

    private ClusterNode createSuiteNode(ClusterInfo clusterInfo) {
        assert (clusterInfo.getProject() != null);
        assert (clusterInfo.getProject().getLookup().lookup(SuiteProvider.class) != null);
        Children.SortedArray sortedArray = new Children.SortedArray();
        sortedArray.setComparator(MODULES_COMPARATOR);
        Set<NbModuleProject> set = SuiteUtils.getSubProjects(clusterInfo.getProject());
        for (NbModuleProject nbModuleProject : set) {
            sortedArray.add(new Node[]{new SuiteComponentNode(nbModuleProject, clusterInfo.isEnabled())});
        }
        return new ClusterNode(clusterInfo, (Children)sortedArray);
    }

    private void initNodes() {
        if (this.libChildren == null) {
            this.libChildren = new LibrariesChildren();
            this.realRoot = new AbstractNode((Children)this.libChildren);
            this.realRoot.setName(SuiteCustomizerLibraries.getMessage("LBL_ModuleListClusters"));
            this.realRoot.setDisplayName(SuiteCustomizerLibraries.getMessage("LBL_ModuleListClustersModules"));
        }
    }

    private void refreshModules() {
        this.platformModules = this.getProperties().getActivePlatform().getSortedModules();
        this.initNodes();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.getProperties().getDisabledModules()));
        HashSet<String> hashSet2 = new HashSet<String>(Arrays.asList(this.getProperties().getEnabledClusters()));
        HashMap<File, ClusterNode> hashMap = new HashMap<File, ClusterNode>();
        this.libChildren.platformNodes.clear();
        boolean bl = ((NbPlatform)this.platformValue.getSelectedItem()).getHarnessVersion() >= 7;
        for (ModuleEntry moduleEntry : this.platformModules) {
            Object object;
            File file = moduleEntry.getClusterDirectory();
            ClusterNode clusterNode = (ClusterNode)((Object)hashMap.get(file));
            if (clusterNode == null) {
                object = new Children.SortedArray();
                object.setComparator(MODULES_COMPARATOR);
                boolean bl2 = bl && hashSet2.isEmpty() || SingleModuleProperties.clusterMatch(hashSet2, file.getName());
                ClusterInfo clusterInfo = ClusterInfo.create(file, true, bl2);
                clusterNode = new ClusterNode(clusterInfo, (Children)object);
                hashMap.put(file, clusterNode);
                this.libChildren.platformNodes.add(clusterNode);
            }
            object = new BinaryModuleNode(moduleEntry, !hashSet.contains(moduleEntry.getCodeNameBase()) && clusterNode.isEnabled());
            clusterNode.getChildren().add(new Node[]{object});
        }
        Set<ClusterInfo> set = this.getProperties().getClusterPath();
        if (set.size() > 0) {
            for (ClusterNode clusterNode : this.libChildren.platformNodes) {
                if (set.contains(clusterNode.getClusterInfo())) continue;
                clusterNode.setEnabled(false);
            }
            if (!this.extClustersLoaded) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ClusterInfo clusterInfo = (ClusterInfo)iterator.next();
                    if (clusterInfo.isPlatformCluster()) continue;
                    if (clusterInfo.getProject() != null) {
                        this.addProjectCluster(clusterInfo, false);
                        continue;
                    }
                    this.addExtCluster(clusterInfo);
                }
                this.extClustersLoaded = true;
            }
        } else {
            this.extClustersLoaded = true;
        }
        this.libChildren.setMergedKeys();
    }

    private void refreshJavaPlatforms() {
        this.javaPlatformCombo.setModel(JavaPlatformComponentFactory.javaPlatformListModel());
        this.javaPlatformCombo.setSelectedItem(this.getProperties().getActiveJavaPlatform());
    }

    private void refreshPlatforms() {
        Logger logger = Logger.getLogger(SuiteCustomizerLibraries.class.getName());
        logger.log(Level.FINE, "refreshPlatforms --> " + this.getProperties().getActivePlatform().getLabel());
        this.platformValue.setModel(new PlatformComponentFactory.NbPlatformListModel(this.getProperties().getActivePlatform()));
        this.platformValue.requestFocus();
    }

    @Override
    public void store() {
        Enabled enabled;
        boolean bl;
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        ArrayList<ClusterInfo> arrayList = new ArrayList<ClusterInfo>();
        boolean bl2 = bl = this.getProperties().getActivePlatform().getHarnessVersion() < 7;
        assert (this.refreshTask != null);
        if (!this.refreshTask.isFinished()) {
            return;
        }
        for (ClusterNode clusterNode : this.libChildren.platformNodes) {
            if (!clusterNode.isEnabled()) continue;
            if (bl) {
                treeSet.add(clusterNode.getName());
            } else {
                arrayList.add(clusterNode.getClusterInfo());
            }
            for (Node node : clusterNode.getChildren().getNodes()) {
                enabled = (Enabled)node;
                if (enabled.isEnabled()) continue;
                treeSet2.add(enabled.getName());
            }
        }
        if (bl) {
            this.getProperties().setEnabledClusters(treeSet.toArray(new String[treeSet.size()]));
        } else {
            for (ClusterNode clusterNode : this.libChildren.extraNodes) {
                arrayList.add(clusterNode.getClusterInfo());
                if (!clusterNode.isEnabled()) continue;
                for (Node node : clusterNode.getChildren().getNodes()) {
                    enabled = (Enabled)node;
                    if (enabled.isEnabled()) continue;
                    treeSet2.add(enabled.getName());
                }
            }
            this.getProperties().setClusterPath(arrayList);
        }
        this.getProperties().setDisabledModules(treeSet2.toArray(new String[treeSet2.size()]));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.platformsPanel = new JPanel();
        this.platformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.platform = new JLabel();
        this.managePlafsButton = new JButton();
        this.javaPlatformLabel = new JLabel();
        this.javaPlatformCombo = new JComboBox();
        this.javaPlatformButton = new JButton();
        this.filler = new JLabel();
        this.view = new OutlineView();
        this.viewLabel = new JLabel();
        this.buttonsPanel = new JPanel();
        this.resolveButtonPanel = new JPanel();
        this.hidingPanel = new JPanel();
        this.resolveButton = new JButton();
        this.addProjectButton = new JButton();
        this.addClusterButton = new JButton();
        this.removeButton = new JButton();
        this.editButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)"jLabel1");
        this.setLayout(new GridBagLayout());
        this.platformsPanel.setLayout(new GridBagLayout());
        this.platformValue.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SuiteCustomizerLibraries.this.platformValueItemStateChanged(itemEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.platformsPanel.add((Component)this.platformValue, gridBagConstraints);
        this.platform.setLabelFor(this.platformValue);
        Mnemonics.setLocalizedText((JLabel)this.platform, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.platformsPanel.add((Component)this.platform, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.managePlafsButton, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"CTL_ManagePlatform_a"));
        this.managePlafsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SuiteCustomizerLibraries.this.managePlatforms(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.platformsPanel.add((Component)this.managePlafsButton, gridBagConstraints);
        this.javaPlatformLabel.setLabelFor(this.javaPlatformCombo);
        Mnemonics.setLocalizedText((JLabel)this.javaPlatformLabel, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_Java_Platform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformsPanel.add((Component)this.javaPlatformLabel, gridBagConstraints);
        this.javaPlatformCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SuiteCustomizerLibraries.this.javaPlatformComboItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformsPanel.add((Component)this.javaPlatformCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.javaPlatformButton, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_Manage_Java_Platforms"));
        this.javaPlatformButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SuiteCustomizerLibraries.this.javaPlatformButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.platformsPanel.add((Component)this.javaPlatformButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.platformsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
        this.view.setBorder(UIManager.getBorder("ScrollPane.border"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.view, gridBagConstraints);
        this.viewLabel.setLabelFor((Component)this.view);
        Mnemonics.setLocalizedText((JLabel)this.viewLabel, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_PlatformModules"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 0, 2, 0);
        this.add((Component)this.viewLabel, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridLayout(1, 0, 5, 0));
        this.resolveButtonPanel.setLayout(new CardLayout());
        this.hidingPanel.setLayout(null);
        this.resolveButtonPanel.add((Component)this.hidingPanel, "card3");
        this.resolveButton.setForeground(Color.red);
        Mnemonics.setLocalizedText((AbstractButton)this.resolveButton, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_ResolveButton"));
        this.resolveButton.setToolTipText(NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_ResolveButtonTooltip"));
        this.resolveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SuiteCustomizerLibraries.this.resolveButtonActionPerformed(actionEvent);
            }
        });
        this.resolveButtonPanel.add((Component)this.resolveButton, "card2");
        this.buttonsPanel.add(this.resolveButtonPanel);
        Mnemonics.setLocalizedText((AbstractButton)this.addProjectButton, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_AddProject"));
        this.addProjectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SuiteCustomizerLibraries.this.addProjectButtonActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.addProjectButton);
        Mnemonics.setLocalizedText((AbstractButton)this.addClusterButton, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_AddCluster"));
        this.addClusterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SuiteCustomizerLibraries.this.addClusterButtonActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.addClusterButton);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"CTL_RemoveButton"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SuiteCustomizerLibraries.this.removeButtonActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.removeButton);
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"CTL_EditButton"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SuiteCustomizerLibraries.this.editButtonActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.editButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.buttonsPanel, gridBagConstraints);
    }

    private void javaPlatformButtonActionPerformed(ActionEvent actionEvent) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)((JavaPlatform)this.javaPlatformCombo.getSelectedItem()));
    }

    private void javaPlatformComboItemStateChanged(ItemEvent itemEvent) {
        this.getProperties().setActiveJavaPlatform((JavaPlatform)this.javaPlatformCombo.getSelectedItem());
    }

    private void platformValueItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.manager.setRootContext((Node)this.waitRoot);
            this.store();
            Logger logger = Logger.getLogger(SuiteCustomizerLibraries.class.getName());
            logger.log(Level.FINE, "platformValueItemStateChanged, setting plaf -->" + ((NbPlatform)this.platformValue.getSelectedItem()).getLabel());
            this.getProperties().setActivePlatform((NbPlatform)this.platformValue.getSelectedItem());
            this.updateJavaPlatformEnabled();
        }
    }

    private void managePlatforms(ActionEvent actionEvent) {
        NbPlatformCustomizer.showCustomizer();
        this.refreshPlatforms();
    }

    private void addProjectButtonActionPerformed(ActionEvent actionEvent) {
        Project project = UIUtil.chooseProject(this);
        if (project != null) {
            ClusterInfo.QueryResult queryResult = ClusterInfo.canCreate(project);
            String string = null;
            switch (queryResult) {
                case NOT_A_NBM_PROJECT: {
                    string = "MSG_TryingToAddNonNBModuleOnClusterPath";
                    break;
                }
                case NBORG_PROJECT_NOT_ALLOWED: {
                    string = "MSG_TryingToAddNBORGModuleOnClusterPath";
                    break;
                }
                case SUITE_COMP_NOT_ALLOWED: {
                    SuiteProvider suiteProvider = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
                    FileObject fileObject = FileUtil.toFileObject((File)suiteProvider.getSuiteDirectory());
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"MSG_AddSuiteInstead", (Object)ProjectUtils.getInformation((Project)project).getDisplayName(), (Object)Util.getDisplayName(fileObject)), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (confirmation.getValue() == NotifyDescriptor.YES_OPTION) {
                        try {
                            project = ProjectManager.getDefault().findProject(fileObject);
                            assert (ClusterInfo.canCreate(project) == ClusterInfo.QueryResult.OK);
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(16, (Throwable)iOException);
                        }
                        break;
                    }
                    return;
                }
            }
            if (string != null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)string, (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            } else {
                this.addProjectCluster(ClusterInfo.create(project, true), true);
            }
        }
    }

    private void addClusterButtonActionPerformed(ActionEvent actionEvent) {
        ClusterInfo clusterInfo = EditClusterPanel.showAddDialog(this.getProperties().getProject());
        if (clusterInfo != null) {
            if (this.libChildren.findCluster(clusterInfo.getClusterDir()) != null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"MSG_ClusterAlreadyOnClusterPath", (Object)clusterInfo.getClusterDir())));
                return;
            }
            this.addExtCluster(clusterInfo);
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        this.libChildren.removeClusters(this.manager.getSelectedNodes());
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.manager.getSelectedNodes();
        assert (nodeArray.length == 1);
        ClusterNode clusterNode = (ClusterNode)nodeArray[0];
        assert (this.isExternalCluster(clusterNode));
        ClusterInfo clusterInfo = EditClusterPanel.showEditDialog(clusterNode.getClusterInfo(), this.getProperties().getProject());
        if (clusterInfo != null) {
            clusterNode.setClusterInfo(clusterInfo);
        }
    }

    private void resolveButtonActionPerformed(ActionEvent actionEvent) {
        if (this.resolveFixInfo == null || !this.resolveFixInfo.fixable) {
            return;
        }
        for (Node node : this.libChildren.getNodes()) {
            ClusterNode clusterNode = (ClusterNode)node;
            Object object = clusterNode.getChildren().getNodes();
            int n = ((Node[])object).length;
            for (int i = 0; i < n; ++i) {
                Node node2 = object[i];
                String string = node2.getName();
                if (!this.resolveFixInfo.toAdd.contains(string)) continue;
                Enabled enabled = (Enabled)node2;
                assert (!enabled.isEnabled());
                enabled.setState(EnabledState.FULL_ENABLED, false);
            }
            if (clusterNode.getProject() == null || (object = (NbModuleProvider)clusterNode.getProject().getLookup().lookup(NbModuleProvider.class)) == null || object.getModuleType() != NbModuleProvider.STANDALONE || !this.resolveFixInfo.toAdd.contains(object.getCodeNameBase())) continue;
            assert (!clusterNode.isEnabled());
            ((Enabled)clusterNode).setState(EnabledState.FULL_ENABLED, false);
        }
        this.libChildren.setMergedKeys();
        this.resolveButton.setEnabled(false);
        this.updateDependencyWarnings(false);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.getProperties().getBrandingModel().isBrandingEnabled()) {
            Enabled enabled;
            Enabled enabled2;
            Node[] nodeArray;
            for (Node node : nodeArray = this.getExplorerManager().getRootContext().getChildren().getNodes()) {
                if (!(node instanceof Enabled)) continue;
                enabled2 = (Enabled)node;
                if (!enabled2.isEnabled()) {
                    return;
                }
                for (Node node2 : enabled2.getChildren().getNodes()) {
                    if (!(node2 instanceof Enabled) || (enabled = (Enabled)node2).isEnabled()) continue;
                    return;
                }
            }
            if (!UIUtil.showAcceptCancelDialog(SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.title.exclude_ide_modules"), SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.text.exclude_ide_modules"), SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.button.exclude"), SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.button.skip"), 3)) {
                return;
            }
            for (Node node : nodeArray) {
                if (!(node instanceof Enabled)) continue;
                enabled2 = (Enabled)node;
                if (enabled2.getName().startsWith("platform")) {
                    for (Node node2 : enabled2.getChildren().getNodes()) {
                        if (!(node2 instanceof Enabled) || !DISABLED_PLATFORM_MODULES.contains((enabled = (Enabled)node2).getName())) continue;
                        enabled.setEnabled(false);
                    }
                    continue;
                }
                enabled2.setEnabled(false);
            }
        }
    }

    private String formatEntryDesc(String string, String string2) throws MissingResourceException {
        String string3 = string2 != null ? (string2.startsWith("<html>") ? "<html>" + NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"SuiteCustomizerLibraries.HINT_module_desc", (Object)string, (Object)string2.substring(6)) : NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"SuiteCustomizerLibraries.HINT_module_desc", (Object)string, (Object)string2)) : NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"SuiteCustomizerLibraries.HINT_module_no_desc", (Object)string);
        return string3;
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(CustomizerDisplay.class, (String)string);
    }

    private void initAccessibility() {
        this.managePlafsButton.getAccessibleContext().setAccessibleDescription(SuiteCustomizerLibraries.getMessage("ACSD_ManagePlafsButton"));
        this.platformValue.getAccessibleContext().setAccessibleDescription(SuiteCustomizerLibraries.getMessage("ACSD_PlatformValue"));
        this.javaPlatformCombo.getAccessibleContext().setAccessibleDescription(SuiteCustomizerLibraries.getMessage("ACSD_JavaPlatformCombo"));
        this.javaPlatformButton.getAccessibleContext().setAccessibleDescription(SuiteCustomizerLibraries.getMessage("ACSD_JavaPlatformButton"));
        this.javaPlatformLabel.getAccessibleContext().setAccessibleDescription(SuiteCustomizerLibraries.getMessage("ACSD_JavaPlatformLbl"));
        this.platform.getAccessibleContext().setAccessibleDescription(SuiteCustomizerLibraries.getMessage("ACSD_PlatformLbl"));
    }

    private void updateDependencyWarnings(final boolean bl) {
        if (TEST || !this.extClustersLoaded) {
            return;
        }
        if (this.updateDependencyWarningsTask == null) {
            this.updateDependencyWarningsTask = this.RP.create(new Runnable(){

                public void run() {
                    if (bl) {
                        SuiteCustomizerLibraries.this.universe = null;
                    }
                    SuiteCustomizerLibraries.this.doUpdateDependencyWarnings();
                }
            });
        }
        this.updateDependencyWarningsTask.schedule(0);
    }

    static Set<UniverseModule> loadUniverseModules(ModuleEntry[] moduleEntryArray, Set<NbModuleProject> set, Set<ModuleEntry> set2) throws IOException {
        LinkedHashSet<UniverseModule> linkedHashSet = new LinkedHashSet<UniverseModule>();
        for (NbModuleProject nbModuleProject : set) {
            linkedHashSet.add(new SuiteModule(nbModuleProject));
        }
        for (ModuleEntry moduleEntry : moduleEntryArray) {
            linkedHashSet.add(new PlatformModule(moduleEntry));
        }
        for (ModuleEntry moduleEntry : set2) {
            linkedHashSet.add(new PlatformModule(moduleEntry));
        }
        return linkedHashSet;
    }

    /*
     * WARNING - void declaration
     */
    FixInfo findWarning(Set<UniverseModule> set, Set<File> set2, Set<String> set3) {
        Object object;
        Object object2;
        TreeMap<String, UniverseModule> treeMap = new TreeMap<String, UniverseModule>();
        HashSet<UniverseModule> hashSet = new HashSet<UniverseModule>();
        HashMap<String, Set<UniverseModule>> hashMap = new HashMap<String, Set<UniverseModule>>();
        for (UniverseModule collection2 : set) {
            object2 = collection2.getCodeNameBase();
            object = collection2.getCluster();
            assert (object != null);
            if (!set2.contains(object) || set3.contains(object2)) {
                hashSet.add(collection2);
            }
            treeMap.put((String)object2, collection2);
            this.addProviders(collection2, hashMap);
        }
        FixInfo fixInfo = new FixInfo();
        Collection collection = treeMap.values();
        block1: while (true) {
            void var8_10;
            object2 = var8_10.iterator();
            while (object2.hasNext()) {
                object = (UniverseModule)object2.next();
                if (hashSet.contains(object)) continue;
                fixInfo.resetCurrentAdditions();
                boolean bl = this.findWarning((UniverseModule)object, treeMap, hashMap, hashSet, fixInfo);
                if (!bl) continue;
                if (!fixInfo.fixable) {
                    return fixInfo;
                }
                if (fixInfo.isEmpty()) continue;
                assert (fixInfo.fixable);
                String string = (object2.hasNext() ? (UniverseModule)object2.next() : object).getCodeNameBase();
                Collection collection2 = treeMap.tailMap(fixInfo.getRestartPointFor(string)).values();
                continue block1;
            }
            break;
        }
        return fixInfo;
    }

    private void addProviders(UniverseModule universeModule, Map<String, Set<UniverseModule>> map) {
        for (String string : universeModule.getProvidedTokens()) {
            Set<UniverseModule> set = map.get(string);
            if (set == null) {
                set = new TreeSet<UniverseModule>(UNIVERSE_MODULE_COMPARATOR);
                map.put(string, set);
            }
            set.add(universeModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateDependencyWarnings() {
        try {
            Object object = this.lock;
            synchronized (object) {
                AbstractSet abstractSet;
                if (this.universe == null) {
                    abstractSet = new HashSet<NbModuleProject>(this.getProperties().getSubModules());
                    this.libChildren.getProjectModules(abstractSet);
                    this.universe = SuiteCustomizerLibraries.loadUniverseModules(this.platformModules, abstractSet, this.extraBinaryModules);
                }
                abstractSet = new TreeSet();
                TreeSet<String> treeSet = new TreeSet<String>();
                abstractSet.add(ClusterUtils.getClusterDirectory(this.getProperties().getProject()));
                for (Node node : this.libChildren.getNodes()) {
                    ClusterNode clusterNode;
                    if (!(node instanceof ClusterNode) || !(clusterNode = (ClusterNode)node).isEnabled()) continue;
                    abstractSet.add(clusterNode.getClusterInfo().getClusterDir());
                    for (Node node2 : clusterNode.getChildren().getNodes()) {
                        Enabled enabled;
                        if (!(node2 instanceof Enabled) || (enabled = (Enabled)node2).isEnabled()) continue;
                        treeSet.add(enabled.getName());
                    }
                }
                final FixInfo fixInfo = this.findWarning(this.universe, abstractSet, treeSet);
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            CardLayout cardLayout = (CardLayout)SuiteCustomizerLibraries.this.resolveButtonPanel.getLayout();
                            if (!fixInfo.isEmpty()) {
                                String string = fixInfo.warning[0];
                                Object[] objectArray = new String[fixInfo.warning.length - 1];
                                System.arraycopy(fixInfo.warning, 1, objectArray, 0, objectArray.length);
                                SuiteCustomizerLibraries.this.category.setErrorMessage(NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)string, (Object[])objectArray));
                                SuiteCustomizerLibraries.this.resolveFixInfo = fixInfo;
                                SuiteCustomizerLibraries.this.resolveButton.setEnabled(fixInfo.fixable);
                                cardLayout.last(SuiteCustomizerLibraries.this.resolveButtonPanel);
                            } else {
                                SuiteCustomizerLibraries.this.category.setErrorMessage(null);
                                cardLayout.first(SuiteCustomizerLibraries.this.resolveButtonPanel);
                            }
                        }
                        finally {
                            SuiteCustomizerLibraries.this.manager.setRootContext((Node)SuiteCustomizerLibraries.this.realRoot);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            Util.err.notify(1, (Throwable)exception);
            this.category.setErrorMessage(NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"MSG_ErrorParsingMetadata", (Object)exception.getLocalizedMessage()));
        }
    }

    private boolean findWarning(UniverseModule universeModule, Map<String, UniverseModule> map, Map<String, Set<UniverseModule>> map2, Set<UniverseModule> set, FixInfo fixInfo) {
        Object object;
        TreeSet<Dependency> treeSet = new TreeSet<Dependency>(new Comparator<Dependency>(){

            @Override
            public int compare(Dependency dependency, Dependency dependency2) {
                return dependency.getName().compareTo(dependency2.getName());
            }
        });
        String string = universeModule.getDisplayName();
        ClusterNode clusterNode = this.libChildren.findCluster(universeModule.getCluster());
        if (clusterNode == null) {
            return false;
        }
        String string2 = clusterNode.getDisplayName();
        treeSet.addAll(universeModule.getModuleDependencies());
        boolean bl = false;
        for (Dependency object2 : treeSet) {
            String string3;
            Object object3;
            int stringArray;
            int set2;
            String bl2;
            object = object2.getName();
            int n = ((String)object).lastIndexOf(47);
            if (n == -1) {
                bl2 = object;
                set2 = -1;
                stringArray = -1;
            } else {
                bl2 = ((String)object).substring(0, n);
                object3 = ((String)object).substring(n + 1);
                int n2 = ((String)object3).lastIndexOf(45);
                if (n2 == -1) {
                    set2 = stringArray = Integer.parseInt((String)object3);
                } else {
                    set2 = Integer.parseInt(((String)object3).substring(0, n2));
                    stringArray = Integer.parseInt(((String)object3).substring(n2 + 1));
                }
            }
            object3 = map.get(bl2);
            if (object3 == null) {
                FixInfo.putUnfixable(fixInfo, new String[]{"ERR_no_dep", string, string2, bl2});
                return true;
            }
            String string4 = object3.getDisplayName();
            if (set.contains(object3)) {
                clusterNode = this.libChildren.findCluster(object3.getCluster());
                if (clusterNode == null) {
                    return false;
                }
                string3 = clusterNode.getDisplayName();
                FixInfo.putFixable(fixInfo, bl2, new String[]{"ERR_excluded_dep", string, string2, string4, string3});
                set.remove(object3);
                bl = true;
            }
            if (object3.getReleaseVersion() < set2 || object3.getReleaseVersion() > stringArray) {
                FixInfo.putUnfixable(fixInfo, new String[]{"ERR_bad_dep_mrv", string, string2, string4});
                return true;
            }
            if (object2.getComparison() == 1) {
                string3 = new SpecificationVersion(object2.getVersion());
                SpecificationVersion specificationVersion = object3.getSpecificationVersion();
                if (specificationVersion != null && specificationVersion.compareTo((Object)string3) >= 0) continue;
                FixInfo.putUnfixable(fixInfo, new String[]{"ERR_bad_dep_spec", string, string2, string4});
                return true;
            }
            if (object2.getComparison() != 2 || (string3 = object2.getVersion()).equals("*") || string3.equals(object3.getImplementationVersion())) continue;
            FixInfo.putUnfixable(fixInfo, new String[]{"ERR_bad_dep_impl", string, string2, string4});
            return true;
        }
        for (String string5 : new TreeSet<String>(universeModule.getRequiredTokens())) {
            object = null;
            boolean bl2 = false;
            Set<UniverseModule> set2 = map2.get(string5);
            if (set2 != null) {
                for (UniverseModule universeModule2 : set2) {
                    if (set.contains(universeModule2)) {
                        if (object != null) continue;
                        object = universeModule2;
                        continue;
                    }
                    bl2 = true;
                    break;
                }
            }
            if (bl2) continue;
            if (object != null) {
                clusterNode = this.libChildren.findCluster(object.getCluster());
                if (clusterNode == null) {
                    return false;
                }
                String[] stringArray = new String[]{"ERR_only_excluded_providers", string5, string, string2, object.getDisplayName(), clusterNode.getDisplayName()};
                if (set2.size() == 1) {
                    set.remove(object);
                    FixInfo.putFixable(fixInfo, object.getCodeNameBase(), stringArray);
                    bl = true;
                    continue;
                }
                FixInfo.putUnfixable(fixInfo, stringArray);
                return true;
            }
            FixInfo.putUnfixable(fixInfo, new String[]{"ERR_no_providers", string5, string, string2});
            return true;
        }
        return bl;
    }

    private void updateJavaPlatformEnabled() {
        boolean bl = ((NbPlatform)this.platformValue.getSelectedItem()).getHarnessVersion() >= 2;
        this.javaPlatformCombo.setEnabled(bl);
        this.javaPlatformButton.setEnabled(bl);
    }

    static /* synthetic */ Comparator access$2400() {
        return MODULES_COMPARATOR;
    }

    static {
        DISABLED_PLATFORM_MODULES.add("org.netbeans.modules.autoupdate.services");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.modules.autoupdate.ui");
        DISABLED_PLATFORM_MODULES.add("org.openide.execution");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.core.execution");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.core.multiview");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.modules.favorites");
        DISABLED_PLATFORM_MODULES.add("org.openide.compat");
        DISABLED_PLATFORM_MODULES.add("org.openide.util.enumerations");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.modules.core.kit");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.modules.templates");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.libs.jsr223");
        DISABLED_PLATFORM_MODULES.add("org.openide.options");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.api.visual");
        NO_ACTIONS = new SystemAction[0];
        ENABLED_PROP_TEMPLATE = new EnabledProp(null);
        ORIGIN_PROP_TEMPLATE = new OriginProp(null);
        UNIVERSE_MODULE_COMPARATOR = new Comparator<UniverseModule>(){
            Collator COLL = Collator.getInstance();

            @Override
            public int compare(UniverseModule universeModule, UniverseModule universeModule2) {
                return this.COLL.compare(universeModule.getDisplayName(), universeModule2.getDisplayName());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FixInfo {
        String[] warning;
        boolean fixable = true;
        Set<String> toAdd = new HashSet<String>();
        private SortedSet<String> currentAdditions = new TreeSet<String>();

        FixInfo() {
        }

        private static void putFixable(FixInfo fixInfo, String string, String[] stringArray) {
            if (!fixInfo.fixable) {
                throw new IllegalStateException("Cannot put fixable error on top of unfixable one.\\nExisting: " + Arrays.toString(fixInfo.warning) + "\\nNew: " + Arrays.toString(stringArray));
            }
            if (fixInfo.warning == null) {
                fixInfo.warning = stringArray;
            }
            fixInfo.toAdd.add(string);
            fixInfo.currentAdditions.add(string);
        }

        private static void putUnfixable(FixInfo fixInfo, String[] stringArray) {
            fixInfo.fixable = false;
        }

        private boolean isEmpty() {
            return this.warning == null;
        }

        public SortedSet<String> getCurrentAdditions() {
            return this.currentAdditions;
        }

        private void resetCurrentAdditions() {
            this.currentAdditions.clear();
        }

        public String getRestartPointFor(String string) {
            this.currentAdditions.add(string);
            return this.currentAdditions.first();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SuiteModule
    extends AbstractUniverseModule {
        private final NbModuleProject project;
        private final Set<Dependency> dependencies;

        public SuiteModule(NbModuleProject nbModuleProject) {
            super(ManifestManager.getInstance(nbModuleProject.getManifest(), false));
            this.project = nbModuleProject;
            this.dependencies = new HashSet<Dependency>();
            Element element = nbModuleProject.getPrimaryConfigurationData();
            Element element2 = Util.findElement(element, "module-dependencies", "http://www.netbeans.org/ns/nb-module-project/3");
            assert (element2 != null) : "Malformed metadata in " + nbModuleProject;
            for (Element element3 : Util.findSubElements(element2)) {
                Element element4;
                Element element5 = Util.findElement(element3, "run-dependency", "http://www.netbeans.org/ns/nb-module-project/3");
                if (element5 == null) continue;
                String string = Util.findText(Util.findElement(element3, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/3"));
                Element element6 = Util.findElement(element5, "release-version", "http://www.netbeans.org/ns/nb-module-project/3");
                if (element6 != null) {
                    string = string + '/' + Util.findText(element6);
                }
                if ((element4 = Util.findElement(element5, "specification-version", "http://www.netbeans.org/ns/nb-module-project/3")) != null) {
                    string = string + " > " + Util.findText(element4);
                } else {
                    Element element7 = Util.findElement(element5, "implementation-version", "http://www.netbeans.org/ns/nb-module-project/3");
                    if (element7 != null) {
                        string = string + " = *";
                    }
                }
                this.dependencies.addAll(Dependency.create((int)1, (String)string));
            }
        }

        @Override
        public String getCodeNameBase() {
            return this.project.getCodeNameBase();
        }

        @Override
        public SpecificationVersion getSpecificationVersion() {
            String string = this.project.getSpecVersion();
            return string != null ? new SpecificationVersion(string) : null;
        }

        @Override
        public Set<Dependency> getModuleDependencies() {
            return this.dependencies;
        }

        @Override
        public File getCluster() {
            return ClusterUtils.getClusterDirectory(this.project);
        }

        @Override
        public String getDisplayName() {
            return ProjectUtils.getInformation((Project)this.project).getDisplayName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PlatformModule
    extends AbstractUniverseModule {
        private final ModuleEntry entry;

        public PlatformModule(ModuleEntry moduleEntry) throws IOException {
            super(ManifestManager.getInstanceFromJAR(moduleEntry.getJarLocation()));
            this.entry = moduleEntry;
        }

        @Override
        public String getCodeNameBase() {
            return this.entry.getCodeNameBase();
        }

        @Override
        public SpecificationVersion getSpecificationVersion() {
            String string = this.entry.getSpecificationVersion();
            return string != null ? new SpecificationVersion(string) : null;
        }

        @Override
        public Set<Dependency> getModuleDependencies() {
            return this.mm.getModuleDependencies();
        }

        @Override
        public File getCluster() {
            return this.entry.getClusterDirectory();
        }

        @Override
        public String getDisplayName() {
            return this.entry.getLocalizedName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractUniverseModule
    implements UniverseModule {
        protected final ManifestManager mm;

        protected AbstractUniverseModule(ManifestManager manifestManager) {
            this.mm = manifestManager;
        }

        @Override
        public int getReleaseVersion() {
            String string = this.mm.getReleaseVersion();
            return string != null ? Integer.parseInt(string) : -1;
        }

        @Override
        public String getImplementationVersion() {
            return this.mm.getImplementationVersion();
        }

        @Override
        public Set<String> getProvidedTokens() {
            return new HashSet<String>(Arrays.asList(this.mm.getProvidedTokens()));
        }

        @Override
        public Set<String> getRequiredTokens() {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.mm.getRequiredTokens()));
            hashSet.addAll(Arrays.asList(this.mm.getNeededTokens()));
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.startsWith("org.openide.modules.ModuleFormat") && !string.startsWith("org.openide.modules.os.")) continue;
                iterator.remove();
            }
            hashSet.addAll(Arrays.asList(this.mm.getNeededTokens()));
            return hashSet;
        }

        public String toString() {
            return this.getCodeNameBase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface UniverseModule {
        public String getCodeNameBase();

        public int getReleaseVersion();

        public SpecificationVersion getSpecificationVersion();

        public String getImplementationVersion();

        public Set<String> getProvidedTokens();

        public Set<String> getRequiredTokens();

        public Set<Dependency> getModuleDependencies();

        public File getCluster();

        public String getDisplayName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LibrariesChildren
    extends Children.Keys<ClusterNode> {
        private SortedSet<ClusterNode> platformNodes = new TreeSet<ClusterNode>(SuiteCustomizerLibraries.access$2400());
        private List<ClusterNode> extraNodes = new ArrayList<ClusterNode>();
        private ClusterNode selfCN;

        private LibrariesChildren() {
        }

        protected Node[] createNodes(ClusterNode clusterNode) {
            return new Node[]{clusterNode};
        }

        protected void addNotify() {
            super.addNotify();
            this.setMergedKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        private ClusterNode findCluster(File file) {
            for (ClusterNode clusterNode : this.extraNodes) {
                if (!clusterNode.getClusterInfo().getClusterDir().equals(file)) continue;
                return clusterNode;
            }
            for (ClusterNode clusterNode : this.platformNodes) {
                if (!clusterNode.getClusterInfo().getClusterDir().equals(file)) continue;
                return clusterNode;
            }
            if (ClusterUtils.getClusterDirectory(SuiteCustomizerLibraries.this.getProperties().getProject()).equals(file)) {
                if (this.selfCN == null) {
                    this.selfCN = SuiteCustomizerLibraries.this.createSuiteNode(ClusterInfo.create(SuiteCustomizerLibraries.this.getProperties().getProject(), true));
                }
                return this.selfCN;
            }
            return null;
        }

        private void getProjectModules(Set<NbModuleProject> set) {
            for (ClusterNode clusterNode : this.extraNodes) {
                ClusterInfo clusterInfo = clusterNode.getClusterInfo();
                Project project = clusterInfo.getProject();
                if (project == null) continue;
                NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
                if (nbModuleProvider != null) {
                    set.add((NbModuleProject)project);
                    continue;
                }
                for (Node node : clusterNode.getChildren().getNodes()) {
                    SuiteComponentNode suiteComponentNode = (SuiteComponentNode)node;
                    set.add((NbModuleProject)suiteComponentNode.getProject());
                }
            }
        }

        private void removeClusters(Node[] nodeArray) {
            this.extraNodes.removeAll(Arrays.asList(nodeArray));
            this.setMergedKeys();
            SuiteCustomizerLibraries.this.updateDependencyWarnings(true);
        }

        private void setMergedKeys() {
            ArrayList<ClusterNode> arrayList = new ArrayList<ClusterNode>(this.platformNodes);
            arrayList.addAll(this.extraNodes);
            for (ClusterNode clusterNode : arrayList) {
                clusterNode.updateClusterState();
            }
            this.setKeys(arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OriginProp
    extends PropertySupport.ReadOnly<String> {
        private Enabled node;

        public PropertyEditor getPropertyEditor() {
            return null;
        }

        private OriginProp(Enabled enabled) {
            super("origin", String.class, SuiteCustomizerLibraries.getMessage("LBL_Origin"), SuiteCustomizerLibraries.getMessage("LBL_OriginShortDesc"));
            this.node = enabled;
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return this.node == null ? null : this.node.getOrigin();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EnabledProp
    extends PropertySupport.ReadWrite<Boolean> {
        private Enabled node;
        private PropertyEditor editor;

        public EnabledProp(Enabled enabled) {
            super("enabled", Boolean.TYPE, SuiteCustomizerLibraries.getMessage("LBL_ModuleListEnabled"), SuiteCustomizerLibraries.getMessage("LBL_ModuleListEnabledShortDescription"));
            this.node = enabled;
        }

        public void setValue(Boolean bl) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.node.setEnabled(bl);
        }

        public Boolean getValue() throws IllegalAccessException, InvocationTargetException {
            Children children = this.node.getChildren();
            Logger logger = Logger.getLogger(EnabledProp.class.getName());
            if (children == Children.LEAF) {
                logger.log(Level.FINE, "Node '" + this.node.getName() + "' is LEAF, enabled=" + this.node.isEnabled());
                return this.node.isEnabled();
            }
            if (this.node.getState() == EnabledState.PART_ENABLED) {
                logger.log(Level.FINE, "Node '" + this.node.getName() + "', enabled=null");
                return null;
            }
            logger.log(Level.FINE, "Node '" + this.node.getName() + "', enabled=" + this.node.isEnabled());
            return this.node.isEnabled();
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                this.editor = super.getPropertyEditor();
            }
            return this.editor;
        }
    }

    final class BinaryModuleNode
    extends Enabled {
        private final boolean deprecated;

        public BinaryModuleNode(ModuleEntry moduleEntry, boolean bl) {
            super(Children.LEAF, bl);
            this.deprecated = moduleEntry.isDeprecated();
            String string = moduleEntry.getCodeNameBase();
            this.setName(string);
            this.setDisplayName(moduleEntry.getLocalizedName());
            String string2 = moduleEntry.getShortDescription();
            this.setShortDescription(SuiteCustomizerLibraries.this.formatEntryDesc(string, string2));
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public boolean isPlatformNode() {
            return ((Enabled)this.getParentNode()).isPlatformNode();
        }

        public String getOrigin() {
            if (this.isPlatformNode()) {
                return SuiteCustomizerLibraries.getMessage("LBL_PlatformOrigin");
            }
            return SuiteCustomizerLibraries.getMessage("LBL_ExtCluster");
        }

        public Project getProject() {
            return null;
        }
    }

    final class ClusterNode
    extends Enabled {
        private ClusterInfo ci;

        public ClusterNode(ClusterInfo clusterInfo, Children children) {
            super(children, clusterInfo.isEnabled());
            this.ci = clusterInfo;
            Project project = clusterInfo.getProject();
            if (project != null) {
                this.setName(ProjectUtils.getInformation((Project)project).getDisplayName());
                NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
                if (nbModuleProvider != null) {
                    String string = ((LocalizedBundleInfo.Provider)project.getLookup().lookup(LocalizedBundleInfo.Provider.class)).getLocalizedBundleInfo().getShortDescription();
                    this.setShortDescription(SuiteCustomizerLibraries.this.formatEntryDesc(nbModuleProvider.getCodeNameBase(), string));
                } else {
                    this.setShortDescription(clusterInfo.getClusterDir().getAbsolutePath());
                }
            } else {
                this.setName(clusterInfo.getClusterDir().getName());
                this.setShortDescription(clusterInfo.getClusterDir().getAbsolutePath());
            }
        }

        private ClusterInfo getClusterInfo() {
            return this.ci;
        }

        private void setClusterInfo(ClusterInfo clusterInfo) {
            if (!this.ci.equals(clusterInfo)) {
                this.ci = clusterInfo;
                SuiteCustomizerLibraries.this.refresh();
            }
        }

        public void setState(EnabledState enabledState, boolean bl) {
            super.setState(enabledState, bl);
            if (this.ci != null && this.ci.isEnabled() != this.isEnabled()) {
                this.ci = ClusterInfo.createFromCP(this.ci.getClusterDir(), this.ci.getProject(), this.ci.isPlatformCluster(), this.ci.getSourceRoots(), this.ci.getJavadocRoots(), this.isEnabled());
            }
        }

        public boolean isPlatformNode() {
            return this.ci.isPlatformCluster();
        }

        public String getOrigin() {
            if (this.isPlatformNode()) {
                return SuiteCustomizerLibraries.getMessage("LBL_PlatformOrigin");
            }
            if (this.getProject() == null) {
                return SuiteCustomizerLibraries.getMessage("LBL_ExtCluster");
            }
            NbModuleProvider nbModuleProvider = (NbModuleProvider)this.getProject().getLookup().lookup(NbModuleProvider.class);
            if (nbModuleProvider == null) {
                return SuiteCustomizerLibraries.getMessage("LBL_SuiteProject");
            }
            if (nbModuleProvider.getModuleType() == NbModuleProvider.STANDALONE) {
                return SuiteCustomizerLibraries.getMessage("LBL_StandaloneProject");
            }
            assert (false) : "Shouldn't contain NB.org module or suite component project";
            return null;
        }

        public Project getProject() {
            return this.ci.getProject();
        }

        public boolean isDeprecated() {
            return false;
        }
    }

    final class SuiteComponentNode
    extends Enabled {
        private Project project;

        public SuiteComponentNode(Project project, boolean bl) {
            super(Children.LEAF, bl);
            this.project = project;
            NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
            if (nbModuleProvider == null) {
                String string = NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"MSG_NotANBMProject", (Object)FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()));
                throw new IllegalArgumentException(string);
            }
            if (nbModuleProvider.getModuleType() != NbModuleProvider.SUITE_COMPONENT) {
                String string = NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"MSG_NotASuiteComponentProject", (Object)FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()));
                throw new IllegalArgumentException(string);
            }
            String string = nbModuleProvider.getCodeNameBase();
            this.setName(string);
            this.setDisplayName(ProjectUtils.getInformation((Project)project).getDisplayName());
            String string2 = ((LocalizedBundleInfo.Provider)project.getLookup().lookup(LocalizedBundleInfo.Provider.class)).getLocalizedBundleInfo().getShortDescription();
            this.setShortDescription(SuiteCustomizerLibraries.this.formatEntryDesc(string, string2));
        }

        public boolean isDeprecated() {
            return ManifestManager.getInstance(Util.getManifest(((NbModuleProvider)this.project.getLookup().lookup(NbModuleProvider.class)).getManifestFile()), false).isDeprecated();
        }

        public boolean isPlatformNode() {
            return false;
        }

        public String getOrigin() {
            return SuiteCustomizerLibraries.getMessage("LBL_SuiteComponent");
        }

        public Project getProject() {
            return this.project;
        }
    }

    abstract class Enabled
    extends AbstractNode {
        private EnabledState state;

        Enabled(Children children, boolean bl) {
            super(children);
            this.setState(bl ? EnabledState.FULL_ENABLED : EnabledState.DISABLED, false);
            Sheet sheet = Sheet.createDefault();
            Sheet.Set set = sheet.get("properties");
            set.put((Node.Property)new EnabledProp(this));
            set.put((Node.Property)new OriginProp(this));
            this.setSheet(sheet);
            this.setIconBaseWithExtension(this.isLeaf() ? "org/netbeans/modules/apisupport/project/resources/module.png" : "org/netbeans/modules/apisupport/project/suite/resources/suite.png");
        }

        public String getHtmlDisplayName() {
            if (this.isDeprecated()) {
                try {
                    return "<html><strike>" + XMLUtil.toElementContent((String)this.getDisplayName()) + "</strike>";
                }
                catch (CharConversionException charConversionException) {
                    // empty catch block
                }
            }
            return null;
        }

        public Action getPreferredAction() {
            return null;
        }

        public SystemAction[] getActions(boolean bl) {
            return NO_ACTIONS;
        }

        public void setEnabled(boolean bl) {
            this.setState(bl ? EnabledState.FULL_ENABLED : EnabledState.DISABLED, true);
        }

        public boolean isEnabled() {
            return this.state != EnabledState.DISABLED;
        }

        public EnabledState getState() {
            return this.state;
        }

        public abstract boolean isPlatformNode();

        public abstract String getOrigin();

        protected void setState(EnabledState enabledState, boolean bl) {
            if (enabledState == this.state) {
                return;
            }
            this.state = enabledState;
            Logger logger = Logger.getLogger(EnabledProp.class.getName());
            logger.log(Level.FINE, "Node '" + this.getName() + "', state=" + (enabledState == EnabledState.DISABLED ? "disabled" : (enabledState == EnabledState.FULL_ENABLED ? "full enabled" : "part enabled")));
            if (bl) {
                EnabledState enabledState2 = enabledState == EnabledState.PART_ENABLED ? null : enabledState;
                for (Node node : this.getChildren().getNodes()) {
                    if (!(node instanceof Enabled)) continue;
                    Enabled enabled = (Enabled)node;
                    if (enabledState2 != null) {
                        enabled.setState(enabledState2, false);
                    }
                    enabled.firePropertyChange(null, null, null);
                }
                Node node = this.getParentNode();
                if (node instanceof Enabled) {
                    assert (enabledState != EnabledState.PART_ENABLED) : "Module node should not be passed ENABLED_PARTIALLY state";
                    Enabled enabled = (Enabled)node;
                    enabled.updateClusterState();
                    enabled.firePropertyChange(null, null, null);
                }
                SuiteCustomizerLibraries.this.updateDependencyWarnings(false);
            }
        }

        void updateClusterState() {
            if (this.getChildren() == Children.LEAF) {
                return;
            }
            boolean bl = true;
            boolean bl2 = true;
            for (Node node : this.getChildren().getNodes()) {
                Enabled enabled;
                if (node instanceof Enabled && !(bl &= (enabled = (Enabled)node).isEnabled()) && !(bl2 &= !enabled.isEnabled())) break;
            }
            if (bl) {
                this.setState(EnabledState.FULL_ENABLED, false);
            } else if (bl2) {
                this.setState(EnabledState.DISABLED, false);
            } else {
                this.setState(EnabledState.PART_ENABLED, false);
            }
        }

        public abstract Project getProject();

        protected abstract boolean isDeprecated();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EnabledState {
        FULL_ENABLED,
        PART_ENABLED,
        DISABLED;

    }

    private final class WaitNode
    extends AbstractNode {
        public WaitNode() {
            super(Children.LEAF);
            this.setDisplayName(CustomizerComponentFactory.WAIT_VALUE);
            this.setIconBaseWithExtension(SuiteCustomizerLibraries.WAIT_ICON_PATH);
        }
    }
}

