/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.EditDependencyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.JavaPlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.modules.java.api.common.project.ui.customizer.ClassPathListCellRenderer;
import org.netbeans.modules.java.api.common.project.ui.customizer.EditMediator;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;

public class CustomizerLibraries
extends NbPropertyPanel.Single {
    private EditMediator.ListComponent emListComp;
    private Map<File, Boolean> isJarExportedMap = Collections.synchronizedMap(new HashMap());
    private ProjectXMLManager pxml;
    private Logger LOG = Logger.getLogger(CustomizerLibraries.class.getName());
    private static final Pattern checkWrappedJarPat = Pattern.compile("^(.*)release[\\\\/]modules[\\\\/]ext[\\\\/]([^\\\\/]+)$");
    private JButton addDepButton;
    private JButton addJarButton;
    private JButton addLibrary;
    private JButton addTokenButton;
    private JList dependencyList;
    private JScrollPane dependencySP;
    private JButton editButton;
    private JButton editDepButton;
    private JButton exportButton;
    private JLabel jLabel1;
    private JPanel jPanelJars;
    private JPanel jPanelModules;
    private JPanel jPanelTokens;
    private JTabbedPane jTabbedPane1;
    private JButton javaPlatformButton;
    private JComboBox javaPlatformCombo;
    private JLabel javaPlatformLabel;
    private JButton managePlafsButton;
    private JLabel moduleDepsLabel;
    private JLabel platform;
    private JComboBox platformValue;
    private JPanel platformsPanel;
    private JButton removeButton;
    private JButton removeDepButton;
    private JButton removeTokenButton;
    private JList reqTokenList;
    private JScrollPane reqTokenSP;
    private JLabel requiredTokensLabel;
    private JList wrappedJarsList;
    private JScrollPane wrappedJarsSP;
    private RequestProcessor RP = new RequestProcessor(CustomizerLibraries.class.getName(), 1);
    private RequestProcessor.Task updateMapTask;
    private final Set[] selPkgsRef = new Set[1];
    private final File[][] jarsRef = new File[1][];

    public CustomizerLibraries(SingleModuleProperties singleModuleProperties, ProjectCustomizer.Category category) {
        super(singleModuleProperties, CustomizerLibraries.class, category);
        this.initComponents();
        this.initAccessibility();
        if (!this.getProperties().isSuiteComponent()) {
            this.addLibrary.setVisible(false);
            Mnemonics.setLocalizedText((AbstractButton)this.addDepButton, (String)this.getMessage("CTL_AddButton"));
        }
        this.refresh();
        this.dependencyList.setCellRenderer(CustomizerComponentFactory.getDependencyCellRenderer(false));
        this.javaPlatformCombo.setRenderer(JavaPlatformComponentFactory.javaPlatformListCellRenderer());
        this.removeTokenButton.setEnabled(false);
        this.wrappedJarsList.setCellRenderer(ClassPathListCellRenderer.createClassPathListRenderer((PropertyEvaluator)this.getProperties().getEvaluator(), (FileObject)FileUtil.toFileObject((File)this.getProperties().getProjectDirectoryFile())));
        DefaultButtonModel defaultButtonModel = new DefaultButtonModel();
        EditMediator.register((Project)this.getProperties().getProject(), (AntProjectHelper)this.getProperties().getHelper(), (ReferenceHelper)this.getProperties().getRefHelper(), (EditMediator.ListComponent)this.emListComp, (ButtonModel)defaultButtonModel, (ButtonModel)defaultButtonModel, (ButtonModel)defaultButtonModel, (ButtonModel)this.removeButton.getModel(), (ButtonModel)defaultButtonModel, (ButtonModel)defaultButtonModel, (ButtonModel)this.editButton.getModel(), null, null);
        this.attachListeners();
        this.pxml = new ProjectXMLManager((NbModuleProject)this.getProperties().getProject());
    }

    void refresh() {
        this.refreshJavaPlatforms();
        this.refreshPlatforms();
        this.platformValue.setEnabled(this.getProperties().isStandalone());
        this.managePlafsButton.setEnabled(this.getProperties().isStandalone());
        this.reqTokenList.setModel(this.getProperties().getRequiredTokenListModel());
        DefaultListModel defaultListModel = this.getProperties().getWrappedJarsListModel();
        this.wrappedJarsList.setModel(defaultListModel);
        this.emListComp = EditMediator.createListComponent((JList)this.wrappedJarsList);
        this.updateJarExportedMap();
        this.runDependenciesListModelRefresh();
        this.dependencyList.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                CustomizerLibraries.this.updateEnabled();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                CustomizerLibraries.this.updateEnabled();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                CustomizerLibraries.this.updateEnabled();
            }
        });
    }

    private void attachListeners() {
        this.platformValue.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CustomizerLibraries.this.getProperties().setActivePlatform((NbPlatform)CustomizerLibraries.this.platformValue.getSelectedItem());
                    CustomizerLibraries.this.runDependenciesListModelRefresh();
                }
            }
        });
        this.dependencyList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    CustomizerLibraries.this.updateEnabled();
                }
            }
        });
        this.javaPlatformCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CustomizerLibraries.this.getProperties().setActiveJavaPlatform((JavaPlatform)CustomizerLibraries.this.javaPlatformCombo.getSelectedItem());
                }
            }
        });
        this.reqTokenList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    CustomizerLibraries.this.removeTokenButton.setEnabled(CustomizerLibraries.this.reqTokenList.getSelectedIndex() != -1);
                }
            }
        });
        this.getProperties().getPublicPackagesModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == 0) {
                    CustomizerLibraries.this.updateJarExportedMap();
                }
            }
        });
    }

    private void runDependenciesListModelRefresh() {
        this.dependencyList.setModel(this.getProperties().getDependenciesListModelInBg(new Runnable(){

            public void run() {
                CustomizerLibraries.this.updateEnabled();
            }
        }));
        this.updateEnabled();
    }

    private void refreshJavaPlatforms() {
        this.javaPlatformCombo.setModel(JavaPlatformComponentFactory.javaPlatformListModel());
        this.javaPlatformCombo.setSelectedItem(this.getProperties().getActiveJavaPlatform());
    }

    private void refreshPlatforms() {
        this.platformValue.setModel(new PlatformComponentFactory.NbPlatformListModel(this.getProperties().getActivePlatform()));
        this.platformValue.requestFocusInWindow();
    }

    private void updateEnabled() {
        Boolean bl;
        int n;
        ClassPathSupport.Item item;
        boolean bl2 = !CustomizerComponentFactory.isWaitModel(this.dependencyList.getModel());
        boolean bl3 = this.dependencyList.getModel().getSize() > 0 && bl2 && this.getProperties().isActivePlatformValid() && this.dependencyList.getSelectedIndex() != -1;
        this.editDepButton.setEnabled(bl3);
        this.removeDepButton.setEnabled(bl3);
        this.addDepButton.setEnabled(bl2 && this.getProperties().isActivePlatformValid());
        boolean bl4 = this.getProperties().isNetBeansOrg() || this.getProperties().isStandalone() && ((NbPlatform)this.platformValue.getSelectedItem()).getHarnessVersion() >= 2;
        this.javaPlatformCombo.setEnabled(bl4);
        this.javaPlatformButton.setEnabled(bl4);
        int[] nArray = this.emListComp.getSelectedIndices();
        DefaultListModel defaultListModel = this.getProperties().getWrappedJarsListModel();
        boolean bl5 = false;
        int[] nArray2 = nArray;
        int n2 = nArray2.length;
        for (int i = 0; !(i >= n2 || (item = (ClassPathSupport.Item)defaultListModel.getElementAt(n = nArray2[i])).getType() == 0 && (bl5 |= (bl = this.isJarExportedMap.get(item.getResolvedFile())) == null || bl == false)); ++i) {
        }
        this.exportButton.setEnabled(bl5);
    }

    private CustomizerComponentFactory.DependencyListModel getDepListModel() {
        return (CustomizerComponentFactory.DependencyListModel)this.dependencyList.getModel();
    }

    private String getMessage(String string) {
        return NbBundle.getMessage(CustomizerLibraries.class, (String)string);
    }

    private void initComponents() {
        this.platformsPanel = new JPanel();
        this.platformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.platform = new JLabel();
        this.managePlafsButton = new JButton();
        this.javaPlatformLabel = new JLabel();
        this.javaPlatformCombo = new JComboBox();
        this.javaPlatformButton = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelModules = new JPanel();
        this.dependencySP = new JScrollPane();
        this.dependencyList = new JList();
        this.addDepButton = new JButton();
        this.addLibrary = new JButton();
        this.removeDepButton = new JButton();
        this.moduleDepsLabel = new JLabel();
        this.editDepButton = new JButton();
        this.jPanelTokens = new JPanel();
        this.reqTokenSP = new JScrollPane();
        this.reqTokenList = new JList();
        this.requiredTokensLabel = new JLabel();
        this.addTokenButton = new JButton();
        this.removeTokenButton = new JButton();
        this.jPanelJars = new JPanel();
        this.jLabel1 = new JLabel();
        this.wrappedJarsSP = new JScrollPane();
        this.wrappedJarsList = new JList();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.addJarButton = new JButton();
        this.exportButton = new JButton();
        this.setLayout(new BorderLayout());
        this.platformsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 12);
        this.platformsPanel.add((Component)this.platformValue, gridBagConstraints);
        this.platform.setLabelFor(this.platformValue);
        Mnemonics.setLocalizedText((JLabel)this.platform, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 12, 12);
        this.platformsPanel.add((Component)this.platform, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.managePlafsButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_ManagePlatform"));
        this.managePlafsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.managePlatforms(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.platformsPanel.add((Component)this.managePlafsButton, gridBagConstraints);
        this.javaPlatformLabel.setLabelFor(this.javaPlatformCombo);
        Mnemonics.setLocalizedText((JLabel)this.javaPlatformLabel, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_Java_Platform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformsPanel.add((Component)this.javaPlatformLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformsPanel.add((Component)this.javaPlatformCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.javaPlatformButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_Manage_Java_Platforms"));
        this.javaPlatformButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.javaPlatformButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.platformsPanel.add((Component)this.javaPlatformButton, gridBagConstraints);
        this.add((Component)this.platformsPanel, "First");
        this.jPanelModules.setLayout(new GridBagLayout());
        this.dependencySP.setViewportView(this.dependencyList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 5, 12);
        this.jPanelModules.add((Component)this.dependencySP, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addDepButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_AddDependency"));
        this.addDepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.addModuleDependency(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 5, 9);
        this.jPanelModules.add((Component)this.addDepButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addLibrary, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_AddNewLibrary"));
        this.addLibrary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.addLibraryActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 12, 9);
        this.jPanelModules.add((Component)this.addLibrary, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeDepButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_RemoveButton"));
        this.removeDepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.removeModuleDependency(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 5, 9);
        this.jPanelModules.add((Component)this.removeDepButton, gridBagConstraints);
        this.moduleDepsLabel.setLabelFor(this.dependencySP);
        Mnemonics.setLocalizedText((JLabel)this.moduleDepsLabel, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_ModuleDependencies"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.jPanelModules.add((Component)this.moduleDepsLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editDepButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_EditButton"));
        this.editDepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.editModuleDependency(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 12, 9);
        this.jPanelModules.add((Component)this.editDepButton, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_ModulesPanel"), this.jPanelModules);
        this.jPanelTokens.setLayout(new GridBagLayout());
        this.reqTokenSP.setViewportView(this.reqTokenList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 5, 12);
        this.jPanelTokens.add((Component)this.reqTokenSP, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.requiredTokensLabel, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_RequiredTokens"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.jPanelTokens.add((Component)this.requiredTokensLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addTokenButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_AddButton"));
        this.addTokenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.addToken(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 9);
        this.jPanelTokens.add((Component)this.addTokenButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeTokenButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_RemoveButton"));
        this.removeTokenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.removeToken(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 9);
        this.jPanelTokens.add((Component)this.removeTokenButton, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_TokensPanel"), this.jPanelTokens);
        this.jPanelJars.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_WrappedJars"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.jPanelJars.add((Component)this.jLabel1, gridBagConstraints);
        this.wrappedJarsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CustomizerLibraries.this.wrappedJarsListValueChanged(listSelectionEvent);
            }
        });
        this.wrappedJarsSP.setViewportView(this.wrappedJarsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 12);
        this.jPanelJars.add((Component)this.wrappedJarsSP, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_EditButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 9);
        this.jPanelJars.add((Component)this.editButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_RemoveButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 9);
        this.jPanelJars.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addJarButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_AddJarButton"));
        this.addJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.addJarButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 9);
        this.jPanelJars.add((Component)this.addJarButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.exportButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_ExportButton"));
        this.exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.exportButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 9);
        this.jPanelJars.add((Component)this.exportButton, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_JarsPanel"), this.jPanelJars);
        this.add((Component)this.jTabbedPane1, "Center");
    }

    private void addLibraryActionPerformed(ActionEvent actionEvent) {
        block4: {
            NbModuleProject nbModuleProject = UIUtil.runLibraryWrapperWizard(this.getProperties().getProject());
            if (nbModuleProject != null) {
                try {
                    this.getProperties().resetUniverseDependencies();
                    ModuleDependency moduleDependency = new ModuleDependency(this.getProperties().getModuleList().getEntry(nbModuleProject.getCodeNameBase()));
                    String string = this.pxml.getDependencyCycleWarning(Collections.singleton(moduleDependency));
                    if (string != null) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        return;
                    }
                    this.getDepListModel().addDependency(moduleDependency);
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)iOException);
                }
            }
        }
    }

    private void javaPlatformButtonActionPerformed(ActionEvent actionEvent) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)((JavaPlatform)this.javaPlatformCombo.getSelectedItem()));
        this.refreshJavaPlatforms();
    }

    private void removeToken(ActionEvent actionEvent) {
        CustomizerComponentFactory.RequiredTokenListModel requiredTokenListModel = (CustomizerComponentFactory.RequiredTokenListModel)this.reqTokenList.getModel();
        Object[] objectArray = this.reqTokenList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            requiredTokenListModel.removeToken((String)objectArray[i]);
        }
        if (requiredTokenListModel.getSize() > 0) {
            this.reqTokenList.setSelectedIndex(0);
        }
        this.reqTokenList.requestFocusInWindow();
    }

    private void addToken(ActionEvent actionEvent) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel.setLayout(new BorderLayout(0, 2));
        JList<String> jList = new JList<String>(this.getProperties().getAllTokens());
        JScrollPane jScrollPane = new JScrollPane(jList);
        JLabel jLabel = new JLabel();
        jLabel.setLabelFor(jList);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)this.getMessage("LBL_ProvidedTokens_T"));
        jPanel.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_ProvidedTokensTitle"));
        jList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_LBL_ProvidedTokens"));
        jScrollPane.getVerticalScrollBar().getAccessibleContext().setAccessibleName(this.getMessage("ACS_CTL_ProvidedTokensVerticalScroll"));
        jScrollPane.getVerticalScrollBar().getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CTL_ProvidedTokensVerticalScroll"));
        jScrollPane.getHorizontalScrollBar().getAccessibleContext().setAccessibleName(this.getMessage("ACS_CTL_ProvidedTokensHorizontalScroll"));
        jScrollPane.getHorizontalScrollBar().getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CTL_ProvidedTokensHorizontalScroll"));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, this.getMessage("LBL_ProvidedTokens_NoMnem"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.dispose();
        if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            Object[] objectArray = jList.getSelectedValues();
            CustomizerComponentFactory.RequiredTokenListModel requiredTokenListModel = (CustomizerComponentFactory.RequiredTokenListModel)this.reqTokenList.getModel();
            for (int i = 0; i < objectArray.length; ++i) {
                requiredTokenListModel.addToken((String)objectArray[i]);
            }
            if (objectArray.length > 0) {
                this.reqTokenList.clearSelection();
                this.reqTokenList.setSelectedValue(objectArray[0], true);
            }
        }
        this.reqTokenList.requestFocusInWindow();
    }

    private void managePlatforms(ActionEvent actionEvent) {
        NbPlatformCustomizer.showCustomizer();
        this.refreshPlatforms();
    }

    private void editModuleDependency(ActionEvent actionEvent) {
        ModuleDependency moduleDependency = this.getDepListModel().getDependency(this.dependencyList.getSelectedIndex());
        EditDependencyPanel editDependencyPanel = new EditDependencyPanel(moduleDependency, this.getProperties().getActivePlatform());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editDependencyPanel, this.getMessage("CTL_EditModuleDependencyTitle"));
        dialogDescriptor.setHelpCtx(new HelpCtx(EditDependencyPanel.class));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            this.getDepListModel().editDependency(moduleDependency, editDependencyPanel.getEditedDependency());
        }
        dialog.dispose();
        this.dependencyList.requestFocusInWindow();
    }

    private void removeModuleDependency(ActionEvent actionEvent) {
        List list = NbCollections.checkedListByCopy(Arrays.asList(this.dependencyList.getSelectedValues()), ModuleDependency.class, (boolean)false);
        if (list.size() > 0) {
            this.getDepListModel().removeDependencies(list);
            if (this.dependencyList.getModel().getSize() > 0) {
                this.dependencyList.setSelectedIndex(0);
            }
        }
        this.dependencyList.requestFocusInWindow();
    }

    private void addModuleDependency(ActionEvent actionEvent) {
        ModuleDependency[] moduleDependencyArray = AddModulePanel.selectDependencies(this.getProperties());
        for (int i = 0; i < moduleDependencyArray.length; ++i) {
            String string;
            ModuleDependency moduleDependency = moduleDependencyArray[i];
            if ("0".equals(moduleDependency.getReleaseVersion()) && !moduleDependency.hasImplementationDepedendency()) {
                moduleDependency = new ModuleDependency(moduleDependency.getModuleEntry(), "0-1", moduleDependency.getSpecificationVersion(), moduleDependency.hasCompileDependency(), moduleDependency.hasImplementationDepedendency());
            }
            if ((string = this.pxml.getDependencyCycleWarning(Collections.singleton(moduleDependency))) != null) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            this.getDepListModel().addDependency(moduleDependency);
            this.dependencyList.setSelectedValue(moduleDependency, true);
        }
        this.dependencyList.requestFocusInWindow();
    }

    private void addJarButtonActionPerformed(ActionEvent actionEvent) {
        AntProjectHelper antProjectHelper = this.getProperties().getHelper();
        Project project = this.getProperties().getProject();
        FileChooser fileChooser = antProjectHelper.isSharableProject() ? new FileChooser(antProjectHelper, true) : new FileChooser(FileUtil.toFile((FileObject)project.getProjectDirectory()), null);
        fileChooser.enableVariableBasedSelection(true);
        fileChooser.setFileHidingEnabled(false);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)fileChooser, null);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setDialogTitle(NbBundle.getMessage(EditMediator.class, (String)"LBL_AddJar_DialogTitle"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(EditMediator.JAR_ZIP_FILTER);
        File file = EditMediator.getLastUsedClassPathFolder();
        fileChooser.setCurrentDirectory(file);
        fileChooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditMediator.class, (String)"LBL_AddJar_DialogTitle"));
        int n = fileChooser.showOpenDialog((Component)SwingUtilities.getWindowAncestor(this.emListComp.getComponent()));
        if (n == 0) {
            String[] stringArray;
            try {
                stringArray = fileChooser.getSelectedPaths();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return;
            }
            File file2 = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : stringArray) {
                block12: {
                    File file3 = PropertyUtils.resolveFile((File)file2, (String)string);
                    FileObject fileObject = FileUtil.toFileObject((File)file3);
                    assert (fileObject != null) : file3;
                    if (FileUtil.isArchiveFile((FileObject)fileObject)) {
                        try {
                            new JarFile(file3);
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this.emListComp.getComponent()), NbBundle.getMessage(EditMediator.class, (String)"LBL_Corrupted_JAR", (Object)file3), NbBundle.getMessage(EditMediator.class, (String)"LBL_Corrupted_JAR_title"), 2);
                            continue;
                        }
                    }
                    Matcher matcher = checkWrappedJarPat.matcher(file3.getAbsolutePath());
                    File file4 = this.getProperties().getProjectDirectoryFile();
                    if (!matcher.matches() || !new File(matcher.group(1)).equals(file4)) {
                        try {
                            String[] stringArray2 = Util.copyClassPathExtensionJar(file4, file3);
                            if (stringArray2 == null) break block12;
                            string = stringArray2[1];
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                            continue;
                        }
                    }
                }
                arrayList.add(string);
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            DefaultListModel defaultListModel = this.getProperties().getWrappedJarsListModel();
            int[] nArray = ClassPathUiSupport.addJarFiles((DefaultListModel)defaultListModel, (int[])this.emListComp.getSelectedIndices(), (String[])stringArray, (File)file2, (String[])fileChooser.getSelectedPathVariables(), null);
            this.emListComp.setSelectedIndices(nArray);
            for (int n2 : nArray) {
                this.isJarExportedMap.put(((ClassPathSupport.Item)defaultListModel.getElementAt(n2)).getResolvedFile(), Boolean.FALSE);
            }
            file = FileUtil.normalizeFile((File)fileChooser.getCurrentDirectory());
            EditMediator.setLastUsedClassPathFolder((File)file);
        }
    }

    private void exportButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.emListComp.getSelectedIndices();
        ArrayList<File> arrayList = new ArrayList<File>();
        DefaultListModel defaultListModel = this.getProperties().getWrappedJarsListModel();
        for (int n : nArray) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)defaultListModel.getElementAt(n);
            if (item.getType() != 0) continue;
            arrayList.add(item.getResolvedFile());
        }
        if (arrayList.size() > 0) {
            int n = this.getProperties().exportPackagesFromJars(arrayList);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerLibraries.class, (String)"MSG_PublicPackagesAddedFmt", (Object)n));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            for (File file : arrayList) {
                this.isJarExportedMap.put(file, Boolean.TRUE);
            }
        }
        this.exportButton.setEnabled(false);
    }

    private void wrappedJarsListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateEnabled();
    }

    private void initAccessibility() {
        this.addTokenButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_AddTokenButton"));
        this.dependencyList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_DependencyList"));
        this.editDepButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_EditDepButton"));
        this.removeDepButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_RemoveDepButton"));
        this.removeTokenButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_RemoveTokenButton"));
        this.addDepButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_AddDepButton"));
        this.reqTokenList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_ReqTokenList"));
        this.managePlafsButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_ManagePlafsButton"));
        this.platformValue.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_PlatformValue"));
        this.javaPlatformCombo.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_JavaPlatformCombo"));
        this.javaPlatformButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_JavaPlatformButton"));
        this.javaPlatformLabel.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_JavaPlatformLbl"));
        this.platform.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_PlatformLbl"));
    }

    private void updateJarExportedMap() {
        this.selPkgsRef[0] = this.getProperties().getPublicPackagesModel().getSelectedPackages();
        Object[] objectArray = this.getProperties().getWrappedJarsListModel().toArray();
        this.jarsRef[0] = new File[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)objectArray[i];
            this.jarsRef[0][i] = item.getResolvedFile();
        }
        if (this.updateMapTask == null) {
            this.updateMapTask = this.RP.create(new Runnable(){

                public void run() {
                    File[] fileArray;
                    for (File file : fileArray = CustomizerLibraries.this.jarsRef[0]) {
                        HashSet<String> hashSet = new HashSet<String>();
                        Util.scanJarForPackageNames(hashSet, file);
                        hashSet.removeAll(CustomizerLibraries.this.selPkgsRef[0]);
                        CustomizerLibraries.this.isJarExportedMap.put(file, hashSet.isEmpty());
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CustomizerLibraries.this.updateEnabled();
                        }
                    });
                }
            });
        }
        this.updateMapTask.schedule(0);
    }
}

