/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ModuleOperations;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleActions
implements ActionProvider {
    static final String TEST_USERDIR_LOCK_PROP_NAME = "run.args.ide";
    static final String TEST_USERDIR_LOCK_PROP_VALUE = "--test-userdir-lock-with-invalid-arg";
    static final Set<String> bkgActions = new HashSet<String>(Arrays.asList("run.single", "debug.single"));
    private final NbModuleProject project;
    private final Map<String, String[]> globalCommands = new HashMap<String, String[]>();
    private String[] supportedActions = null;
    private static final Pattern SRCDIRJAVA = Pattern.compile("\\.java$");
    private static final String SUBST = "Test.java";
    private static final String SYSTEM_PROPERTY_PREFIX = "test-unit-sys-prop.";

    static Action[] getProjectActions(NbModuleProject nbModuleProject) {
        boolean bl;
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(CommonProjectActions.newFileAction());
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_build"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_rebuild"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_clean"), null));
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_run"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_debug"), null));
        arrayList.addAll(Utilities.actionsForPath((String)"Projects/Profiler_Actions_temporary"));
        if (nbModuleProject.supportedTestTypes().contains("unit")) {
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_test"), null));
        }
        arrayList.add(null);
        boolean bl2 = bl = Util.getModuleType(nbModuleProject) == NbModuleProvider.NETBEANS_ORG;
        if (bl) {
            arrayList.add(ModuleActions.createCheckBundleAction(nbModuleProject, NbBundle.getMessage(ModuleActions.class, (String)"ACTION_unused_bundle_keys")));
            arrayList.add(null);
        }
        arrayList.add(ModuleActions.createReloadAction(nbModuleProject, new String[]{"reload"}, NbBundle.getMessage(ModuleActions.class, (String)"ACTION_reload"), false));
        arrayList.add(ModuleActions.createReloadAction(nbModuleProject, new String[]{"reload-in-ide"}, NbBundle.getMessage(ModuleActions.class, (String)"ACTION_reload_in_ide"), true));
        arrayList.add(ModuleActions.createSimpleAction(nbModuleProject, new String[]{"nbm"}, NbBundle.getMessage(ModuleActions.class, (String)"ACTION_nbm")));
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"javadoc", (String)NbBundle.getMessage(ModuleActions.class, (String)"ACTION_javadoc"), null));
        arrayList.add(ModuleActions.createArchAction(nbModuleProject));
        arrayList.add(null);
        arrayList.add(CommonProjectActions.setAsMainProjectAction());
        arrayList.add(CommonProjectActions.openSubprojectsAction());
        arrayList.add(CommonProjectActions.closeProjectAction());
        arrayList.add(null);
        arrayList.add(CommonProjectActions.renameProjectAction());
        arrayList.add(CommonProjectActions.moveProjectAction());
        arrayList.add(CommonProjectActions.copyProjectAction());
        arrayList.add(CommonProjectActions.deleteProjectAction());
        arrayList.add(null);
        arrayList.add((Action)SystemAction.get(FindAction.class));
        arrayList.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
        arrayList.add(null);
        arrayList.add(CommonProjectActions.customizeProjectAction());
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public ModuleActions(NbModuleProject nbModuleProject) {
        this.project = nbModuleProject;
        this.refresh();
    }

    public void refresh() {
        HashSet<String> hashSet = new HashSet<String>();
        this.globalCommands.put("build", new String[]{"netbeans"});
        this.globalCommands.put("clean", new String[]{"clean"});
        if ("mkleint".equals(System.getProperty("user.name"))) {
            this.globalCommands.put("rebuild", new String[]{"clean", "netbeans", "do-test-build"});
        } else {
            this.globalCommands.put("rebuild", new String[]{"clean", "netbeans"});
        }
        this.globalCommands.put("run", new String[]{"run"});
        this.globalCommands.put("debug", new String[]{"debug"});
        this.globalCommands.put("profile", new String[]{"profile"});
        this.globalCommands.put("javadoc", new String[]{"javadoc-nb"});
        if (this.project.supportedTestTypes().contains("unit")) {
            this.globalCommands.put("test", new String[]{"test-unit"});
        }
        hashSet.addAll(this.globalCommands.keySet());
        hashSet.add("compile.single");
        hashSet.add("debug.fix");
        if (!this.project.supportedTestTypes().isEmpty()) {
            hashSet.add("test.single");
            hashSet.add("debug.test.single");
            hashSet.add("run.single");
            hashSet.add("debug.single");
        }
        hashSet.add("rename");
        hashSet.add("move");
        hashSet.add("copy");
        hashSet.add("delete");
        this.supportedActions = hashSet.toArray(new String[hashSet.size()]);
    }

    public String[] getSupportedActions() {
        return this.supportedActions;
    }

    private static FileObject findBuildXml(NbModuleProject nbModuleProject) {
        return nbModuleProject.getProjectDirectory().getFileObject("build.xml");
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        if ("delete".equals(string) || "rename".equals(string) || "move".equals(string) || "copy".equals(string)) {
            return true;
        }
        if (ModuleActions.findBuildXml(this.project) == null) {
            return false;
        }
        if (string.equals("compile.single")) {
            return this.findSources(lookup) != null || this.findTestSources(lookup, false) != null;
        }
        if (string.equals("test.single")) {
            return this.findTestSourcesForSources(lookup) != null || this.findTestSources(lookup, false) != null;
        }
        if (string.equals("debug.test.single")) {
            TestSources testSources = this.findTestSourcesForSources(lookup);
            if (testSources == null) {
                testSources = this.findTestSources(lookup, false);
            }
            return testSources != null && testSources.sources.length == 1;
        }
        if (string.equals("run.single")) {
            return this.findTestSources(lookup, false) != null;
        }
        if (string.equals("debug.single")) {
            TestSources testSources = this.findTestSources(lookup, false);
            return testSources != null && testSources.sources.length == 1;
        }
        if (string.equals("debug.fix")) {
            FileObject[] fileObjectArray = this.findSources(lookup);
            if (fileObjectArray != null && fileObjectArray.length == 1) {
                return true;
            }
            TestSources testSources = this.findTestSources(lookup, false);
            return testSources != null && testSources.sources.length == 1;
        }
        return true;
    }

    private FileObject[] findSources(Lookup lookup) {
        FileObject fileObject = this.project.getSourceDirectory();
        if (fileObject != null) {
            FileObject[] fileObjectArray = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObject, (String)".java", (boolean)true);
            return fileObjectArray;
        }
        return null;
    }

    private TestSources findTestSources(Lookup lookup, boolean bl) {
        FileObject[] fileObjectArray;
        FileObject[] fileObjectArray2;
        for (String string : this.project.supportedTestTypes()) {
            fileObjectArray2 = this.project.getTestSourceDirectory(string);
            if (fileObjectArray2 == null || (fileObjectArray = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObjectArray2, (String)".java", (boolean)true)) == null) continue;
            return new TestSources(fileObjectArray, string, (FileObject)fileObjectArray2);
        }
        if (bl) {
            String string;
            FileObject fileObject = this.project.getSourceDirectory();
            string = this.project.getTestSourceDirectory("unit");
            if (fileObject != null && string != null && (fileObjectArray2 = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObject, (String)".java", (boolean)true)) != null && (fileObjectArray = ActionUtils.regexpMapFiles((FileObject[])fileObjectArray2, (FileObject)fileObject, (Pattern)SRCDIRJAVA, (FileObject)string, (String)SUBST, (boolean)true)) != null) {
                return new TestSources(fileObjectArray, "unit", (FileObject)string);
            }
        }
        return null;
    }

    private String getMainClass(Lookup lookup) {
        FileObject fileObject;
        Collection collection;
        FileObject[] fileObjectArray = ActionUtils.findSelectedFiles((Lookup)lookup, null, (String)".java", (boolean)true);
        if (fileObjectArray.length == 1 && (collection = SourceUtils.getMainClasses((FileObject)(fileObject = fileObjectArray[0]))).size() > 0) {
            ElementHandle elementHandle = (ElementHandle)collection.iterator().next();
            String string = elementHandle.getQualifiedName();
            return string;
        }
        return null;
    }

    private TestSources findTestSourcesForSources(Lookup lookup) {
        String string = "unit";
        FileObject[] fileObjectArray = this.findSources(lookup);
        if (fileObjectArray == null) {
            return null;
        }
        FileObject fileObject = this.project.getTestSourceDirectory(string);
        if (fileObject == null) {
            return null;
        }
        FileObject fileObject2 = this.project.getSourceDirectory();
        FileObject[] fileObjectArray2 = ActionUtils.regexpMapFiles((FileObject[])fileObjectArray, (FileObject)fileObject2, (Pattern)SRCDIRJAVA, (FileObject)fileObject, (String)SUBST, (boolean)true);
        if (fileObjectArray2 != null) {
            return new TestSources(fileObjectArray2, string, fileObject);
        }
        return null;
    }

    public void invokeAction(final String string, final Lookup lookup) throws IllegalArgumentException {
        if ("delete".equals(string)) {
            if (ModuleOperations.canRun(this.project)) {
                DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            }
            return;
        }
        if ("rename".equals(string)) {
            if (ModuleOperations.canRun(this.project)) {
                DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            }
            return;
        }
        if ("move".equals(string)) {
            if (ModuleOperations.canRun(this.project)) {
                DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            }
            return;
        }
        if ("copy".equals(string)) {
            if (ModuleOperations.canRun(this.project)) {
                DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            }
            return;
        }
        if (!ModuleActions.verifySufficientlyNewHarness(this.project)) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                String[] stringArray;
                Object object;
                Properties properties = new Properties();
                if (string.equals("compile.single")) {
                    object = ModuleActions.this.findSources(lookup);
                    if (object != null) {
                        properties.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])object, (FileObject)ModuleActions.this.project.getSourceDirectory()));
                        stringArray = new String[]{"compile-single"};
                    } else {
                        TestSources testSources = ModuleActions.this.findTestSources(lookup, false);
                        properties.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])testSources.sources, (FileObject)testSources.sourceDirectory));
                        properties.setProperty("test.type", testSources.testType);
                        stringArray = new String[]{"compile-test-single"};
                    }
                } else if (string.equals("test.single")) {
                    object = ModuleActions.this.findTestSourcesForSources(lookup);
                    if (object == null) {
                        object = ModuleActions.this.findTestSources(lookup, false);
                    }
                    stringArray = ModuleActions.this.setupTestSingle(properties, (TestSources)object);
                } else if (string.equals("debug.test.single")) {
                    object = ModuleActions.this.findTestSourcesForSources(lookup);
                    if (object == null) {
                        object = ModuleActions.this.findTestSources(lookup, false);
                    }
                    stringArray = ModuleActions.this.setupDebugTestSingle(properties, (TestSources)object);
                } else if (string.equals("run.single")) {
                    object = ModuleActions.this.findTestSources(lookup, false);
                    String string2 = ModuleActions.this.getMainClass(lookup);
                    stringArray = string2 != null ? ModuleActions.this.setupRunMain(properties, (TestSources)object, lookup, string2) : ModuleActions.this.setupTestSingle(properties, (TestSources)object);
                } else if (string.equals("debug.single")) {
                    object = ModuleActions.this.findTestSources(lookup, false);
                    String string3 = ModuleActions.this.getMainClass(lookup);
                    stringArray = string3 != null ? ModuleActions.this.setupDebugMain(properties, (TestSources)object, lookup, string3) : ModuleActions.this.setupDebugTestSingle(properties, (TestSources)object);
                } else if (string.equals("debug.fix")) {
                    Object object2;
                    object = ModuleActions.this.findSources(lookup);
                    String string4 = null;
                    if (object != null) {
                        string4 = FileUtil.getRelativePath((FileObject)ModuleActions.this.project.getSourceDirectory(), (FileObject)object[0]);
                        assert (string4 != null);
                        assert (string4.endsWith(".java"));
                        stringArray = new String[]{"debug-fix-nb"};
                    } else {
                        object2 = ModuleActions.this.findTestSources(lookup, false);
                        if (object2 == null) {
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ModuleActions.class, (String)"MSG_no_source"));
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                            return;
                        }
                        string4 = FileUtil.getRelativePath((FileObject)((TestSources)object2).sourceDirectory, (FileObject)((TestSources)object2).sources[0]);
                        properties.setProperty("test.type", ((TestSources)object2).testType);
                        assert (string4 != null);
                        assert (string4.endsWith(".java"));
                        stringArray = new String[]{"debug-fix-test-nb"};
                    }
                    object2 = string4.substring(0, string4.length() - 5);
                    properties.setProperty("fix.class", (String)object2);
                } else {
                    if (string.equals("javadoc") && !ModuleActions.this.project.supportsJavadoc()) {
                        ModuleActions.this.promptForPublicPackagesToDocument();
                        return;
                    }
                    if ((string.equals("run") || string.equals("debug")) && ModuleActions.this.project.getTestUserDirLockFile().isFile()) {
                        properties.setProperty(ModuleActions.TEST_USERDIR_LOCK_PROP_NAME, ModuleActions.TEST_USERDIR_LOCK_PROP_VALUE);
                    }
                    if ((stringArray = (String[])ModuleActions.this.globalCommands.get(string)) == null) {
                        throw new IllegalArgumentException(string);
                    }
                }
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(ModuleActions.this.project), (String[])stringArray, (Properties)properties);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }
        };
        if (bkgActions.contains(string)) {
            RequestProcessor.getDefault().post(runnable);
        } else {
            runnable.run();
        }
    }

    private void promptForPublicPackagesToDocument() {
        if (UIUtil.showAcceptCancelDialog(NbBundle.getMessage(ModuleActions.class, (String)"TITLE_javadoc_disabled"), NbBundle.getMessage(ModuleActions.class, (String)"ERR_javadoc_disabled"), NbBundle.getMessage(ModuleActions.class, (String)"LBL_configure_pubpkg"), null, 2)) {
            CustomizerProviderImpl customizerProviderImpl = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            customizerProviderImpl.showCustomizer("Versioning", "publicPackages");
        }
    }

    private boolean hasTestUnitDataDir() {
        String string = this.project.evaluator().getProperty("test.unit.data.dir");
        return string != null && this.project.getHelper().resolveFileObject(string) != null;
    }

    private void prepareSystemProperties(Map<String, Object> map) {
        Map map2 = this.project.evaluator().getProperties();
        if (map2 == null) {
            return;
        }
        for (Map.Entry entry : map2.entrySet()) {
            if (!((String)entry.getKey()).startsWith(SYSTEM_PROPERTY_PREFIX) || entry.getValue() == null) continue;
            LinkedList<String> linkedList = (LinkedList<String>)map.get("run.jvmargs");
            if (linkedList == null) {
                linkedList = new LinkedList<String>();
                map.put("run.jvmargs", linkedList);
            }
            linkedList.add("-D" + ((String)entry.getKey()).substring(SYSTEM_PROPERTY_PREFIX.length()) + "=" + (String)entry.getValue());
        }
    }

    private static boolean verifySufficientlyNewHarness(NbModuleProject nbModuleProject) {
        NbPlatform nbPlatform = nbModuleProject.getPlatform(false);
        if (nbPlatform != null && nbPlatform.getHarnessVersion() != 0 && nbPlatform.getHarnessVersion() < nbModuleProject.getMinimumHarnessVersion()) {
            ModuleActions.promptForNewerHarness();
            return false;
        }
        return true;
    }

    static void promptForNewerHarness() {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ModuleActions.class, (String)"ERR_harness_too_old"), 0);
        message.setTitle(NbBundle.getMessage(ModuleActions.class, (String)"TITLE_harness_too_old"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private String[] setupTestSingle(Properties properties, TestSources testSources) {
        properties.setProperty("test.includes", ActionUtils.antIncludesList((FileObject[])testSources.sources, (FileObject)testSources.sourceDirectory));
        properties.setProperty("test.type", testSources.testType);
        return new String[]{"test-single"};
    }

    private String[] setupRunMain(Properties properties, TestSources testSources, Lookup lookup, String string) {
        properties.setProperty("main.class", string);
        return new String[]{"run-test-main"};
    }

    private String[] setupDebugMain(Properties properties, TestSources testSources, Lookup lookup, String string) {
        properties.setProperty("main.class", string);
        return new String[]{"debug-test-main-nb"};
    }

    private String[] setupDebugTestSingle(Properties properties, TestSources testSources) {
        String string = FileUtil.getRelativePath((FileObject)testSources.sourceDirectory, (FileObject)testSources.sources[0]);
        properties.setProperty("test.class", string.substring(0, string.length() - 5).replace('/', '.'));
        properties.setProperty("test.type", testSources.testType);
        return new String[]{"debug-test-single-nb"};
    }

    private boolean bypassAntBuildScript(String string, FileObject[] fileObjectArray) throws IllegalArgumentException {
        FileObject fileObject = null;
        if ("run.single".equals(string) || "debug.single".equals(string)) {
            fileObject = fileObjectArray[0];
        }
        if (fileObject != null) {
            String string2;
            String string3 = string2 = "run.single".equals(string) ? "junit" : "junit-debug";
            if (!JavaRunner.isSupported((String)string2, Collections.singletonMap("execute.file", fileObject))) {
                return false;
            }
            try {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                this.prepareSystemProperties(hashMap);
                hashMap.put("execute.file", fileObject);
                JavaRunner.execute((String)string2, hashMap);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return true;
        }
        return false;
    }

    private static Action createSimpleAction(final NbModuleProject nbModuleProject, final String[] stringArray, String string) {
        return new AbstractAction(string){

            public boolean isEnabled() {
                return ModuleActions.findBuildXml(nbModuleProject) != null;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ModuleActions.verifySufficientlyNewHarness(nbModuleProject)) {
                    return;
                }
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(nbModuleProject), (String[])stringArray, null);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }
        };
    }

    private static Action createCheckBundleAction(final NbModuleProject nbModuleProject, String string) {
        return new AbstractAction(string){

            public boolean isEnabled() {
                return this.findMonitorXml() != null && nbModuleProject.getPathWithinNetBeansOrg() != null;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Properties properties = new Properties();
                properties.put("modules", nbModuleProject.getPathWithinNetBeansOrg());
                properties.put("fixedmodules", "");
                try {
                    ActionUtils.runTarget((FileObject)this.findMonitorXml(), (String[])new String[]{"check-bundle-usage"}, (Properties)properties);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }

            private FileObject findMonitorXml() {
                return nbModuleProject.getNbrootFileObject("nbbuild/monitor.xml");
            }
        };
    }

    private static Action createReloadAction(final NbModuleProject nbModuleProject, final String[] stringArray, String string, final boolean bl) {
        return new AbstractAction(string){

            public boolean isEnabled() {
                if (ModuleActions.findBuildXml(nbModuleProject) == null) {
                    return false;
                }
                if (Boolean.parseBoolean(nbModuleProject.evaluator().getProperty("is.autoload")) || Boolean.parseBoolean(nbModuleProject.evaluator().getProperty("is.eager"))) {
                    return false;
                }
                if (!bl) {
                    return nbModuleProject.getTestUserDirLockFile().isFile();
                }
                NbModuleProvider.NbModuleType nbModuleType = Util.getModuleType(nbModuleProject);
                if (nbModuleType == NbModuleProvider.NETBEANS_ORG) {
                    return true;
                }
                if (nbModuleType == NbModuleProvider.STANDALONE) {
                    NbPlatform nbPlatform = nbModuleProject.getPlatform(false);
                    return nbPlatform != null && nbPlatform.isDefault();
                }
                assert (nbModuleType == NbModuleProvider.SUITE_COMPONENT) : nbModuleType;
                try {
                    SuiteProject suiteProject = SuiteUtils.findSuite(nbModuleProject);
                    if (suiteProject == null) {
                        return false;
                    }
                    NbPlatform nbPlatform = suiteProject.getPlatform(false);
                    if (nbPlatform == null || !nbPlatform.isDefault()) {
                        return false;
                    }
                    return SuiteProperties.getArrayProperty(suiteProject.getEvaluator(), "enabled.clusters").length == 0 && SuiteProperties.getArrayProperty(suiteProject.getEvaluator(), "disabled.clusters").length == 0 && SuiteProperties.getArrayProperty(suiteProject.getEvaluator(), "disabled.modules").length == 0;
                }
                catch (IOException iOException) {
                    Util.err.notify(1, (Throwable)iOException);
                    return false;
                }
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ModuleActions.verifySufficientlyNewHarness(nbModuleProject)) {
                    return;
                }
                if (bl && ModuleUISettings.getDefault().getConfirmReloadInIDE()) {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ModuleActions.class, (String)"LBL_reload_in_ide_confirm"), NbBundle.getMessage(ModuleActions.class, (String)"LBL_reload_in_ide_confirm_title"), 2);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) != NotifyDescriptor.OK_OPTION) {
                        return;
                    }
                    ModuleUISettings.getDefault().setConfirmReloadInIDE(false);
                }
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(nbModuleProject), (String[])stringArray, null);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }
        };
    }

    private static Action createArchAction(final NbModuleProject nbModuleProject) {
        return new AbstractAction(NbBundle.getMessage(ModuleActions.class, (String)"ACTION_arch")){

            public boolean isEnabled() {
                return ModuleActions.findBuildXml(nbModuleProject) != null;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ModuleActions.verifySufficientlyNewHarness(nbModuleProject)) {
                    return;
                }
                ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                    public Void run() {
                        String string = "javadoc.arch";
                        if (nbModuleProject.evaluator().getProperty(string) == null) {
                            EditableProperties editableProperties = nbModuleProject.getHelper().getProperties("nbproject/project.properties");
                            editableProperties.setProperty(string, "${basedir}/arch.xml");
                            nbModuleProject.getHelper().putProperties("nbproject/project.properties", editableProperties);
                            try {
                                ProjectManager.getDefault().saveProject((Project)nbModuleProject);
                            }
                            catch (IOException iOException) {
                                Util.err.notify((Throwable)iOException);
                            }
                        }
                        return null;
                    }
                });
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(nbModuleProject), (String[])new String[]{"arch-nb"}, null);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }
        };
    }

    static class TestSources {
        final FileObject[] sources;
        final String testType;
        final FileObject sourceDirectory;

        public TestSources(FileObject[] fileObjectArray, String string, FileObject fileObject) {
            assert (fileObjectArray != null);
            assert (fileObject != null);
            this.sources = fileObjectArray;
            this.testType = string;
            this.sourceDirectory = fileObject;
        }
    }
}

