/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.ui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlRenderer;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PlatformUiSupport {
    private static final SpecificationVersion JDK_1_5 = new SpecificationVersion("1.5");
    private static final Logger LOGGER = Logger.getLogger(PlatformUiSupport.class.getName());

    private PlatformUiSupport() {
    }

    public static ComboBoxModel createPlatformComboBoxModel(String string) {
        return new PlatformComboBoxModel(string);
    }

    public static ListCellRenderer createPlatformListCellRenderer() {
        return new PlatformListCellRenderer();
    }

    public static void storePlatform(EditableProperties editableProperties, UpdateHelper updateHelper, String string, String string2, SpecificationVersion specificationVersion) {
        Parameters.notNull((CharSequence)"props", (Object)editableProperties);
        Parameters.notNull((CharSequence)"helper", (Object)updateHelper);
        Parameters.notNull((CharSequence)"projectConfigurationNamespace", (Object)string);
        Parameters.notNull((CharSequence)"sourceLevel", (Object)specificationVersion);
        PlatformKey platformKey = string2 != null ? new PlatformKey(PlatformUiSupport.findPlatform(string2)) : new PlatformKey(JavaPlatformManager.getDefault().getDefaultPlatform());
        PlatformUiSupport.storePlatform(editableProperties, updateHelper, string, platformKey, new SourceLevelKey(specificationVersion));
    }

    public static void storePlatform(EditableProperties editableProperties, UpdateHelper updateHelper, String string, Object object, Object object2) {
        Object object3;
        Object object4;
        Element element;
        Parameters.notNull((CharSequence)"props", (Object)editableProperties);
        Parameters.notNull((CharSequence)"helper", (Object)updateHelper);
        Parameters.notNull((CharSequence)"projectConfigurationNamespace", (Object)string);
        Parameters.notNull((CharSequence)"platformKey", (Object)object);
        assert (object instanceof PlatformKey);
        PlatformKey platformKey = (PlatformKey)object;
        JavaPlatform javaPlatform = PlatformUiSupport.getPlatform(platformKey);
        if (javaPlatform == null) {
            return;
        }
        SpecificationVersion specificationVersion = new SpecificationVersion("1.3");
        String string2 = (String)javaPlatform.getProperties().get("platform.ant.name");
        assert (string2 != null);
        editableProperties.put("platform.active", string2);
        Element element2 = updateHelper.getPrimaryConfigurationData(true);
        boolean bl = false;
        NodeList nodeList = element2.getElementsByTagNameNS(string, "explicit-platform");
        if (platformKey.isDefaultPlatform()) {
            if (nodeList.getLength() == 1) {
                element2.removeChild(nodeList.item(0));
                bl = true;
            }
        } else {
            switch (nodeList.getLength()) {
                case 0: {
                    element = element2.getOwnerDocument().createElementNS(string, "explicit-platform");
                    object4 = element2.getChildNodes();
                    object3 = null;
                    for (int i = 0; i < object4.getLength(); ++i) {
                        Node node = object4.item(i);
                        if (node.getNodeType() != 1 || node.getNodeName().equals("name") || node.getNodeName().equals("minimum-ant-version")) continue;
                        object3 = node;
                        break;
                    }
                    if (object3 != null) {
                        element2.insertBefore(element, (Node)object3);
                    } else {
                        element2.appendChild(element);
                    }
                    bl = true;
                    break;
                }
                case 1: {
                    element = (Element)nodeList.item(0);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Broken project.xml file");
                }
            }
            object4 = element.getAttribute("explicit-source-supported");
            if (specificationVersion.compareTo((Object)javaPlatform.getSpecification().getVersion()) >= 0 && !"false".equals(object4)) {
                element.setAttribute("explicit-source-supported", "false");
                bl = true;
            } else if (specificationVersion.compareTo((Object)javaPlatform.getSpecification().getVersion()) < 0 && !"true".equals(object4)) {
                element.setAttribute("explicit-source-supported", "true");
                bl = true;
            }
        }
        if (object2 == null) {
            element = javaPlatform.getSpecification().getVersion();
        } else {
            assert (object2 instanceof SourceLevelKey);
            element = ((SourceLevelKey)object2).getSourceLevel();
        }
        object3 = object4 = element.toString();
        if (specificationVersion.compareTo((Object)element) >= 0) {
            object3 = "1.1";
        }
        if (!((String)object4).equals(editableProperties.getProperty("javac.source"))) {
            editableProperties.setProperty("javac.source", (String)object4);
        }
        if (!((String)object3).equals(editableProperties.getProperty("javac.target"))) {
            editableProperties.setProperty("javac.target", (String)object3);
        }
        if (bl) {
            updateHelper.putPrimaryConfigurationData(element2, true);
        }
    }

    public static JavaPlatform getPlatform(Object object) {
        Parameters.notNull((CharSequence)"platformKey", (Object)object);
        if (object instanceof PlatformKey) {
            return PlatformUiSupport.getPlatform((PlatformKey)object);
        }
        throw new IllegalArgumentException();
    }

    public static ComboBoxModel createSourceLevelComboBoxModel(ComboBoxModel comboBoxModel, String string, String string2, SpecificationVersion specificationVersion) {
        Parameters.notNull((CharSequence)"platformComboBoxModel", (Object)comboBoxModel);
        return new SourceLevelComboBoxModel(comboBoxModel, string, string2, specificationVersion);
    }

    public static ComboBoxModel createSourceLevelComboBoxModel(ComboBoxModel comboBoxModel, String string, String string2) {
        Parameters.notNull((CharSequence)"platformComboBoxModel", (Object)comboBoxModel);
        return new SourceLevelComboBoxModel(comboBoxModel, string, string2, null);
    }

    public static ListCellRenderer createSourceLevelListCellRenderer() {
        return new SourceLevelListCellRenderer();
    }

    private static JavaPlatform getPlatform(PlatformKey platformKey) {
        return platformKey == null ? null : platformKey.platform;
    }

    private static JavaPlatform findPlatform(String string) {
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(string, new Specification("j2se", null));
        if (javaPlatformArray.length == 0) {
            return null;
        }
        return javaPlatformArray[0];
    }

    private static final class SourceLevelListCellRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate = HtmlRenderer.createRenderer();

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            if (object == null) {
                string = "";
            } else {
                assert (object instanceof SourceLevelKey);
                SourceLevelKey sourceLevelKey = (SourceLevelKey)object;
                string = sourceLevelKey.isBroken() ? "<html><font color=\"#A40000\">" + NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_InvalidSourceLevel", (Object)sourceLevelKey.getDisplayName()) : sourceLevelKey.getDisplayName();
            }
            return this.delegate.getListCellRendererComponent(jList, string, n, bl, bl2);
        }
    }

    private static final class SourceLevelComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    ListDataListener {
        private static final long serialVersionUID = 1L;
        private static final String VERSION_PREFIX = "1.";
        private static final int INITIAL_VERSION_MINOR = 2;
        private final ComboBoxModel platformComboBoxModel;
        private final SpecificationVersion minimalSpecificationVersion;
        private SpecificationVersion selectedSourceLevel;
        private SpecificationVersion originalSourceLevel;
        private SourceLevelKey[] sourceLevelCache;
        private PlatformKey activePlatform;

        public SourceLevelComboBoxModel(ComboBoxModel comboBoxModel, String string, String string2, SpecificationVersion specificationVersion) {
            this.platformComboBoxModel = comboBoxModel;
            this.activePlatform = (PlatformKey)this.platformComboBoxModel.getSelectedItem();
            this.platformComboBoxModel.addListDataListener(this);
            if (string != null && string.length() > 0) {
                try {
                    this.originalSourceLevel = new SpecificationVersion(string);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.warning("Invalid javac.source: " + string);
                }
            }
            if (string2 != null && string2.length() > 0) {
                try {
                    SpecificationVersion specificationVersion2 = new SpecificationVersion(string2);
                    if (this.originalSourceLevel == null || this.originalSourceLevel.compareTo((Object)specificationVersion2) < 0) {
                        this.originalSourceLevel = specificationVersion2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.warning("Invalid javac.target: " + string2);
                }
            }
            this.selectedSourceLevel = this.originalSourceLevel;
            this.minimalSpecificationVersion = specificationVersion;
        }

        public int getSize() {
            SourceLevelKey[] sourceLevelKeyArray = this.getSourceLevels();
            return sourceLevelKeyArray.length;
        }

        public Object getElementAt(int n) {
            SourceLevelKey[] sourceLevelKeyArray = this.getSourceLevels();
            assert (n >= 0 && n < sourceLevelKeyArray.length);
            return sourceLevelKeyArray[n];
        }

        public Object getSelectedItem() {
            for (SourceLevelKey sourceLevelKey : this.getSourceLevels()) {
                if (!sourceLevelKey.getSourceLevel().equals((Object)this.selectedSourceLevel)) continue;
                return sourceLevelKey;
            }
            return null;
        }

        public void setSelectedItem(Object object) {
            this.selectedSourceLevel = object == null ? null : ((SourceLevelKey)object).getSourceLevel();
            this.fireContentsChanged(this, -1, -1);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            PlatformKey platformKey = (PlatformKey)this.platformComboBoxModel.getSelectedItem();
            JavaPlatform javaPlatform = PlatformUiSupport.getPlatform(platformKey);
            if (javaPlatform != null) {
                SpecificationVersion specificationVersion = javaPlatform.getSpecification().getVersion();
                if (this.selectedSourceLevel != null && this.selectedSourceLevel.compareTo((Object)specificationVersion) > 0 && !this.shouldChangePlatform(this.selectedSourceLevel, specificationVersion)) {
                    this.platformComboBoxModel.setSelectedItem(this.activePlatform);
                    return;
                }
                this.originalSourceLevel = null;
            }
            this.activePlatform = platformKey;
            this.resetCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetCache() {
            SourceLevelComboBoxModel sourceLevelComboBoxModel = this;
            synchronized (sourceLevelComboBoxModel) {
                this.sourceLevelCache = null;
            }
            this.fireContentsChanged(this, -1, -1);
        }

        private SourceLevelKey[] getSourceLevels() {
            if (this.sourceLevelCache == null) {
                PlatformKey platformKey = (PlatformKey)this.platformComboBoxModel.getSelectedItem();
                JavaPlatform javaPlatform = PlatformUiSupport.getPlatform(platformKey);
                ArrayList<SourceLevelKey> arrayList = new ArrayList<SourceLevelKey>();
                boolean bl = false;
                if (javaPlatform != null) {
                    SpecificationVersion specificationVersion = javaPlatform.getSpecification().getVersion();
                    int n = this.getMinimalIndex(specificationVersion);
                    SpecificationVersion specificationVersion2 = new SpecificationVersion(VERSION_PREFIX + Integer.toString(n++));
                    boolean bl2 = false;
                    while (specificationVersion2.compareTo((Object)specificationVersion) <= 0) {
                        if (specificationVersion2.equals((Object)this.originalSourceLevel)) {
                            bl2 = true;
                        }
                        if (specificationVersion2.equals((Object)this.selectedSourceLevel)) {
                            bl = true;
                        }
                        arrayList.add(new SourceLevelKey(specificationVersion2));
                        specificationVersion2 = new SpecificationVersion(VERSION_PREFIX + Integer.toString(n++));
                    }
                    if (this.originalSourceLevel != null && !bl2) {
                        if (this.originalSourceLevel.equals((Object)this.selectedSourceLevel)) {
                            bl = true;
                        }
                        arrayList.add(new SourceLevelKey(this.originalSourceLevel, true));
                    }
                }
                this.sourceLevelCache = arrayList.toArray(new SourceLevelKey[arrayList.size()]);
                if (!bl) {
                    this.selectedSourceLevel = this.sourceLevelCache.length == 0 ? null : this.sourceLevelCache[this.sourceLevelCache.length - 1].getSourceLevel();
                }
            }
            return this.sourceLevelCache;
        }

        private int getMinimalIndex(SpecificationVersion specificationVersion) {
            int n = 2;
            if (this.minimalSpecificationVersion != null) {
                SpecificationVersion specificationVersion2 = new SpecificationVersion(VERSION_PREFIX + Integer.toString(n));
                while (specificationVersion2.compareTo((Object)specificationVersion) <= 0) {
                    if (specificationVersion2.equals((Object)this.minimalSpecificationVersion)) {
                        return n;
                    }
                    specificationVersion2 = new SpecificationVersion(VERSION_PREFIX + Integer.toString(++n));
                }
            }
            return n;
        }

        private boolean shouldChangePlatform(SpecificationVersion specificationVersion, SpecificationVersion specificationVersion2) {
            JButton jButton = new JButton(NbBundle.getMessage(PlatformUiSupport.class, (String)"CTL_ChangePlatform"));
            jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformUiSupport.class, (String)"AD_ChangePlatform"));
            String string = MessageFormat.format(NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_ChangePlatform"), specificationVersion.toString(), specificationVersion2.toString());
            return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)string, NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_ChangePlatformTitle"), -1, 2, new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton)) == jButton;
        }
    }

    private static final class PlatformListCellRenderer
    implements ListCellRenderer {
        private final ListCellRenderer delegate = HtmlRenderer.createRenderer();

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            if (object == null) {
                string = "";
            } else {
                assert (object instanceof PlatformKey) : "Wrong model";
                PlatformKey platformKey = (PlatformKey)object;
                string = platformKey.isBroken() ? "<html><font color=\"#A40000\">" + NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_BrokenPlatformFmt", (Object)platformKey.getDisplayName()) : platformKey.getDisplayName();
            }
            return this.delegate.getListCellRendererComponent(jList, string, n, bl, bl2);
        }
    }

    private static final class PlatformComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private final JavaPlatformManager pm = JavaPlatformManager.getDefault();
        private PlatformKey[] platformNamesCache;
        private String initialPlatform;
        private PlatformKey selectedPlatform;

        public PlatformComboBoxModel(String string) {
            this.pm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.pm));
            this.initialPlatform = string;
        }

        public int getSize() {
            PlatformKey[] platformKeyArray = this.getPlatformNames();
            return platformKeyArray.length;
        }

        public Object getElementAt(int n) {
            PlatformKey[] platformKeyArray = this.getPlatformNames();
            assert (n >= 0 && n < platformKeyArray.length);
            return platformKeyArray[n];
        }

        public Object getSelectedItem() {
            this.getPlatformNames();
            return this.selectedPlatform;
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                this.selectedPlatform = (PlatformKey)object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("installedPlatforms".equals(propertyChangeEvent.getPropertyName())) {
                PlatformComboBoxModel platformComboBoxModel = this;
                synchronized (platformComboBoxModel) {
                    this.platformNamesCache = null;
                }
                this.fireContentsChanged(this, -1, -1);
            }
        }

        private synchronized PlatformKey[] getPlatformNames() {
            if (this.platformNamesCache == null) {
                JavaPlatform[] javaPlatformArray = this.pm.getPlatforms(null, new Specification("j2se", null));
                TreeSet<PlatformKey> treeSet = new TreeSet<PlatformKey>();
                boolean bl = false;
                for (JavaPlatform javaPlatform : javaPlatformArray) {
                    String string;
                    if (javaPlatform.getInstallFolders().size() <= 0) continue;
                    PlatformKey platformKey = new PlatformKey(javaPlatform);
                    treeSet.add(platformKey);
                    if (bl || this.initialPlatform == null || !this.initialPlatform.equals(string = (String)javaPlatform.getProperties().get("platform.ant.name"))) continue;
                    if (this.selectedPlatform == null) {
                        this.selectedPlatform = platformKey;
                        this.initialPlatform = null;
                    }
                    bl = true;
                }
                if (!bl) {
                    if (this.initialPlatform == null) {
                        if (this.selectedPlatform == null || !treeSet.contains(this.selectedPlatform)) {
                            this.selectedPlatform = new PlatformKey(JavaPlatformManager.getDefault().getDefaultPlatform());
                        }
                    } else {
                        PlatformKey platformKey = new PlatformKey(this.initialPlatform);
                        treeSet.add(platformKey);
                        if (this.selectedPlatform == null) {
                            this.selectedPlatform = platformKey;
                        }
                    }
                }
                this.platformNamesCache = treeSet.toArray(new PlatformKey[0]);
                assert (this.selectedPlatform != null) : "platformNamesCache: " + treeSet + " initialPlatform: " + this.initialPlatform;
            }
            return this.platformNamesCache;
        }
    }

    private static final class SourceLevelKey
    implements Comparable {
        private final SpecificationVersion sourceLevel;
        private final boolean broken;

        public SourceLevelKey(SpecificationVersion specificationVersion) {
            this(specificationVersion, false);
        }

        public SourceLevelKey(SpecificationVersion specificationVersion, boolean bl) {
            assert (specificationVersion != null) : "Source level cannot be null";
            this.sourceLevel = specificationVersion;
            this.broken = bl;
        }

        public SpecificationVersion getSourceLevel() {
            return this.sourceLevel;
        }

        public boolean isBroken() {
            return this.broken;
        }

        public int compareTo(Object object) {
            assert (object instanceof SourceLevelKey) : "Illegal argument of SourceLevelKey.compareTo()";
            SourceLevelKey sourceLevelKey = (SourceLevelKey)object;
            return this.sourceLevel.compareTo((Object)sourceLevelKey.sourceLevel);
        }

        public boolean equals(Object object) {
            return object instanceof SourceLevelKey && ((SourceLevelKey)object).sourceLevel.equals((Object)this.sourceLevel);
        }

        public int hashCode() {
            return this.sourceLevel.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.broken) {
                stringBuilder.append("Broken: ");
            }
            stringBuilder.append(this.sourceLevel.toString());
            return stringBuilder.toString();
        }

        public String getDisplayName() {
            String string = this.sourceLevel.toString();
            if (JDK_1_5.compareTo((Object)this.sourceLevel) <= 0) {
                string = string.replaceFirst("^1\\.([5-9]|\\d\\d+)$", "$1");
            }
            return NbBundle.getMessage(PlatformUiSupport.class, (String)"LBL_JDK", (Object)string);
        }
    }

    private static final class PlatformKey
    implements Comparable {
        private String name;
        private JavaPlatform platform;

        public PlatformKey(String string) {
            assert (string != null);
            this.name = string;
        }

        public PlatformKey(JavaPlatform javaPlatform) {
            assert (javaPlatform != null);
            this.platform = javaPlatform;
        }

        public int compareTo(Object object) {
            return this.getDisplayName().compareTo(((PlatformKey)object).getDisplayName());
        }

        public boolean equals(Object object) {
            if (object instanceof PlatformKey) {
                PlatformKey platformKey = (PlatformKey)object;
                boolean bl = this.platform == null ? platformKey.platform == null : this.platform.equals(platformKey.platform);
                return bl && platformKey.getDisplayName().equals(this.getDisplayName());
            }
            return false;
        }

        public int hashCode() {
            return this.getDisplayName().hashCode();
        }

        public String toString() {
            return this.getDisplayName();
        }

        public synchronized String getDisplayName() {
            if (this.name == null) {
                this.name = this.platform.getDisplayName();
            }
            return this.name;
        }

        public boolean isDefaultPlatform() {
            if (this.platform == null) {
                return false;
            }
            return this.platform.equals(JavaPlatformManager.getDefault().getDefaultPlatform());
        }

        public boolean isBroken() {
            return this.platform == null;
        }
    }
}

