/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import org.mozilla.nb.javascript.Node;
import org.mozilla.nb.javascript.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstPath
implements Iterable<Node> {
    private ArrayList<Node> path = new ArrayList(30);

    public AstPath() {
    }

    public AstPath(AstPath astPath) {
        this.path.addAll(astPath.path);
    }

    public AstPath(ArrayList<Node> arrayList) {
        this.path = arrayList;
    }

    public AstPath(Node node, int n) {
        this.findPathTo(node, n);
    }

    public AstPath(Node node, Node node2) {
        if (!this.find(node, node2)) {
            this.path.clear();
        } else {
            Collections.reverse(this.path);
        }
    }

    public void descend(Node node) {
        this.path.add(node);
    }

    public void ascend() {
        this.path.remove(this.path.size() - 1);
    }

    public boolean contains(int n) {
        int n2 = this.path.size();
        for (int i = 0; i < n2; ++i) {
            if (this.path.get(i).getType() != n) continue;
            return true;
        }
        return false;
    }

    public Node findPathTo(Node node, int n) {
        Node node2 = this.find(node, n);
        this.path.add(node);
        Collections.reverse(this.path);
        return node2;
    }

    private Node find(Node node, int n) {
        int n2 = node.getSourceStart();
        int n3 = node.getSourceEnd();
        if (n >= n2 && n <= n3) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                Node node3 = this.find(node2, n);
                if (node3 == null) continue;
                this.path.add(node2);
                return node3;
            }
            return node;
        }
        for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
            Node node5 = this.find(node4, n);
            if (node5 == null) continue;
            this.path.add(node4);
            return node5;
        }
        return null;
    }

    public boolean find(Node node, Node node2) {
        if (node == node2) {
            return true;
        }
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
            boolean bl = this.find(node3, node2);
            if (!bl) continue;
            this.path.add(node3);
            return bl;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Path(");
        stringBuilder.append(this.path.size());
        stringBuilder.append(")=[");
        for (Node node : this.path) {
            String string = Token.fullName((int)node.getType());
            string = string.substring(string.lastIndexOf(46) + 1);
            stringBuilder.append(string);
            stringBuilder.append(":");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public Node leaf() {
        if (this.path.size() == 0) {
            return null;
        }
        return this.path.get(this.path.size() - 1);
    }

    public Node leafParent() {
        if (this.path.size() < 2) {
            return null;
        }
        return this.path.get(this.path.size() - 2);
    }

    public Node leafGrandParent() {
        if (this.path.size() < 3) {
            return null;
        }
        return this.path.get(this.path.size() - 3);
    }

    public Node root() {
        if (this.path.size() == 0) {
            return null;
        }
        return this.path.get(0);
    }

    @Override
    public Iterator<Node> iterator() {
        return new LeafToRootIterator(this.path);
    }

    public ListIterator<Node> rootToLeaf() {
        return this.path.listIterator();
    }

    public ListIterator<Node> leafToRoot() {
        return new LeafToRootIterator(this.path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LeafToRootIterator
    implements ListIterator<Node> {
        private final ListIterator<Node> it;

        private LeafToRootIterator(ArrayList<Node> arrayList) {
            this.it = arrayList.listIterator(arrayList.size());
        }

        @Override
        public boolean hasNext() {
            return this.it.hasPrevious();
        }

        @Override
        public Node next() {
            return this.it.previous();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasNext();
        }

        @Override
        public Node previous() {
            return this.it.next();
        }

        @Override
        public int nextIndex() {
            return this.it.previousIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.nextIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void set(Node node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void add(Node node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

