/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.search.AbstractSearchScope;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

abstract class AbstractProjectSearchScope
extends AbstractSearchScope
implements PropertyChangeListener {
    private final String interestingProperty;
    private PropertyChangeListener openProjectsWeakListener;

    protected AbstractProjectSearchScope(String string) {
        this.interestingProperty = string;
    }

    protected void startListening() {
        OpenProjects openProjects = OpenProjects.getDefault();
        this.openProjectsWeakListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)openProjects);
        openProjects.addPropertyChangeListener(this.openProjectsWeakListener);
    }

    protected void stopListening() {
        OpenProjects.getDefault().removePropertyChangeListener(this.openProjectsWeakListener);
        this.openProjectsWeakListener = null;
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.interestingProperty.equals(propertyChangeEvent.getPropertyName())) {
            this.updateIsApplicable();
        }
    }

    protected SearchInfo createSingleProjectSearchInfo(Project project) {
        SearchInfo searchInfo = (SearchInfo)project.getLookup().lookup(SearchInfo.class);
        if (searchInfo != null) {
            return searchInfo;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
        if (sourceGroupArray.length == 0) {
            return this.createEmptySearchInfo();
        }
        FileObjectFilter[] fileObjectFilterArray = new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER, SearchInfoFactory.SHARABILITY_FILTER};
        if (sourceGroupArray.length == 1) {
            return SearchInfoFactory.createSearchInfo((FileObject)sourceGroupArray[0].getRootFolder(), (boolean)true, (FileObjectFilter[])fileObjectFilterArray);
        }
        FileObject[] fileObjectArray = new FileObject[sourceGroupArray.length];
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            fileObjectArray[i] = sourceGroupArray[i].getRootFolder();
        }
        return SearchInfoFactory.createSearchInfo((FileObject[])fileObjectArray, (boolean)true, (FileObjectFilter[])fileObjectFilterArray);
    }
}

