/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.netbeans.modules.web.jsf.navigation.PageFlowController;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AddPageActionProvider
extends AbstractAction
implements ContextAwareAction {
    private static final String LBL_AddPage = NbBundle.getMessage(AddPageActionProvider.class, (String)"LBL_AddPage");

    public Action createContextAwareInstance(Lookup lookup) {
        AddPageAction addPageAction;
        PageFlowScene pageFlowScene = (PageFlowScene)((Object)lookup.lookup(PageFlowScene.class));
        if (pageFlowScene != null) {
            this.setEnabled(true);
            addPageAction = new AddPageAction(pageFlowScene);
        } else {
            this.setEnabled(false);
            addPageAction = null;
        }
        return addPageAction;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class AddPageAction
    extends AbstractAction {
        private final PageFlowScene scene;

        public AddPageAction(PageFlowScene pageFlowScene) {
            this.putValue("Name", LBL_AddPage);
            this.scene = pageFlowScene;
        }

        protected String getDisplayName() {
            return LBL_AddPage;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                PageFlowController pageFlowController = this.scene.getPageFlowView().getPageFlowController();
                FileObject fileObject = pageFlowController.getWebFolder();
                String string = FileUtil.findFreeFileName((FileObject)fileObject, (String)"page", (String)"jsp");
                string = JOptionPane.showInputDialog("Select Page Name", (Object)string);
                this.createIndexJSP(fileObject, string);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        private void createIndexJSP(FileObject fileObject, String string) throws IOException {
            FileObject fileObject2 = FileUtil.getConfigFile((String)"Templates/JSP_Servlet/JSP.jsp");
            if (fileObject2 == null) {
                return;
            }
            DataObject dataObject = DataObject.find((FileObject)fileObject2);
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            dataObject.createFromTemplate(dataFolder, string);
        }
    }
}

