/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.Dialog;
import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.jsf.navigation.PageFlowController;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;
import org.netbeans.modules.web.jsf.navigation.pagecontentmodel.PageContentItem;
import org.netbeans.modules.web.jsf.navigation.pagecontentmodel.PageContentModel;
import org.netbeans.modules.web.jsf.navigation.pagecontentmodel.PageContentModelProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page
extends PageFlowSceneElement
implements SaveCookie {
    public final PageFlowController pc;
    private Node original;
    private PageContentModel pageContentModel = null;
    private String nodeDisplayName;
    private boolean renaming = false;
    private static final Image ABSTRACTNODE = ImageUtilities.loadImage((String)"org/netbeans/modules/web/jsf/navigation/graph/resources/abstract.gif");
    private boolean hasPageContentModelBeenChecked = false;
    private PageContentChangeListener pccl;

    public Page(PageFlowController pageFlowController, Node node) {
        this.pc = pageFlowController;
        this.setNode(node);
    }

    public void updateContentModel() {
        if (!this.isDataNode()) {
            return;
        }
        FileObject fileObject = ((DataNode)this.original).getDataObject().getPrimaryFile();
        this.destroyListeners();
        for (PageContentModelProvider pageContentModelProvider : PageFlowController.getPageContentModelProviders()) {
            this.pageContentModel = pageContentModelProvider.getPageContentModel(fileObject);
            if (this.pageContentModel == null) continue;
            this.initListeners();
            return;
        }
    }

    private void setNode(Node node) {
        String string = this.nodeDisplayName;
        this.original = node;
        this.nodeDisplayName = this.original.getDisplayName();
        if (this.original instanceof DataNode) {
            assert (this.pc != null);
            FileObject fileObject = ((DataNode)this.original).getDataObject().getPrimaryFile();
            assert (fileObject != null);
            this.nodeDisplayName = Page.getFolderDisplayName(this.pc.getWebFolder(), fileObject);
        }
        if (!this.nodeDisplayName.equals(string)) {
            if (string != null) {
                this.pc.removePageName2Page(string, false);
            }
            this.pc.putPageName2Page(this.nodeDisplayName, this);
        }
    }

    public void updateNode_HACK() {
        this.setNode(this.original);
    }

    public void replaceWrappedNode(Node node) {
        this.setNode(node);
        this.pc.putPageName2Page(this.getDisplayName(), this);
    }

    public boolean isRenaming() {
        return this.renaming;
    }

    @Override
    public void setName(String string) {
        String string2 = this.getDisplayName();
        try {
            if (!this.pc.isPageInAnyFacesConfig(string2)) {
                this.original.setName(string);
            } else {
                this.renaming = true;
                this.original.setName(string);
                String string3 = this.original.getDisplayName();
                if (this.isDataNode()) {
                    string3 = Page.getFolderDisplayName(this.pc.getWebFolder(), ((DataNode)this.original).getDataObject().getPrimaryFile());
                }
                this.pc.saveLocation(string2, string3);
                this.renaming = false;
                this.pc.renamePageInModel(string2, string3);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            boolean bl;
            boolean bl2 = bl = Exceptions.findLocalizedMessage((Throwable)illegalArgumentException) == null;
            if (bl) {
                Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)NbBundle.getMessage(Page.class, (String)"MSG_BadFormat", (Object)string2, (Object)string));
            }
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
    }

    public String getDisplayName() {
        return this.nodeDisplayName;
    }

    @Override
    public String getName() {
        return this.original.getName();
    }

    @Override
    public boolean canRename() {
        return this.isModifiable();
    }

    @Override
    public boolean canDestroy() {
        return true;
    }

    public void destroy2() {
        this.destroyListeners();
        if (this.original instanceof NonDataNode) {
            this.original = null;
        }
        this.pccl = null;
        this.pageContentModel = null;
    }

    @Override
    public void destroy() throws IOException {
        String string;
        Object object = DialogDescriptor.NO_OPTION;
        boolean bl = true;
        if (this.isDataNode()) {
            string = new DialogDescriptor((Object)NbBundle.getMessage(Page.class, (String)"MSG_DELETE_QUESTION", (Object)this.getDisplayName()), NbBundle.getMessage(Page.class, (String)"MSG_DELETE_TITLE"), true, 1, DialogDescriptor.NO_OPTION, null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)string);
            dialog.setVisible(true);
            object = string.getValue();
            if (this.pc != null && this.pc.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_PROJECT)) {
                bl = false;
            }
        }
        string = this.getDisplayName();
        if (object == DialogDescriptor.YES_OPTION) {
            this.pc.removeSceneNodeEdges(this);
            this.original.destroy();
            this.destroyListeners();
        } else if (object == DialogDescriptor.NO_OPTION || object == DialogDescriptor.CANCEL_OPTION) {
            // empty if block
        }
    }

    @Override
    public Image getIcon(int n) {
        if (!this.isDataNode()) {
            return ABSTRACTNODE;
        }
        return this.original.getIcon(n);
    }

    @Override
    public HelpCtx getHelpCtx() {
        return this.original.getHelpCtx();
    }

    @Override
    public Node getNode() {
        if (this.isDataNode()) {
            return this.original;
        }
        return new NonDataNode(this.original.getName());
    }

    public boolean isDataNode() {
        return this.original instanceof DataNode;
    }

    public void save() throws IOException {
        this.getCookie(SaveCookie.class).save();
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        if (clazz.equals(SaveCookie.class)) {
            return (T)this.pc.getConfigDataObject().getCookie(clazz);
        }
        return (T)this.original.getCookie(clazz);
    }

    public static String getFolderDisplayName(FileObject fileObject, FileObject fileObject2) {
        String string = fileObject.getPath();
        String string2 = fileObject2.getPath();
        return string2.replaceFirst(string + "/", "");
    }

    public static String getFolderDisplayName(FileObject fileObject, String string, String string2) {
        String string3 = fileObject.getPath();
        return string.replaceFirst(string3 + "/", "") + string2;
    }

    public Collection<PageContentItem> getPageContentItems() {
        if (this.pageContentModel == null) {
            return new ArrayList<PageContentItem>();
        }
        return this.pageContentModel.getPageContentItems();
    }

    public Collection<Pin> getPinNodes() {
        if (!this.hasPageContentModelBeenChecked) {
            this.updateContentModel();
            this.hasPageContentModelBeenChecked = true;
        }
        if (this.pageContentModel == null) {
            return Collections.emptyList();
        }
        Collection<PageContentItem> collection = this.pageContentModel.getPageContentItems();
        ArrayList<Pin> arrayList = new ArrayList<Pin>(collection.size());
        for (PageContentItem pageContentItem : collection) {
            arrayList.add(new Pin(this, pageContentItem));
        }
        return arrayList;
    }

    private void initListeners() {
        if (this.pageContentModel != null && this.pccl == null) {
            this.pccl = new PageContentChangeListener();
            this.pageContentModel.addChangeListener(this.pccl);
        }
    }

    private void destroyListeners() {
        if (this.pccl != null && this.pageContentModel != null) {
            try {
                this.pageContentModel.removeChangeListener(this.pccl);
                this.pageContentModel.destroy();
                this.pageContentModel = null;
                this.pccl = null;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private final Page getInstance() {
        return this;
    }

    public Action[] getActions(boolean bl) {
        if (this.pageContentModel != null) {
            return this.pageContentModel.getActions();
        }
        return new SystemAction[0];
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public final class NonDataNode
    extends AbstractNode {
        public NonDataNode(String string) {
            super(Children.LEAF);
            super.setName(string);
        }

        public boolean canRename() {
            return true;
        }

        public String getName() {
            return Page.this.getInstance().getName();
        }

        public void setName(String string) {
            super.setName(string);
            Page.this.getInstance().setName(string);
        }
    }

    private class PageContentChangeListener
    implements ChangeListener {
        private PageContentChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!Page.this.pc.getView().isShowing()) {
                Page.this.pc.setGraphDirty();
            } else {
                Page.this.pc.updatePageItems(Page.this.getInstance());
            }
        }
    }
}

