/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.java.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.selector.java.nodes.JavaClassNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.PackageNode;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPackageNode
extends PackageNode {
    private ClasspathInfo cpInfo;
    private Set<ClassIndex.SearchScope> scope;
    private ClientUtils.SourceCodeSelection signature;

    public JavaPackageNode(ClasspathInfo classpathInfo, String string, ContainerNode containerNode, Set<ClassIndex.SearchScope> set) {
        super(string, containerNode);
        this.cpInfo = classpathInfo;
        this.scope = set;
        this.signature = new ClientUtils.SourceCodeSelection(string + ".**", null, null);
    }

    protected List<ClassNode> getContainedClasses() {
        final ArrayList<ClassNode> arrayList = new ArrayList<ClassNode>();
        JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.PARSED);
                    PackageElement packageElement = compilationController.getElements().getPackageElement(JavaPackageNode.this.getNodeName());
                    if (packageElement != null) {
                        for (TypeElement typeElement : ElementFilter.typesIn(packageElement.getEnclosedElements())) {
                            if (typeElement.getKind() != ElementKind.CLASS && typeElement.getKind() != ElementKind.ENUM) continue;
                            arrayList.add(new JavaClassNode(JavaPackageNode.this.cpInfo, false, typeElement, (ContainerNode)JavaPackageNode.this));
                        }
                    } else {
                        LOGGER.log(Level.FINEST, "Package name {0} resulted into a NULL element", JavaPackageNode.this.getNodeName());
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            LOGGER.severe(iOException.getLocalizedMessage());
        }
        return arrayList;
    }

    protected List<PackageNode> getContainedPackages() {
        ClassIndex classIndex = this.cpInfo.getClassIndex();
        ArrayList<PackageNode> arrayList = new ArrayList<PackageNode>();
        for (String string : classIndex.getPackageNames(this.getNodeName() + ".", true, this.scope)) {
            arrayList.add(new JavaPackageNode(this.cpInfo, string, (ContainerNode)this, this.scope));
        }
        return arrayList;
    }

    public ClientUtils.SourceCodeSelection getSignature() {
        return this.signature;
    }
}

