/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.profiler.selector.java.nodes.JavaClassNode;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleFileSelectionTreeBuilder
extends SelectionTreeBuilder {
    private FileObject file;

    public SingleFileSelectionTreeBuilder(FileObject fileObject) {
        super(new SelectionTreeBuilder.Type("single-file", "Single File"), false);
        this.file = fileObject;
    }

    public List<SelectorNode> buildSelectionTree() {
        final SelectorNode[] selectorNodeArray = new SelectorNode[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
        if (javaSource != null) {
            try {
                javaSource.runWhenScanFinished((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        TypeElement typeElement = SingleFileSelectionTreeBuilder.getToplevelClass(compilationController);
                        selectorNodeArray[0] = new JavaClassNode(compilationController.getClasspathInfo(), typeElement, null);
                    }
                }, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return selectorNodeArray[0] != null ? Collections.singletonList(selectorNodeArray[0]) : Collections.EMPTY_LIST;
    }

    public int estimatedNodeCount() {
        return 1;
    }

    private static TypeElement getToplevelClass(final CompilationController compilationController) throws IOException {
        if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
            return null;
        }
        TreePathScanner<TypeElement, Void> treePathScanner = new TreePathScanner<TypeElement, Void>(){

            @Override
            public TypeElement visitClass(ClassTree classTree, Void void_) {
                try {
                    return (TypeElement)compilationController.getTrees().getElement(this.getCurrentPath());
                }
                catch (NullPointerException nullPointerException) {
                    Exceptions.printStackTrace((Throwable)nullPointerException);
                    return null;
                }
            }
        };
        return (TypeElement)treePathScanner.scan(compilationController.getCompilationUnit(), null);
    }
}

