/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class SourceLevelQuery {
    private static final Logger LOGGER = Logger.getLogger(SourceLevelQuery.class.getName());
    private static final Pattern SOURCE_LEVEL = Pattern.compile("\\d+\\.\\d+");
    private static final Lookup.Result<? extends SourceLevelQueryImplementation> implementations = Lookup.getDefault().lookupResult(SourceLevelQueryImplementation.class);

    private SourceLevelQuery() {
    }

    public static String getSourceLevel(FileObject fileObject) {
        for (SourceLevelQueryImplementation sourceLevelQueryImplementation : implementations.allInstances()) {
            String string = sourceLevelQueryImplementation.getSourceLevel(fileObject);
            if (string == null) continue;
            if (!SOURCE_LEVEL.matcher(string).matches()) {
                LOGGER.log(Level.WARNING, "#83994: Ignoring bogus source level {0} for {1} from {2}", new Object[]{string, fileObject, sourceLevelQueryImplementation});
                continue;
            }
            LOGGER.log(Level.FINE, "Found source level {0} for {1} from {2}", new Object[]{string, fileObject, sourceLevelQueryImplementation});
            return string;
        }
        LOGGER.log(Level.FINE, "No source level found for {0}", fileObject);
        return null;
    }
}

