/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.help.HelpSet;
import javax.help.JHelpSearchNavigator;
import javax.help.Map;
import javax.help.ModifiedBasicSearchCellRenderer;
import javax.help.ModifiedJHelpSearchNavigator;
import javax.help.NavigatorView;
import javax.help.SearchHit;
import javax.help.SearchTOCItem;
import javax.help.plaf.basic.BasicSearchNavigatorUI;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;

public class ModifiedBasicSearchNavigatorUI
extends BasicSearchNavigatorUI {
    public ModifiedBasicSearchNavigatorUI(JHelpSearchNavigator jHelpSearchNavigator) {
        super(jHelpSearchNavigator);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new ModifiedBasicSearchNavigatorUI((ModifiedJHelpSearchNavigator)jComponent);
    }

    protected void addSubHelpSets(HelpSet helpSet) {
        Enumeration enumeration = helpSet.getHelpSets();
        while (enumeration.hasMoreElements()) {
            HelpSet helpSet2 = (HelpSet)enumeration.nextElement();
            NavigatorView[] navigatorViewArray = helpSet2.getNavigatorViews();
            for (int i = 0; i < navigatorViewArray.length; ++i) {
                if (!this.searchnav.canMerge(navigatorViewArray[i])) continue;
                try {
                    this.searchnav.merge(navigatorViewArray[i]);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Hashtable hashtable = navigatorViewArray[i].getParameters();
                    Object var8_8 = null;
                    if (hashtable != null) {
                        var8_8 = hashtable.get("data");
                    }
                    throw new IllegalArgumentException("View is invalid:\n   View Name: " + navigatorViewArray[i].getName() + "   View Class: " + navigatorViewArray[i].getClass().getName() + "   View Params: " + hashtable + "   View Data: " + var8_8 + "   HelpSet URL: " + navigatorViewArray[i].getHelpSet().getHelpSetURL());
                }
            }
            this.addSubHelpSets(helpSet2);
        }
    }

    protected void setCellRenderer(NavigatorView navigatorView, JTree jTree) {
        if (navigatorView == null) {
            return;
        }
        Map map = navigatorView.getHelpSet().getCombinedMap();
        jTree.setCellRenderer(new ModifiedBasicSearchCellRenderer(map));
    }

    private boolean isTagged(SearchTOCItem searchTOCItem) {
        Enumeration enumeration = searchTOCItem.getSearchHits();
        while (enumeration.hasMoreElements()) {
            SearchHit searchHit = (SearchHit)enumeration.nextElement();
            if (searchHit.getBegin() < 0x1FFFFFFF) continue;
            return true;
        }
        return false;
    }

    void quickSort(DefaultMutableTreeNode[] defaultMutableTreeNodeArray, int n, int n2) {
        if (n2 > n) {
            Arrays.sort(defaultMutableTreeNodeArray, n, n2, new Comparator(){

                public int compare(Object object, Object object2) {
                    SearchTOCItem searchTOCItem = (SearchTOCItem)((DefaultMutableTreeNode)object).getUserObject();
                    double d = searchTOCItem.getConfidence();
                    int n = searchTOCItem.hitCount();
                    SearchTOCItem searchTOCItem2 = (SearchTOCItem)((DefaultMutableTreeNode)object2).getUserObject();
                    double d2 = searchTOCItem2.getConfidence();
                    int n2 = searchTOCItem2.hitCount();
                    boolean bl = ModifiedBasicSearchNavigatorUI.this.isTagged(searchTOCItem);
                    boolean bl2 = ModifiedBasicSearchNavigatorUI.this.isTagged(searchTOCItem2);
                    if (bl && !bl2) {
                        return -1;
                    }
                    if (bl2 && !bl) {
                        return 1;
                    }
                    if (d > d2) {
                        return 1;
                    }
                    if (d < d2) {
                        return -1;
                    }
                    if (n < n2) {
                        return 1;
                    }
                    if (n > n2) {
                        return -1;
                    }
                    return searchTOCItem.getName().compareTo(searchTOCItem2.getName());
                }
            });
        }
    }

    private void swap(DefaultMutableTreeNode[] defaultMutableTreeNodeArray, int n, int n2) {
        DefaultMutableTreeNode defaultMutableTreeNode = defaultMutableTreeNodeArray[n];
        defaultMutableTreeNodeArray[n] = defaultMutableTreeNodeArray[n2];
        defaultMutableTreeNodeArray[n2] = defaultMutableTreeNode;
    }
}

