/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.samples;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.samples.MavenSamplesWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class MavenSamplesPanelVisual
extends JPanel
implements DocumentListener {
    private boolean withDB = false;
    private MavenSamplesWizardPanel panel;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;

    public MavenSamplesPanelVisual(MavenSamplesWizardPanel mavenSamplesWizardPanel, boolean bl) {
        this.initComponents();
        this.panel = mavenSamplesWizardPanel;
        this.withDB = bl;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(MavenSamplesPanelVisual.class, (String)"LBL_ProjectName"));
        this.projectNameTextField.setEditable(false);
        this.projectNameTextField.setEnabled(false);
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(MavenSamplesPanelVisual.class, (String)"LBL_ProjectLocation"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(MavenSamplesPanelVisual.class, (String)"LBL_Browse"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MavenSamplesPanelVisual.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(MavenSamplesPanelVisual.class, (String)"LBL_ProjectFolder"));
        this.createdFolderTextField.setEditable(false);
        this.createdFolderTextField.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameLabel).add((Component)this.projectLocationLabel).add((Component)this.createdFolderLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.createdFolderTextField, -1, 297, Short.MAX_VALUE).add((Component)this.projectLocationTextField, -1, 297, Short.MAX_VALUE).add((Component)this.projectNameTextField, -1, 297, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.browseButton)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLocationLabel).add((Component)this.projectLocationTextField, -2, -1, -2).add((Component)this.browseButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createdFolderLabel).add((Component)this.createdFolderTextField, -2, -1, -2)).addContainerGap(176, Short.MAX_VALUE)));
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MavenSamplesPanelVisual.class, (String)"LBL_ProjectLocation_A11YDesc"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MavenSamplesPanelVisual.class, (String)"LBL_Browse_A11YDesc"));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("BROWSE".equals(string)) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setDialogTitle(NbBundle.getMessage(MavenSamplesPanelVisual.class, (String)"LBL_TITLE"));
            jFileChooser.setFileSelectionMode(1);
            String string2 = this.projectLocationTextField.getText();
            if (string2.length() > 0 && (file = new File(string2)).exists()) {
                jFileChooser.setSelectedFile(file);
            }
            if (0 == jFileChooser.showOpenDialog(this)) {
                file = jFileChooser.getSelectedFile();
                this.projectLocationTextField.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File file;
        File file2;
        if (this.projectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(MavenSamplesPanelVisual.class, (String)"MSG_InvalidProjectName"));
            return false;
        }
        String string = this.projectLocationTextField.getText();
        File file3 = FileUtil.normalizeFile((File)new File(string).getAbsoluteFile());
        if (!file3.isDirectory() || string.length() == 0) {
            String string2 = NbBundle.getMessage(MavenSamplesPanelVisual.class, (String)"MSG_InvalidPath");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string2);
            return false;
        }
        for (file2 = file = FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()).getAbsoluteFile()); file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
        }
        if (file2 == null || !file2.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(MavenSamplesPanelVisual.class, (String)"MSG_FolderCannotBeCreated"));
            return false;
        }
        if (FileUtil.toFileObject((File)file2) == null) {
            String string3 = NbBundle.getMessage(MavenSamplesPanelVisual.class, (String)"MSG_InvalidPath");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string3);
            return false;
        }
        File[] fileArray = file.listFiles();
        if (file.exists() && fileArray != null && fileArray.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(MavenSamplesPanelVisual.class, (String)"MSG_FolderAlreadyExists"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameTextField.getText().trim();
        String string2 = this.createdFolderTextField.getText().trim();
        wizardDescriptor.putProperty("projdir", (Object)new File(string2));
        wizardDescriptor.putProperty("name", (Object)string);
    }

    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        this.projectLocationTextField.setText(file.getAbsolutePath());
        String string = (String)wizardDescriptor.getProperty("name");
        if (string == null) {
            string = "sample";
        }
        this.projectNameTextField.setText(string);
        this.projectNameTextField.selectAll();
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    private void update(DocumentEvent documentEvent) {
        Document document;
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("name", null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("projdir", null, this.projectLocationTextField.getText());
        }
        if ((document = documentEvent.getDocument()) == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText();
            String string2 = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(string2 + File.separatorChar + string);
        }
        this.panel.fireChangeEvent();
    }
}

