/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.trampoline;

import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskGroupFactory {
    static final String ATTR_GROUP_NAME = "groupName";
    static final String ATTR_BUNDLE_NAME = "localizingBundle";
    static final String ATTR_DISPLAY_NAME_KEY = "diplayNameKey";
    static final String ATTR_DESCRIPTION_KEY = "descriptionKey";
    static final String ATTR_ICON_KEY = "iconKey";
    private static final String GROUP_LIST_PATH = "TaskList/Groups";
    private static TaskGroupFactory theInstance;
    private Lookup.Result<TaskGroup> lookupRes;
    private Map<String, TaskGroup> name2group;
    private List<TaskGroup> groups;
    private static TaskGroup defaultGroup;

    private TaskGroupFactory() {
    }

    public static TaskGroup create(Map<String, String> map) {
        String string = map.get(ATTR_GROUP_NAME);
        String string2 = map.get(ATTR_BUNDLE_NAME);
        String string3 = map.get(ATTR_DISPLAY_NAME_KEY);
        String string4 = map.get(ATTR_DESCRIPTION_KEY);
        String string5 = map.get(ATTR_ICON_KEY);
        return TaskGroupFactory.create(string, string2, string3, string4, string5);
    }

    public static TaskGroup create(String string, String string2, String string3, String string4, String string5) {
        ResourceBundle resourceBundle = NbBundle.getBundle((String)string2);
        String string6 = resourceBundle.getString(string3);
        String string7 = resourceBundle.getString(string4);
        String string8 = resourceBundle.getString(string5);
        Image image = ImageUtilities.loadImage((String)string8);
        return new TaskGroup(string, string6, string7, image);
    }

    public static TaskGroupFactory getDefault() {
        if (null == theInstance) {
            theInstance = new TaskGroupFactory();
        }
        return theInstance;
    }

    public TaskGroup getDefaultGroup() {
        if (null == defaultGroup) {
            ResourceBundle resourceBundle = NbBundle.getBundle(TaskGroupFactory.class);
            defaultGroup = new TaskGroup("nb-unknown-group", resourceBundle.getString("LBL_UnknownGroup"), resourceBundle.getString("HINT_UnknownGroup"), ImageUtilities.loadImage((String)"org/netbeans/modules/tasklist/trampoline/unknown.gif"));
        }
        return defaultGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGroups() {
        TaskGroupFactory taskGroupFactory = this;
        synchronized (taskGroupFactory) {
            if (null == this.name2group) {
                if (null == this.lookupRes) {
                    this.lookupRes = this.initLookup();
                    this.lookupRes.addLookupListener(new LookupListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void resultChanged(LookupEvent lookupEvent) {
                            TaskGroupFactory taskGroupFactory = TaskGroupFactory.this;
                            synchronized (taskGroupFactory) {
                                TaskGroupFactory.this.name2group = null;
                                TaskGroupFactory.this.groups = null;
                            }
                        }
                    });
                }
                int n = 0;
                this.groups = new ArrayList<TaskGroup>(this.lookupRes.allInstances());
                this.name2group = new HashMap<String, TaskGroup>(this.groups.size());
                for (TaskGroup taskGroup : this.groups) {
                    this.name2group.put(taskGroup.getName(), taskGroup);
                    taskGroup.setIndex(n++);
                }
            }
        }
    }

    public TaskGroup getGroup(String string) {
        assert (null != string);
        this.initGroups();
        return this.name2group.get(string);
    }

    public List<? extends TaskGroup> getGroups() {
        this.initGroups();
        return this.groups;
    }

    private Lookup.Result<TaskGroup> initLookup() {
        Lookup lookup = Lookups.forPath((String)GROUP_LIST_PATH);
        Lookup.Template template = new Lookup.Template(TaskGroup.class);
        Lookup.Result result = lookup.lookup(template);
        return result;
    }
}

