/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.LinkButton;
import org.netbeans.modules.welcome.content.Utils;
import org.netbeans.modules.welcome.ui.InstallConfig;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;

class PluginsPanel
extends JPanel
implements Constants {
    public PluginsPanel() {
        super(new GridBagLayout());
        this.setOpaque(false);
        InstallConfig installConfig = InstallConfig.getDefault();
        if (installConfig.isErgonomicsEnabled()) {
            if (installConfig.somePacksDisabled()) {
                this.addActivateFeatures(0, BundleSupport.getLabel("ActivateFeaturesFullIDE"), BundleSupport.getLabel("ActivateFeaturesDescrFullIDE"));
                this.addInstallPlugins(2, BundleSupport.getLabel("InstallPluginsFullIDE"), BundleSupport.getLabel("InstallPluginsDescrFullIDE"));
            } else {
                this.addInstallPlugins(0, BundleSupport.getLabel("InstallPluginsFullIDE"), BundleSupport.getLabel("InstallPluginsDescrFullIDE"));
            }
        } else if (installConfig.isJavaFXInstalled()) {
            this.addInstallPlugins(0, BundleSupport.getLabel("InstallPluginsJavaFX"), BundleSupport.getLabel("InstallPluginsDescrJavaFX"));
        } else {
            this.addInstallPlugins(0, BundleSupport.getLabel("InstallPlugins"), BundleSupport.getLabel("InstallPluginsDescr"));
        }
    }

    private void addActivateFeatures(int n, String string, String string2) {
        LinkButton linkButton = new LinkButton(string, true, Utils.getColor("HeaderForegroundColor1")){

            public void actionPerformed(ActionEvent actionEvent) {
                new ShowPluginManagerAction("installed").actionPerformed(actionEvent);
            }
        };
        linkButton.setFont(GET_STARTED_FONT);
        this.add((Component)linkButton, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        JLabel jLabel = new JLabel(string2);
        this.add((Component)jLabel, new GridBagConstraints(0, n + 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 28, 5, 5), 0, 0));
    }

    private void addInstallPlugins(int n, String string, String string2) {
        LinkButton linkButton = new LinkButton(string, true, Utils.getColor("HeaderForegroundColor2")){

            public void actionPerformed(ActionEvent actionEvent) {
                new ShowPluginManagerAction("available").actionPerformed(actionEvent);
            }
        };
        linkButton.setFont(GET_STARTED_FONT);
        this.add((Component)linkButton, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 5, 5, 5), 0, 0));
        JLabel jLabel = new JLabel(string2);
        this.add((Component)jLabel, new GridBagConstraints(0, n + 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 28, 5, 5), 0, 0));
    }

    private static class ShowPluginManagerAction
    extends AbstractAction {
        private final String initialTab;

        public ShowPluginManagerAction(String string) {
            super(BundleSupport.getLabel("AddPlugins"));
            this.initialTab = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                CallableSystemAction callableSystemAction = (CallableSystemAction)SystemAction.get(classLoader.loadClass("org.netbeans.modules.autoupdate.ui.actions.PluginManagerAction").asSubclass(CallableSystemAction.class));
                callableSystemAction.putValue("InitialTab", (Object)this.initialTab);
                callableSystemAction.performAction();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }
}

