/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.testrunner;

import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.ui.testrunner.TestSessionVO;
import org.openide.util.Exceptions;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class PhpUnitLogParser
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(PhpUnitLogParser.class.getName());
    private static final String NO_FILE = "NO_FILE";
    private final XMLReader xmlReader;
    private final TestSessionVO testSession;
    private Stack<TestSessionVO.TestSuiteVO> testSuites = new Stack();
    private TestSessionVO.TestCaseVO testCase;
    private String file;
    private Content content = Content.NONE;
    private StringBuilder buffer = new StringBuilder(200);

    private PhpUnitLogParser(TestSessionVO testSessionVO) throws SAXException {
        assert (testSessionVO != null);
        this.testSession = testSessionVO;
        this.xmlReader = FileUtils.createXmlReader();
        this.xmlReader.setContentHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void parse(Reader reader, TestSessionVO testSessionVO) {
        block10: {
            PhpUnitLogParser phpUnitLogParser = new PhpUnitLogParser(testSessionVO);
            phpUnitLogParser.xmlReader.parse(new InputSource(reader));
            Object var4_5 = null;
            try {
                reader.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            break block10;
            {
                catch (SAXException sAXException) {
                    LOGGER.log(Level.INFO, null, sAXException);
                    Object var4_6 = null;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.WARNING, null, throwable);
                    Object var4_7 = null;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                throw throwable;
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("testsuite".equals(string3)) {
            this.processTestSuiteStart(attributes);
        } else if ("testcase".equals(string3)) {
            this.processTestCase(attributes);
        } else if ("failure".equals(string3)) {
            this.startTestFailure(attributes);
        } else if ("error".equals(string3)) {
            this.startTestError(attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("testsuite".equals(string3)) {
            this.processTestSuiteEnd();
        } else if ("testcase".equals(string3)) {
            assert (this.testCase != null);
            this.testCase = null;
        } else if ("failure".equals(string3) || "error".equals(string3)) {
            this.endTestContent();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        switch (this.content) {
            case FAILURE: 
            case ERROR: {
                this.buffer.append(new String(cArray, n, n2));
            }
        }
    }

    private void processTestSuiteStart(Attributes attributes) {
        if (this.testSession.getTime() == -1L && this.testSession.getTests() == -1) {
            this.testSession.setTests(this.getTests(attributes));
            this.testSession.setTime(this.getTime(attributes));
            this.file = this.getFile(attributes, NO_FILE);
        } else {
            this.file = this.getFile(attributes);
        }
        assert (this.file != null);
        TestSessionVO.TestSuiteVO testSuiteVO = new TestSessionVO.TestSuiteVO(this.getName(attributes), this.file, this.getTime(attributes));
        this.testSuites.push(testSuiteVO);
        if (!this.file.equals(NO_FILE)) {
            this.testSession.addTestSuite(testSuiteVO);
        }
    }

    private void processTestSuiteEnd() {
        this.testSuites.pop();
    }

    private void processTestCase(Attributes attributes) {
        assert (this.testCase == null);
        this.testCase = new TestSessionVO.TestCaseVO(this.getName(attributes), this.getFile(attributes), this.getLine(attributes), this.getTime(attributes));
        ((TestSessionVO.TestSuiteVO)this.testSuites.lastElement()).addTestCase(this.testCase);
    }

    private void startTestError(Attributes attributes) {
        this.content = Content.ERROR;
    }

    private void startTestFailure(Attributes attributes) {
        this.content = Content.FAILURE;
    }

    private void endTestContent() {
        assert (this.testCase != null);
        assert (this.buffer.length() > 0);
        this.fillStacktrace();
        switch (this.content) {
            case FAILURE: {
                this.testCase.setFailureStatus();
                break;
            }
            case ERROR: {
                this.testCase.setErrorStatus();
                break;
            }
            default: {
                assert (false) : "Unknown content type: " + (Object)((Object)this.content);
                break;
            }
        }
        this.buffer = new StringBuilder(200);
        this.content = Content.NONE;
    }

    private void fillStacktrace() {
        String[] stringArray = this.buffer.toString().trim().split("\n");
        assert (stringArray.length >= 2) : "At least 2 lines must be found (message + stacktrace)";
        this.buffer = new StringBuilder(200);
        boolean bl = false;
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.trim().length() == 0) {
                if (bl) continue;
                bl = true;
                this.testCase.addStacktrace(this.buffer.toString().trim());
                continue;
            }
            if (string.startsWith("\n\n")) {
                bl = true;
                this.testCase.addStacktrace(this.buffer.toString().trim());
                continue;
            }
            if (!bl) {
                this.buffer.append(string + "\n");
                continue;
            }
            this.testCase.addStacktrace(string.trim());
        }
        if (this.testCase.getStacktrace().length == 0) {
            this.testCase.addStacktrace(this.buffer.toString().trim());
        }
    }

    private int getTests(Attributes attributes) {
        return this.getInt(attributes, "tests");
    }

    private long getTime(Attributes attributes) {
        long l = -1L;
        try {
            l = Math.round(Double.parseDouble(attributes.getValue("time")) * 1000.0);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    private String getName(Attributes attributes) {
        return attributes.getValue("name");
    }

    private String getFile(Attributes attributes) {
        return this.getFile(attributes, null);
    }

    private String getFile(Attributes attributes, String string) {
        String string2 = attributes.getValue("file");
        if (string2 != null) {
            return string2;
        }
        if (string != null) {
            return string;
        }
        return this.file;
    }

    private int getLine(Attributes attributes) {
        return this.getInt(attributes, "line");
    }

    private int getInt(Attributes attributes, String string) {
        int n = -1;
        try {
            n = Integer.parseInt(attributes.getValue(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Content {
        NONE,
        ERROR,
        FAILURE;

    }
}

