/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.ui.PathUiSupport;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerIgnorePath
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = 32813080125323378L;
    private final ProjectCustomizer.Category category;
    private final PhpProject project;
    private JButton addButton;
    private JLabel ignorePathLabel;
    private JList ignorePathList;
    private JScrollPane ignorePathScrollPane;
    private JButton removeButton;

    public CustomizerIgnorePath(ProjectCustomizer.Category category, PhpProjectProperties phpProjectProperties) {
        this.category = category;
        this.project = phpProjectProperties.getProject();
        this.initComponents();
        PathUiSupport.EditMediator.FileChooserDirectoryHandler fileChooserDirectoryHandler = new PathUiSupport.EditMediator.FileChooserDirectoryHandler(){

            public File getCurrentDirectory() {
                return FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(CustomizerIgnorePath.this.project));
            }

            public void setCurrentDirectory(File file) {
            }
        };
        this.ignorePathList.setModel(phpProjectProperties.getIgnorePathListModel());
        this.ignorePathList.setCellRenderer(phpProjectProperties.getIgnorePathListRenderer());
        PathUiSupport.EditMediator.register(phpProjectProperties.getProject(), this.ignorePathList, this.addButton.getModel(), this.removeButton.getModel(), fileChooserDirectoryHandler);
        this.ignorePathList.getModel().addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                CustomizerIgnorePath.this.validateData();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                CustomizerIgnorePath.this.validateData();
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                CustomizerIgnorePath.this.validateData();
            }
        });
    }

    void validateData() {
        int n = this.ignorePathList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            BasePathSupport.Item item = (BasePathSupport.Item)this.ignorePathList.getModel().getElementAt(i);
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(item.getFilePath())));
            if (fileObject == null || CommandUtils.isUnderAnySourceGroup(this.project, fileObject, false)) continue;
            this.category.setErrorMessage(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"MSG_NotSourceGroupSubdirectory", (Object)fileObject.getNameExt()));
            this.category.setValid(false);
            return;
        }
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    private void initComponents() {
        this.ignorePathLabel = new JLabel();
        this.ignorePathScrollPane = new JScrollPane();
        this.ignorePathList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                return CustomizerIgnorePath.this.removeButton;
            }

            public Component getFirstComponent(Container container) {
                return CustomizerIgnorePath.this.removeButton;
            }

            public Component getLastComponent(Container container) {
                return CustomizerIgnorePath.this.removeButton;
            }

            public Component getComponentAfter(Container container, Component component) {
                if (component == CustomizerIgnorePath.this.addButton) {
                    return CustomizerIgnorePath.this.removeButton;
                }
                if (component == CustomizerIgnorePath.this.ignorePathList) {
                    return CustomizerIgnorePath.this.addButton;
                }
                return CustomizerIgnorePath.this.removeButton;
            }

            public Component getComponentBefore(Container container, Component component) {
                if (component == CustomizerIgnorePath.this.removeButton) {
                    return CustomizerIgnorePath.this.addButton;
                }
                if (component == CustomizerIgnorePath.this.addButton) {
                    return CustomizerIgnorePath.this.ignorePathList;
                }
                return CustomizerIgnorePath.this.removeButton;
            }
        });
        this.ignorePathLabel.setLabelFor(this.ignorePathList);
        Mnemonics.setLocalizedText((JLabel)this.ignorePathLabel, (String)NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathLabel.text"));
        this.ignorePathScrollPane.setViewportView(this.ignorePathList);
        this.ignorePathList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathList.AccessibleContext.accessibleName"));
        this.ignorePathList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.addButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.removeButton.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.ignorePathLabel).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.ignorePathScrollPane, -1, 271, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.removeButton).add((Component)this.addButton)).add(0, 0, 0)));
        groupLayout.linkSize(new Component[]{this.addButton, this.removeButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.ignorePathLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton)).add((Component)this.ignorePathScrollPane, -1, 143, Short.MAX_VALUE)).add(0, 0, 0)));
        this.ignorePathLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathLabel.AccessibleContext.accessibleName"));
        this.ignorePathLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathLabel.AccessibleContext.accessibleDescription"));
        this.ignorePathScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathScrollPane.AccessibleContext.accessibleName"));
        this.ignorePathScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathScrollPane.AccessibleContext.accessibleDescription"));
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.addButton.AccessibleContext.accessibleName"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.addButton.AccessibleContext.accessibleDescription"));
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.removeButton.AccessibleContext.accessibleName"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.removeButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.AccessibleContext.accessibleDescription"));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerIgnorePath.class);
    }
}

