/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.copysupport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.copysupport.FileOperationFactory;
import org.netbeans.modules.php.project.copysupport.LocalOperationFactory;
import org.netbeans.modules.php.project.copysupport.RemoteOperationFactory;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CopySupport
extends FileChangeAdapter
implements PropertyChangeListener,
FileChangeListener,
ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(CopySupport.class.getName());
    public static final boolean ALLOW_BROKEN = Boolean.getBoolean(CopySupport.class.getName() + ".allowBroken");
    private static final RequestProcessor COPY_SUPPORT_RP = new RequestProcessor("PHP file change handler (copy support)");
    private static final int FILE_CHANGE_DELAY = 300;
    private static final int PROPERTY_CHANGE_DELAY = 500;
    private static final int PROGRESS_INITIAL_DELAY = 1000;
    static final Queue<Callable<Boolean>> OPERATIONS_QUEUE = new ConcurrentLinkedQueue<Callable<Boolean>>();
    static final RequestProcessor.Task COPY_TASK = CopySupport.createCopyTask();
    final PhpProject project;
    final PhpVisibilityQuery phpVisibilityQuery;
    private final RequestProcessor.Task initTask;
    private volatile boolean projectOpened = false;
    private final ProxyOperationFactory proxyOperationFactory;
    private FileSystem fileSystem;
    private FileChangeListener fileChangeListener;

    private CopySupport(PhpProject phpProject) {
        assert (phpProject != null);
        this.project = phpProject;
        this.phpVisibilityQuery = PhpVisibilityQuery.forProject(phpProject);
        this.proxyOperationFactory = new ProxyOperationFactory(phpProject);
        ProjectPropertiesSupport.addWeakPropertyEvaluatorListener(phpProject, this);
        RemoteConnections remoteConnections = RemoteConnections.get();
        remoteConnections.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)remoteConnections));
        this.initTask = COPY_SUPPORT_RP.create(new Runnable(){

            public void run() {
                CopySupport.this.init();
            }
        });
    }

    public static CopySupport getInstance(PhpProject phpProject) {
        return new CopySupport(phpProject);
    }

    private static RequestProcessor.Task createCopyTask() {
        return COPY_SUPPORT_RP.create(new Runnable(){

            public void run() {
                Callable<Boolean> callable = OPERATIONS_QUEUE.poll();
                while (callable != null) {
                    try {
                        callable.call();
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.WARNING, null, exception);
                    }
                    callable = OPERATIONS_QUEUE.poll();
                }
            }
        });
    }

    public void projectOpened() {
        LOGGER.log(Level.FINE, "Opening Copy support for project {0}", this.project.getName());
        assert (!this.projectOpened) : "Copy Support already opened for project " + this.project.getName();
        this.projectOpened = true;
        this.initTask.schedule(500);
    }

    public void projectClosed() {
        LOGGER.log(Level.FINE, "Closing Copy support for project {0}", this.project.getName());
        assert (this.projectOpened) : "Copy Support already closed for project " + this.project.getName();
        this.projectOpened = false;
        this.unregisterFileChangeListener();
    }

    private void prepareOperation(Callable<Boolean> callable) {
        if (callable != null) {
            OPERATIONS_QUEUE.offer(callable);
            COPY_TASK.schedule(300);
        }
    }

    synchronized void init() {
        LOGGER.log(Level.FINE, "Copy support INIT for project {0}", this.project.getName());
        this.proxyOperationFactory.reset();
        if (this.proxyOperationFactory.isEnabled()) {
            this.prepareOperation(this.proxyOperationFactory.createInitHandler(this.getSources()));
            this.registerFileChangeListener();
        } else {
            this.unregisterFileChangeListener();
        }
    }

    private void registerFileChangeListener() {
        LOGGER.log(Level.FINE, "Copy support REGISTERING FS listener for project {0}", this.project.getName());
        assert (Thread.holdsLock(this));
        if (this.fileChangeListener != null) {
            LOGGER.log(Level.FINE, "\t-> not needed for project {0} (already registered)", this.project.getName());
            return;
        }
        if (ALLOW_BROKEN) {
            assert (this.fileChangeListener == null) : "FS listener cannot yet exist for project " + this.project.getName();
            try {
                this.fileSystem = this.getSources().getFileSystem();
                this.fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.fileSystem);
                this.fileSystem.addFileChangeListener(this.fileChangeListener);
                LOGGER.log(Level.FINE, "\t-> NON-RECURSIVE listener registered for project {0}", this.project.getName());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                LOGGER.log(Level.WARNING, null, fileStateInvalidException);
            }
        } else {
            this.fileChangeListener = new SourcesFileChangeListener(this);
            FileUtil.addRecursiveListener((FileChangeListener)this.fileChangeListener, (File)FileUtil.toFile((FileObject)this.getSources()));
            LOGGER.log(Level.FINE, "\t-> RECURSIVE listener registered for project {0}", this.project.getName());
        }
    }

    private synchronized void unregisterFileChangeListener() {
        LOGGER.log(Level.FINE, "Copy support UNREGISTERING FS listener for project {0}", this.project.getName());
        if (this.fileChangeListener == null) {
            LOGGER.log(Level.FINE, "\t-> not needed for project {0} (not registered)", this.project.getName());
        } else {
            if (ALLOW_BROKEN) {
                assert (this.fileChangeListener != null) : "FS listener must be known already for project " + this.project.getName();
                this.fileSystem.removeFileChangeListener(this.fileChangeListener);
                LOGGER.log(Level.FINE, "\t-> NON-RECURSIVE listener unregistered for project {0}", this.project.getName());
            } else {
                assert (this.fileChangeListener instanceof SourcesFileChangeListener) : "FS listener of incorrect type: " + this.fileChangeListener.getClass().getName();
                try {
                    FileUtil.removeRecursiveListener((FileChangeListener)this.fileChangeListener, (File)FileUtil.toFile((FileObject)this.getSources()));
                    LOGGER.log(Level.FINE, "\t-> RECURSIVE listener unregistered for project {0}", this.project.getName());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOGGER.log(Level.WARNING, "If this happens to you reliably, report issue with steps to reproduce and attach IDE log (http://www.netbeans.org/community/issues).", illegalArgumentException);
                    FileObject fileObject = ((SourcesFileChangeListener)this.fileChangeListener).getSources();
                    FileObject fileObject2 = this.getSources();
                    LOGGER.log(Level.INFO, "registered sources (valid): {0} ({1}), current sources (valid): {2} ({3}), equals: {4}", new Object[]{fileObject, fileObject.isValid(), fileObject2, fileObject2.isValid(), fileObject.equals(fileObject2)});
                }
            }
            this.fileSystem = null;
            this.fileChangeListener = null;
        }
    }

    public void waitFinished() {
        COPY_TASK.schedule(0);
        COPY_TASK.waitFinished();
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        FileObject fileObject = this.getValidProjectSource(fileEvent);
        if (fileObject == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Processing event FOLDER CREATED for project {0}", this.project.getName());
        this.prepareOperation(this.proxyOperationFactory.createCopyHandler(fileObject));
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fileObject = this.getValidProjectSource(fileEvent);
        if (fileObject == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Processing event DATA CREATED for project {0}", this.project.getName());
        this.prepareOperation(this.proxyOperationFactory.createCopyHandler(fileObject));
    }

    public void fileChanged(FileEvent fileEvent) {
        FileObject fileObject = this.getValidProjectSource(fileEvent);
        if (fileObject == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Processing event FILE CHANGED for project {0}", this.project.getName());
        this.prepareOperation(this.proxyOperationFactory.createCopyHandler(fileObject));
    }

    public void fileDeleted(FileEvent fileEvent) {
        FileObject fileObject = this.getValidProjectSource(fileEvent);
        if (fileObject == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Processing event FILE DELETED for project {0}", this.project.getName());
        this.prepareOperation(this.proxyOperationFactory.createDeleteHandler(fileObject));
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fileObject = this.getValidProjectSource((FileEvent)fileRenameEvent);
        if (fileObject == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Processing event FILE RENAMED for project {0}", this.project.getName());
        String string = fileRenameEvent.getName();
        String string2 = fileRenameEvent.getExt();
        if (StringUtils.hasText((String)string2)) {
            string = string + "." + string2;
        }
        this.prepareOperation(this.proxyOperationFactory.createRenameHandler(fileObject, string));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.projectOpened) {
            LOGGER.log(Level.FINE, "Processing event PROPERTY CHANGE for opened project {0}", this.project.getName());
            this.initTask.schedule(500);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.projectOpened) {
            LOGGER.log(Level.FINE, "Processing event STATE CHANGE (remote connections) for opened project {0}", this.project.getName());
            this.initTask.schedule(500);
        }
    }

    private FileObject getValidProjectSource(FileEvent fileEvent) {
        LOGGER.log(Level.FINEST, "Getting source file for project {0} from {1}", new Object[]{this.project.getName(), fileEvent});
        FileObject fileObject = fileEvent.getFile();
        if (!PhpProjectUtils.isVisible(this.phpVisibilityQuery, fileObject)) {
            LOGGER.finest("\t-> null (invisible source)");
            return null;
        }
        if (!CommandUtils.isUnderSources(this.project, fileObject)) {
            LOGGER.finest("\t-> null (invalid source)");
            return null;
        }
        LOGGER.log(Level.FINE, "Got source file for project {0} from {1}", new Object[]{this.project.getName(), fileEvent});
        return fileObject;
    }

    FileObject getSources() {
        return ProjectPropertiesSupport.getSourcesDirectory(this.project);
    }

    private static class SourcesFileChangeListener
    implements FileChangeListener {
        private final CopySupport copySupport;
        private final FileObject sources;

        public SourcesFileChangeListener(CopySupport copySupport) {
            this.copySupport = copySupport;
            this.sources = copySupport.getSources();
        }

        public FileObject getSources() {
            return this.sources;
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.copySupport.fileFolderCreated(fileEvent);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.copySupport.fileDataCreated(fileEvent);
        }

        public void fileChanged(FileEvent fileEvent) {
            this.copySupport.fileChanged(fileEvent);
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.copySupport.fileDeleted(fileEvent);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.copySupport.fileRenamed(fileRenameEvent);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            this.copySupport.fileAttributeChanged(fileAttributeEvent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProxyOperationFactory
    extends FileOperationFactory {
        final FileOperationFactory localFactory;
        final FileOperationFactory remoteFactory;

        ProxyOperationFactory(PhpProject phpProject) {
            super(phpProject);
            this.localFactory = new LocalOperationFactory(phpProject);
            this.remoteFactory = new RemoteOperationFactory(phpProject);
        }

        @Override
        protected void resetInternal() {
            this.localFactory.reset();
            this.remoteFactory.reset();
        }

        @Override
        Logger getLogger() {
            return LOGGER;
        }

        @Override
        protected boolean isEnabled() {
            return this.localFactory.isEnabled() || this.remoteFactory.isEnabled();
        }

        @Override
        protected Callable<Boolean> createInitHandlerInternal(FileObject fileObject) {
            return this.createHandler(this.localFactory.createInitHandler(fileObject), this.remoteFactory.createInitHandler(fileObject));
        }

        @Override
        protected Callable<Boolean> createCopyHandlerInternal(FileObject fileObject) {
            return this.createHandler(this.localFactory.createCopyHandler(fileObject), this.remoteFactory.createCopyHandler(fileObject));
        }

        @Override
        protected Callable<Boolean> createRenameHandlerInternal(FileObject fileObject, String string) {
            return this.createHandler(this.localFactory.createRenameHandler(fileObject, string), this.remoteFactory.createRenameHandler(fileObject, string));
        }

        @Override
        protected Callable<Boolean> createDeleteHandlerInternal(FileObject fileObject) {
            return this.createHandler(this.localFactory.createDeleteHandler(fileObject), this.remoteFactory.createDeleteHandler(fileObject));
        }

        private Callable<Boolean> createHandler(Callable<Boolean> callable, Callable<Boolean> callable2) {
            if (callable == null && callable2 == null) {
                LOGGER.fine("No handler given");
                return null;
            }
            return new ProxyHandler(callable, callable2);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ProxyHandler
        implements Callable<Boolean> {
            private final Callable<Boolean> localHandler;
            private final Callable<Boolean> remoteHandler;

            public ProxyHandler(Callable<Boolean> callable, Callable<Boolean> callable2) {
                this.localHandler = callable;
                this.remoteHandler = callable2;
            }

            @Override
            public Boolean call() throws Exception {
                Boolean bl = this.callLocal();
                Boolean bl2 = this.callRemote();
                if (bl == null && bl2 == null) {
                    return null;
                }
                if (bl != null && !bl.booleanValue()) {
                    return false;
                }
                if (bl2 != null && !bl2.booleanValue()) {
                    return false;
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private Boolean callLocal() {
                Exception exception;
                Boolean bl;
                block6: {
                    bl = null;
                    exception = null;
                    if (this.localHandler != null) {
                        LOGGER.log(Level.FINE, "Processing LOCAL copying handler for project {0}", ProxyOperationFactory.this.project.getName());
                        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CopySupport.class, (String)"LBL_LocalSynchronization"));
                        progressHandle.setInitialDelay(1000);
                        try {
                            try {
                                progressHandle.start();
                                bl = this.localHandler.call();
                            }
                            catch (Exception exception2) {
                                LOGGER.log(Level.INFO, "LOCAL copying fail: ", exception2);
                                bl = false;
                                exception = exception2;
                                Object var6_5 = null;
                                progressHandle.finish();
                                break block6;
                            }
                            Object var6_4 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            progressHandle.finish();
                            throw throwable;
                        }
                        progressHandle.finish();
                    }
                }
                if (bl != null && !bl.booleanValue() && ProxyOperationFactory.this.askUser(NbBundle.getMessage(CopySupport.class, (String)"LBL_Copy_Support_Fail", (Object)ProxyOperationFactory.this.project.getName()))) {
                    ProxyOperationFactory.this.localFactory.invalidate();
                    LOGGER.log(Level.INFO, String.format("LOCAL copying for project %s disabled by user", ProxyOperationFactory.this.project.getName()), exception);
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private Boolean callRemote() {
                Exception exception;
                Boolean bl;
                block5: {
                    bl = null;
                    exception = null;
                    if (this.remoteHandler == null) return bl;
                    LOGGER.log(Level.FINE, "Processing REMOTE copying handler for project {0}", ProxyOperationFactory.this.project.getName());
                    ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CopySupport.class, (String)"LBL_RemoteSynchronization"));
                    progressHandle.setInitialDelay(1000);
                    try {
                        try {
                            progressHandle.start();
                            bl = this.remoteHandler.call();
                        }
                        catch (Exception exception2) {
                            LOGGER.log(Level.INFO, "REMOTE copying fail: ", exception2);
                            bl = false;
                            exception = exception2;
                            Object var6_5 = null;
                            progressHandle.finish();
                            break block5;
                        }
                        Object var6_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        progressHandle.finish();
                        throw throwable;
                    }
                    progressHandle.finish();
                }
                if (bl != null && !bl.booleanValue() && ProxyOperationFactory.this.askUser(NbBundle.getMessage(CopySupport.class, (String)"LBL_Remote_On_Save_Fail", (Object)ProxyOperationFactory.this.project.getName()))) {
                    ProxyOperationFactory.this.remoteFactory.invalidate();
                    LOGGER.log(Level.INFO, String.format("REMOTE copying for project %s disabled by user", ProxyOperationFactory.this.project.getName()), exception);
                }
                return bl;
            }
        }
    }
}

