/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sftp;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.sftp.SftpClient;
import org.netbeans.modules.php.project.connections.sftp.SftpConfiguration;
import org.netbeans.modules.php.project.connections.sftp.SftpConfigurationPanel;
import org.netbeans.modules.php.project.connections.spi.RemoteClient;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteConfigurationPanel;
import org.netbeans.modules.php.project.connections.spi.RemoteConnectionProvider;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SftpConnectionProvider
implements RemoteConnectionProvider {
    private static final String SFTP_CONNECTION_TYPE = "SFTP";
    private static final SshFiles UNKNOWN_SSH_FILES = new SshFiles();
    static final String TYPE = "type";
    static final String HOST = "host";
    static final String PORT = "port";
    static final String USER = "user";
    static final String KNOWN_HOSTS_FILE = "knownHostsFile";
    static final String IDENTITY_FILE = "identityFile";
    static final String PASSWORD = "password";
    static final String INITIAL_DIRECTORY = "initialDirectory";
    static final String TIMEOUT = "timeout";
    private static final Set<String> PROPERTIES = new HashSet<String>(Arrays.asList("type", "host", "port", "user", "password", "knownHostsFile", "identityFile", "initialDirectory", "timeout"));
    private static final int DEFAULT_PORT = 22;
    private static final int DEFAULT_TIMEOUT = 30;
    private static final String DEFAULT_INITIAL_DIRECTORY = "/var/www";

    private SftpConnectionProvider() {
    }

    public static SftpConnectionProvider get() {
        return new SftpConnectionProvider();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(SftpConnectionProvider.class, (String)"LBL_Sftp");
    }

    @Override
    public Set<String> getPropertyNames() {
        return PROPERTIES;
    }

    @Override
    public RemoteConfiguration createRemoteConfiguration(ConfigManager.Configuration configuration) {
        SshFiles sshFiles = this.getDefaultSshFiles();
        configuration.putValue(TYPE, SFTP_CONNECTION_TYPE);
        configuration.putValue(HOST, "");
        configuration.putValue(PORT, String.valueOf(22));
        configuration.putValue(USER, "");
        configuration.putValue(PASSWORD, "");
        configuration.putValue(KNOWN_HOSTS_FILE, sshFiles.getKnownHostsFile());
        configuration.putValue(IDENTITY_FILE, sshFiles.getIdentityFile());
        configuration.putValue(INITIAL_DIRECTORY, DEFAULT_INITIAL_DIRECTORY);
        configuration.putValue(TIMEOUT, String.valueOf(30));
        assert (this.accept(configuration)) : "Not my configuration?!";
        return new SftpConfiguration(configuration);
    }

    @Override
    public RemoteConfiguration getRemoteConfiguration(ConfigManager.Configuration configuration) {
        if (this.accept(configuration)) {
            return new SftpConfiguration(configuration);
        }
        return null;
    }

    @Override
    public RemoteClient getRemoteClient(RemoteConfiguration remoteConfiguration, InputOutput inputOutput) {
        if (remoteConfiguration instanceof SftpConfiguration) {
            return new SftpClient((SftpConfiguration)remoteConfiguration, inputOutput);
        }
        return null;
    }

    @Override
    public RemoteConfigurationPanel getRemoteConfigurationPanel(ConfigManager.Configuration configuration) {
        if (this.accept(configuration)) {
            return new SftpConfigurationPanel();
        }
        return null;
    }

    private boolean accept(ConfigManager.Configuration configuration) {
        String string = configuration.getValue(TYPE);
        return SFTP_CONNECTION_TYPE.equals(string);
    }

    private SshFiles getDefaultSshFiles() {
        if (Utilities.isWindows()) {
            return this.getDefaultWindowsSshFiles();
        }
        if (Utilities.isUnix()) {
            return this.getDefaultUnixSshFiles();
        }
        return UNKNOWN_SSH_FILES;
    }

    private SshFiles getDefaultUnixSshFiles() {
        String string = "";
        String string2 = "";
        File file = new File(System.getProperty("user.home"), ".ssh");
        File file2 = new File(file, "id_dsa");
        File file3 = new File(file, "id_rsa");
        if (file2.isFile()) {
            string = file2.getAbsolutePath();
        } else if (file3.isFile()) {
            string = file3.getAbsolutePath();
        }
        File file4 = new File(file, "known_hosts");
        if (file4.isFile()) {
            string2 = file4.getAbsolutePath();
        }
        return new SshFiles(string, string2);
    }

    private SshFiles getDefaultWindowsSshFiles() {
        return UNKNOWN_SSH_FILES;
    }

    private static final class SshFiles {
        private final String identityFile;
        private final String knownHostsFile;

        public SshFiles() {
            this("", "");
        }

        public SshFiles(String string, String string2) {
            assert (string != null);
            assert (string2 != null);
            this.identityFile = string;
            this.knownHostsFile = string2;
        }

        public String getIdentityFile() {
            return this.identityFile;
        }

        public String getKnownHostsFile() {
            return this.knownHostsFile;
        }
    }
}

