/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.TransferInfo;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteConnectionProvider;
import org.netbeans.modules.php.project.connections.spi.RemoteFile;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteClient
implements Cancellable {
    private static final Logger LOGGER = Logger.getLogger(RemoteClient.class.getName());
    private static final AdvancedProperties DEFAULT_ADVANCED_PROPERTIES = new AdvancedProperties();
    private static final OperationMonitor DEV_NULL_OPERATION_MONITOR = new DevNullOperationMonitor();
    private static final Set<String> IGNORED_DIRS = new HashSet<String>(Arrays.asList(".", "..", "nbproject"));
    private static final int TRIES_TO_TRANSFER = 3;
    private static final String LOCAL_TMP_NEW_SUFFIX = ".new~";
    private static final String LOCAL_TMP_OLD_SUFFIX = ".old~";
    private static final String REMOTE_TMP_NEW_SUFFIX = ".new";
    private static final String REMOTE_TMP_OLD_SUFFIX = ".old";
    private final RemoteConfiguration configuration;
    private final AdvancedProperties properties;
    private final OperationMonitor operationMonitor;
    private final String baseRemoteDirectory;
    private final org.netbeans.modules.php.project.connections.spi.RemoteClient remoteClient;
    private volatile boolean cancelled = false;

    public RemoteClient(RemoteConfiguration remoteConfiguration) {
        this(remoteConfiguration, DEFAULT_ADVANCED_PROPERTIES);
    }

    public RemoteClient(RemoteConfiguration remoteConfiguration, AdvancedProperties advancedProperties) {
        RemoteConnectionProvider remoteConnectionProvider;
        String string;
        assert (remoteConfiguration != null);
        assert (advancedProperties != null);
        this.configuration = remoteConfiguration;
        this.properties = advancedProperties;
        OperationMonitor operationMonitor = advancedProperties.getOperationMonitor();
        this.operationMonitor = operationMonitor != null ? operationMonitor : DEV_NULL_OPERATION_MONITOR;
        StringBuilder stringBuilder = new StringBuilder(remoteConfiguration.getInitialDirectory());
        String string2 = advancedProperties.getAdditionalInitialSubdirectory();
        if (StringUtils.hasText((String)string2)) {
            if (!string2.startsWith("/")) {
                throw new IllegalArgumentException("additionalInitialSubdirectory must start with /");
            }
            stringBuilder.append(string2);
        }
        if ((string = stringBuilder.toString()).length() > 1 && string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        this.baseRemoteDirectory = string.replaceAll("/{2,}", "/");
        assert (this.baseRemoteDirectory.startsWith("/")) : "base directory must start with /: " + this.baseRemoteDirectory;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Remote client created with configuration: %s, advanced properties: %s, base remote directory: %s", remoteConfiguration, advancedProperties, this.baseRemoteDirectory));
        }
        org.netbeans.modules.php.project.connections.spi.RemoteClient remoteClient = null;
        Iterator<RemoteConnectionProvider> iterator = RemoteConnections.get().getConnectionProviders().iterator();
        while (iterator.hasNext() && (remoteClient = (remoteConnectionProvider = iterator.next()).getRemoteClient(remoteConfiguration, advancedProperties.getInputOutput())) == null) {
        }
        assert (remoteClient != null) : "no suitable remote client for configuration: " + remoteConfiguration;
        this.remoteClient = remoteClient;
    }

    public void connect() throws RemoteException {
        this.remoteClient.connect();
        assert (this.remoteClient.isConnected()) : "Remote client should be connected";
        if (!this.cdBaseRemoteDirectory()) {
            if (this.remoteClient.isConnected()) {
                this.disconnect();
            }
            throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)this.baseRemoteDirectory), this.remoteClient.getReplyString());
        }
    }

    public void disconnect() throws RemoteException {
        this.remoteClient.disconnect();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean cancel() {
        this.cancelled = true;
        return true;
    }

    public void reset() {
        this.cancelled = false;
    }

    public boolean exists(TransferFile transferFile) throws RemoteException {
        this.ensureConnected();
        LOGGER.fine(String.format("Checking whether file %s exists", transferFile));
        this.cdBaseRemoteDirectory();
        boolean bl = this.remoteClient.exists(transferFile.getParentRelativePath(), transferFile.getName());
        LOGGER.fine(String.format("Exists: %b", bl));
        return bl;
    }

    public boolean rename(TransferFile transferFile, TransferFile transferFile2) throws RemoteException {
        this.ensureConnected();
        LOGGER.fine(String.format("Moving file from %s to %s", transferFile, transferFile2));
        this.cdBaseRemoteDirectory();
        boolean bl = this.remoteClient.rename(transferFile.getRelativePath(), transferFile2.getRelativePath());
        LOGGER.fine(String.format("Success: %b", bl));
        return bl;
    }

    public Set<TransferFile> prepareUpload(FileObject fileObject, FileObject ... fileObjectArray) throws RemoteException {
        assert (fileObject != null);
        assert (fileObjectArray != null);
        assert (fileObject.isFolder()) : "Base local directory must be a directory";
        assert (fileObjectArray.length > 0) : "At least one file to upload must be specified";
        File file = FileUtil.toFile((FileObject)fileObject);
        String string = file.getAbsolutePath();
        LinkedList<TransferFile> linkedList = new LinkedList<TransferFile>();
        for (FileObject fileArray : fileObjectArray) {
            File[] fileArray2 = FileUtil.toFile((FileObject)fileArray);
            if (fileArray2 == null) continue;
            if (this.isVisible((File)fileArray2)) {
                LOGGER.fine("File " + fileArray + " added to upload queue");
                linkedList.offer(TransferFile.fromFileObject(fileArray, string));
                continue;
            }
            LOGGER.fine("File " + fileArray + " NOT added to upload queue [invisible]");
        }
        HashSet hashSet = new HashSet();
        while (!linkedList.isEmpty()) {
            File file2;
            File[] fileArray;
            if (this.cancelled) {
                LOGGER.fine("Prepare upload cancelled");
                break;
            }
            TransferFile transferFile = (TransferFile)linkedList.poll();
            if (!hashSet.add(transferFile)) {
                LOGGER.fine("File " + transferFile + " already in queue");
                continue;
            }
            if (!transferFile.isDirectory() || (fileArray = (file2 = this.getLocalFile(file, transferFile)).listFiles()) == null) continue;
            for (File file3 : fileArray) {
                if (this.isVisible(file3)) {
                    LOGGER.fine("File " + file3 + " added to upload queue");
                    linkedList.offer(TransferFile.fromFile(file3, string));
                    continue;
                }
                LOGGER.fine("File " + file3 + " NOT added to upload queue [invisible]");
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Prepared for upload: " + hashSet);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferInfo upload(FileObject fileObject, Set<TransferFile> set) throws RemoteException {
        assert (fileObject != null);
        assert (set != null);
        assert (fileObject.isFolder()) : "Base local directory must be a directory";
        assert (set.size() > 0) : "At least one file to upload must be specified";
        this.ensureConnected();
        long l = System.currentTimeMillis();
        TransferInfo transferInfo = new TransferInfo();
        File file = FileUtil.toFile((FileObject)fileObject);
        try {
            this.operationMonitor.operationStart(Operation.UPLOAD, set);
            for (TransferFile transferFile : set) {
                if (this.cancelled) {
                    LOGGER.fine("Upload cancelled");
                    break;
                }
                this.operationMonitor.operationProcess(Operation.UPLOAD, transferFile);
                try {
                    this.uploadFile(transferInfo, file, transferFile);
                }
                catch (IOException iOException) {
                    this.transferFailed(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)iOException.getMessage().trim()));
                }
                catch (RemoteException remoteException) {
                    this.transferFailed(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)remoteException.getMessage().trim()));
                }
            }
        }
        finally {
            this.operationMonitor.operationFinish(Operation.UPLOAD, set);
            transferInfo.setRuntime(System.currentTimeMillis() - l);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(transferInfo.toString());
            }
        }
        return transferInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void uploadFile(TransferInfo transferInfo, File file, TransferFile transferFile) throws IOException, RemoteException {
        int n2;
        if (transferFile.isDirectory()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Uploading directory: " + transferFile);
            }
            this.cdBaseRemoteDirectory(transferFile.getRelativePath(), true);
            this.transferSucceeded(transferInfo, transferFile);
            return;
        }
        assert (transferFile.getParentRelativePath() != null) : "Must be underneath base remote directory! [" + transferFile + "]";
        if (!this.cdBaseRemoteDirectory(transferFile.getParentRelativePath(), true)) {
            this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)transferFile.getParentRelativePath()));
            return;
        }
        String string2 = transferFile.getName();
        int n = -1;
        if (this.properties.isPreservePermissions()) {
            n = this.remoteClient.getPermissions(string2);
            LOGGER.fine(String.format("Original permissions of %s: %d", string2, n));
        } else {
            LOGGER.fine("Permissions are not preserved.");
        }
        String string = null;
        if (this.properties.isUploadDirectly()) {
            LOGGER.fine("File will be uploaded directly.");
            string = string2;
        } else {
            string = string2 + REMOTE_TMP_NEW_SUFFIX;
            LOGGER.fine("File will be uploaded using a temporary file.");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Uploading file " + string2 + " => " + this.remoteClient.printWorkingDirectory() + "/" + string);
        }
        FileInputStream fileInputStream = new FileInputStream(new File(file, transferFile.getRelativePath(true)));
        boolean bl = false;
        try {
            for (int i = 1; i <= 3; ++i) {
                String string3;
                if (this.remoteClient.storeFile(string, fileInputStream)) {
                    bl = true;
                    if (!LOGGER.isLoggable(Level.FINE)) break;
                    string3 = transferFile.getRelativePath() + (this.properties.isUploadDirectly() ? "" : REMOTE_TMP_NEW_SUFFIX);
                    LOGGER.fine(String.format("The %d. attempt to upload '%s' was successful", i, string3));
                    break;
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                string3 = transferFile.getRelativePath() + (this.properties.isUploadDirectly() ? "" : REMOTE_TMP_NEW_SUFFIX);
                LOGGER.fine(String.format("The %d. attempt to upload '%s' was NOT successful", i, string3));
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            int n3;
            Object var12_12 = null;
            ((InputStream)fileInputStream).close();
            if (bl) {
                if (!this.properties.isUploadDirectly()) {
                    bl = this.moveRemoteFile(string, string2);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("File %s renamed to %s: %s", string, string2, bl));
                    }
                }
                if (this.properties.isPreservePermissions() && bl && n != -1) {
                    n3 = this.remoteClient.getPermissions(string2);
                    LOGGER.fine(String.format("New permissions of %s: %d", string2, n3));
                    if (n != n3) {
                        LOGGER.fine(String.format("Setting permissions %d for %s.", n, string2));
                        boolean bl3 = this.remoteClient.setPermissions(n, string2);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(String.format("Permissions for %s set: %s", string2, bl3));
                            LOGGER.fine(String.format("Permissions for %s read: %s", string2, this.remoteClient.getPermissions(string2)));
                        }
                        if (!bl3) {
                            this.transferPartiallyFailed(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_PermissionsNotSet", (Object)n, (Object)transferFile.getName()));
                        }
                    }
                }
            }
            if (bl) {
                this.transferSucceeded(transferInfo, transferFile);
                throw throwable;
            } else {
                this.transferFailed(transferInfo, transferFile, this.getOperationFailureMessage(Operation.UPLOAD, string2));
                n3 = this.remoteClient.deleteFile(string);
                if (!LOGGER.isLoggable(Level.FINE)) throw throwable;
                LOGGER.fine(String.format("Unsuccessfully uploaded file %s deleted: %s", transferFile.getRelativePath() + REMOTE_TMP_NEW_SUFFIX, n3 != 0));
            }
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        if (bl) {
            if (!this.properties.isUploadDirectly()) {
                bl = this.moveRemoteFile(string, string2);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("File %s renamed to %s: %s", string, string2, bl));
                }
            }
            if (this.properties.isPreservePermissions() && bl && n != -1) {
                n2 = this.remoteClient.getPermissions(string2);
                LOGGER.fine(String.format("New permissions of %s: %d", string2, n2));
                if (n != n2) {
                    LOGGER.fine(String.format("Setting permissions %d for %s.", n, string2));
                    boolean bl2 = this.remoteClient.setPermissions(n, string2);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Permissions for %s set: %s", string2, bl2));
                        LOGGER.fine(String.format("Permissions for %s read: %s", string2, this.remoteClient.getPermissions(string2)));
                    }
                    if (!bl2) {
                        this.transferPartiallyFailed(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_PermissionsNotSet", (Object)n, (Object)transferFile.getName()));
                    }
                }
            }
        }
        if (bl) {
            this.transferSucceeded(transferInfo, transferFile);
            return;
        }
        this.transferFailed(transferInfo, transferFile, this.getOperationFailureMessage(Operation.UPLOAD, string2));
        n2 = this.remoteClient.deleteFile(string);
        if (!LOGGER.isLoggable(Level.FINE)) return;
        LOGGER.fine(String.format("Unsuccessfully uploaded file %s deleted: %s", transferFile.getRelativePath() + REMOTE_TMP_NEW_SUFFIX, n2 != 0));
    }

    private boolean moveRemoteFile(String string, String string2) throws RemoteException {
        boolean bl = this.remoteClient.rename(string, string2);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("File %s directly renamed to %s: %s", string, string2, bl));
        }
        if (bl) {
            return true;
        }
        String string3 = string2 + REMOTE_TMP_OLD_SUFFIX;
        this.remoteClient.deleteFile(string3);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Renaming in chain: (1) <file> -> <file>.old~ ; (2) <file>.new~ -> <file> ; (3) rm <file>.old~");
        }
        bl = this.remoteClient.rename(string2, string3);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("(1) File %s renamed to %s: %s", string2, string3, bl));
        }
        if (!bl) {
            return false;
        }
        bl = this.remoteClient.rename(string, string2);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("(2) File %s renamed to %s: %s", string, string2, bl));
        }
        if (!bl) {
            boolean bl2 = this.remoteClient.rename(string3, string2);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("(-) File %s restored to original %s: %s", string3, string2, bl2));
            }
        } else {
            boolean bl3 = this.remoteClient.deleteFile(string3);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("(3) File %s deleted: %s", string3, bl3));
            }
        }
        return bl;
    }

    public Set<TransferFile> prepareDownload(FileObject fileObject, FileObject ... fileObjectArray) throws RemoteException {
        assert (fileObject != null);
        assert (fileObject.isFolder()) : "Base local directory must be a directory";
        assert (fileObjectArray != null);
        assert (fileObjectArray.length > 0) : "At least one file to download must be specified";
        ArrayList<File> arrayList = new ArrayList<File>(fileObjectArray.length);
        for (FileObject fileObject2 : fileObjectArray) {
            File file = FileUtil.toFile((FileObject)fileObject2);
            if (file == null) continue;
            arrayList.add(file);
        }
        return this.prepareDownload(FileUtil.toFile((FileObject)fileObject), arrayList.toArray(new File[arrayList.size()]));
    }

    /*
     * WARNING - void declaration
     */
    public Set<TransferFile> prepareDownload(File file, File ... fileArray) throws RemoteException {
        assert (file != null);
        assert (fileArray != null);
        assert (fileArray.length > 0) : "At least one file to download must be specified";
        this.ensureConnected();
        String string = file.getAbsolutePath();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (File file2 : fileArray) {
            if (this.isVisible(file2)) {
                void object;
                LOGGER.fine("File " + file2 + " added to download queue");
                Object var9_13 = null;
                if (file2.exists()) {
                    TransferFile transferFile = TransferFile.fromFile(file2, string);
                } else {
                    TransferFile transferFile = TransferFile.fromFile(file2, string, true);
                }
                linkedList.offer(object);
                continue;
            }
            LOGGER.fine("File " + file2 + " NOT added to download queue [invisible]");
        }
        HashSet hashSet = new HashSet();
        while (!linkedList.isEmpty()) {
            if (this.cancelled) {
                LOGGER.fine("Prepare download cancelled");
                break;
            }
            TransferFile transferFile = (TransferFile)linkedList.poll();
            if (!hashSet.add(transferFile)) {
                LOGGER.fine("File " + transferFile + " already in queue");
                continue;
            }
            if (!transferFile.isDirectory()) continue;
            try {
                if (!this.cdBaseRemoteDirectory(transferFile.getRelativePath(), false)) {
                    LOGGER.fine("Remote directory " + transferFile.getRelativePath() + " cannot be entered or does not exist => ignoring");
                    continue;
                }
                String string2 = this.getRemoteRelativePath(transferFile);
                for (RemoteFile remoteFile : this.remoteClient.listFiles()) {
                    if (this.isVisible(this.getLocalFile(file, transferFile, remoteFile))) {
                        LOGGER.fine("File " + remoteFile + " added to download queue");
                        linkedList.offer(TransferFile.fromRemoteFile(remoteFile, this.baseRemoteDirectory, string2));
                        continue;
                    }
                    LOGGER.fine("File " + remoteFile + " NOT added to download queue [invisible]");
                }
            }
            catch (RemoteException remoteException) {
                LOGGER.fine("Remote directory " + transferFile.getRelativePath() + "/* cannot be entered or does not exist => ignoring");
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Prepared for download: " + hashSet);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferInfo download(FileObject fileObject, Set<TransferFile> set) throws RemoteException {
        assert (fileObject != null);
        assert (set != null);
        assert (fileObject.isFolder()) : "Base local directory must be a directory";
        assert (set.size() > 0) : "At least one file to download must be specified";
        this.ensureConnected();
        long l = System.currentTimeMillis();
        TransferInfo transferInfo = new TransferInfo();
        File file = FileUtil.toFile((FileObject)fileObject);
        try {
            this.operationMonitor.operationStart(Operation.DOWNLOAD, set);
            for (TransferFile transferFile : set) {
                if (this.cancelled) {
                    LOGGER.fine("Download cancelled");
                    break;
                }
                this.operationMonitor.operationProcess(Operation.DOWNLOAD, transferFile);
                try {
                    this.downloadFile(transferInfo, file, transferFile);
                }
                catch (IOException iOException) {
                    this.transferFailed(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)iOException.getMessage().trim()));
                }
                catch (RemoteException remoteException) {
                    this.transferFailed(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)remoteException.getMessage().trim()));
                }
            }
            Object var11_11 = null;
            this.operationMonitor.operationFinish(Operation.DOWNLOAD, set);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.operationMonitor.operationFinish(Operation.DOWNLOAD, set);
            FileUtil.refreshFor((File[])new File[]{file});
            transferInfo.setRuntime(System.currentTimeMillis() - l);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(transferInfo.toString());
            }
            throw throwable;
        }
        FileUtil.refreshFor((File[])new File[]{file});
        transferInfo.setRuntime(System.currentTimeMillis() - l);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(transferInfo.toString());
        }
        return transferInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(TransferInfo transferInfo, File file, TransferFile transferFile) throws IOException, RemoteException {
        block30: {
            block31: {
                File file2;
                block29: {
                    file2 = this.getLocalFile(file, transferFile);
                    if (!transferFile.isDirectory()) break block29;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Downloading directory: " + transferFile);
                    }
                    if (!this.cdBaseRemoteDirectory(transferFile.getRelativePath(), false)) {
                        LOGGER.fine("Remote directory " + transferFile.getRelativePath() + " does not exist => ignoring");
                        this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)transferFile.getRelativePath()));
                        return;
                    }
                    if (!file2.exists()) {
                        if (!RemoteClient.mkLocalDirs(file2)) {
                            this.transferFailed(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotCreateDir", (Object)file2));
                            return;
                        }
                    } else if (file2.isFile()) {
                        this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_DirFileCollision", (Object)transferFile));
                        return;
                    }
                    this.transferSucceeded(transferInfo, transferFile);
                    break block30;
                }
                if (!transferFile.isFile()) break block31;
                File file3 = file2.getParentFile();
                assert (file3 != null) : "File " + file2 + " has no parent file?!";
                if (!file3.exists()) {
                    if (!RemoteClient.mkLocalDirs(file3)) {
                        this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotCreateDir", (Object)file3));
                        return;
                    }
                } else {
                    if (file3.isFile()) {
                        this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_DirFileCollision", (Object)transferFile));
                        return;
                    }
                    if (file2.exists() && !file2.canWrite()) {
                        this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_FileNotWritable", (Object)file2));
                        return;
                    }
                }
                assert (file3.isDirectory()) : "Parent file of " + file2 + " must be a directory";
                File file4 = new File(file2.getAbsolutePath() + LOCAL_TMP_NEW_SUFFIX);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Downloading " + transferFile.getRelativePath() + " => " + file4.getAbsolutePath());
                }
                if (!this.cdBaseRemoteDirectory(transferFile.getParentRelativePath(), false)) {
                    LOGGER.fine("Remote directory " + transferFile.getParentRelativePath() + " does not exist => ignoring file " + transferFile.getRelativePath());
                    this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)transferFile.getParentRelativePath()));
                    return;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file4);
                boolean bl = false;
                try {
                    for (int i = 1; i <= 3; ++i) {
                        if (this.remoteClient.retrieveFile(transferFile.getName(), fileOutputStream)) {
                            bl = true;
                            if (!LOGGER.isLoggable(Level.FINE)) break;
                            LOGGER.fine(String.format("The %d. attempt to download '%s' was successful", i, transferFile.getRelativePath()));
                            break;
                        }
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine(String.format("The %d. attempt to download '%s' was NOT successful", i, transferFile.getRelativePath()));
                    }
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    ((OutputStream)fileOutputStream).close();
                    if (bl) {
                        bl = this.moveLocalFile(file4, file2);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(String.format("File %s renamed to %s: %s", file4, file2, bl));
                        }
                    }
                    if (bl) {
                        this.transferSucceeded(transferInfo, transferFile);
                    } else {
                        this.transferFailed(transferInfo, transferFile, this.getOperationFailureMessage(Operation.DOWNLOAD, transferFile.getName()));
                        boolean bl2 = file4.delete();
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(String.format("Unsuccessfully downloaded file %s deleted: %s", file4, bl2));
                        }
                    }
                    throw throwable;
                }
                ((OutputStream)fileOutputStream).close();
                if (bl) {
                    bl = this.moveLocalFile(file4, file2);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("File %s renamed to %s: %s", file4, file2, bl));
                    }
                }
                if (bl) {
                    this.transferSucceeded(transferInfo, transferFile);
                } else {
                    this.transferFailed(transferInfo, transferFile, this.getOperationFailureMessage(Operation.DOWNLOAD, transferFile.getName()));
                    boolean bl3 = file4.delete();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Unsuccessfully downloaded file %s deleted: %s", file4, bl3));
                    }
                }
                break block30;
            }
            this.transferIgnored(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_UnknownFileType", (Object)transferFile.getRelativePath()));
        }
    }

    private boolean moveLocalFile(final File file, final File file2) {
        final boolean[] blArray = new boolean[1];
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            public void run() {
                File file3 = new File(file2.getAbsolutePath() + RemoteClient.LOCAL_TMP_OLD_SUFFIX);
                String string = file.getName();
                String string2 = file2.getName();
                String string3 = file3.getName();
                if (!file2.exists()) {
                    blArray[0] = RemoteClient.renameLocalFileTo(file, file2);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("File %s directly renamed to %s: %s", string, string2, blArray[0]));
                    }
                    if (blArray[0]) {
                        return;
                    }
                }
                RemoteClient.this.deleteLocalFile(file3, "");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Renaming in chain: (1) <file> -> <file>.old~ ; (2) <file>.new~ -> <file> ; (3) rm <file>.old~");
                }
                blArray[0] = file2.renameTo(file3);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("(1) File %s renamed to %s: %s", string2, string3, blArray[0]));
                }
                if (!blArray[0]) {
                    return;
                }
                blArray[0] = RemoteClient.renameLocalFileTo(file, file2);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("(2) File %s renamed to %s: %s", string, string2, blArray[0]));
                }
                if (!blArray[0] && file3.exists() && !file2.exists()) {
                    boolean bl = RemoteClient.renameLocalFileTo(file3, file2);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("(-) File %s restored to original %s: %s", string3, string2, bl));
                    }
                    return;
                }
                RemoteClient.this.deleteLocalFile(file3, "(3) ");
            }
        });
        assert (blArray[0] || !blArray[0]);
        return blArray[0];
    }

    private File getLocalFile(File file, TransferFile transferFile) {
        if (transferFile.getRelativePath() == ".") {
            return file;
        }
        return new File(file, transferFile.getRelativePath(true));
    }

    private File getLocalFile(File file, TransferFile transferFile, RemoteFile remoteFile) {
        return new File(this.getLocalFile(file, transferFile), remoteFile.getName());
    }

    public Set<TransferFile> prepareDelete(FileObject fileObject, FileObject ... fileObjectArray) throws RemoteException {
        LOGGER.fine("Preparing files to delete => calling prepareUpload because in fact the same operation is done");
        return this.prepareUpload(fileObject, fileObjectArray);
    }

    public TransferInfo delete(TransferFile transferFile) throws RemoteException {
        return this.delete(Collections.singleton(transferFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferInfo delete(Set<TransferFile> set) throws RemoteException {
        assert (set != null);
        assert (set.size() > 0) : "At least one file to upload must be specified";
        this.ensureConnected();
        long l = System.currentTimeMillis();
        TransferInfo transferInfo = new TransferInfo();
        try {
            Set<TransferFile> set2 = this.getFiles(set);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Only files: %s => %s", set, set2));
            }
            this.delete(transferInfo, set2);
            Set<TransferFile> set3 = this.getDirectories(set);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Only dirs: %s => %s", set, set3));
            }
            this.delete(transferInfo, set3);
            assert (set.size() == set2.size() + set3.size()) : String.format("%s does not match files and dirs: %s %s", set, set2, set3);
            Object var8_6 = null;
            transferInfo.setRuntime(System.currentTimeMillis() - l);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(transferInfo.toString());
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            transferInfo.setRuntime(System.currentTimeMillis() - l);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(transferInfo.toString());
            }
            throw throwable;
        }
        return transferInfo;
    }

    private void delete(TransferInfo transferInfo, Set<TransferFile> set) {
        for (TransferFile transferFile : set) {
            if (this.cancelled) {
                LOGGER.fine("Delete cancelled");
                break;
            }
            try {
                this.deleteFile(transferInfo, transferFile);
            }
            catch (IOException iOException) {
                this.transferFailed(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)iOException.getMessage().trim()));
            }
            catch (RemoteException remoteException) {
                this.transferFailed(transferInfo, transferFile, NbBundle.getMessage(RemoteClient.class, (String)"MSG_ErrorReason", (Object)remoteException.getMessage().trim()));
            }
        }
    }

    private void deleteFile(TransferInfo transferInfo, TransferFile transferFile) throws IOException, RemoteException {
        boolean bl = false;
        this.cdBaseRemoteDirectory();
        if (transferFile.isDirectory()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Deleting directory: " + transferFile);
            }
            bl = this.remoteClient.deleteDirectory(transferFile.getRelativePath());
            LOGGER.fine("Folder deleted: " + bl);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Deleting file: " + transferFile);
            }
            bl = this.remoteClient.deleteFile(transferFile.getRelativePath());
            LOGGER.fine("File deleted: " + bl);
        }
        if (bl) {
            this.transferSucceeded(transferInfo, transferFile);
        } else {
            String string = null;
            string = !this.remoteClient.exists(transferFile.getParentRelativePath(), transferFile.getName()) ? NbBundle.getMessage(RemoteClient.class, (String)"MSG_FileNotExists", (Object)transferFile.getName()) : (transferFile.isDirectory() && this.cdBaseRemoteDirectory(transferFile.getParentRelativePath(), false) && this.remoteClient.listFiles().size() > 0 ? NbBundle.getMessage(RemoteClient.class, (String)"MSG_FolderNotEmpty", (Object)transferFile.getName()) : this.getOperationFailureMessage(Operation.DELETE, transferFile.getName()));
            this.transferFailed(transferInfo, transferFile, string);
        }
    }

    private void transferSucceeded(TransferInfo transferInfo, TransferFile transferFile) {
        transferInfo.addTransfered(transferFile);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Transfered: " + transferFile);
        }
    }

    private void transferFailed(TransferInfo transferInfo, TransferFile transferFile, String string) {
        if (!transferInfo.isFailed(transferFile)) {
            transferInfo.addFailed(transferFile, string);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Failed: " + transferFile + ", reason: " + string);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Failed: " + transferFile + ", reason: " + string + " [ignored, failed already]");
        }
    }

    private void transferPartiallyFailed(TransferInfo transferInfo, TransferFile transferFile, String string) {
        if (!transferInfo.isPartiallyFailed(transferFile)) {
            transferInfo.addPartiallyFailed(transferFile, string);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Partially failed: " + transferFile + ", reason: " + string);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Partially failed: " + transferFile + ", reason: " + string + " [ignored, partially failed already]");
        }
    }

    private void transferIgnored(TransferInfo transferInfo, TransferFile transferFile, String string) {
        if (!transferInfo.isIgnored(transferFile)) {
            transferInfo.addIgnored(transferFile, string);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Ignored: " + transferFile + ", reason: " + string);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Ignored: " + transferFile + ", reason: " + string + " [ignored, ignored already]");
        }
    }

    private String getOperationFailureMessage(Operation operation, String string) {
        String string2 = this.remoteClient.getNegativeReplyString();
        if (string2 == null) {
            String string3 = null;
            switch (operation) {
                case UPLOAD: {
                    string3 = "MSG_CannotUploadFile";
                    break;
                }
                case DOWNLOAD: {
                    string3 = "MSG_CannotDownloadFile";
                    break;
                }
                case DELETE: {
                    string3 = "MSG_CannotDeleteFile";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation type: " + (Object)((Object)operation));
                }
            }
            string2 = NbBundle.getMessage(RemoteClient.class, (String)string3, (Object)string);
        }
        return string2;
    }

    private void ensureConnected() throws RemoteException {
        if (!this.remoteClient.isConnected()) {
            LOGGER.fine("Client not connected -> connecting");
            this.connect();
        }
    }

    private boolean cdBaseRemoteDirectory() throws RemoteException {
        return this.cdRemoteDirectory(this.baseRemoteDirectory, true);
    }

    private boolean cdBaseRemoteDirectory(String string, boolean bl) throws RemoteException {
        assert (string == null || !string.startsWith("/")) : "Subdirectory must be null or relative [" + string + "]";
        String string2 = this.baseRemoteDirectory;
        if (string != null && !string.equals(".")) {
            string2 = this.baseRemoteDirectory + "/" + string;
        }
        return this.cdRemoteDirectory(string2, bl);
    }

    private boolean cdRemoteDirectory(String string, boolean bl) throws RemoteException {
        LOGGER.fine("Changing directory to " + string);
        boolean bl2 = this.remoteClient.changeWorkingDirectory(string);
        if (!bl2 && bl) {
            return this.createAndCdRemoteDirectory(string);
        }
        return bl2;
    }

    private boolean createAndCdRemoteDirectory(String string) throws RemoteException {
        LOGGER.fine("Creating file path " + string);
        if (string.startsWith("/") && !this.remoteClient.changeWorkingDirectory("/")) {
            throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotChangeDirectory", (Object)"/"), this.remoteClient.getReplyString());
        }
        for (String string2 : string.split("/")) {
            if (string2.length() == 0 || this.remoteClient.changeWorkingDirectory(string2)) continue;
            if (!this.remoteClient.makeDirectory(string2)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Cannot create directory: " + this.remoteClient.printWorkingDirectory() + "/" + string2);
                }
                throw new RemoteException(NbBundle.getMessage(RemoteClient.class, (String)"MSG_CannotCreateDirectory", (Object)string2), this.remoteClient.getReplyString());
            }
            if (!this.remoteClient.changeWorkingDirectory(string2)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Cannot enter directory: " + this.remoteClient.printWorkingDirectory() + "/" + string2);
                }
                return false;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Directory '" + this.remoteClient.printWorkingDirectory() + "' created and entered");
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [remote configuration: ");
        stringBuilder.append(this.configuration);
        stringBuilder.append(", baseRemoteDirectory: ");
        stringBuilder.append(this.baseRemoteDirectory);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private boolean isVisible(File file) {
        assert (file != null);
        if (IGNORED_DIRS.contains(file.getName())) {
            return false;
        }
        return this.properties.getPhpVisibilityQuery().isVisible(file);
    }

    private static boolean mkLocalDirs(File file) {
        try {
            FileUtil.createFolder((File)file);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean renameLocalFileTo(File file, File file2) {
        boolean bl;
        long l;
        block11: {
            l = 0L;
            if (LOGGER.isLoggable(Level.FINE)) {
                l = System.currentTimeMillis();
            }
            assert (file.exists()) : "Source file must exist " + file;
            assert (!file2.exists()) : "Target file cannot exist " + file2;
            FileObject fileObject = FileUtil.toFileObject((File)file);
            assert (fileObject != null) : "Source fileobject must exist " + file;
            String string = RemoteClient.getName(file2.getName());
            String string2 = FileUtil.getExtension((String)file2.getName());
            bl = false;
            try {
                FileLock fileLock = fileObject.lock();
                try {
                    try {
                        fileObject.rename(fileLock, string, string2);
                        bl = true;
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.INFO, null, iOException);
                        Object var11_10 = null;
                        fileLock.releaseLock();
                        break block11;
                    }
                    Object var11_9 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    fileLock.releaseLock();
                    throw throwable;
                }
                fileLock.releaseLock();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Move %s -> %s took: %sms", file, file2, System.currentTimeMillis() - l));
        }
        return bl;
    }

    private void deleteLocalFile(File file, String string) {
        if (!file.exists()) {
            return;
        }
        boolean bl = file.delete();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format(string + "File %s deleted: %s", file.getName(), bl));
        }
    }

    private static String getName(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private String getRemoteRelativePath(TransferFile transferFile) {
        StringBuilder stringBuilder = new StringBuilder(this.baseRemoteDirectory);
        if (transferFile.getRelativePath() != ".") {
            stringBuilder.append("/");
            stringBuilder.append(transferFile.getRelativePath());
        }
        return stringBuilder.toString();
    }

    private Set<TransferFile> getFiles(Set<TransferFile> set) {
        HashSet<TransferFile> hashSet = new HashSet<TransferFile>();
        for (TransferFile transferFile : set) {
            if (!transferFile.isFile()) continue;
            hashSet.add(transferFile);
        }
        return hashSet;
    }

    private Set<TransferFile> getDirectories(Set<TransferFile> set) {
        TreeSet<TransferFile> treeSet = new TreeSet<TransferFile>(new Comparator<TransferFile>(){
            private final String SEPARATOR = Pattern.quote("/");

            @Override
            public int compare(TransferFile transferFile, TransferFile transferFile2) {
                int n = transferFile2.getRelativePath().split(this.SEPARATOR).length - transferFile.getRelativePath().split(this.SEPARATOR).length;
                return n != 0 ? n : 1;
            }
        });
        for (TransferFile transferFile : set) {
            if (!transferFile.isDirectory()) continue;
            treeSet.add(transferFile);
        }
        return treeSet;
    }

    private static final class AdvancedPropertiesBuilder {
        InputOutput io;
        String additionalInitialSubdirectory;
        boolean preservePermissions = false;
        boolean uploadDirectly = false;
        OperationMonitor operationMonitor;
        PhpVisibilityQuery phpVisibilityQuery;

        AdvancedPropertiesBuilder() {
        }

        public AdvancedPropertiesBuilder(AdvancedProperties advancedProperties) {
            this.io = advancedProperties.getInputOutput();
            this.additionalInitialSubdirectory = advancedProperties.getAdditionalInitialSubdirectory();
            this.preservePermissions = advancedProperties.isPreservePermissions();
            this.uploadDirectly = advancedProperties.isUploadDirectly();
            this.operationMonitor = advancedProperties.getOperationMonitor();
            this.phpVisibilityQuery = advancedProperties.getPhpVisibilityQuery();
        }

        public AdvancedPropertiesBuilder setAdditionalInitialSubdirectory(String string) {
            this.additionalInitialSubdirectory = string;
            return this;
        }

        public AdvancedPropertiesBuilder setInputOutput(InputOutput inputOutput) {
            this.io = inputOutput;
            return this;
        }

        public AdvancedPropertiesBuilder setOperationMonitor(OperationMonitor operationMonitor) {
            this.operationMonitor = operationMonitor;
            return this;
        }

        public AdvancedPropertiesBuilder setPreservePermissions(boolean bl) {
            this.preservePermissions = bl;
            return this;
        }

        public AdvancedPropertiesBuilder setUploadDirectly(boolean bl) {
            this.uploadDirectly = bl;
            return this;
        }

        public AdvancedPropertiesBuilder setPhpVisibilityQuery(PhpVisibilityQuery phpVisibilityQuery) {
            this.phpVisibilityQuery = phpVisibilityQuery;
            return this;
        }
    }

    public static final class AdvancedProperties {
        private final InputOutput io;
        private final String additionalInitialSubdirectory;
        private final boolean preservePermissions;
        private final boolean uploadDirectly;
        private final OperationMonitor operationMonitor;
        private final PhpVisibilityQuery phpVisibilityQuery;

        public AdvancedProperties() {
            this(new AdvancedPropertiesBuilder());
        }

        private AdvancedProperties(AdvancedPropertiesBuilder advancedPropertiesBuilder) {
            this.io = advancedPropertiesBuilder.io;
            this.additionalInitialSubdirectory = advancedPropertiesBuilder.additionalInitialSubdirectory;
            this.preservePermissions = advancedPropertiesBuilder.preservePermissions;
            this.uploadDirectly = advancedPropertiesBuilder.uploadDirectly;
            this.operationMonitor = advancedPropertiesBuilder.operationMonitor;
            this.phpVisibilityQuery = advancedPropertiesBuilder.phpVisibilityQuery;
        }

        public String getAdditionalInitialSubdirectory() {
            return this.additionalInitialSubdirectory;
        }

        public AdvancedProperties setAdditionalInitialSubdirectory(String string) {
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setAdditionalInitialSubdirectory(string));
        }

        public InputOutput getInputOutput() {
            return this.io;
        }

        public AdvancedProperties setInputOutput(InputOutput inputOutput) {
            Parameters.notNull((CharSequence)"io", (Object)inputOutput);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setInputOutput(inputOutput));
        }

        public OperationMonitor getOperationMonitor() {
            return this.operationMonitor;
        }

        public AdvancedProperties setOperationMonitor(OperationMonitor operationMonitor) {
            Parameters.notNull((CharSequence)"operationMonitor", (Object)operationMonitor);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setOperationMonitor(operationMonitor));
        }

        public boolean isPreservePermissions() {
            return this.preservePermissions;
        }

        public AdvancedProperties setPreservePermissions(boolean bl) {
            Parameters.notNull((CharSequence)"preservePermissions", (Object)bl);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setPreservePermissions(bl));
        }

        public boolean isUploadDirectly() {
            return this.uploadDirectly;
        }

        public AdvancedProperties setUploadDirectly(boolean bl) {
            Parameters.notNull((CharSequence)"uploadDirectly", (Object)bl);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setUploadDirectly(bl));
        }

        public PhpVisibilityQuery getPhpVisibilityQuery() {
            if (this.phpVisibilityQuery != null) {
                return this.phpVisibilityQuery;
            }
            return PhpVisibilityQuery.getDefault();
        }

        public AdvancedProperties setPhpVisibilityQuery(PhpVisibilityQuery phpVisibilityQuery) {
            Parameters.notNull((CharSequence)"phpVisibilityQuery", (Object)phpVisibilityQuery);
            return new AdvancedProperties(new AdvancedPropertiesBuilder(this).setPhpVisibilityQuery(phpVisibilityQuery));
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("AdvancedProperties [ io: ");
            stringBuilder.append(this.io);
            stringBuilder.append(", additionalInitialSubdirectory: ");
            stringBuilder.append(this.additionalInitialSubdirectory);
            stringBuilder.append(", preservePermissions: ");
            stringBuilder.append(this.preservePermissions);
            stringBuilder.append(", uploadDirectly: ");
            stringBuilder.append(this.uploadDirectly);
            stringBuilder.append(", operationMonitor: ");
            stringBuilder.append(this.operationMonitor);
            stringBuilder.append(", phpVisibilityQuery: ");
            stringBuilder.append(this.phpVisibilityQuery);
            stringBuilder.append(" ]");
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DevNullOperationMonitor
    implements OperationMonitor {
        private DevNullOperationMonitor() {
        }

        @Override
        public void operationStart(Operation operation, Collection<TransferFile> collection) {
        }

        @Override
        public void operationProcess(Operation operation, TransferFile transferFile) {
        }

        @Override
        public void operationFinish(Operation operation, Collection<TransferFile> collection) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OperationMonitor {
        public void operationStart(Operation var1, Collection<TransferFile> var2);

        public void operationProcess(Operation var1, TransferFile var2);

        public void operationFinish(Operation var1, Collection<TransferFile> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        UPLOAD,
        DOWNLOAD,
        DELETE;

    }
}

