/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

public abstract class BasePathSupport {
    public static String getAntPropertyName(String string) {
        if (string != null && string.startsWith("${") && string.endsWith("}")) {
            return string.substring(2, string.length() - 1);
        }
        return string;
    }

    public static final class Item {
        private final Type type;
        private final String filePath;
        private final boolean broken;
        protected String property;

        private Item(Type type, String string, String string2, boolean bl) {
            this.type = type;
            this.filePath = string;
            this.property = string2;
            this.broken = bl;
        }

        public static Item create(String string) {
            if (string == null) {
                throw new IllegalArgumentException("property must not be null");
            }
            return new Item(Type.CLASSPATH, null, string, false);
        }

        public static Item create(String string, String string2) {
            if (string == null) {
                throw new IllegalArgumentException("filePath must not be null");
            }
            return new Item(Type.FOLDER, string, string2, false);
        }

        public static Item createBroken(String string, String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            return new Item(Type.FOLDER, string, string2, true);
        }

        public Type getType() {
            return this.type;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getReference() {
            return this.property;
        }

        public boolean isBroken() {
            return this.broken;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("BaseIncludePathSupport.Item[ type: ");
            stringBuilder.append(this.type.name());
            stringBuilder.append(", filePath: ");
            stringBuilder.append(this.filePath);
            stringBuilder.append(", property: ");
            stringBuilder.append(this.property);
            stringBuilder.append(", broken: ");
            stringBuilder.append(this.broken);
            stringBuilder.append(" ]");
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Item item = (Item)object;
            if (this.broken != item.broken) {
                return false;
            }
            switch (this.getType()) {
                case CLASSPATH: {
                    if (this.property == item.property || this.property != null && this.property.equals(item.property)) break;
                    return false;
                }
                default: {
                    if (this.filePath == item.filePath || this.filePath != null && this.filePath.equals(item.filePath)) break;
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            if (this.broken) {
                return 42;
            }
            int n = this.getType().ordinal();
            switch (this.getType()) {
                case CLASSPATH: {
                    n += this.property.hashCode();
                    break;
                }
                default: {
                    n = 41 * n + (this.filePath != null ? this.filePath.hashCode() : 0);
                }
            }
            return n;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            CLASSPATH,
            FOLDER;

        }
    }
}

